/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.clus;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.model.ar.PredicateRowData;
import oracle.dmt.dataminer.core.model.ar.RuleRowData;
import oracle.dmt.dataminer.core.model.clus.CentroidRowData;
import oracle.dmt.dataminer.core.model.clus.HistogramRowData;
import oracle.dmt.dataminer.core.model.generated.server.DmChild;
import oracle.dmt.dataminer.core.model.generated.server.DmChildren;
import oracle.dmt.dataminer.core.model.generated.server.DmCluster;
import oracle.dmt.dataminer.core.utils.ObjectUtils;

public class ClusteringDetailRow
implements Comparable<ClusteringDetailRow> {
    private static final Logger theLogger = Logger.getLogger(ClusteringDetailRow.class.getName());
    private Integer id;
    private Integer count;
    private Integer parent;
    private Integer treeLevel;
    private Double dispersion;
    private String clusterId;
    private List<PredicateRowData> splitPredicate;
    private List<Integer> child;
    private List<CentroidRowData> centroid;
    private List<HistogramRowData> histogram;
    private RuleRowData rule;

    public ClusteringDetailRow() {
        this.id = 0;
        this.clusterId = "";
        this.count = 0;
        this.parent = 0;
        this.treeLevel = 0;
        this.dispersion = 0.0;
        this.splitPredicate = new ArrayList<PredicateRowData>();
        this.child = new ArrayList<Integer>();
        this.centroid = new ArrayList<CentroidRowData>();
        this.histogram = new ArrayList<HistogramRowData>();
    }

    public ClusteringDetailRow(DmCluster dmCluster) throws SQLException {
        this.id = dmCluster.getId() != null ? Integer.valueOf(dmCluster.getId().intValue()) : null;
        this.clusterId = dmCluster.getClusterId() != null ? dmCluster.getClusterId() : null;
        this.count = dmCluster.getRecordCount() != null ? Integer.valueOf(dmCluster.getRecordCount().intValue()) : null;
        this.parent = dmCluster.getParent() != null ? Integer.valueOf(dmCluster.getParent().intValue()) : null;
        this.treeLevel = dmCluster.getTreeLevel() != null ? Integer.valueOf(dmCluster.getTreeLevel().intValue()) : null;
        this.dispersion = dmCluster.getDispersion() != null ? Double.valueOf(dmCluster.getDispersion().doubleValue()) : null;
        this.splitPredicate = dmCluster.getSplitPredicate() != null ? PredicateRowData.createPredicatesFrom(dmCluster.getSplitPredicate()) : null;
        this.child = dmCluster.getChild() != null ? ClusteringDetailRow.createChildrenFromDmChildren(dmCluster.getChild()) : null;
        this.centroid = dmCluster.getCentroid() != null ? CentroidRowData.createCentroidsFromDmCentroids(dmCluster.getCentroid()) : null;
        this.histogram = dmCluster.getHistogram() != null ? HistogramRowData.createHistogramsFromDmHistograms(dmCluster.getHistogram()) : null;
        this.rule = dmCluster.getRule() != null ? new RuleRowData(dmCluster.getRule()) : null;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Integer getId() {
        return this.id;
    }

    public void setCount(Integer n) {
        this.count = n;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setParent(Integer n) {
        this.parent = n;
    }

    public Integer getParent() {
        return this.parent;
    }

    public void setTreeLevel(Integer n) {
        this.treeLevel = n;
    }

    public Integer getTreeLevel() {
        return this.treeLevel;
    }

    public void setDispersion(Double d) {
        this.dispersion = d;
    }

    public Double getDispersion() {
        return this.dispersion;
    }

    public void setSplitPredicate(List<PredicateRowData> list) {
        this.splitPredicate = list;
    }

    public List<PredicateRowData> getSplitPredicate() {
        return this.splitPredicate;
    }

    public void setChild(List<Integer> list) {
        this.child = list;
    }

    public List<Integer> getChild() {
        return this.child;
    }

    public void setCentroid(List<CentroidRowData> list) {
        this.centroid = list;
    }

    public List<CentroidRowData> getCentroid() {
        return this.centroid;
    }

    public void setHistogram(List<HistogramRowData> list) {
        this.histogram = list;
    }

    public List<HistogramRowData> getHistogram() {
        return this.histogram;
    }

    public void setRule(RuleRowData ruleRowData) {
        this.rule = ruleRowData;
    }

    public RuleRowData getRule() {
        return this.rule;
    }

    public void setClusterId(String string) {
        this.clusterId = string;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String toString() {
        Object object2 = "";
        for (PredicateRowData object3 : this.splitPredicate) {
            object2 = (String)object2 + object3 + ",";
        }
        Object object4 = "";
        for (CentroidRowData centroidRowData : this.centroid) {
            object4 = (String)object4 + centroidRowData + ",";
        }
        String string = "[ Id = " + this.id + ", Cluster Id = " + this.clusterId + ", Count = " + this.count + ", Parent = " + this.parent + ", Tree Level = " + this.treeLevel + ", Dispersion = " + this.dispersion + ", Rule = " + this.rule + ", Child = " + this.child + ", Split Predicate = " + (String)object2 + ", Centroid = " + (String)object4 + "]";
        return string;
    }

    public boolean equals(Object object) {
        Comparable<PredicateRowData> comparable;
        boolean bl = true;
        if (!(object instanceof ClusteringDetailRow)) {
            return false;
        }
        ClusteringDetailRow clusteringDetailRow = (ClusteringDetailRow)object;
        boolean bl2 = bl = ObjectUtils.areEqual(this.id, clusteringDetailRow.getId()) && ObjectUtils.areEqual(this.clusterId, clusteringDetailRow.getClusterId()) && ObjectUtils.areEqual(this.count, clusteringDetailRow.getCount()) && ObjectUtils.areEqual(this.parent, clusteringDetailRow.getParent()) && ObjectUtils.areEqual(this.treeLevel, clusteringDetailRow.getTreeLevel()) && ObjectUtils.areEqual(this.dispersion, clusteringDetailRow.getDispersion()) && ObjectUtils.areEqual(this.rule, clusteringDetailRow.getRule());
        if (bl && this.child.size() == clusteringDetailRow.getChild().size()) {
            for (int i = 0; i < this.child.size(); ++i) {
                if (this.child.get(i).equals(clusteringDetailRow.getChild().get(i))) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (bl && this.splitPredicate.size() == clusteringDetailRow.getSplitPredicate().size()) {
            PredicateRowData predicateRowData = null;
            comparable = null;
            for (int i = 0; i < this.splitPredicate.size(); ++i) {
                predicateRowData = this.splitPredicate.get(i);
                if (predicateRowData.equals(comparable = clusteringDetailRow.getSplitPredicate().get(i))) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (bl && this.centroid.size() == clusteringDetailRow.getCentroid().size()) {
            int n = this.centroid.size();
            comparable = null;
            CentroidRowData centroidRowData = null;
            List<CentroidRowData> list = Arrays.asList(new CentroidRowData[n]);
            List<CentroidRowData> list2 = Arrays.asList(new CentroidRowData[n]);
            Collections.copy(list, this.centroid);
            Collections.copy(list2, clusteringDetailRow.getCentroid());
            Collections.sort(list);
            Collections.sort(list2);
            for (int i = 0; i < n; ++i) {
                comparable = list.get(i);
                if (((CentroidRowData)comparable).equals(centroidRowData = list2.get(i))) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.id);
        n += ObjectUtils.hashCode(this.clusterId);
        n += ObjectUtils.hashCode(this.count);
        n += ObjectUtils.hashCode(this.parent);
        n += ObjectUtils.hashCode(this.treeLevel);
        n += ObjectUtils.hashCode(this.dispersion);
        n += ObjectUtils.hashCode(this.rule);
        n += ObjectUtils.hashCode(this.centroid);
        n += ObjectUtils.hashCode(this.child);
        return n += ObjectUtils.hashCode(this.splitPredicate);
    }

    @Override
    public int compareTo(ClusteringDetailRow clusteringDetailRow) {
        return this.id.compareTo(clusteringDetailRow.getId());
    }

    public static List<Integer> createChildrenFromDmChildren(DmChildren dmChildren) throws SQLException {
        DmChild dmChild;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BigDecimal bigDecimal = null;
        for (int i = 0; i < dmChildren.length() && (bigDecimal = (dmChild = dmChildren.getElement(i)).getId()) != null; ++i) {
            Integer n = dmChild.getId().intValue();
            arrayList.add(n);
        }
        return arrayList;
    }

    public static List<Integer> createChildren(Integer n, Integer n2) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!n.equals(0)) {
            arrayList.add(n);
        }
        if (!n2.equals(0)) {
            arrayList.add(n2);
        }
        return arrayList;
    }

    public static Map<String, ClusteringDetailRow> createMappedClusterLabelToID(List<ClusteringDetailRow> list, boolean bl) {
        HashMap<String, ClusteringDetailRow> hashMap = new HashMap<String, ClusteringDetailRow>();
        for (ClusteringDetailRow clusteringDetailRow : list) {
            if (bl) {
                if (clusteringDetailRow.getChild() != null && clusteringDetailRow.getChild().size() != 0) continue;
                hashMap.put(clusteringDetailRow.getClusterId(), clusteringDetailRow);
                continue;
            }
            hashMap.put(clusteringDetailRow.getClusterId(), clusteringDetailRow);
        }
        return hashMap;
    }
}

