/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ar;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.ItemSetStructure;
import oracle.dmt.dataminer.core.model.ar.RuleAggregateData;
import oracle.dmt.dataminer.core.model.generated.server.DmRule;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class Rule {
    private Integer id;
    private List<Item> antecedent;
    private Item consequent;
    private Double support;
    private Double confidence;
    private Double reverseConfidence;
    private Double lift;
    private Double antecedentSupport;
    private Double consequentSupport;
    private Integer numberOfItems;
    private Map<String, RuleAggregateData> aggregateMap;
    private List<String> aggregates;
    private ItemSetStructure itemSetStructure;

    public Rule(Integer n) {
        this.id = n;
        this.support = 0.0;
        this.confidence = 0.0;
        this.reverseConfidence = 0.0;
        this.lift = 0.0;
        this.antecedentSupport = 0.0;
        this.consequentSupport = 0.0;
        this.numberOfItems = 0;
        this.aggregateMap = new HashMap<String, RuleAggregateData>();
        this.aggregates = new ArrayList<String>(2);
        this.antecedent = new ArrayList<Item>(3);
        this.consequent = new Item();
    }

    public Rule(DmRule dmRule) throws SQLException {
        this.id = dmRule.getRuleId();
        this.numberOfItems = dmRule.getNumberOfItems();
        if (dmRule.getRuleSupport() != null) {
            this.support = dmRule.getRuleSupport().doubleValue();
        }
        if (dmRule.getRuleConfidence() != null) {
            this.confidence = dmRule.getRuleConfidence().doubleValue();
        }
        if (dmRule.getRuleLift() != null) {
            this.lift = dmRule.getRuleLift().doubleValue();
        }
        if (dmRule.getAntecedentSupport() != null) {
            this.antecedentSupport = dmRule.getAntecedentSupport().doubleValue();
        }
        if (dmRule.getConsequentSupport() != null) {
            this.consequentSupport = dmRule.getConsequentSupport().doubleValue();
        }
        if (dmRule.getAntecedent() != null) {
            this.antecedent = Item.createItemsFrom(dmRule.getAntecedent());
        }
        if (dmRule.getConsequent() != null) {
            this.consequent = Item.createItemsFrom(dmRule.getConsequent()).get(0);
        }
    }

    private String getItemsToString(List<Item> list) {
        StringBuilder stringBuilder = new StringBuilder(30);
        String[] stringArray = this.itemSetStructure.name().split("_");
        for (Item item : list) {
            boolean bl = false;
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            block11: for (int i = 0; i < n; ++i) {
                String string;
                switch (string = stringArray2[i]) {
                    case "NAME": {
                        stringBuilder.append(item.getAttributeName());
                        bl = true;
                        continue block11;
                    }
                    case "SUBNAME": {
                        String string2 = item.getAttributeSubname();
                        if (!StringUtils.isNotEmpty(string2)) continue block11;
                        if (bl) {
                            stringBuilder.append(".");
                        }
                        stringBuilder.append(string2);
                        continue block11;
                    }
                    case "VALUE": {
                        String string3 = item.getValue();
                        if (!StringUtils.isNotEmpty(string3) || "0".equals(string3)) continue block11;
                        stringBuilder.append(" = ");
                        stringBuilder.append(item.getValue());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Invalid option";
                        continue block11;
                    }
                }
            }
            stringBuilder.append(" AND ");
        }
        stringBuilder.delete(stringBuilder.length() - 5, stringBuilder.length());
        return stringBuilder.toString();
    }

    public String getFullAntecedent() {
        return this.getItemsToString(this.antecedent);
    }

    public String getFullConsequent() {
        return this.getItemsToString(Collections.singletonList(this.consequent));
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Integer getId() {
        return this.id;
    }

    public void setSupport(Double d) {
        this.support = d;
    }

    public Double getSupport() {
        return this.support;
    }

    public void setConfidence(Double d) {
        this.confidence = d;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public void setReverseConfidence(Double d) {
        this.reverseConfidence = d;
    }

    public Double getReverseConfidence() {
        return this.reverseConfidence;
    }

    public void setLift(Double d) {
        this.lift = d;
    }

    public Double getLift() {
        return this.lift;
    }

    public void setAntecedentSupport(Double d) {
        this.antecedentSupport = d;
    }

    public Double getAntecedentSupport() {
        return this.antecedentSupport;
    }

    public void setConsequentSupport(Double d) {
        this.consequentSupport = d;
    }

    public Double getConsequentSupport() {
        return this.consequentSupport;
    }

    public void setAntecedent(List<Item> list) {
        this.antecedent = list;
    }

    public List<Item> getAntecedent() {
        return this.antecedent;
    }

    public void setConsequent(Item item) {
        this.consequent = item;
    }

    public Item getConsequent() {
        return this.consequent;
    }

    public void setNumberOfItems(Integer n) {
        this.numberOfItems = n;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public void addAggregateData(String string, RuleAggregateData ruleAggregateData) {
        this.aggregateMap.put(string, ruleAggregateData);
        this.aggregates.add(string);
    }

    public RuleAggregateData getAggregateData(String string) {
        return this.aggregateMap.get(string);
    }

    public List<String> getAggregateNames() {
        return this.aggregates;
    }

    public void setItemSetStructure(ItemSetStructure itemSetStructure) {
        this.itemSetStructure = itemSetStructure;
    }

    public ItemSetStructure getItemSetStructure() {
        return this.itemSetStructure;
    }

    public String toString() {
        Object object2 = "";
        for (Item object3 : this.antecedent) {
            object2 = (String)object2 + object3.getFullAttributeName();
        }
        String string = this.consequent.getFullAttributeName();
        String string2 = "[RuleId = " + this.id + ", Antecedent = " + (String)object2 + ", Consequent = " + (String)string + ", Support = " + this.support + ", Confidence = " + this.confidence + ", lift = " + this.lift + ", Ant Support = " + this.antecedentSupport + ", Cons Support = " + this.consequentSupport + ", Items = " + this.getNumberOfItems() + "]";
        return string2;
    }
}

