/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ar;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.model.generated.server.DmPredicate;
import oracle.dmt.dataminer.core.model.generated.server.DmPredicates;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;

public class PredicateRowData
implements Comparable<PredicateRowData> {
    protected String attributeName;
    protected String attributeSubname;
    protected String conditionalOperator;
    protected Double attributeNumValue;
    protected String attributeStrValue;
    protected Double attributeSupport;
    protected Double attributeConfidence;

    public PredicateRowData() {
        this("", "", "", 0.0, "", 0.0, 0.0);
    }

    public PredicateRowData(String string, String string2, Double d, String string3) {
        this(string, string2, " = ", d, string3, 0.0, 0.0);
    }

    public PredicateRowData(String string, String string2, String string3, Double d, String string4, Double d2, Double d3) {
        this.attributeName = string;
        this.attributeSubname = string2;
        this.conditionalOperator = string3;
        this.attributeNumValue = d;
        this.attributeStrValue = string4;
        this.attributeSupport = d2;
        this.attributeConfidence = d3;
    }

    public PredicateRowData(DmPredicate dmPredicate) throws SQLException {
        this.attributeName = dmPredicate.getAttributeName();
        this.attributeSubname = dmPredicate.getAttributeSubname();
        this.conditionalOperator = dmPredicate.getConditionalOperator();
        this.attributeStrValue = dmPredicate.getAttributeStrValue();
        this.attributeNumValue = dmPredicate.getAttributeNumValue() != null ? Double.valueOf(dmPredicate.getAttributeNumValue().doubleValue()) : null;
        this.attributeSupport = dmPredicate.getAttributeSupport() != null ? Double.valueOf(dmPredicate.getAttributeSupport().doubleValue()) : null;
        this.attributeConfidence = dmPredicate.getAttributeConfidence() != null ? Double.valueOf(dmPredicate.getAttributeConfidence().doubleValue()) : null;
    }

    public void setAttributeName(String string) {
        this.attributeName = string;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeSubname(String string) {
        this.attributeSubname = string;
    }

    public String getAttributeSubname() {
        return this.attributeSubname;
    }

    public void setConditionalOperator(String string) {
        this.conditionalOperator = string;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setAttributeNumValue(Double d) {
        this.attributeNumValue = d;
    }

    public Double getAttributeNumValue() {
        return this.attributeNumValue;
    }

    public void setAttributeStrValue(String string) {
        this.attributeStrValue = string;
    }

    public String getAttributeStrValue() {
        return this.attributeStrValue;
    }

    public void setAttributeSupport(Double d) {
        this.attributeSupport = d;
    }

    public Double getAttributeSupport() {
        return this.attributeSupport;
    }

    public void setAttributeConfidence(Double d) {
        this.attributeConfidence = d;
    }

    public Double getAttributeConfidence() {
        return this.attributeConfidence;
    }

    public String getFullAttributeName() {
        return this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY);
    }

    public String getFullAttributeName(NameContent nameContent) {
        Object object = "";
        switch (nameContent) {
            case NC_NAME_ONLY: {
                object = this.attributeName;
                break;
            }
            case NC_NAME_SUBNAME_ONLY: {
                object = this.attributeName;
                if (this.attributeSubname == null || this.attributeSubname.trim().length() == 0) break;
                object = this.attributeName + "." + this.attributeSubname;
                break;
            }
            case NC_SUBNAME_ONLY: {
                if (this.attributeSubname == null) break;
                object = this.attributeSubname;
                break;
            }
            default: {
                object = "";
            }
        }
        return object;
    }

    public String getValue() {
        if (this.attributeNumValue != null) {
            return NumericFormat.format(this.attributeNumValue, true, 2);
        }
        return this.attributeStrValue;
    }

    public String getFullPredicate() {
        String string = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY) + " " + this.conditionalOperator + this.getValue();
        return string;
    }

    public static List<PredicateRowData> createPredicatesFrom(DmPredicates dmPredicates) throws SQLException {
        ArrayList<PredicateRowData> arrayList = new ArrayList<PredicateRowData>();
        if (dmPredicates != null) {
            for (int i = 0; i < dmPredicates.length(); ++i) {
                DmPredicate dmPredicate = dmPredicates.getElement(i);
                PredicateRowData predicateRowData = new PredicateRowData(dmPredicate);
                arrayList.add(predicateRowData);
            }
        } else {
            return arrayList;
        }
        return arrayList;
    }

    public String toString() {
        String string = "[Name = " + this.attributeName + ", Subname = " + this.attributeSubname + ", Attribute Num Value = " + this.attributeNumValue + ", Attribute String Value = " + this.attributeStrValue + ", Conditional Operator= " + this.conditionalOperator + ", Attribute Support = " + this.attributeSupport + ", Attribute Confidence  = " + this.attributeConfidence + "]";
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PredicateRowData)) {
            return false;
        }
        PredicateRowData predicateRowData = (PredicateRowData)object;
        return ObjectUtils.areEqual(this.getFullPredicate(), predicateRowData.getFullPredicate()) && ObjectUtils.areEqual(this.attributeSupport, predicateRowData.getAttributeSupport()) && ObjectUtils.areEqual(this.attributeConfidence, predicateRowData.getAttributeConfidence()) && ObjectUtils.areEqual(this.conditionalOperator, predicateRowData.getConditionalOperator());
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.getFullPredicate());
        n += ObjectUtils.hashCode(this.attributeSupport);
        n += ObjectUtils.hashCode(this.attributeConfidence);
        return n += ObjectUtils.hashCode(this.conditionalOperator);
    }

    @Override
    public int compareTo(PredicateRowData predicateRowData) {
        int n = ObjectUtils.compare(this.attributeName, predicateRowData.getAttributeName());
        if (n == 0 && (n = ObjectUtils.compare(this.attributeSubname, predicateRowData.getAttributeSubname())) == 0 && (n = ObjectUtils.compare(this.getValue(), predicateRowData.getValue())) == 0) {
            n = ObjectUtils.compare(this.conditionalOperator, predicateRowData.getConditionalOperator());
        }
        return n;
    }

    private static enum NameContent {
        NC_NAME_ONLY,
        NC_NAME_SUBNAME_ONLY,
        NC_SUBNAME_ONLY;

    }
}

