/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.metadata;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.metadata.GetTableColumnsDataTypeMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.DBTableColumns;
import oracle.javatools.util.Pair;
import oracle.jdbc.OraclePreparedStatement;

public class GetTableColumnsDataTypeQuery
extends SqlQuery<Pair<String, String>, OraclePreparedStatement> {
    private String schema;
    private String tableName;
    private String columnName;

    public GetTableColumnsDataTypeQuery(String string, String string2) {
        super(new GetTableColumnsDataTypeMapper());
        this.schema = string;
        this.tableName = string2;
    }

    public GetTableColumnsDataTypeQuery setColumnName(String string) {
        this.columnName = string;
        return this;
    }

    @Override
    protected String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select("COLUMN_NAME", "DATA_TYPE").from(DBTableColumns.ALL_TAB_COLUMNS.name()).where(Conditional.equals("OWNER", this.schema), Conditional.equals("TABLE_NAME", this.tableName), Conditional.equals("COLUMN_NAME", this.columnName));
        String string = sqlBuilder.toString();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        oraclePreparedStatement.setStringAtName("OWNER", this.schema);
        oraclePreparedStatement.setStringAtName("TABLE_NAME", this.tableName);
        SqlUtils.setStringAtName(oraclePreparedStatement, "COLUMN_NAME", this.columnName);
    }
}

