/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class SVMCCoefficientsQuery
extends ModelDetailsQuery {
    private static final String REVERSED_COEFFICIENT = "REVERSED_COEFFICIENT";

    public SVMCCoefficientsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public SVMCCoefficientsQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? (ModelDetailType.AD_COEFFICIENTS.equals((Object)this.outputType) || ModelDetailType.SVMC_COEFFICIENTS.equals((Object)this.outputType) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"CLASS", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}, {REVERSED_COEFFICIENT, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}, {REVERSED_COEFFICIENT, "NUMBER"}}) : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"CLASS", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            String string = "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n   PARTITION_NAME as \"{$PARTITION_NAME}\",\n<TARGET_VALUE>   ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\n   ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n   ATTRIBUTE_VALUE as \"{$ATTRIBUTE_VALUE}\",\n   COEFFICIENT as \"{$COEFFICIENT}\",\n   REVERSED_COEFFICIENT as \"{$REVERSED_COEFFICIENT}\"\n   FROM {$MODEL_SCHEMA_VALUE}.DM$VL{$MODEL_NAME_VALUE}";
            if (ModelDetailType.AD_COEFFICIENTS.equals((Object)this.outputType) || ModelDetailType.SVMC_COEFFICIENTS.equals((Object)this.outputType)) {
                return StringUtils.getReplacedString(string, "<TARGET_VALUE>", "   TARGET_VALUE as \"{$CLASS}\",\n");
            }
            return StringUtils.getReplacedString(string, "<TARGET_VALUE>", "");
        }
        return "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",  \n   t.class as \"{$CLASS}\",\n   s.attribute_name as \"{$ATTRIBUTE_NAME}\",\n   s.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\",\n   s.attribute_value as \"{$ATTRIBUTE_VALUE}\",\n   s.coefficient as \"{$COEFFICIENT}\"\n   FROM TABLE(dbms_data_mining.get_model_details_svm('{$GET_MODEL_NAME}')) t,\n   TABLE(t.attribute_set) s";
    }
}

