/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class GLMRRowDiagnosticsQuery
extends ModelDetailsQuery {
    private static final String PREDICTED_VALUE = "PREDICTED_VALUE";
    private static final String RESIDUAL = "RESIDUAL";
    private static final String STD_ERR_RESIDUAL = "STD_ERR_RESIDUAL";
    private static final String STUDENTIZED_RESIDUAL = "STUDENTIZED_RESIDUAL";
    private static final String PRED_RES = "PRED_RES";
    private static final String COOKS_D = "COOKS_D";

    public GLMRRowDiagnosticsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public GLMRRowDiagnosticsQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"CASE_ID", "VARCHAR2"}, {"TARGET_VALUE", "NUMBER"}, {PREDICTED_VALUE, "NUMBER"}, {"HAT", "NUMBER"}, {RESIDUAL, "NUMBER"}, {STD_ERR_RESIDUAL, "NUMBER"}, {STUDENTIZED_RESIDUAL, "NUMBER"}, {PRED_RES, "NUMBER"}, {COOKS_D, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"CASE_ID", "VARCHAR2"}, {"TARGET_VALUE", "NUMBER"}, {PREDICTED_VALUE, "NUMBER"}, {"HAT", "NUMBER"}, {RESIDUAL, "NUMBER"}, {STD_ERR_RESIDUAL, "NUMBER"}, {STUDENTIZED_RESIDUAL, "NUMBER"}, {PRED_RES, "NUMBER"}, {COOKS_D, "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n   CAST(case_id  AS VARCHAR2(4000)) as \"{$CASE_ID}\",\n   PARTITION_NAME as \"{$PARTITION_NAME}\",\n   target_value as \"{$TARGET_VALUE}\",\n   predicted_target_value as \"{$PREDICTED_VALUE}\",\n   hat as \"{$HAT}\",\n   residual as \"{$RESIDUAL}\", \n   std_err_residual as \"{$STD_ERR_RESIDUAL}\",\n   studentized_residual as \"{$STUDENTIZED_RESIDUAL}\",\n   pred_res  as \"{$PRED_RES}\",\n   cooks_d as \"{$COOKS_D}\" \n   FROM {$MODEL_SCHEMA_VALUE}.DM$VA{$MODEL_NAME_VALUE}" : "\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n     CAST(case_id  AS VARCHAR2(4000)) as \"{$CASE_ID}\", \n     target_value as \"{$TARGET_VALUE}\",\n     predicted_value as \"{$PREDICTED_VALUE}\", \n     hat as \"{$HAT}\", \n     residual as \"{$RESIDUAL}\", \n     std_err_residual as \"{$STD_ERR_RESIDUAL}\",\n     studentized_residual as \"{$STUDENTIZED_RESIDUAL}\",\n     pred_res  as \"{$PRED_RES}\",\n     cooks_d as \"{$COOKS_D}\" \n     FROM \"{$TABLE_NAME}\"";
        return string;
    }
}

