/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class DTLeafProfileQuery
extends ModelDetailsQuery {
    public DTLeafProfileQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public DTLeafProfileQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PROFILE_ID", "NUMBER"}, {"PREDICTION", "VARCHAR2"}, {"SUPPORT", "NUMBER"}, {"CONFIDENCE", "NUMBER"}, {"FULL_SIMPLE_RULE", "VARCHAR2"}};
    }

    @Override
    protected String getSQLTemplate() {
        this._builder = new StringBuilder("with \"<MODEL_NAME_VALUE>\" as (SELECT * FROM\nXMLTABLE('\ndeclare function local:parent_node($e as element()*) as element()*\n{\n  for $n in $e\n    return\n    <dummy id=\"{$n/@id}\">\n      {local:parent_node($n/../../Node[@id=$n/../@id])}\n      {$n/SimplePredicate}\n      {$n/SimpleSetPredicate}\n      {\n        if ($n/CompoundPredicate/@booleanOperator=\"surrogate\") then\n          $n/CompoundPredicate/*[1]\n        else\n          $n/CompoundPredicate\n      }\n    </dummy>/*\n}; declare function local:eliminate_duplicate_SimplePredicates($e as\nelement()*) as element()*\n{\n  for $all in $e/*\n  return\n    <dummy>\n    {\n   if (count($e/SimplePredicate[@field=$all/@field and\n@operator=$all/@operator]) > 1) then\n      if ($all/@value = $e/SimplePredicate[@field=$all/@field and\n@operator=$all/@operator][last()]/@value) then\n        $all\n      else ()\n    else\n      $all\n    }\n    </dummy>/*\n}; declare function local:eliminate_duplicate_SimpleSetPredicates($e as\nelement()*) as element()*\n{\n  for $all in $e/*\n  return\n    <dummy>\n    {\n    if (count($e/SimpleSetPredicate[@field=$all/@field and\n@booleanOperator=$all/@booleanOperator]) > 1) then\n      if ($all/Array is $e/SimpleSetPredicate[@field=$all/@field and\n@booleanOperator=$all/@booleanOperator][last()]/Array) then\n        $all\n      else ()\n    else\n      $all\n    }\n    </dummy>/*\n}; for $a at $i in /PMML/TreeModel//Node[not(Node)]\n      where count($a/../../Node) > 0\n    return\n      if (count($a/../../../Node) > 0) then\n        <SimpleRule id=\"{$i}\" score=\"{$a/@score}\"\nrecordCount=\"{$a/@recordCount}\">\n          <CompoundPredicate booleanOperator=\"and\">\n          {local:eliminate_duplicate_SimpleSetPredicates(\n            <dummy>\n              {local:eliminate_duplicate_SimplePredicates(\n                <dummy>\n                  {local:parent_node($a)}\n                </dummy>\n              )}\n            </dummy>\n          )}\n          </CompoundPredicate>\n          {$a/ScoreDistribution}\n        </SimpleRule>\n      else\n    <SimpleRule id=\"{$i}\" score=\"{$a/@score}\"\nrecordCount=\"{$a/@recordCount}\">\n      {$a/SimplePredicate}\n      {$a/SimpleSetPredicate}\n      {\n        if ($a/CompoundPredicate/@booleanOperator=\"surrogate\") then\n          $a/CompoundPredicate/*[1]\n        else\n          $a/CompoundPredicate\n      }\n      {$a/ScoreDistribution}\n    </SimpleRule>\n' PASSING dbms_data_mining.get_model_details_xml('<GET_MODEL_NAME>')\nCOLUMNS\n    \"PROFILE_ID\" FOR ORDINALITY,\n    \"RECORD_COUNT\" NUMBER PATH '/SimpleRule/@recordCount',\n    \"DESCRIPTION\" XMLType PATH '.'\n))\n\n select  '<MODEL_SCHEMA_VALUE>'  as \"<MODEL_SCHEMA>\", \n '<MODEL_NAME_VALUE>'  as \"<MODEL_NAME>\", \n        profile_id as \"<PROFILE_ID>\",\n       prediction as \"<PREDICTION>\",\n       support as \"<SUPPORT>\",\n       confidence as \"<CONFIDENCE>\",\n       full_rule as \"<FULL_RULE>\"\nfrom (select profile_id, predicted_value as prediction, support, confidence, \nreplace(replace(replace(rtrim(extractvalue(description, '/text()'), \n'DMandDM ' || chr(10)), 'DMandDM ', 'and '), 'greaterThan', '>'), \n'lessOrEqual', '<=') full_rule \nfrom (\nselect\n  profile_id,\n  extractvalue(description, '/SimpleRule/@score') predicted_value,\n  record_count/tot.sum_rec_count support,\n  extractvalue(description, '/SimpleRule/ScoreDistribution[@value=\"' ||\nextractvalue(description, '/SimpleRule/@score') ||\n'\"]/@recordCount')/record_count confidence,\n  xmlquery('\n  for $n in /SimpleRule/child::node() return\n    if ($n instance of element(CompoundPredicate)) then\n      for $i in $n/* return\n        if ($i instance of element(SimplePredicate)) then\n          concat(\n            string($i/@field),string('' ''),\n            string($i/@operator),string('' ''),\n            string($i/@value),string('' DMandDM '')\n          )\n        else if ($i instance of element(SimpleSetPredicate)) then\n          concat(\n            string($i/@field),string('' ''),\n            string($i/@booleanOperator),string('' (''),\n            string($i/Array/text()),string('') DMandDM '')\n          )\n        else\n          string('''')\n    else if ($n instance of element(SimplePredicate)) then\n      concat(\n        string($n/@field),string('' ''),\n        string($n/@operator),string('' ''),\n        string($n/@value),string('' DMandDM '')\n      )\n    else if ($n instance of element(SimpleSetPredicate)) then\n      concat(\n        string($n/@field),string('' ''),\n        string($n/@booleanOperator),string('' (''),\n        string($n/Array/text()),string('') DMandDM '')\n      )\n    else\n      string('''')\n  ' PASSING description RETURNING CONTENT\n) description \nfrom\n  \"<MODEL_NAME_VALUE>\",\n  (select sum(record_count) sum_rec_count from \"<MODEL_NAME_VALUE>\") tot))\n");
        return this._builder.toString();
    }
}

