/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ClusterRuleQuery
extends ModelDetailsQuery {
    private static final String ATTR_RULE_COMPONENT = "ATTR_RULE_COMPONENT";
    private static final String CENTROID_VALUE = "CENTROID_VALUE";
    private static final String RULE_ID = "RULE_ID";
    private static final String RULE_SUPPORT = "RULE_SUPPORT";
    private static final String RULE_CONFIDENCE = "RULE_CONFIDENCE";
    private static final String ATTRIBUTE_SUPPORT = "ATTRIBUTE_SUPPORT";
    private static final String ATTRIBUTE_CONFIDENCE = "ATTRIBUTE_CONFIDENCE";

    public ClusterRuleQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public ClusterRuleQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {RULE_ID, "NUMBER"}, {RULE_SUPPORT, "NUMBER"}, {RULE_CONFIDENCE, "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {ATTR_RULE_COMPONENT, "VARCHAR2"}, {ATTRIBUTE_CONFIDENCE, "NUMBER"}, {ATTRIBUTE_SUPPORT, "NUMBER"}, {CENTROID_VALUE, "VARCHAR2"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {RULE_ID, "NUMBER"}, {RULE_SUPPORT, "NUMBER"}, {RULE_CONFIDENCE, "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {ATTR_RULE_COMPONENT, "VARCHAR2"}, {ATTRIBUTE_CONFIDENCE, "NUMBER"}, {ATTRIBUTE_SUPPORT, "NUMBER"}, {CENTROID_VALUE, "VARCHAR2"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\nSELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\", \n     A.PARTITION_NAME as \"{$PARTITION_NAME}\",\n     A.CLUSTER_ID as \"{$ID}\",  \n     CAST(A.CLUSTER_NAME AS VARCHAR2(4000)) as \"{$CLUSTER_ID}\",  \n     A.CLUSTER_ID as \"{$RULE_ID}\",  \n     A.RULE_CONFIDENCE as \"{$RULE_CONFIDENCE}\",  \n     A.RULE_SUPPORT as \"{$RULE_SUPPORT}\",  \n     A.ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\", \n     A.ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\", \n     (A.OPERATOR || ' ' || A.NUMERIC_VALUE || A.ATTRIBUTE_VALUE) as \"{$ATTR_RULE_COMPONENT}\", \n     A.CONFIDENCE as \"{$ATTRIBUTE_CONFIDENCE}\", \n     A.SUPPORT as \"{$ATTRIBUTE_SUPPORT}\",\n     CASE WHEN B.MEAN IS NULL AND B.VARIANCE IS NULL \n     THEN B.MODE_VALUE \n     ELSE TO_CHAR(NVL(B.MEAN, B.VARIANCE), 'TM') END as \"{$CENTROID_VALUE}\"\n     FROM {$MODEL_SCHEMA_VALUE}.{$ALGO_SOURCE}{$MODEL_NAME_VALUE} A \n     INNER JOIN {$MODEL_SCHEMA_VALUE}.DM$VA{$MODEL_NAME_VALUE} B ON A.CLUSTER_ID = B.CLUSTER_ID AND A.ATTRIBUTE_NAME = B.ATTRIBUTE_NAME" : "SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\", \n     a.id as \"{$ID}\", \n     a.cluster_id as \"{$CLUSTER_ID}\",  \n     a.rule.rule_id as \"{$RULE_ID}\",  \n     a.rule.rule_confidence as \"{$RULE_CONFIDENCE}\",  \n     a.rule.rule_support as \"{$RULE_SUPPORT}\",  \n     rl_ant.attribute_name as \"{$ATTRIBUTE_NAME}\", \n     rl_ant.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\", \n     (rl_ant.conditional_operator || ' ' || rl_ant.attribute_str_value || rl_ant.attribute_num_value) as \"{$ATTR_RULE_COMPONENT}\", \n     rl_ant.ATTRIBUTE_CONFIDENCE as \"{$ATTRIBUTE_CONFIDENCE}\", \n     rl_ant.ATTRIBUTE_SUPPORT as \"{$ATTRIBUTE_SUPPORT}\", \n     NVL(cent.MODE_VALUE, cent.MEAN) as \"{$CENTROID_VALUE}\" \n     FROM (SELECT * FROM TABLE(dbms_data_mining.{$ALGO_SOURCE}('{$GET_MODEL_NAME}'))) a, \n     TABLE(a.rule.antecedent) rl_ant, \n     TABLE(a.centroid) cent \n     WHERE rl_ant.attribute_name=cent.attribute_name AND \n     nvl(rl_ant.attribute_subname,' ')=nvl(cent.attribute_subname,' ') \n";
        return string;
    }

    @Override
    protected String getActualSource(MiningAlgorithmType miningAlgorithmType) {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "DM$VR";
        }
        switch (miningAlgorithmType) {
            case KMEANS: {
                return "GET_MODEL_DETAILS_KM";
            }
            case O_CLUSTER: {
                return "GET_MODEL_DETAILS_OC";
            }
            case EXPECTATION_MAXIMIZATION: {
                return "GET_MODEL_DETAILS_EM";
            }
        }
        assert (false) : "Incompatible Algorithm";
        return null;
    }
}

