/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ClusterCentroidQuery
extends ModelDetailsQuery {
    private static final String MEAN = "MEAN";
    private static final String MODE_VALUE = "MODE_VALUE";

    public ClusterCentroidQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public ClusterCentroidQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {MEAN, "NUMBER"}, {MODE_VALUE, "VARCHAR2"}, {"VARIANCE", "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"CLUSTER_ID", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {MEAN, "NUMBER"}, {MODE_VALUE, "VARCHAR2"}, {"VARIANCE", "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n  SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n  CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n  VA.PARTITION_NAME as \"{$PARTITION_NAME}\",\n  VA.CLUSTER_ID as \"{$ID}\", \n  CAST(VD.CLUSTER_NAME AS VARCHAR2(4000)) as \"{$CLUSTER_ID}\", \n  VA.ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\" ,\n  VA.ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n  VA.MEAN as \"{$MEAN}\",\n  VA.VARIANCE as \"{$VARIANCE}\",\n  VA.MODE_VALUE as \"{$MODE_VALUE}\"\n  FROM {$MODEL_SCHEMA_VALUE}.{$ALGO_SOURCE}{$MODEL_NAME_VALUE} VA INNER JOIN {$MODEL_SCHEMA_VALUE}.DM$VD{$MODEL_NAME_VALUE} VD ON VA.CLUSTER_ID = VD.CLUSTER_ID\n" : "\n  SELECT DISTINCT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n  CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n  ID AS \"{$ID}\",\n  CLUSTER_ID as \"{$CLUSTER_ID}\", \n  cent.attribute_name as \"{$ATTRIBUTE_NAME}\" ,\n  cent.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\",\n  cent.mean as \"{$MEAN}\",\n  cent.mode_value as \"{$MODE_VALUE}\",\n  cent.variance as \"{$VARIANCE}\"\n  FROM (SELECT * FROM TABLE(dbms_data_mining.{$ALGO_SOURCE}('{$GET_MODEL_NAME}',NULL,NULL,1,0,0))) a,\n  TABLE(a.centroid) cent\n";
        return string;
    }

    @Override
    protected String getActualSource(MiningAlgorithmType miningAlgorithmType) {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "DM$VA";
        }
        switch (miningAlgorithmType) {
            case KMEANS: {
                return "GET_MODEL_DETAILS_KM";
            }
            case O_CLUSTER: {
                return "GET_MODEL_DETAILS_OC";
            }
            case EXPECTATION_MAXIMIZATION: {
                return "GET_MODEL_DETAILS_EM";
            }
        }
        assert (false) : "Incompatible Algorithm";
        return null;
    }
}

