/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.fe.common.GetSingularValuesMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetSingularValuesQuery
extends SqlBaseModelQuery<SVDCoefficient, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> query;

    public GetSingularValuesQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new GetSingularValuesMapper(), modelDescriptor);
        this.query = DbVersionHelper.isDB122Up(version) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("FEATURE_ID", "FEATURE_NAME", "VALUE").from(GetSingularValuesQuery.this.getViewName("DM$VE")).where(Conditional.equals("PARTITION_NAME", GetSingularValuesQuery.this.getPartitionId()));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetSingularValuesQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            return "SELECT FEATURE_ID, MAPPED_FEATURE_ID, VALUE\n FROM TABLE(dbms_data_mining.get_model_details_svd(:model)) \n WHERE MATRIX_TYPE = 'S'";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetSingularValuesQuery.this.getQualifiedName());
        }
    }
}

