/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.Order;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.AbstractFeatureCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.fe.common.FeatureCoefficient;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public class FeatureCoefficientsQuery
extends AbstractFeatureCoefficientsQuery<FeatureCoefficient, OraclePreparedStatement> {
    private static final String SQL_TEMPLATE = "SELECT * FROM ({$SOURCE}) WHERE ROWNUM <= {$FETCH_SIZE}";
    private List<SortSpec> sortSpecifications;
    private BigDecimal minCoefficient;
    private BigDecimal maxCoefficient;
    private List<String> featureIds;

    public FeatureCoefficientsQuery(Version version, Class<? extends ModelType> clazz, List<SortSpec> list, ModelDescriptor modelDescriptor) {
        super(version, new SqlDefaultMapper<FeatureCoefficient>(FeatureCoefficient.class), clazz, modelDescriptor);
        this.matchingType = ColumnFilter.Match.ALL;
        this.featureIds = new ArrayList<String>();
        this.sortSpecifications = list;
        this.attributeFilters = new ArrayList();
    }

    public FeatureCoefficientsQuery setCoefficientRange(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this.minCoefficient = bigDecimal;
        this.maxCoefficient = bigDecimal2;
        return this;
    }

    public FeatureCoefficientsQuery setFeatureId(String string) {
        assert (StringUtils.isNotEmpty(string)) : "Feature Id cannot be empty";
        this.featureIds.add(string);
        return this;
    }

    public FeatureCoefficientsQuery setFeatureIds(List<String> list) {
        if (list != null) {
            this.featureIds.addAll(list);
        }
        return this;
    }

    public FeatureCoefficientsQuery setMatchType(ColumnFilter.Match match) {
        assert (match != null) : "Match type cannot be null";
        this.matchingType = match;
        return this;
    }

    public FeatureCoefficientsQuery setFilterList(List<ColumnFilter> list) {
        if (list != null) {
            // empty if block
        }
        this.attributeFilters.addAll(list);
        return this;
    }

    public FeatureCoefficientsQuery setFetchSize(int n) {
        this.fetchSize = n;
        return this;
    }

    @Override
    public String getSQLCommand() {
        String string = this.getCoefficientColumn();
        SqlBuilder sqlBuilder = new SqlBuilder().select("PARTITION_NAME", "{$FEATURE_COLUMN} FEATURE_ID", "ATTRIBUTE_NAME", "CASE WHEN INSTR(ATTRIBUTE_SUBNAME, CHR(32)) > 0 THEN '''' || ATTRIBUTE_SUBNAME || '''' ELSE ATTRIBUTE_SUBNAME END ATTRIBUTE_SUBNAME", "ATTRIBUTE_VALUE", string + " AS COEFFICIENT").from("{$SOURCE}").where(Conditional.in(this.featureColumn, this.featureIds), Conditional.equalsOrNull("PARTITION_NAME", this.getPartitionId()), Conditional.between(this.getCoefficientColumn(), this.minCoefficient, this.maxCoefficient), StringUtils.addParentheses(this.getFilterCondition())).orderBy(Order.BySpec(this.sortSpecifications));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SOURCE", this.getCoefficientsSource());
        String string2 = StringUtils.getReplacedString(sqlBuilder.toString(), hashMap);
        hashMap.clear();
        hashMap.put("SCHEMA", this.getSchema());
        hashMap.put("MODEL_NAME", this.getModelName());
        hashMap.put("FEATURE_COLUMN", this.featureColumn);
        string2 = StringUtils.getReplacedString(string2, hashMap);
        if (this.fetchSize > -1) {
            hashMap.clear();
            hashMap.put("SOURCE", string2);
            hashMap.put("FETCH_SIZE", this.fetchSize.toString());
            string2 = StringUtils.getReplacedString(SQL_TEMPLATE, hashMap);
        }
        return string2;
    }

    private String getFilterCondition() {
        if (ColumnFilter.Match.NONE.equals((Object)this.matchingType) || this.attributeFilters.isEmpty()) {
            return "";
        }
        String string = DbVersionHelper.isDB122Up(this.dbVersion) ? (ExplicitSemanticAnalysisModelType.class.equals((Object)this.modelType) ? "ATTRIBUTE_SUBNAME" : "ATTRIBUTE_VALUE") : (NonNegativeMatrixFactorModelType.class.equals((Object)this.modelType) ? "ATTRIBUTE_VALUE" : "ATTRIBUTE_SUBNAME");
        return this.getAttributeFilterCondition(string);
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        String string = this.getCoefficientColumn();
        SqlUtils.setStringParameterList((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, this.featureColumn, this.featureIds);
        SqlUtils.setStringAtName((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
        if (this.minCoefficient != null && this.maxCoefficient != null) {
            oraclePreparedStatement.setBigDecimalAtName(string + "_FROM", this.minCoefficient);
            oraclePreparedStatement.setBigDecimalAtName(string + "_TO", this.maxCoefficient);
        }
    }
}

