/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clus.em;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlStringMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetComponentsQuery
extends SqlBaseModelQuery<String, OraclePreparedStatement> {
    private List<String> clusterIds;
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetComponentsQuery(Version version, ModelDescriptor modelDescriptor, List<String> list) {
        super(version, new SqlStringMapper(), modelDescriptor);
        this.clusterIds = list;
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.queryGenerator.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("COMPONENT_ID").from("{$SCHEMA}.DM$VO{$MODEL}").where(Conditional.in("CLUSTER_ID", GetComponentsQuery.this.clusterIds), Conditional.equals("PARTITION_NAME", GetComponentsQuery.this.getPartitionId()));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("SCHEMA", GetComponentsQuery.this.getSchema());
            hashMap.put("MODEL", GetComponentsQuery.this.getModelName());
            String string = StringUtils.getReplacedString(sqlBuilder.toString(), hashMap);
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringParameterList(oraclePreparedStatement, "CLUSTER_ID", GetComponentsQuery.this.clusterIds);
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetComponentsQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("COMPONENT_ID").from("TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:MODEL))").where(Conditional.equals("INFO_TYPE", "Cluster"), Conditional.in("CLUSTER_ID", GetComponentsQuery.this.clusterIds));
            String string = sqlBuilder.toString();
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "MODEL", GetComponentsQuery.this.getQualifiedName());
            SqlUtils.setStringAtName(oraclePreparedStatement, "INFO_TYPE", "Cluster");
            SqlUtils.setStringParameterList(oraclePreparedStatement, "CLUSTER_ID", GetComponentsQuery.this.clusterIds);
        }
    }
}

