/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.nb;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public abstract class GetPropensitiesBaseQuery<T, O extends OraclePreparedStatement>
extends SqlBaseModelQuery<T, O> {
    private Object targetValue1;
    private Object targetValue2;
    private Integer fetchSize;
    private boolean isStringTarget;
    private ISqlQuery<OraclePreparedStatement> query;
    protected static final String BASE_QUERY = "SELECT {$COLUMNS} FROM (\n  SELECT *\n  FROM (\n    SELECT attribute_name_subname,\n           attribute_value,\n           CASE WHEN v > 0 THEN\n               v\n             ELSE\n               NULL\n           END\n           propensity_target_one,\n           CASE WHEN v < 0 THEN\n               abs(v)\n             ELSE\n               NULL\n           END\n           propensity_target_two,\n           abs(v) propensity_target\n    FROM (\n      SELECT attribute_name_subname,\n             attribute_value,\n             ( nvl(c1, 0) - nvl(c2, 0) ) / ( nvl(c1, 0) + nvl(c2, 0) ) v\n      FROM (\n        SELECT *\n        FROM (\n          SELECT target_attribute_value,\n            attribute_name_subname,\n        attribute_value,\n        agg_attribute_value_prob\n          FROM (\n            SELECT /*+ NO_MERGE(P) */ target_attribute_value,\n                   attribute_name_subname,\n                   attribute_value,\n                   ( attribute_value_prob / SUM(attribute_value_prob) OVER(PARTITION BY attribute_name_subname, attribute_value) ) agg_attribute_value_prob\n            FROM (\n              {$QUERY}            ) p\n          )\n          ORDER BY attribute_name_subname, target_attribute_value\n        )\n      )\n      PIVOT ( MAX ( agg_attribute_value_prob )\n              FOR target_attribute_value IN ( {$TARGET_VALUE_PARAM_1} c1, {$TARGET_VALUE_PARAM_2} c2 ))\n      WHERE\n     c1 IS NOT NULL \n     OR\n        c2 IS NOT NULL\n    )\n  )\n  ORDER BY propensity_target DESC NULLS LAST,\n           attribute_name_subname ASC,\n           attribute_value ASC\n) {$FETCH_SIZE}";

    public GetPropensitiesBaseQuery(Version version, SqlMapper<T> sqlMapper, ModelDescriptor modelDescriptor, Object object, Object object2, Integer n) {
        super(version, sqlMapper, modelDescriptor);
        assert (object != null && object2 != null) : "Invalid target values 1:" + object + ", 2:" + object2;
        this.targetValue1 = object;
        this.targetValue2 = object2;
        this.isStringTarget = object instanceof String;
        this.fetchSize = n;
        this.query = DbVersionHelper.isDB122Up(this.dbVersion) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    public String getSQLCommand() {
        String string = this.targetValue1.toString();
        String string2 = this.targetValue2.toString();
        if (this.isStringTarget) {
            string = StringUtils.addSingleQuotes(StringUtils.escapeSingleQuotesForSQL(string));
            string2 = StringUtils.addSingleQuotes(StringUtils.escapeSingleQuotesForSQL(string2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("COLUMNS", this.getColumns());
        hashMap.put("QUERY", this.query.getSQLCommand());
        hashMap.put("TARGET_VALUE_PARAM_1", string);
        hashMap.put("TARGET_VALUE_PARAM_2", string2);
        hashMap.put("FETCH_SIZE", this.getFetchSize());
        String string3 = StringUtils.getReplacedString(BASE_QUERY, hashMap);
        return string3;
    }

    @Override
    protected void setParameters(O o) throws SQLException {
        this.query.setParameters((OraclePreparedStatement)o);
    }

    private String getFetchSize() {
        Object object = "";
        if (this.fetchSize != null) {
            object = "WHERE rownum <= " + this.fetchSize;
        }
        return object;
    }

    protected abstract String getColumns();

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "Select a.TARGET_VALUE as TARGET_ATTRIBUTE_VALUE,\n       b.PRIOR_PROBABILITY * a.CONDITIONAL_PROBABILITY as ATTRIBUTE_VALUE_PROB,\n       NVL2(a.ATTRIBUTE_SUBNAME, a.ATTRIBUTE_NAME ||  '.' ||  a.ATTRIBUTE_SUBNAME, a.ATTRIBUTE_NAME) ATTRIBUTE_NAME_SUBNAME,\n       a.ATTRIBUTE_VALUE\nFROM {$VIEW_PROBABILITIES} a,\n     {$VIEW_PRIORS} b\nWHERE A.TARGET_NAME  = B.TARGET_NAME\nAND   A.TARGET_VALUE = B.TARGET_VALUE\n{$PARTITION} ";

        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("VIEW_PROBABILITIES", GetPropensitiesBaseQuery.this.getViewName("DM$VV"));
            hashMap.put("VIEW_PRIORS", GetPropensitiesBaseQuery.this.getViewName("DM$VP"));
            hashMap.put("PARTITION", this.getPartitionSql());
            String string = StringUtils.getReplacedString(QUERY, hashMap);
            return string;
        }

        private String getPartitionSql() {
            Object object = Conditional.equals("A.PARTITION_NAME", "PARTITION_NAME", GetPropensitiesBaseQuery.this.getPartitionId());
            if (StringUtils.isNotEmpty((String)object)) {
                object = " AND " + (String)object;
            }
            return object;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetPropensitiesBaseQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            return "SELECT NVL(TO_CHAR(TARGET_ATTRIBUTE_NUM_VALUE), TARGET_ATTRIBUTE_STR_VALUE) TARGET_ATTRIBUTE_VALUE,\n       PRIOR_PROBABILITY * s.CONDITIONAL_PROBABILITY ATTRIBUTE_VALUE_PROB,\n       NVL2(s.ATTRIBUTE_SUBNAME, s.ATTRIBUTE_NAME ||  '.' ||  s.ATTRIBUTE_SUBNAME, s.ATTRIBUTE_NAME) ATTRIBUTE_NAME_SUBNAME,\n       NVL(TO_CHAR(s.ATTRIBUTE_NUM_VALUE), s.ATTRIBUTE_STR_VALUE) ATTRIBUTE_VALUE\nFROM\n  TABLE ( dbms_data_mining.get_model_details_nb(:model) ) t,\n  TABLE ( t.conditionals ) s";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetPropensitiesBaseQuery.this.getQualifiedName());
        }
    }
}

