/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.glm;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.glm.GetTotalCoefficientsForTargetMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetTotalCoefficientsForTargetQuery
extends SqlBaseModelQuery<Map<String, Object>, OraclePreparedStatement> {
    private boolean isClassification;
    private List<? extends Object> targetValues;

    public GetTotalCoefficientsForTargetQuery(Version version, ModelDescriptor modelDescriptor, List<? extends Object> list) {
        super(version, new GetTotalCoefficientsForTargetMapper(), modelDescriptor);
        assert (list != null && list.size() > 0) : "Not empty list";
        this.targetValues = list;
        this.isClassification = true;
    }

    public GetTotalCoefficientsForTargetQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new GetTotalCoefficientsForTargetMapper(), modelDescriptor);
    }

    @Override
    public String getSQLCommand() {
        String string = "SELECT COUNT(*) TOTAL_COEFFICIENTS, MAX(ABS(COEFFICIENT)) MAXIMUM_ABS_COEFFICIENT_VALUE\n    FROM {$TABLE}\n    {$WHERE}";
        String string2 = DbVersionHelper.isDB122Up(this.dbVersion) ? this.getSqlCommand122Up(string) : this.getSqlCommandOriginal(string);
        return string2;
    }

    private String getSqlCommandOriginal(String string) {
        String string2 = "TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_GLM(:MODEL))";
        String string3 = this.isClassification ? "WHERE " + Conditional.in("CLASS", "TARGET", this.targetValues) : "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", string2);
        hashMap.put("WHERE", string3);
        String string4 = StringUtils.getReplacedString(string, hashMap);
        return string4;
    }

    private String getSqlCommand122Up(String string) {
        String string2 = this.getViewName("DM$VD");
        String string3 = "WHERE " + Conditional.equalsOrNull("PARTITION_NAME", this.getPartitionId());
        string3 = string3 + (String)(this.isClassification ? " AND " + Conditional.in("TARGET_VALUE", "TARGET", this.targetValues) : "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE", string2);
        hashMap.put("WHERE", string3);
        String string4 = StringUtils.getReplacedString(string, hashMap);
        return string4;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.setParametersCommon(oraclePreparedStatement);
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
        } else {
            SqlUtils.setStringAtName(oraclePreparedStatement, "MODEL", this.getQualifiedName());
        }
    }

    private void setParametersCommon(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this.isClassification) {
            if (this.targetValues.get(0) instanceof String) {
                SqlUtils.setStringParameterList(oraclePreparedStatement, "TARGET", this.targetValues);
            } else if (this.targetValues.get(0) instanceof BigDecimal) {
                SqlUtils.setBigDecimalParameterList(oraclePreparedStatement, "TARGET", this.targetValues);
            } else assert (false) : "Invalid Target Type";
        }
    }
}

