/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.supervized.BaseTestModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.NameValue;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelPerformanceMatrixQuery
extends BaseTestModelQuery<NameValue, OraclePreparedStatement> {
    private static final String PARTITION_NAME = "PARTITION_NAME";
    private static final String METRIC_NAME = "METRIC_NAME";
    private static final List<String> CLASS_METRICS = new ArrayList<String>(4);
    private static final List<String> CLASS_METRICS_122;
    private static final List<String> REG_METRICS;
    private static final List<String> REG_METRICS_122;
    private String performanceTable;
    private List<String> metrics;

    public GetModelPerformanceMatrixQuery(Version version, CompareMode compareMode, QueryMode queryMode, String string, String string2) {
        super(version, new SqlDefaultMapper<NameValue>(NameValue.class), compareMode);
        this.performanceTable = string;
        this.initMetrics(queryMode);
        this.setPartitionId(string2);
    }

    private void initMetrics(QueryMode queryMode) {
        this.metrics = DbVersionHelper.isDB122Up(this.dbVersion) ? (queryMode == QueryMode.CLASSIFICATION ? CLASS_METRICS : REG_METRICS) : (queryMode == QueryMode.CLASSIFICATION ? CLASS_METRICS_122 : REG_METRICS_122);
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select("metric_name NAME", "metric_num_value BIG_DECIMAL_VALUE").from(this.performanceTable);
        if (this.isPartitioned()) {
            sqlBuilder.where(Conditional.in(METRIC_NAME, this.metrics), Conditional.equalsOrNull(PARTITION_NAME, this.getPartitionId()));
        } else {
            sqlBuilder.where(Conditional.in(METRIC_NAME, this.metrics));
        }
        String string = sqlBuilder.toString();
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringParameterList(oraclePreparedStatement, METRIC_NAME, this.metrics);
        SqlUtils.setStringAtName(oraclePreparedStatement, PARTITION_NAME, this.getPartitionId());
    }

    static {
        CLASS_METRICS.add("PREDICTIVE_CONFIDENCE");
        CLASS_METRICS.add("AVG_ACCURACY");
        CLASS_METRICS.add("ACCURACY");
        CLASS_METRICS.add("COST");
        CLASS_METRICS_122 = new ArrayList<String>(5);
        CLASS_METRICS_122.addAll(CLASS_METRICS);
        CLASS_METRICS.add("TEST_ROWS");
        REG_METRICS = new ArrayList<String>(5);
        REG_METRICS.add("PREDICTIVE_CONFIDENCE");
        REG_METRICS.add("MEAN_RMS_ERROR");
        REG_METRICS.add("MEAN_ABSOLUTE_ERROR");
        REG_METRICS.add("MEAN_PREDICATED_VALUE");
        REG_METRICS.add("MEAN_ACTUAL_VALUE");
        REG_METRICS_122 = new ArrayList<String>(5);
        REG_METRICS_122.addAll(REG_METRICS);
        REG_METRICS_122.add("TEST_ROWS");
    }

    public static enum QueryMode {
        CLASSIFICATION,
        REGRESSION;

    }
}

