/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.supervized.BaseTestModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetLiftResultsQuery<T>
extends BaseTestModelQuery<T, OraclePreparedStatement> {
    private String liftTable;

    public GetLiftResultsQuery(Version version, SqlMapper<T> sqlMapper, CompareMode compareMode, String string) {
        super(version, sqlMapper, compareMode);
        this.liftTable = string;
    }

    @Override
    protected String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select(new String[0]).from(this.liftTable);
        if (this.isPartitioned()) {
            sqlBuilder.where(Conditional.equalsOrNull("PARTITION_NAME", this.getPartitionId()));
        }
        sqlBuilder.orderBy("QUANTILE_NUMBER");
        String string = sqlBuilder.toString();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
    }
}

