/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlIntegerArrayMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.supervized.BaseTestModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetConfusionMatrixResultsQuery
extends BaseTestModelQuery<Integer[], OraclePreparedStatement> {
    private String confusionMatrixTable;
    private String targetDataType;
    private String targetValue;
    private ISqlQuery<OraclePreparedStatement> query;

    public GetConfusionMatrixResultsQuery(Version version, CompareMode compareMode, String string, String string2, String string3) {
        super(version, new SqlIntegerArrayMapper(), compareMode);
        this.confusionMatrixTable = string;
        this.targetDataType = string2;
        this.targetValue = string3;
        this.query = DbVersionHelper.isDB122Up(version) ? new DB122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        String string = this.query.getSQLCommand();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        boolean bl = DbMetadataUtils.isTargetNumericalDataTypeSupported(this.dbVersion, this.targetDataType);
        boolean bl2 = DbMetadataUtils.isTargetCategoricalDataTypeSupported(this.dbVersion, this.targetDataType);
        if (bl) {
            oraclePreparedStatement.setDoubleAtName("target", Double.parseDouble(this.targetValue));
        } else if (bl2) {
            oraclePreparedStatement.setStringAtName("target", this.targetValue);
        } else assert (false) : "Invalid Target Data Type";
        this.query.setParameters(oraclePreparedStatement);
    }

    private class DB122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "WITH partitioned_data as \n({$SQL}), \npos as   (SELECT sum(value) numPosTargets \n   FROM partitioned_data \n   WHERE actual_target_value = :target), \ntot as   (SELECT sum(value) totNumRows \n   FROM partitioned_data) \nSELECT numPosTargets, totNumRows FROM pos, tot";

        private DB122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("*").from(GetConfusionMatrixResultsQuery.this.confusionMatrixTable);
            if (GetConfusionMatrixResultsQuery.this.isPartitioned()) {
                sqlBuilder.where(Conditional.equalsOrNull("PARTITION_NAME", GetConfusionMatrixResultsQuery.this.getPartitionId()));
            }
            String string = StringUtils.getReplacedString(QUERY, sqlBuilder.toString());
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetConfusionMatrixResultsQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "WITH POS AS \n (SELECT SUM(VALUE) NUMPOSTARGETS FROM {$TABLE} WHERE ACTUAL_TARGET_VALUE = :target), \nTOT AS \n (SELECT SUM(VALUE) TOTNUMROWS FROM {$TABLE}) SELECT NUMPOSTARGETS, TOTNUMROWS FROM POS, TOT";

        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = StringUtils.getReplacedString(QUERY, GetConfusionMatrixResultsQuery.this.confusionMatrixTable);
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        }
    }
}

