/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ar.ap;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.ar.ap.GetRulesMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.model.ar.filter.FilterFor;
import oracle.dmt.dataminer.core.model.ar.filter.FilterOn;
import oracle.dmt.dataminer.core.model.ar.filter.FilterRule;
import oracle.dmt.dataminer.core.model.ar.filter.FilterType;
import oracle.dmt.dataminer.core.model.common.Range;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.model.generated.server.DmItems;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetRulesQuery
extends SqlBaseModelQuery<Rule, OraclePreparedStatement> {
    private static final String ANT_ITEMS = "ANT_ITEMS";
    private static final String CONFIDENCE = "RULE_CONFIDENCE";
    private static final String CONFIDENCE_MAX = "RULE_CONFIDENCE_TO";
    private static final String CONFIDENCE_MIN = "RULE_CONFIDENCE_FROM";
    private static final String REV_CONFIDENCE = "RULE_REVCONFIDENCE";
    private static final String REV_CONFIDENCE_MAX = "RULE_REVCONFIDENCE_TO";
    private static final String REV_CONFIDENCE_MIN = "RULE_REVCONFIDENCE_FROM";
    private static final String CONS_ITEMS = "CONS_ITEMS";
    private static final String FETCH_SIZE = "FETCH_SIZE";
    private static final String LIFT = "RULE_LIFT";
    private static final String LIFT_MAX = "RULE_LIFT_TO";
    private static final String LIFT_MIN = "RULE_LIFT_FROM";
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final String NUMBER_OF_ITEMS = "NUMBER_OF_ITEMS";
    private static final String NUMBER_OF_ITEMS_MAX = "NUMBER_OF_ITEMS_TO";
    private static final String NUMBER_OF_ITEMS_MIN = "NUMBER_OF_ITEMS_FROM";
    private static final String PARTITION = "PARTITION_NAME";
    private static final String SORT = "SORT";
    private static final String SUPPORT = "RULE_SUPPORT";
    private static final String SUPPORT_MAX = "RULE_SUPPORT_TO";
    private static final String SUPPORT_MIN = "RULE_SUPPORT_FROM";
    private static final String SUPPORT_ANT = "ANTECEDENT_SUPPORT";
    private static final String SUPPORT_ANT_MAX = "ANTECEDENT_SUPPORT_TO";
    private static final String SUPPORT_ANT_MIN = "ANTECEDENT_SUPPORT_FROM";
    private static final String SUPPORT_CONS = "CONSEQUENT_SUPPORT";
    private static final String SUPPORT_CONS_MAX = "CONSEQUENT_SUPPORT_TO";
    private static final String SUPPORT_CONS_MIN = "CONSEQUENT_SUPPORT_FROM";
    private static final String SUPPORT_COUNT = "RULE_SUPPORT";
    private static final String SUPPORT_COUNT_MAX = "RULE_SUPPORT_COUNT_TO";
    private static final String SUPPORT_COUNT_MIN = "RULE_SUPPORT_COUNT_FROM";
    private static final String SUPPORT_COUNT_ANT = "ANTECEDENT_SUPPORT";
    private static final String SUPPORT_COUNT_ANT_MAX = "ANTECEDENT_SUPPORT_COUNT_TO";
    private static final String SUPPORT_COUNT_ANT_MIN = "ANTECEDENT_SUPPORT_COUNT_FROM";
    private static final String SUPPORT_COUNT_CONS = "CONSEQUENT_SUPPORT";
    private static final String SUPPORT_COUNT_CONS_MAX = "CONSEQUENT_SUPPORT_COUNT_TO";
    private static final String SUPPORT_COUNT_CONS_MIN = "CONSEQUENT_SUPPORT_COUNT_FROM";
    private static final String CONSEQUENT_INCLUDE = "CONSEQUENT_NAME_INC";
    private static final String CONSEQUENT_EXCLUDE = "CONSEQUENT_NAME_EXC";
    private Double confidenceMax;
    private Double confidenceMin;
    private Double liftMax;
    private Double liftMin;
    private Double revConfidenceMax;
    private Double revConfidenceMin;
    private Double supportAntMax;
    private Double supportAntMin;
    private Double supportConsMax;
    private Double supportConsMin;
    private Double supportCountAntMax;
    private Double supportCountAntMin;
    private Double supportCountConsMax;
    private Double supportCountConsMin;
    private Double supportCountMax;
    private Double supportCountMin;
    private Double supportMax;
    private Double supportMin;
    private Integer ruleLengthMax;
    private Integer ruleLengthMin;
    private Integer fetchSize;
    private List<AggregateFilter> aggFilters;
    private List<String> antInclude;
    private List<String> antExclude;
    private List<String> conInclude;
    private List<String> conExclude;
    private boolean hasAggregates;
    private boolean hasAntecedentFilter;
    private List<SortSpec> sorting;
    private DmItems conditionItemFilter;
    private DmItems associationItemFilter;
    private List<String> aggregates;
    private List<FilterRule> filters;
    private int transactionCount;
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetRulesQuery(Version version, ModelDescriptor modelDescriptor, int n, List<String> list, int n2) {
        super(version, new GetRulesMapper(version, list, n2), modelDescriptor);
        assert (list != null);
        this.fetchSize = n;
        this.aggregates = list;
        this.hasAggregates = !this.aggregates.isEmpty();
        this.transactionCount = n2;
        this.filters = Collections.emptyList();
        this.sorting = Collections.emptyList();
        this.aggFilters = new ArrayList<AggregateFilter>();
        this.antInclude = new ArrayList<String>();
        this.antExclude = new ArrayList<String>();
        this.conInclude = new ArrayList<String>();
        this.conExclude = new ArrayList<String>();
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new DB12_2Query() : new DBOriginalQuery();
    }

    public GetRulesQuery setFilter(List<FilterRule> list) {
        this.filters = list;
        this.processFilter();
        return this;
    }

    private void processFilter() {
        for (FilterRule filterRule : this.filters) {
            if (FilterType.METRIC.equals((Object)filterRule.getFilterType())) {
                this.processMetricRule(filterRule);
                continue;
            }
            this.processItemRule(filterRule);
        }
    }

    private void processMetricRule(FilterRule filterRule) {
        Double d;
        Range range = filterRule.getRange();
        Double d2 = range.getMin() != null ? Double.valueOf(range.getMin().doubleValue()) : null;
        boolean bl = this.processMetricRuleCommon(filterRule, d2, d = range.getMax() != null ? Double.valueOf(range.getMax().doubleValue()) : null);
        if (!bl && DbVersionHelper.isDB122Up(this.dbVersion)) {
            this.processMetricRule12_2(filterRule, d2, d);
        }
    }

    private boolean processMetricRuleCommon(FilterRule filterRule, Double d, Double d2) {
        boolean bl = false;
        if (FilterOn.LIFT.equals(filterRule.getFilterOn())) {
            this.liftMin = d;
            this.liftMax = d2;
            bl = true;
        } else if (FilterOn.CONFIDENCE.equals(filterRule.getFilterOn())) {
            this.confidenceMin = d;
            this.confidenceMax = d2;
            bl = true;
        } else if (FilterOn.SUPPORT.equals(filterRule.getFilterOn()) && FilterFor.RULE.equals((Object)filterRule.getFilterFor())) {
            this.supportMin = d;
            this.supportMax = d2;
            bl = true;
        } else if (FilterOn.ITEMS_IN_RULE.equals(filterRule.getFilterOn())) {
            this.ruleLengthMin = d.intValue();
            this.ruleLengthMax = d2.intValue();
            bl = true;
        }
        assert (DbVersionHelper.isDB122Up(this.dbVersion) || !DbVersionHelper.isDB122Up(this.dbVersion) && bl) : "Not valid filter for this DB Version";
        return bl;
    }

    private void processMetricRule12_2(FilterRule filterRule, Double d, Double d2) {
        if (FilterOn.REV_CONFIDENCE.equals(filterRule.getFilterOn())) {
            this.revConfidenceMin = d;
            this.revConfidenceMax = d2;
            return;
        }
        if (FilterOn.SUPPORT.equals(filterRule.getFilterOn()) && FilterFor.ANTECEDENT.equals((Object)filterRule.getFilterFor())) {
            this.supportAntMin = d;
            this.supportAntMax = d2;
            return;
        }
        if (FilterOn.SUPPORT.equals(filterRule.getFilterOn()) && FilterFor.CONSEQUENT.equals((Object)filterRule.getFilterFor())) {
            this.supportConsMin = d;
            this.supportConsMax = d2;
            return;
        }
        if (FilterOn.SUPPORT_COUNT.equals(filterRule.getFilterOn()) && FilterFor.RULE.equals((Object)filterRule.getFilterFor())) {
            this.supportCountMin = d != null ? Double.valueOf(d / (double)this.transactionCount) : null;
            this.supportCountMax = d2 != null ? Double.valueOf(d2 / (double)this.transactionCount) : null;
            return;
        }
        if (FilterOn.SUPPORT_COUNT.equals(filterRule.getFilterOn()) && FilterFor.ANTECEDENT.equals((Object)filterRule.getFilterFor())) {
            this.supportCountAntMin = d != null ? Double.valueOf(d / (double)this.transactionCount) : null;
            this.supportCountAntMax = d2 != null ? Double.valueOf(d2 / (double)this.transactionCount) : null;
            return;
        }
        if (FilterOn.SUPPORT_COUNT.equals(filterRule.getFilterOn()) && FilterFor.CONSEQUENT.equals((Object)filterRule.getFilterFor())) {
            this.supportCountConsMin = d != null ? Double.valueOf(d / (double)this.transactionCount) : null;
            this.supportCountConsMax = d2 != null ? Double.valueOf(d2 / (double)this.transactionCount) : null;
            return;
        }
        if (filterRule.getFilterOn().isAggregate()) {
            this.processAggregateFilter(filterRule, d, d2);
        } else assert (false) : "Missing filter handler";
    }

    private void processAggregateFilter(FilterRule filterRule, Double d, Double d2) {
        FilterOn filterOn = filterRule.getFilterOn();
        String string = filterOn.getAggregateName();
        AggregateFilter aggregateFilter = new AggregateFilter();
        if (filterOn.isItemSetAggretate()) {
            String string2 = "ANT_" + string;
            String string3 = "CON_" + string;
            if (FilterFor.ANTECEDENT.equals((Object)filterRule.getFilterFor())) {
                aggregateFilter.setColumnAndHolder(string2);
            } else if (FilterFor.CONSEQUENT.equals((Object)filterRule.getFilterFor())) {
                aggregateFilter.setColumnAndHolder(string3);
            } else if (FilterFor.RULE.equals((Object)filterRule.getFilterFor())) {
                aggregateFilter.setColumn("(" + string2 + " + " + string3 + ")");
                aggregateFilter.setFromHolder("RULE_" + string + "_FROM");
                aggregateFilter.setToHolder("RULE_" + string + "_TO");
            }
        } else {
            String string4 = "ANT_RULE_" + string;
            String string5 = "CON_RULE_" + string;
            if (FilterFor.ANTECEDENT.equals((Object)filterRule.getFilterFor())) {
                aggregateFilter.setColumnAndHolder(string4);
            } else if (FilterFor.CONSEQUENT.equals((Object)filterRule.getFilterFor())) {
                aggregateFilter.setColumnAndHolder(string5);
            } else if (FilterFor.RULE.equals((Object)filterRule.getFilterFor())) {
                aggregateFilter.setColumnAndHolder("(" + string4 + " + " + string5 + ")");
                aggregateFilter.setFromHolder("RULE_RULE_" + string + "_FROM");
                aggregateFilter.setToHolder("RULE_RULE_" + string + "_TO");
            }
        }
        aggregateFilter.setMin(d);
        aggregateFilter.setMax(d2);
        this.aggFilters.add(aggregateFilter);
    }

    private void processItemRule(FilterRule filterRule) {
        if (FilterFor.CONSEQUENT.equals((Object)filterRule.getFilterFor())) {
            if (FilterType.ITEM_INCLUDE.equals((Object)filterRule.getFilterType())) {
                this.conInclude.add(filterRule.getValue());
            } else {
                this.conExclude.add(filterRule.getValue());
            }
        } else if (FilterFor.ANTECEDENT.equals((Object)filterRule.getFilterFor())) {
            this.hasAntecedentFilter = true;
            if (FilterType.ITEM_INCLUDE.equals((Object)filterRule.getFilterType())) {
                this.antInclude.add(filterRule.getValue());
            } else {
                this.antExclude.add(filterRule.getValue());
            }
        }
    }

    public GetRulesQuery setSorting(List<SortSpec> list) {
        this.sorting = list;
        return this;
    }

    @Override
    protected String getSQLCommand() {
        String string = this.queryGenerator.getSQLCommand();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class AggregateFilter {
        private String column;
        private String fromHolder;
        private String toHolder;
        private Double min;
        private Double max;

        private AggregateFilter() {
        }

        private void setColumnAndHolder(String string) {
            this.column = string;
            this.fromHolder = string + "_FROM";
            this.toHolder = string + "_TO";
        }

        private void setColumn(String string) {
            this.column = string;
        }

        private void setFromHolder(String string) {
            this.fromHolder = string;
        }

        private void setToHolder(String string) {
            this.toHolder = string;
        }

        private void setMax(Double d) {
            this.max = d;
        }

        private void setMin(Double d) {
            this.min = d;
        }
    }

    private class DB12_2Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String BASE_QUERY = "{$ANTECEDENT_QUERY}TOPN_RULES as\n(select * from \n ({$FILTER_QUERY})\n  where rnk <= {$FETCH_SIZE}),\nANT_RULES as \n (select ALL_R.RULE_ID, ALL_R.ANTECEDENT\n  from TOPN_RULES, {$RULES_VIEW} ALL_R\n  where TOPN_RULES.RULE_ID = ALL_R.RULE_ID \n  {$PARTITION}  order by rnk),\nANT_INFO as \n(select rownum as rindex, r.*, items.* from ANT_RULES r, xmltable('itemset/item' passing r.ANTECEDENT \n  columns\n{$XML_AGG_COLS}   \"INAME\"    varchar(128) path 'item_name',\n   \"ISUBNAME\" varchar(128) path 'item_subname',\n   \"IVALUE\"   varchar(128) path 'item_value') ITEMS) ,\nANT_INFO_AGG as\n(select RULE_ID,\n{$LISTAGG_AGGS}        listagg(INAME,    chr(0)) within group(order by rindex) as INAMES,\n        listagg(ISUBNAME, chr(0)) within group(order by rindex) as ISUBNAMES,\n        listagg(IVALUE  , chr(0)) within group(order by rindex) as IVALUES\nfrom ANT_INFO \ngroup by RULE_ID)\nselect ALL_R.*, AGG.*\nfrom ANT_INFO_AGG AGG, {$RULES_VIEW} ALL_R \nwhere AGG.RULE_ID = ALL_R.RULE_ID\n{$PARTITION}order by {$SORTING}";

        private DB12_2Query() {
        }

        @Override
        public String getSQLCommand() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("ANTECEDENT_QUERY", this.getAntecedentFilterSql());
            hashMap.put("FILTER_QUERY", this.getFilterSql());
            hashMap.put(GetRulesQuery.FETCH_SIZE, Integer.toString(GetRulesQuery.this.fetchSize));
            hashMap.put("XML_AGG_COLS", this.getXMLAggColumns());
            hashMap.put("LISTAGG_AGGS", this.getListAggAggregates());
            hashMap.put("PARTITION", GetRulesQuery.this.isPartitioned() ? "and PARTITION_NAME = :PARTITION_NAME \n" : "");
            String string = StringUtils.getReplacedString(BASE_QUERY, hashMap);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("SORTING", SortSpec.getSortSql(GetRulesQuery.this.sorting));
            hashMap2.put("RULES_VIEW", GetRulesQuery.this.getViewName("DM$VR"));
            String string2 = StringUtils.getReplacedString(string, hashMap2);
            return string2;
        }

        private String getAntecedentFilterSql() {
            Object object = "WITH ";
            if (GetRulesQuery.this.hasAntecedentFilter) {
                object = this.generateAntecedentSql(GetRulesQuery.this.antInclude, GetRulesQuery.this.antExclude);
                object = "WITH ANT_FILTER AS \n (" + (String)object + "), \n";
            }
            return object;
        }

        private String generateAntecedentSql(List<String> list, List<String> list2) {
            Object object;
            String string = "SELECT rule_id, antecedent\nFROM {$RULES_VIEW} \nWHERE {$LIKES}  \n";
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (bl) {
                    stringBuilder.append("(");
                    bl = false;
                }
                stringBuilder.append("ANTECEDENT LIKE '%<item_name>");
                stringBuilder.append((String)object);
                stringBuilder.append("</item_name>%'");
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" AND ");
            }
            if (list.size() > 0) {
                stringBuilder.append(")");
                if (list2.size() > 0) {
                    stringBuilder.append(" AND ");
                }
            }
            iterator = list2.iterator();
            bl = true;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (bl) {
                    stringBuilder.append("(");
                    bl = false;
                }
                stringBuilder.append("ANTECEDENT NOT LIKE '%<item_name>");
                stringBuilder.append((String)object);
                stringBuilder.append("</item_name>%'");
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" AND ");
            }
            if (list2.size() > 0) {
                stringBuilder.append(")");
            }
            object = new HashMap();
            object.put("LIKES", stringBuilder.toString());
            String string2 = StringUtils.getReplacedString(string, (Map<String, String>)object);
            return string2;
        }

        private String getFilterSql() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Conditional.equals(GetRulesQuery.PARTITION, GetRulesQuery.this.getPartitionId()));
            arrayList.add(Conditional.greaterEquals(GetRulesQuery.LIFT, GetRulesQuery.LIFT_MIN, GetRulesQuery.this.liftMin));
            arrayList.add(Conditional.lessEquals(GetRulesQuery.LIFT, GetRulesQuery.LIFT_MAX, GetRulesQuery.this.liftMax));
            arrayList.add(Conditional.greaterEquals(GetRulesQuery.CONFIDENCE, GetRulesQuery.CONFIDENCE_MIN, GetRulesQuery.this.confidenceMin));
            arrayList.add(Conditional.lessEquals(GetRulesQuery.CONFIDENCE, GetRulesQuery.CONFIDENCE_MAX, GetRulesQuery.this.confidenceMax));
            arrayList.add(Conditional.greaterEquals("RULE_SUPPORT", GetRulesQuery.SUPPORT_MIN, GetRulesQuery.this.supportMin));
            arrayList.add(Conditional.lessEquals("RULE_SUPPORT", GetRulesQuery.SUPPORT_MAX, GetRulesQuery.this.supportMax));
            arrayList.add(Conditional.greaterEquals(GetRulesQuery.NUMBER_OF_ITEMS, GetRulesQuery.NUMBER_OF_ITEMS_MIN, GetRulesQuery.this.ruleLengthMin));
            arrayList.add(Conditional.lessEquals(GetRulesQuery.NUMBER_OF_ITEMS, GetRulesQuery.NUMBER_OF_ITEMS_MAX, GetRulesQuery.this.ruleLengthMax));
            arrayList.add(Conditional.greaterEquals(GetRulesQuery.REV_CONFIDENCE, GetRulesQuery.REV_CONFIDENCE_MIN, GetRulesQuery.this.revConfidenceMin));
            arrayList.add(Conditional.lessEquals(GetRulesQuery.REV_CONFIDENCE, GetRulesQuery.REV_CONFIDENCE_MAX, GetRulesQuery.this.revConfidenceMax));
            arrayList.add(Conditional.greaterEquals("ANTECEDENT_SUPPORT", GetRulesQuery.SUPPORT_ANT_MIN, GetRulesQuery.this.supportAntMin));
            arrayList.add(Conditional.lessEquals("ANTECEDENT_SUPPORT", GetRulesQuery.SUPPORT_ANT_MAX, GetRulesQuery.this.supportAntMax));
            arrayList.add(Conditional.greaterEquals("CONSEQUENT_SUPPORT", GetRulesQuery.SUPPORT_CONS_MIN, GetRulesQuery.this.supportConsMin));
            arrayList.add(Conditional.lessEquals("CONSEQUENT_SUPPORT", GetRulesQuery.SUPPORT_CONS_MAX, GetRulesQuery.this.supportConsMax));
            arrayList.add(Conditional.greaterEquals("RULE_SUPPORT", GetRulesQuery.SUPPORT_COUNT_MIN, GetRulesQuery.this.supportCountMin));
            arrayList.add(Conditional.lessEquals("RULE_SUPPORT", GetRulesQuery.SUPPORT_COUNT_MAX, GetRulesQuery.this.supportCountMax));
            arrayList.add(Conditional.greaterEquals("ANTECEDENT_SUPPORT", GetRulesQuery.SUPPORT_COUNT_ANT_MIN, GetRulesQuery.this.supportCountAntMin));
            arrayList.add(Conditional.lessEquals("ANTECEDENT_SUPPORT", GetRulesQuery.SUPPORT_COUNT_ANT_MAX, GetRulesQuery.this.supportCountAntMax));
            arrayList.add(Conditional.greaterEquals("CONSEQUENT_SUPPORT", GetRulesQuery.SUPPORT_COUNT_CONS_MIN, GetRulesQuery.this.supportCountConsMin));
            arrayList.add(Conditional.lessEquals("CONSEQUENT_SUPPORT", GetRulesQuery.SUPPORT_COUNT_CONS_MAX, GetRulesQuery.this.supportCountConsMax));
            arrayList.add(Conditional.in("CONSEQUENT_NAME", GetRulesQuery.CONSEQUENT_INCLUDE, GetRulesQuery.this.conInclude));
            arrayList.add(Conditional.notIn("CONSEQUENT_NAME", GetRulesQuery.CONSEQUENT_EXCLUDE, GetRulesQuery.this.conExclude));
            for (AggregateFilter object2 : GetRulesQuery.this.aggFilters) {
                arrayList.add(Conditional.greaterEquals(object2.column, object2.fromHolder, object2.min));
                arrayList.add(Conditional.lessEquals(object2.column, object2.toHolder, object2.max));
            }
            Object object3 = "{$RULES_VIEW} r";
            if (GetRulesQuery.this.hasAntecedentFilter) {
                object3 = "{$RULES_VIEW} r, ANT_FILTER a";
                arrayList.add("r.rule_id = a.rule_id");
            }
            SqlBuilder sqlBuilder = new SqlBuilder().select("r.rule_id", "row_number() over (order by {$SORTING}) rnk").from((String)object3).where(arrayList.toArray(new String[arrayList.size()]));
            String string = sqlBuilder.toString();
            return string;
        }

        private String getXMLAggColumns() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < GetRulesQuery.this.aggregates.size(); ++i) {
                stringBuilder.append("   \"IASSO_AGG");
                stringBuilder.append(i);
                stringBuilder.append("\" varchar(128) PATH '");
                stringBuilder.append("ASSO_AGG");
                stringBuilder.append(i);
                stringBuilder.append("', \n");
            }
            return stringBuilder.toString();
        }

        private String getListAggAggregates() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < GetRulesQuery.this.aggregates.size(); ++i) {
                stringBuilder.append("        listagg(IASSO_AGG");
                stringBuilder.append(i);
                stringBuilder.append(" , chr(0)) within group(order by rindex) as IASSO_AGG");
                stringBuilder.append(i);
                stringBuilder.append("S, \n");
            }
            return stringBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, GetRulesQuery.PARTITION, GetRulesQuery.this.getPartitionId());
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.LIFT_MIN, GetRulesQuery.this.liftMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.LIFT_MAX, GetRulesQuery.this.liftMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.CONFIDENCE_MIN, GetRulesQuery.this.confidenceMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.CONFIDENCE_MAX, GetRulesQuery.this.confidenceMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_MIN, GetRulesQuery.this.supportMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_MAX, GetRulesQuery.this.supportMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_ANT_MIN, GetRulesQuery.this.supportAntMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_ANT_MAX, GetRulesQuery.this.supportAntMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_CONS_MIN, GetRulesQuery.this.supportConsMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_CONS_MAX, GetRulesQuery.this.supportConsMax);
            SqlUtils.setIntAtName(oraclePreparedStatement, GetRulesQuery.NUMBER_OF_ITEMS_MIN, GetRulesQuery.this.ruleLengthMin);
            SqlUtils.setIntAtName(oraclePreparedStatement, GetRulesQuery.NUMBER_OF_ITEMS_MAX, GetRulesQuery.this.ruleLengthMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.REV_CONFIDENCE_MIN, GetRulesQuery.this.revConfidenceMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.REV_CONFIDENCE_MAX, GetRulesQuery.this.revConfidenceMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_COUNT_MIN, GetRulesQuery.this.supportCountMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_COUNT_MAX, GetRulesQuery.this.supportCountMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_COUNT_ANT_MIN, GetRulesQuery.this.supportCountAntMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_COUNT_ANT_MAX, GetRulesQuery.this.supportCountAntMax);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_COUNT_CONS_MIN, GetRulesQuery.this.supportCountConsMin);
            SqlUtils.setDoubleAtName(oraclePreparedStatement, GetRulesQuery.SUPPORT_COUNT_CONS_MAX, GetRulesQuery.this.supportCountConsMax);
            for (AggregateFilter aggregateFilter : GetRulesQuery.this.aggFilters) {
                SqlUtils.setDoubleAtName(oraclePreparedStatement, aggregateFilter.fromHolder, aggregateFilter.min);
                SqlUtils.setDoubleAtName(oraclePreparedStatement, aggregateFilter.toHolder, aggregateFilter.max);
            }
            SqlUtils.setStringParameterList(oraclePreparedStatement, GetRulesQuery.CONSEQUENT_INCLUDE, GetRulesQuery.this.conInclude);
            SqlUtils.setStringParameterList(oraclePreparedStatement, GetRulesQuery.CONSEQUENT_EXCLUDE, GetRulesQuery.this.conExclude);
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetRulesQuery.this.isPartitioned() ? ",:PARTITION_NAME" : "";
            Object[] objectArray = new Object[]{GetRulesQuery.MODEL_NAME, GetRulesQuery.FETCH_SIZE, GetRulesQuery.CONFIDENCE, "RULE_SUPPORT", GetRulesQuery.NUMBER_OF_ITEMS_MAX, GetRulesQuery.NUMBER_OF_ITEMS_MIN, GetRulesQuery.SORT, GetRulesQuery.ANT_ITEMS, GetRulesQuery.CONS_ITEMS, GetRulesQuery.LIFT, string};
            String string2 = "select * \nfrom table(DBMS_DATA_MINING.GET_ASSOCIATION_RULES(:%s, :%s, NULL, :%s, :%s,\n                                                  :%s, :%s, :%s, :%s, :%s, \n                                                  :%s %s)) t";
            String string3 = String.format(string2, objectArray);
            return string3;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setIntAtName(GetRulesQuery.FETCH_SIZE, GetRulesQuery.this.fetchSize.intValue());
            oraclePreparedStatement.setStringAtName(GetRulesQuery.MODEL_NAME, GetRulesQuery.this.getQualifiedName());
            SqlUtils.setDoubleOrNullAtName(oraclePreparedStatement, GetRulesQuery.LIFT, GetRulesQuery.this.liftMin);
            SqlUtils.setDoubleOrNullAtName(oraclePreparedStatement, GetRulesQuery.CONFIDENCE, GetRulesQuery.this.confidenceMin);
            SqlUtils.setDoubleOrNullAtName(oraclePreparedStatement, "RULE_SUPPORT", GetRulesQuery.this.supportMin);
            SqlUtils.setIntOrNullAtName(oraclePreparedStatement, GetRulesQuery.NUMBER_OF_ITEMS_MIN, GetRulesQuery.this.ruleLengthMin);
            SqlUtils.setIntOrNullAtName(oraclePreparedStatement, GetRulesQuery.NUMBER_OF_ITEMS_MAX, GetRulesQuery.this.ruleLengthMax);
            SqlUtils.setORADataOrNullAtName(oraclePreparedStatement, GetRulesQuery.SORT, 2003, "SYS.ORA_MINING_VARCHAR2_NT", SortSpec.getSortCollection(GetRulesQuery.this.sorting));
            SqlUtils.setORADataOrNullAtName(oraclePreparedStatement, GetRulesQuery.ANT_ITEMS, 2003, "SYS.DM_ITEMS", GetRulesQuery.this.conditionItemFilter);
            SqlUtils.setORADataOrNullAtName(oraclePreparedStatement, GetRulesQuery.CONS_ITEMS, 2003, "SYS.DM_ITEMS", GetRulesQuery.this.associationItemFilter);
        }
    }
}

