/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries;

import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDoubleMapper;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public abstract class AggregateQuery
extends SqlQuery<Double, OraclePreparedStatement> {
    private static final String FORMAT = "%s(%s)";
    private Aggregate function;
    private String source;
    private String column;

    public AggregateQuery(Version version, Aggregate aggregate, String string, String string2) {
        this(version, aggregate);
        this.source = string2;
        this.column = string;
    }

    public AggregateQuery(Version version, Aggregate aggregate) {
        super(version, new SqlDoubleMapper());
        this.function = aggregate;
    }

    protected SqlBuilder getSqlBuilder() {
        assert (StringUtils.isNotEmpty(this.column) && StringUtils.isNotEmpty(this.source)) : "Column and Source must be defined.";
        SqlBuilder sqlBuilder = new SqlBuilder().select(this.function.toString(this.column)).from(this.source);
        return sqlBuilder;
    }

    protected AggregateQuery setSource(String string) {
        this.source = string;
        return this;
    }

    protected AggregateQuery setColumn(String string) {
        this.column = string;
        return this;
    }

    public static enum Aggregate {
        COUNT,
        MAX,
        MIN,
        AVG;


        public String toString(String string) {
            if (StringUtils.isEmpty(string)) {
                return "";
            }
            return String.format(AggregateQuery.FORMAT, this.name(), string);
        }
    }
}

