/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clus.common;

import java.sql.ResultSet;
import oracle.dmt.dataminer.core.dal.sql.ISqlMapper;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.ar.PredicateRowData;
import oracle.dmt.dataminer.core.model.ar.RuleRowData;
import oracle.dmt.dataminer.core.model.clus.CentroidRowData;
import oracle.dmt.dataminer.core.model.clus.ClusteringAlgorithm;
import oracle.dmt.dataminer.core.model.clus.ClusteringDetailRow;
import oracle.dmt.dataminer.core.model.generated.server.DmCentroids;
import oracle.dmt.dataminer.core.model.generated.server.DmChildren;
import oracle.dmt.dataminer.core.model.generated.server.DmPredicates;
import oracle.dmt.dataminer.core.model.generated.server.DmRule;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleResultSet;

public class GetClusterModelDetailsQueryMapper
extends SqlMapper<ClusteringDetailRow> {
    private boolean levelDetailsAll;
    private ISqlMapper<ClusteringDetailRow> mapper;
    private ClusteringAlgorithm algorithmType;

    public GetClusterModelDetailsQueryMapper(Version version, ClusteringAlgorithm clusteringAlgorithm, Boolean bl) {
        super(version);
        this.algorithmType = clusteringAlgorithm;
        this.levelDetailsAll = bl;
        this.mapper = DbVersionHelper.isDB122Up(version) ? new DB12_2Mapper() : (DbVersionHelper.isDB121Up(this.dbVersion) ? new DB12_0Mapper() : new DB11Mapper());
    }

    @Override
    public ClusteringDetailRow map(ResultSet resultSet) throws Exception {
        return this.mapper.map(resultSet);
    }

    private class DB12_2Mapper
    implements ISqlMapper<ClusteringDetailRow> {
        private DB12_2Mapper() {
        }

        @Override
        public ClusteringDetailRow map(ResultSet resultSet) throws Exception {
            Object object;
            ClusteringDetailRow clusteringDetailRow = new ClusteringDetailRow();
            clusteringDetailRow.setId(resultSet.getInt("CLUSTER_ID"));
            clusteringDetailRow.setClusterId(resultSet.getString("CLUSTER_ID"));
            clusteringDetailRow.setCount(resultSet.getInt("RECORD_COUNT"));
            clusteringDetailRow.setParent(resultSet.getInt("PARENT"));
            clusteringDetailRow.setTreeLevel(resultSet.getInt("TREE_LEVEL"));
            Integer n = resultSet.getInt("LEFT_CHILD_ID");
            Integer n2 = resultSet.getInt("RIGHT_CHILD_ID");
            clusteringDetailRow.setChild(ClusteringDetailRow.createChildren(n, n2));
            if (ClusteringAlgorithm.OCLUSTER.equals((Object)GetClusterModelDetailsQueryMapper.this.algorithmType)) {
                object = (DmPredicates)((OracleResultSet)resultSet).getORAData("SPLIT_PREDICATE", DmPredicates.getORADataFactory());
                clusteringDetailRow.setSplitPredicate(PredicateRowData.createPredicatesFrom((DmPredicates)object));
            } else if (ClusteringAlgorithm.KMEANS.equals((Object)GetClusterModelDetailsQueryMapper.this.algorithmType)) {
                object = resultSet.getDouble("DISPERSION");
                clusteringDetailRow.setDispersion((Double)object);
            }
            if (GetClusterModelDetailsQueryMapper.this.levelDetailsAll) {
                object = (DmCentroids)((OracleResultSet)resultSet).getORAData("CENTROID", DmCentroids.getORADataFactory());
                clusteringDetailRow.setCentroid(CentroidRowData.createCentroidsFromDmCentroids((DmCentroids)object));
                DmRule dmRule = (DmRule)((OracleResultSet)resultSet).getORAData("RULE", DmRule.getORADataFactory());
                if (dmRule != null) {
                    clusteringDetailRow.setRule(new RuleRowData(dmRule));
                }
            }
            return clusteringDetailRow;
        }
    }

    private class DB12_0Mapper
    implements ISqlMapper<ClusteringDetailRow> {
        private DB12_0Mapper() {
        }

        @Override
        public ClusteringDetailRow map(ResultSet resultSet) throws Exception {
            Object object;
            ClusteringDetailRow clusteringDetailRow = new ClusteringDetailRow();
            clusteringDetailRow.setId(resultSet.getInt("ID"));
            clusteringDetailRow.setClusterId(resultSet.getString("CLUSTER_ID"));
            clusteringDetailRow.setCount(resultSet.getInt("RECORD_COUNT"));
            clusteringDetailRow.setParent(resultSet.getInt("PARENT"));
            clusteringDetailRow.setTreeLevel(resultSet.getInt("TREE_LEVEL"));
            clusteringDetailRow.setDispersion(resultSet.getDouble("DISPERSION"));
            if (ClusteringAlgorithm.OCLUSTER.equals((Object)GetClusterModelDetailsQueryMapper.this.algorithmType)) {
                object = (DmPredicates)((OracleResultSet)resultSet).getORAData("SPLIT_PREDICATE", DmPredicates.getORADataFactory());
                clusteringDetailRow.setSplitPredicate(PredicateRowData.createPredicatesFrom(object));
            }
            object = (DmChildren)((OracleResultSet)resultSet).getORAData("CHILD", DmChildren.getORADataFactory());
            clusteringDetailRow.setChild(ClusteringDetailRow.createChildrenFromDmChildren((DmChildren)object));
            if (GetClusterModelDetailsQueryMapper.this.levelDetailsAll) {
                DmCentroids dmCentroids = (DmCentroids)((OracleResultSet)resultSet).getORAData("CENTROID", DmCentroids.getORADataFactory());
                clusteringDetailRow.setCentroid(CentroidRowData.createCentroidsFromDmCentroids(dmCentroids));
                DmRule dmRule = (DmRule)((OracleResultSet)resultSet).getORAData("RULE", DmRule.getORADataFactory());
                if (dmRule != null) {
                    clusteringDetailRow.setRule(new RuleRowData(dmRule));
                }
            }
            return clusteringDetailRow;
        }
    }

    private class DB11Mapper
    implements ISqlMapper<ClusteringDetailRow> {
        private DB11Mapper() {
        }

        @Override
        public ClusteringDetailRow map(ResultSet resultSet) throws Exception {
            Object object;
            ClusteringDetailRow clusteringDetailRow = new ClusteringDetailRow();
            clusteringDetailRow.setId(resultSet.getInt("ID"));
            clusteringDetailRow.setClusterId(resultSet.getString("CLUSTER_ID"));
            clusteringDetailRow.setCount(resultSet.getInt("RECORD_COUNT"));
            clusteringDetailRow.setParent(resultSet.getInt("PARENT"));
            clusteringDetailRow.setTreeLevel(resultSet.getInt("TREE_LEVEL"));
            clusteringDetailRow.setDispersion(resultSet.getDouble("DISPERSION"));
            DmCentroids dmCentroids = (DmCentroids)((OracleResultSet)resultSet).getORAData("CENTROID", DmCentroids.getORADataFactory());
            clusteringDetailRow.setCentroid(CentroidRowData.createCentroidsFromDmCentroids(dmCentroids));
            if (ClusteringAlgorithm.OCLUSTER.equals((Object)GetClusterModelDetailsQueryMapper.this.algorithmType)) {
                object = (DmPredicates)((OracleResultSet)resultSet).getORAData("SPLIT_PREDICATE", DmPredicates.getORADataFactory());
                clusteringDetailRow.setSplitPredicate(PredicateRowData.createPredicatesFrom(object));
            }
            object = (DmChildren)((OracleResultSet)resultSet).getORAData("CHILD", DmChildren.getORADataFactory());
            clusteringDetailRow.setChild(ClusteringDetailRow.createChildrenFromDmChildren((DmChildren)object));
            DmRule dmRule = (DmRule)((OracleResultSet)resultSet).getORAData("RULE", DmRule.getORADataFactory());
            clusteringDetailRow.setRule(new RuleRowData(dmRule));
            return clusteringDetailRow;
        }
    }
}

