/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clas.glm;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.CoreMappingLrb;
import oracle.dmt.dataminer.core.model.clas.common.GLMCoefficient;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;

public class GetCoefficientsMapper
extends SqlMapper<GLMCoefficient> {
    private static String ATTR_NAME_SUBNAME = "attribute_name_subname";
    private static String EXP_COEFFICIENT = "EXP_COEFFICIENT";
    private static String EXP_UPPER_COEFF_LIMIT = "EXP_UPPER_COEFF_LIMIT";

    public GetCoefficientsMapper(Version version) {
        super(version);
    }

    @Override
    public GLMCoefficient map(ResultSet resultSet) throws Exception {
        GLMCoefficient gLMCoefficient = null;
        gLMCoefficient = DbVersionHelper.isDB122Up(this.dbVersion) ? this.mapRow122Up(resultSet) : this.mapRowOriginal(resultSet);
        return gLMCoefficient;
    }

    private GLMCoefficient mapRowOriginal(ResultSet resultSet) throws SQLException {
        Object object = resultSet.getString(ATTR_NAME_SUBNAME);
        if (object == null) {
            object = "<" + CoreMappingLrb.get("INTERCEPT_NAME") + ">";
        }
        GLMCoefficient gLMCoefficient = this.mapCommon(resultSet, (String)object);
        return gLMCoefficient;
    }

    private GLMCoefficient mapRow122Up(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("FEATURE_EXPRESSION");
        Object object = resultSet.getString("ATTRIBUTE_NAME");
        String string2 = resultSet.getString(ATTR_NAME_SUBNAME);
        object = object == null && string == null ? "<" + CoreMappingLrb.get("INTERCEPT_NAME") + ">" : (object == null ? string : string2);
        GLMCoefficient gLMCoefficient = this.mapCommon(resultSet, (String)object);
        return gLMCoefficient;
    }

    private GLMCoefficient mapCommon(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString("ATTRIBUTE_VALUE");
        if (string2 == null) {
            string2 = "";
        }
        Double d = resultSet.getDouble("COEFFICIENT");
        Double d2 = resultSet.getDouble("STD_ERROR");
        Double d3 = resultSet.getDouble("TEST_STATISTIC");
        Double d4 = resultSet.getDouble("P_VALUE");
        Double d5 = resultSet.getDouble("STD_COEFFICIENT");
        Double d6 = resultSet.getDouble("LOWER_COEFF_LIMIT");
        Double d7 = resultSet.getDouble("UPPER_COEFF_LIMIT");
        Double d8 = resultSet.getDouble(EXP_COEFFICIENT);
        Double d9 = resultSet.getDouble("EXP_LOWER_COEFF_LIMIT");
        Double d10 = resultSet.getDouble(EXP_UPPER_COEFF_LIMIT);
        GLMCoefficient gLMCoefficient = new GLMCoefficient(string, string2, d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
        return gLMCoefficient;
    }
}

