/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.Mapper;
import oracle.dmt.dataminer.core.dal.sql.ISqlMapper;
import oracle.dmt.dataminer.core.utils.DebugTimer;
import oracle.javatools.util.Version;

public abstract class SqlMapper<T>
implements Mapper<T, ResultSet>,
ISqlMapper<T> {
    private static final Logger LOGGER = Logger.getLogger(SqlMapper.class.getName());
    protected Version dbVersion;

    public SqlMapper() {
    }

    public SqlMapper(Version version) {
        this.dbVersion = version;
    }

    @Override
    public T mapOne(ResultSet resultSet) throws Exception {
        T t = null;
        if (resultSet.next()) {
            t = this.map(resultSet);
        }
        return t;
    }

    @Override
    public List<T> mapAll(ResultSet resultSet) throws Exception {
        DebugTimer debugTimer = new DebugTimer().start();
        ArrayList arrayList = new ArrayList();
        while (resultSet.next()) {
            arrayList.add(this.map(resultSet));
        }
        debugTimer.stop();
        LOGGER.log(Level.FINER, "Mapping all objects took: {0} miliseconds", debugTimer.getElapsedTime());
        return arrayList;
    }
}

