/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ide.osgi.Platform;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.ideimpl.resource.ManageFeaturesArb;
import oracle.ideimpl.webupdate.CustomTypeDefinition;
import oracle.ideimpl.webupdate.CustomUpdateType;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCategory;
import oracle.ideimpl.webupdate.UpdateCenterMessage;
import oracle.ideimpl.webupdate.UpdateHandlerHook;
import oracle.ideimpl.webupdate.UpdateHelper;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.CategoryItem;
import oracle.ideimpl.webupdate.wizard.TreeItem;
import oracle.ideimpl.webupdate.wizard.UpdateItem;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils2;
import org.osgi.framework.Bundle;

public abstract class UpdatesTreePanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(UpdatesTreePanel.class.getName());
    private static final Icon CATEGORY_ICON = OracleIcons.getIcon((String)"folder.png");
    private static final Icon NEWINSTALLBUNDLE_ICON = OracleIcons.getIcon((String)"newinstallbundle.png");
    private static final Icon UPDATEINSTALLBUNDLE_ICON = OracleIcons.getIcon((String)"updateinstallbundle.png");
    private final CustomJTree _tree = new CustomJTree();
    private JMutableTreeNode _root = new JMutableTreeNode("root");
    private final DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._root);
    private final JEditorPane _description = new JEditorPane();
    private final SearchField _searchField = new SearchField();
    final JCheckBox _onlyUpgrades = new JCheckBox();
    private transient TreeExpansionListener _nodeExpansionListener;
    private transient TreeSelectionListener _nodeSelectionListener;
    private transient TreeCellCheckedListener _nodeCheckListener;
    private transient BundleSearchListener _searchListener;
    private transient ActionListener _upgradesActionListener;
    private TreeState _treeState = TreeState.COLLAPSED;
    private HyperlinkButton _collapseTreeButton;
    private HyperlinkButton _expandTreeButton;
    private BlockingComponent _blockingComponent;
    private final Map<UpdateInfo, UpdateItem> _itemsByUpdateInfo = new HashMap<UpdateInfo, UpdateItem>();
    private final Comparator<UpdateInfo> dependencyComparator = new Comparator<UpdateInfo>(){

        @Override
        public int compare(UpdateInfo o1, UpdateInfo o2) {
            Collection requiredIds = o1.getRequiredIds();
            for (String reqId : requiredIds) {
                if (!reqId.equals(o2.getID())) continue;
                return 1;
            }
            return -1;
        }
    };

    protected UpdatesTreePanel() {
    }

    protected void initializeGUI() {
        this.configureSearchField();
        this.configureBundlesTree();
        this.configureDescriptionPane();
        this._onlyUpgrades.addActionListener(this.getActionListener());
        JPanel searchPanel = new JPanel(new GridBagLayout());
        Insets searchInsets = new Insets(0, 0, 0, 10);
        searchPanel.add((Component)this._searchField, new GridBagConstraints(0, 0, -1, 1, 1.0, 1.0, 17, 0, searchInsets, 5, 5));
        this._searchField.setMaximumSize(new Dimension(400, 40));
        this._searchField.setPreferredSize(new Dimension(200, this._searchField.getPreferredSize().height - 3));
        this._searchField.setMinimumSize(new Dimension(160, this._searchField.getPreferredSize().height - 3));
        JComponent rightComponent = this.getSearchPanelRightComponent();
        if (rightComponent != null) {
            searchPanel.add((Component)rightComponent, new GridBagConstraints(1, 0, -1, 1, 0.0, 0.0, 13, 0, searchInsets, 0, 0));
        }
        this._tree.setEditable(false);
        JScrollPane scrollpane = new JScrollPane((Component)this._tree);
        scrollpane.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        JPanel treePanel = new JPanel(new BorderLayout(0, 8));
        treePanel.add((Component)searchPanel, "North");
        treePanel.add((Component)scrollpane, "Center");
        this._blockingComponent = new BlockingComponent((JComponent)treePanel);
        JSplitPane splitPanel = new JSplitPane(1);
        splitPanel.setBorder(null);
        splitPanel.setLeftComponent(this._blockingComponent.getBlockingComponent());
        splitPanel.setRightComponent(this._description);
        splitPanel.setResizeWeight(0.6);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 10);
        buttonPanel.add((Component)this.expandTreeButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        buttonPanel.add((Component)this.collapseTreeButton(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0));
        JPanel progressPanel = this.getLayoutProgressBar();
        if (progressPanel != null) {
            bottomPanel.add((Component)progressPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0));
        }
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)splitPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this._blockingComponent.setMessage(BlockingComponent.Message.LOADING);
        this._blockingComponent.setState(BlockingComponent.State.BLOCKED);
    }

    protected JPanel getLayoutProgressBar() {
        return null;
    }

    protected JComponent getSearchPanelRightComponent() {
        return null;
    }

    private void configureSearchField() {
        this._searchField.setPrompt(ManageFeaturesArb.getString((int)7));
        this._searchField.getTextField().setColumns(30);
        this._searchField.setAllowEmptySearch(false);
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.addSearchListener(this.getSearchListener());
        this._searchField.setName("UpdatesTreePanel.SearchTextField");
    }

    private void configureDescriptionPane() {
        this._description.setEditorKit(new DescriptionPaneEditorKit());
        this._description.setPreferredSize(new Dimension(200, 100));
        this._description.setEditable(false);
        this._description.setFocusable(true);
        this.setDescriptionBorder(false);
        this._description.setOpaque(false);
        this._description.setName("UpdatesTreePanel.DescriptionEditorPane");
        this._description.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && (url = e.getURL()) != null) {
                    try {
                        Desktop.getDesktop().browse(url.toURI());
                    }
                    catch (IOException iOException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (UnsupportedOperationException f) {
                        UpdatesTreePanel.this.linksNotSupportedDialg(url);
                    }
                }
            }
        });
        this._description.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                UpdatesTreePanel.this.setDescriptionBorder(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                UpdatesTreePanel.this.setDescriptionBorder(false);
            }
        });
    }

    private void setDescriptionBorder(boolean focused) {
        Border outer = BorderFactory.createEmptyBorder(0, -2, 0, 0);
        Border innerOuter = BorderFactory.createLineBorder(focused ? UIManager.getColor("Tree.selectionBorderColor") : Colors.FLAT_EDITOR_BORDER);
        Border innerInner = BorderFactory.createEmptyBorder(-5, 10, 0, 10);
        CompoundBorder inner = BorderFactory.createCompoundBorder(innerOuter, innerInner);
        this._description.setBorder(BorderFactory.createCompoundBorder(outer, inner));
    }

    protected boolean linksNotSupportedDialg(URL url) {
        JEditorPane editor = new JEditorPane();
        editor.setEditorKit(new DescriptionPaneEditorKit());
        StringBuilder b = new StringBuilder();
        b.append("<p>");
        b.append(UpdateArb.getString(218));
        b.append("</p>");
        b.append("<br>");
        b.append("<p>");
        b.append(url);
        b.append("</p>");
        editor.setText(UpdatesTreePanel.html(b.toString()));
        editor.setOpaque(false);
        BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)this, (String)UpdateArb.getString(219), (int)2);
        dialog.setMessage((Object)editor);
        boolean ok = dialog.runDialog();
        return ok;
    }

    private void configureBundlesTree() {
        this._tree.setModel((TreeModel)this._treeModel);
        this._tree.setBorder(null);
        this._tree.setRootVisible(false);
        this._tree.setRowHeight(20);
        this._tree.setShowsRootHandles(true);
        TreeSelectionModel selectionModel = this._tree.getSelectionModel();
        selectionModel.addTreeSelectionListener(this.getTreeSelectionListener());
        this._tree.addTreeExpansionListener(this.getTreeExpansionListener());
        this._tree.setEditable(true);
        this._tree.addTreeCellCheckedListener(this.getTreeCheckListener());
        this._tree.setName("UpdatesTreePanel.AvailableUpdatesCustomJTree");
    }

    Component getInitialFocus() {
        return this._searchField;
    }

    List<FeatureCategory> getEnabledCategories(UpdateWizardModel updateWizardModel) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        List categories = extensionRegistry.getFeatureRegistry().getCategories();
        for (FeatureCategory c : categories) {
            System.out.println("Cat:" + c.getDisplayName());
        }
        return categories;
    }

    protected void populateUpdates(Collection<UpdateInfo> updates, boolean selectAll) {
        this._itemsByUpdateInfo.clear();
        this._root = new JMutableTreeNode("root");
        this._treeModel.setRoot((TreeNode)this._root);
        this._searchField.setEnabled(!updates.isEmpty());
        if (updates.isEmpty()) {
            this._blockingComponent.setMessage(BlockingComponent.Message.NO_MESSAGE);
            this._blockingComponent.setState(BlockingComponent.State.UNBLOCKED);
            return;
        }
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        for (UpdateInfo update : updates) {
            UpdateItem item = new UpdateItem(update);
            item.setSelected(update.getType() == UpdateInfo.Type.PATCH || selectAll);
            this._itemsByUpdateInfo.put(update, item);
            this.addUpdateNode(item);
        }
        root.sortChildren();
        root.updateNodes();
        this._treeModel.reload((TreeNode)root);
        this._collapseTreeButton.setEnabled(true);
        this._expandTreeButton.setEnabled(false);
        this._treeState = TreeState.EXPANDED;
        IdeUtil.expandAllTreeRows((JTree)this._tree);
        this._blockingComponent.setMessage(BlockingComponent.Message.NO_MESSAGE);
        this._blockingComponent.setState(BlockingComponent.State.UNBLOCKED);
    }

    private void addUpdateNode(UpdateItem updateItem) {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        UpdateCategory category = updateItem.getUpdate().getCategory();
        JMutableTreeNode node = root;
        if (category != null) {
            JMutableTreeNode found = this.searchNode(node, category);
            if (found != null) {
                node = found;
            } else {
                this.addUpdateNode(node, updateItem, category);
                return;
            }
        }
        this.addUpdateNode(node, updateItem);
    }

    private void addUpdateNode(JMutableTreeNode parent, UpdateItem update, UpdateCategory category) {
        JMutableTreeNode node = parent;
        SortedUpdateNode categoryNode = new SortedUpdateNode(category);
        categoryNode.getModel().setHasCheckBox(false);
        node.add((MutableTreeNode)((Object)categoryNode));
        node.sortChildren();
        node = categoryNode;
        this.addUpdateNode(node, update);
    }

    private void addUpdateNode(JMutableTreeNode parent, UpdateItem update) {
        TriStateBoolean checkBoxState = update.isSelected() ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        SortedUpdateNode child = new SortedUpdateNode(update, checkBoxState);
        child.getModel().setHasCheckBox(!update.getUpdate().getCategory().isMessage());
        parent.add((MutableTreeNode)((Object)child));
        child.setUserObject(update);
        parent.sortChildren();
    }

    protected void clear() {
        this._itemsByUpdateInfo.clear();
    }

    void cleanUp() {
        this._searchField.clear();
        this._root = new JMutableTreeNode("root");
        this._treeModel.setRoot((TreeNode)this._root);
        this.refreshTree();
    }

    boolean hasUpdates() {
        return !this._itemsByUpdateInfo.isEmpty();
    }

    protected abstract void completeValueChanged();

    protected List<UpdateInfo> getSelectedUpdates() {
        ArrayList<UpdateInfo> selectedUpdates = new ArrayList<UpdateInfo>();
        Enumeration e = this._root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            UpdateItem item;
            JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
            if (node == null || !(node.getUserObject() instanceof UpdateItem) || !(item = (UpdateItem)node.getUserObject()).isSelected()) continue;
            selectedUpdates.add(item.getUpdate());
        }
        this.sortByDependency(selectedUpdates);
        return selectedUpdates;
    }

    private void sortByDependency(List<UpdateInfo> updates) {
        Collections.sort(updates, this.dependencyComparator);
    }

    void save(UpdateWizardModel model) {
        model.setSelectedUpdates(this.getSelectedUpdates());
    }

    boolean isLicenseRequired() {
        List<UpdateInfo> updates = this.getSelectedUpdates();
        for (UpdateInfo info : updates) {
            if (info.getClickThroughURL() == null) continue;
            return true;
        }
        return false;
    }

    private JMutableTreeNode searchNode(JMutableTreeNode n, UpdateCategory category) {
        Enumeration e = n.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof CategoryItem) || !category.equals(((CategoryItem)userObject).getCategory())) continue;
            return node;
        }
        return null;
    }

    protected void refreshTree() {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        this.refreshTreeCheckedState(root, new HashSet<String>());
        root.updateNodes();
        this._tree.repaint();
        this.completeValueChanged();
    }

    private void refreshTreeCheckedState(JMutableTreeNode node, Set<String> expanded) {
        JTreeCellData cellData = node.getModel();
        TriStateBoolean checkState = cellData.getCheckBoxState();
        Object object = node.getUserObject();
        if (object instanceof TreeItem) {
            TreeItem update = (TreeItem)object;
            boolean enabled = update.isEnabled();
            boolean selected = update.isSelected();
            if (!enabled) {
                cellData.setEnabled(enabled);
            } else if (!selected && checkState.isTrue() || selected && checkState.isFalse()) {
                cellData.setCheckBoxState(selected);
                String textForNode = node.getParent().toString();
                if (expanded.add(textForNode)) {
                    ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                    for (TreeNode n = node.getParent(); n != null; n = n.getParent()) {
                        list.add(n);
                    }
                    Collections.reverse(list);
                    TreePath pathToNode = new TreePath(list.toArray());
                    this._tree.expandPath(pathToNode);
                }
            }
        }
        if (node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                JMutableTreeNode child = (JMutableTreeNode)e.nextElement();
                this.refreshTreeCheckedState(child, expanded);
            }
        }
    }

    Component getFirstFocusComponent() {
        return this._searchField.getTextField();
    }

    public String[] getTreeExpansionState() {
        JMutableTreeNode root = (JMutableTreeNode)this._treeModel.getRoot();
        ArrayList<String> expandedNodes = new ArrayList<String>(root.getChildCount());
        TreePath rootPath = new TreePath(root);
        Enumeration e = root.children();
        while (e.hasMoreElements()) {
            TreeNode n;
            TreePath path;
            TreeNode groupNode = (TreeNode)e.nextElement();
            TreePath parent = rootPath.pathByAddingChild(groupNode);
            if (groupNode.getChildCount() <= 0 || !this._tree.isVisible(path = parent.pathByAddingChild(n = groupNode.getChildAt(0)))) continue;
            expandedNodes.add(groupNode.toString());
        }
        return expandedNodes.toArray(new String[expandedNodes.size()]);
    }

    void restoreTreeExpansion(String ... expandedNodes) {
        block0: for (String groupnode : expandedNodes) {
            for (int i = 0; i < this._tree.getRowCount(); ++i) {
                TreePath path = this._tree.getPathForRow(i);
                DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                String val = String.valueOf(last);
                if (!groupnode.equals(val)) continue;
                this._tree.expandPath(path);
                continue block0;
            }
        }
        this.checkExpansionState();
    }

    private void checkExpansionState() {
        this._treeState = this.checkExpansionState(new TreePath(this._tree.getModel().getRoot()), null);
        this._expandTreeButton.setEnabled(TreeState.MIXED.equals((Object)this._treeState) || TreeState.COLLAPSED.equals((Object)this._treeState));
        this._collapseTreeButton.setEnabled(TreeState.MIXED.equals((Object)this._treeState) || TreeState.EXPANDED.equals((Object)this._treeState));
    }

    private TreeState checkExpansionState(TreePath nodePath, TreeState expansionState) {
        TreeNode node = (TreeNode)nodePath.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = nodePath.pathByAddingChild(n);
                expansionState = this.checkExpansionState(path, expansionState);
                if (TreeState.MIXED.equals((Object)expansionState)) {
                    return expansionState;
                }
                if (n.getChildCount() != 0) continue;
                break;
            }
        } else if (nodePath.getPath().length > 2) {
            boolean nodeVisible = this._tree.isVisible(nodePath);
            if (TreeState.COLLAPSED.equals((Object)expansionState) && nodeVisible || TreeState.EXPANDED.equals((Object)expansionState) && !nodeVisible) {
                return TreeState.MIXED;
            }
            return nodeVisible ? TreeState.EXPANDED : TreeState.COLLAPSED;
        }
        return expansionState;
    }

    private TreeExpansionListener getTreeExpansionListener() {
        if (this._nodeExpansionListener == null) {
            this._nodeExpansionListener = new NodeExpansionListener();
        }
        return this._nodeExpansionListener;
    }

    private TreeSelectionListener getTreeSelectionListener() {
        if (this._nodeSelectionListener == null) {
            this._nodeSelectionListener = new NodeSelectionListener();
        }
        return this._nodeSelectionListener;
    }

    private TreeCellCheckedListener getTreeCheckListener() {
        if (this._nodeCheckListener == null) {
            this._nodeCheckListener = new NodeCheckListener();
        }
        return this._nodeCheckListener;
    }

    private SearchListener getSearchListener() {
        if (this._searchListener == null) {
            this._searchListener = new BundleSearchListener();
        }
        return this._searchListener;
    }

    private ActionListener getActionListener() {
        if (this._upgradesActionListener == null) {
            this._upgradesActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdatesTreePanel.this.getSearchListener().searchPerformed(null);
                }
            };
        }
        return this._upgradesActionListener;
    }

    private AbstractButton collapseTreeButton() {
        this._collapseTreeButton = new HyperlinkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatesTreePanel.this._expandTreeButton.setEnabled(true);
                UpdatesTreePanel.this._collapseTreeButton.setEnabled(false);
                UpdatesTreePanel.this._treeState = TreeState.COLLAPSED;
                IdeUtil.expandTreeToDepth((JTree)UpdatesTreePanel.this._tree, (int)1);
            }
        });
        this._collapseTreeButton.setText(ManageFeaturesArb.getString((int)6));
        ResourceUtils.setComponentName((Object)this, (Component)this._collapseTreeButton, (String)"_collapseTreeButton");
        this._collapseTreeButton.setEnabled(false);
        return this._collapseTreeButton;
    }

    private AbstractButton expandTreeButton() {
        this._expandTreeButton = new HyperlinkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatesTreePanel.this._collapseTreeButton.setEnabled(true);
                UpdatesTreePanel.this._expandTreeButton.setEnabled(false);
                UpdatesTreePanel.this._treeState = TreeState.EXPANDED;
                IdeUtil.expandAllTreeRows((JTree)UpdatesTreePanel.this._tree);
            }
        });
        this._expandTreeButton.setText(ManageFeaturesArb.getString((int)5));
        ResourceUtils.setComponentName((Object)this, (Component)this._expandTreeButton, (String)"_expandTreeButton");
        return this._expandTreeButton;
    }

    protected abstract void updateDependencies(UpdateItem var1);

    protected boolean confirmInstallDepedencies(String targetBundle, Set<UpdateItem> dependencies, boolean install) {
        ArrayList<String> deps = new ArrayList<String>();
        for (UpdateItem otherItem : dependencies) {
            deps.add(otherItem.getUpdate().getName());
        }
        JEditorPane editor = new JEditorPane();
        editor.setEditorKit(new DescriptionPaneEditorKit());
        StringBuilder b = new StringBuilder();
        b.append("<p>");
        b.append("<b>");
        b.append(UpdateArb.format(install ? 22 : 26, targetBundle));
        b.append("</b>");
        b.append("</p>");
        b.append("<p>");
        b.append("<b>");
        b.append(UpdateArb.getString(install ? 23 : 27));
        b.append("</b>");
        b.append("</p>");
        b.append("<br>");
        b.append("<p>");
        b.append(UpdateArb.format(24, targetBundle));
        b.append("</p>");
        b.append("<br>");
        b.append("<p>");
        b.append(UpdateArb.getString(install ? 25 : 28));
        b.append("</p>");
        editor.setText(UpdatesTreePanel.html(b.toString()));
        editor.setOpaque(false);
        editor.setEditable(false);
        JPanel listPanel = new JPanel(new BorderLayout());
        JList<Object> list = new JList<Object>(deps.toArray());
        JScrollPane scrollPane = new JScrollPane(list);
        listPanel.add((Component)editor, "North");
        listPanel.add((Component)scrollPane, "Center");
        BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)this, (String)UpdateArb.getString(install ? 21 : 29), (int)4);
        dialog.setMessage((Object)listPanel);
        boolean ok = dialog.runDialog();
        return ok;
    }

    private static JMutableTreeNode cloneTree(JMutableTreeNode root) {
        if (root != null) {
            JMutableTreeNode newRoot = new JMutableTreeNode(root.getModel(), root.getAllowsChildren());
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                JMutableTreeNode newChild = UpdatesTreePanel.cloneTree(child);
                if (newChild == null) continue;
                newChild.setUserObject(child.getUserObject());
                newRoot.add((MutableTreeNode)newChild);
            }
            return newRoot;
        }
        return null;
    }

    private static boolean filter(JMutableTreeNode root) {
        boolean matchingChildren = false;
        ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
            if (UpdatesTreePanel.filter(child)) {
                matchingChildren = true;
                continue;
            }
            nodesToRemove.add(i);
        }
        int removedCount = 0;
        Iterator iterator = nodesToRemove.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            root.remove(i - removedCount++);
        }
        if (matchingChildren) {
            return true;
        }
        return root.getUserObject() instanceof UpdateItem && !((UpdateItem)root.getUserObject()).getUpdate().isNew();
    }

    private static DefaultTreeModel filterUpdatesOnly(TreeModel treeModel) {
        Object rootObject = treeModel.getRoot();
        JMutableTreeNode root = UpdatesTreePanel.cloneTree((JMutableTreeNode)rootObject);
        UpdatesTreePanel.filter(root);
        return new DefaultTreeModel((TreeNode)root);
    }

    protected Map<UpdateInfo, UpdateItem> getMapOfUpdateInfos() {
        return this._itemsByUpdateInfo;
    }

    protected void nodeChanged(JMutableTreeNode node, boolean checked) {
    }

    private static String buildLink(String linkURL, String linkText) {
        StringBuilder sb = new StringBuilder("<a href=\"");
        sb.append(linkURL).append("\">").append(linkText).append("</a>");
        return sb.toString();
    }

    protected static String html(String string) {
        return "<html><body>" + string + "</body></html>";
    }

    private static String displayPropertiesToCSS(Font font) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append(" }");
        return rule.toString();
    }

    private static boolean isHighContrastWhite() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Color rgbBackground = (Color)toolkit.getDesktopProperty("win.desktop.backgroundColor");
        return SwingUtils2.isInHighConstrastMode() && rgbBackground != null && rgbBackground.getRed() == 255 && rgbBackground.getGreen() == 255 && rgbBackground.getBlue() == 255;
    }

    private static enum TreeState {
        EXPANDED,
        COLLAPSED,
        MIXED;

    }

    protected static class DescriptionPaneEditorKit
    extends HTMLEditorKit {
        private static StyleSheet _defaultStyles;

        protected DescriptionPaneEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (_defaultStyles == null) {
                _defaultStyles = new StyleSheet();
                _defaultStyles.addStyleSheet(super.getStyleSheet());
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString(UpdatesTreePanel.displayPropertiesToCSS(new JLabel().getFont())));
            }
            if (SwingUtils2.isInHighConstrastMode() && !UpdatesTreePanel.isHighContrastWhite()) {
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("body { color: white }"));
            }
            return _defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String s) {
            StyleSheet ss = new StyleSheet();
            try (StringReader r = null;){
                r = new StringReader(s);
                ss.loadRules(r, null);
            }
            return ss;
        }
    }

    private class NodeSelectionListener
    implements TreeSelectionListener {
        private final HashMap<String, String> _map = new HashMap();

        private NodeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object userData;
            JMutableTreeNode node = (JMutableTreeNode)e.getPath().getLastPathComponent();
            if (this._map.containsKey(node.toString())) {
                UpdatesTreePanel.this._description.setText(this._map.get(node.toString()));
            }
            if ((userData = node.getUserObject()) instanceof UpdateItem) {
                UpdateItem feature = (UpdateItem)userData;
                String d = this.buildDescription(feature.getUpdate());
                this._map.put(node.toString(), d);
                UpdatesTreePanel.this._description.setText(d);
            } else if (userData instanceof CategoryItem) {
                UpdateCategory category = ((CategoryItem)userData).getCategory();
                String d = this.buildDescription(category);
                this._map.put(node.toString(), d);
                UpdatesTreePanel.this._description.setText(d);
            }
        }

        private String buildDescription(UpdateInfo update) {
            StringBuilder b = new StringBuilder();
            boolean isMessage = UpdateInfo.Type.MESSAGE.equals((Object)update.getType());
            b.append("<h3>");
            b.append(update.getName());
            b.append("</h3>");
            if (!isMessage) {
                b.append("<p>");
                b.append(update.getVersion());
                b.append("</p>");
                b.append("<br>");
            }
            b.append("<p>");
            b.append(ModelUtil.hasLength((String)update.getDescription()) ? update.getDescription() : "<No description available>");
            b.append("</p>");
            b.append("<br>");
            if (isMessage) {
                UpdateCenterMessage message = (UpdateCenterMessage)update;
                b.append("<br>").append(UpdatesTreePanel.buildLink(message.getURL(), message.getLinkText())).append("</br>");
            } else {
                b.append("<h3>");
                b.append("Created By");
                b.append("</h3>");
                b.append("<p>");
                b.append(update.getAuthor());
                b.append("</p>");
                b.append("<p>");
                if (update.getAuthorURL() != null) {
                    b.append(UpdatesTreePanel.buildLink(update.getAuthorURL(), "Visit Homepage"));
                } else {
                    b.append("No Homepage");
                }
                b.append("</p>");
                b.append("<br>");
                b.append("<h3>");
                b.append("Currently Installed Version");
                b.append("</h3>");
                b.append("<p>");
                if (!update.getType().equals((Object)UpdateInfo.Type.CUSTOM)) {
                    ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                    Extension extension = extensionRegistry.findExtension(update.getID());
                    if (extension != null) {
                        b.append(extension.getVersion());
                    } else {
                        b.append("None");
                    }
                } else if (update.getCustomType().equals("osgi")) {
                    Bundle osgiBundle = Platform.getBundleRegistry().findBundle(update.getID());
                    if (osgiBundle != null) {
                        b.append(osgiBundle.getVersion());
                    } else {
                        b.append("None");
                    }
                } else {
                    CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
                    List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
                    boolean isInstalled = false;
                    for (CustomUpdateType t : cuts) {
                        if (!t.getType().equals(update.getCustomType())) continue;
                        UpdateHelper uh = t.getUpdateHelper();
                        if (uh == null || !uh.isInstalled(update.getID())) break;
                        if (uh.getCurrentlyInstalledVersion(update.getID()) != null) {
                            b.append(uh.getCurrentlyInstalledVersion(update.getID()));
                        } else {
                            b.append(uh.getInternalId(update.getID()));
                        }
                        isInstalled = true;
                        break;
                    }
                    if (!isInstalled) {
                        b.append("None");
                    }
                }
                b.append("</p>");
            }
            return UpdatesTreePanel.html(b.toString());
        }

        private String buildDescription(UpdateCategory category) {
            StringBuilder b = new StringBuilder();
            b.append("<h3>");
            b.append(category.getDisplayName());
            b.append("</h3>");
            b.append("<p>");
            b.append(ModelUtil.hasLength((String)category.getDescription()) ? category.getDescription() : "<No description available>");
            b.append("</p>");
            return UpdatesTreePanel.html(b.toString());
        }
    }

    private class NodeCheckListener
    implements TreeCellCheckedListener {
        private NodeCheckListener() {
        }

        public synchronized void cellChecked(TreeCellCheckedEvent event) {
            JMutableTreeNode node = (JMutableTreeNode)event.getSource();
            this.processNodeChecked(node, true);
        }

        public synchronized void cellUnchecked(TreeCellCheckedEvent event) {
            JMutableTreeNode node = (JMutableTreeNode)event.getSource();
            this.processNodeChecked(node, false);
        }

        private void processNodeChecked(JMutableTreeNode node, boolean checked) {
            Object object = node.getUserObject();
            if (object instanceof UpdateItem) {
                UpdateItem userItem = (UpdateItem)object;
                userItem.setSelected(checked);
                UpdatesTreePanel.this.updateDependencies(userItem);
            } else if (object instanceof CategoryItem) {
                Enumeration e = node.children();
                while (e.hasMoreElements()) {
                    JMutableTreeNode child = (JMutableTreeNode)e.nextElement();
                    this.processNodeChecked(child, checked);
                }
            }
            UpdatesTreePanel.this.refreshTree();
            UpdatesTreePanel.this.nodeChanged(node, checked);
        }
    }

    private class NodeExpansionListener
    implements TreeExpansionListener {
        private NodeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (!TreeState.EXPANDED.equals((Object)UpdatesTreePanel.this._treeState)) {
                UpdatesTreePanel.this.checkExpansionState();
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (!TreeState.COLLAPSED.equals((Object)UpdatesTreePanel.this._treeState)) {
                UpdatesTreePanel.this.checkExpansionState();
            }
        }
    }

    private static class SortedUpdateNode
    extends JMutableTreeNode {
        public SortedUpdateNode(UpdateItem update, TriStateBoolean tri) {
            super(new JTreeCellData(update.getUpdate().isNew() ? NEWINSTALLBUNDLE_ICON : UPDATEINSTALLBUNDLE_ICON, update.getUpdate().getName(), true, tri));
            this.setUserObject(update);
        }

        public SortedUpdateNode(UpdateCategory category) {
            super(new JTreeCellData(CATEGORY_ICON, category.getCategoryName(), true));
            this.setUserObject(new CategoryItem(category));
        }

        public int compareTo(JMutableTreeNode otherNode) {
            if (otherNode != null) {
                if (this.getChildCount() > 0) {
                    if (otherNode.getChildCount() == 0) {
                        return -1;
                    }
                    UpdateCategory cat = ((CategoryItem)this.getUserObject()).getCategory();
                    UpdateCategory otherCat = ((CategoryItem)otherNode.getUserObject()).getCategory();
                    if (cat.isPatch()) {
                        return -1;
                    }
                    if (otherCat.isPatch()) {
                        return 1;
                    }
                    if (cat.isMessage()) {
                        return -1;
                    }
                    if (otherCat.isMessage()) {
                        return 1;
                    }
                } else if (otherNode.getChildCount() > 0) {
                    return 1;
                }
            }
            return super.compareTo(otherNode);
        }
    }

    private class BundleSearchListener
    implements SearchListener {
        private BundleSearchListener() {
        }

        public void searchPerformed(SearchEvent se) {
            TreePath selected = UpdatesTreePanel.this._tree.getSelectionPath();
            String searchText = se != null ? se.getSearchText() : UpdatesTreePanel.this._searchField.getText();
            DefaultTreeModel model = searchText.trim().length() > 0 ? this.buildFilteredTreeModel(UpdatesTreePanel.this._treeModel, searchText, false) : UpdatesTreePanel.this._treeModel;
            if (UpdatesTreePanel.this._onlyUpgrades.isSelected()) {
                model = UpdatesTreePanel.filterUpdatesOnly(model);
            }
            UpdatesTreePanel.this._tree.setModel((TreeModel)model);
            JMutableTreeNode root = (JMutableTreeNode)model.getRoot();
            UpdatesTreePanel.this.refreshTreeCheckedState(root, new HashSet());
            root.updateNodes();
            UpdatesTreePanel.this._tree.expandAllRows();
            this.restoreSelection(selected);
            UpdatesTreePanel.this.checkExpansionState();
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private void restoreSelection(TreePath selected) {
            if (selected != null) {
                String name = String.valueOf(selected.getLastPathComponent());
                for (int i = 0; i < UpdatesTreePanel.this._tree.getRowCount(); ++i) {
                    TreePath path = UpdatesTreePanel.this._tree.getPathForRow(i);
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                    String val = String.valueOf(last);
                    if (!name.equals(val)) continue;
                    UpdatesTreePanel.this._tree.setSelectionRow(i);
                    UpdatesTreePanel.this._tree.scrollRowToVisible(i);
                    break;
                }
            } else {
                UpdatesTreePanel.this._tree.setSelectionRow(0);
            }
        }

        public DefaultTreeModel buildFilteredTreeModel(DefaultTreeModel treeModel, String filterText, boolean prefixMatch) {
            if (treeModel == null) {
                throw new IllegalArgumentException("treeModel cannot be null", new NullPointerException());
            }
            if (filterText == null) {
                throw new IllegalArgumentException("the filter text must be a non-null string");
            }
            Object rootObject = treeModel.getRoot();
            if (!(rootObject instanceof JMutableTreeNode)) {
                throw new IllegalArgumentException("the tree root must be a JMutableTreeNode");
            }
            JMutableTreeNode root = UpdatesTreePanel.cloneTree((JMutableTreeNode)rootObject);
            SearchMatcher matcher = prefixMatch ? SearchMatcher.getPrefixMatcher((CharSequence)filterText, (boolean)true, (boolean)false) : SearchMatcher.getSubstringMatcher((CharSequence)filterText, (boolean)true);
            this.filter(root, matcher);
            return new DefaultTreeModel((TreeNode)root);
        }

        private boolean filter(JMutableTreeNode root, SearchMatcher matcher) {
            boolean matchingChildren = false;
            ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                if (this.filter(child, matcher)) {
                    matchingChildren = true;
                    continue;
                }
                nodesToRemove.add(i);
            }
            int removedCount = 0;
            Iterator iterator = nodesToRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                root.remove(i - removedCount++);
            }
            if (matchingChildren) {
                return true;
            }
            return matcher.matches((CharSequence)String.valueOf(root.getModel().getText()));
        }
    }
}

