/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.dialogs.ExceptionDialog;

final class UpdateLicensePage
extends UpdateWizardPage {
    private static final Logger LOG = Logger.getLogger(UpdateLicensePage.class.getName());
    private final JMultiLineLabel _hintText = new JMultiLineLabel();
    private final JLabel _title = new JLabel();
    private final JEditorPane _licensePane = new JEditorPane();
    private final JScrollPane _licenseScroll = new JScrollPane();
    private final JButton _agree = new JButton();
    private List _updates;
    private int _listPos;
    private boolean _errorOccurred = false;

    UpdateLicensePage() {
        this.resControls();
        this.layoutControls();
        this.installListeners();
        this._licenseScroll.getViewport().add(this._licensePane);
        this._licensePane.setEditable(false);
    }

    private void resControls() {
        this._hintText.setText(UpdateArb.getString(72));
        ResourceUtils.resLabel((JLabel)this._title, (Component)this._licensePane, (String)UpdateArb.getString(73));
        ResourceUtils.resButton((AbstractButton)this._agree, (String)UpdateArb.getString(76));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = INSETS_HINT;
        this.add((Component)this._hintText, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.insets = INSETS_GAP_BELOW;
        this.add(this._title, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add(this._licenseScroll, gbc);
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        this.add(this._agree, gbc);
    }

    private void installListeners() {
        this._agree.addActionListener(new Listener());
    }

    @Override
    public Component getInitialFocus() {
        return this._agree;
    }

    @Override
    protected void pageSelected(TraversableContext context) {
        context.getWizardCallbacks().wizardUpdateExpectedTransition(this.getExitTransition());
        this._agree.setEnabled(false);
        this._errorOccurred = false;
        if (context.getDirection() == 1) {
            try {
                this._hintText.setText(UpdateArb.getString(72));
                this._licenseScroll.setVisible(true);
                this._title.setVisible(true);
                this._agree.setVisible(true);
                this._updates = this.getModel(context).getUpdatesRequiringAgreement();
                this.selectUpdate(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)t);
                this.error(UpdateArb.format(190, t instanceof NullPointerException ? UpdateArb.getString(192) : t.getLocalizedMessage()));
                this._errorOccurred = true;
            }
            this.completeValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectUpdate(int listIndex) {
        URL url;
        this._agree.setEnabled(false);
        if (listIndex >= this._updates.size()) {
            this.completeValueChanged();
            this._hintText.setText(UpdateArb.getString(77));
            this._licenseScroll.setVisible(false);
            this._title.setVisible(false);
            this._agree.setVisible(false);
            this.invalidate();
            this.validate();
            return;
        }
        this._listPos = listIndex;
        UpdateInfo update = (UpdateInfo)this._updates.get(listIndex);
        if (this._updates.size() == 1) {
            ResourceUtils.resLabel((JLabel)this._title, (Component)this._licensePane, (String)UpdateArb.format(74, new Object[]{update.getName(), update.getVersion()}));
        } else {
            ResourceUtils.resLabel((JLabel)this._title, (Component)this._licensePane, (String)UpdateArb.format(75, new Object[]{update.getName(), update.getVersion(), String.valueOf(listIndex + 1), String.valueOf(this._updates.size())}));
        }
        String updateUrl = update.getClickThroughURL();
        if (this.getModel(this.getTraversableContext()).getLocalBundle() != null) {
            try {
                int lastSlash = updateUrl.lastIndexOf(47);
                String zipEntryPath = "META-INF" + updateUrl.substring(lastSlash);
                String licenseText = this.getModel(this.getTraversableContext()).getLocalBundle().getContent(zipEntryPath);
                if (updateUrl.toLowerCase().indexOf("htm") == -1) {
                    this._licensePane.setContentType("text/plain");
                } else {
                    this._licensePane.setContentType("text/html");
                    this._licensePane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                }
                this._licensePane.setText(licenseText);
                this._licensePane.setCaretPosition(0);
                if (this._licensePane.getText().trim().length() == 0) {
                    this.error(update, UpdateArb.getString(191));
                } else {
                    this._agree.setEnabled(true);
                }
                return;
            }
            catch (Exception lastSlash) {
                // empty catch block
            }
        }
        if ((url = URLFactory.newURL((String)updateUrl)) == null) {
            this.error(update, UpdateArb.format(79, updateUrl));
            return;
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode > 299) {
                if (responseCode == 404) {
                    this.error(update, UpdateArb.format(80, url));
                    return;
                }
                this.error(update, UpdateArb.format(81, String.valueOf(responseCode), url));
                return;
            }
            this._licensePane.setPage(url);
            this._agree.setEnabled(true);
        }
        catch (IOException ioe) {
            LOG.warning(UpdateArb.format(78, update.getName(), ioe.getMessage()));
            this.error(update, ioe.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public Object getExitTransition() {
        UpdateWizardModel model = this.getModel(this.getTraversableContext());
        UpdatePageConditions state = model.getConditions();
        if (state.isSingleUser()) {
            if (state.isLocal()) {
                return "licenseToSummary";
            }
            return "licenseToDownload";
        }
        return "licenseToDlLocation";
    }

    @Override
    public boolean isComplete() {
        if (this._errorOccurred) {
            return false;
        }
        return this.getModel(this.getTraversableContext()).getUpdatesRequiringAgreement().isEmpty();
    }

    private void error(String message) {
        this.error(null, message);
    }

    private void error(UpdateInfo update, String message) {
        if (update != null) {
            this._hintText.setText(UpdateArb.format(78, update.getName(), message));
        } else {
            this._hintText.setText(message);
        }
        this._licenseScroll.setVisible(false);
        this._title.setVisible(false);
        this._agree.setVisible(false);
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            UpdateInfo update = (UpdateInfo)UpdateLicensePage.this._updates.get(UpdateLicensePage.this._listPos);
            UpdateLicensePage.this.getModel(UpdateLicensePage.this.getTraversableContext()).setLicenseAgreed(update, true);
            UpdateLicensePage.this.selectUpdate(UpdateLicensePage.this._listPos + 1);
        }
    }
}

