/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.ideimpl.webupdate.ProgressMonitor;

public class BasicProgressMonitor
extends JPanel
implements ProgressMonitor {
    private final JLabel _message = new JLabel();
    private final JProgressBar _progress = new JProgressBar();
    private final JLabel _note = new JLabel();
    private final JButton _stopButton = new JButton("Stop");
    private int _jumpPerStep;
    private int _stepsElapsed;
    private boolean _canceled;
    private static final int MAX_PROGRESS = 100000;

    public BasicProgressMonitor() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._message, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this._progress, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._stopButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._note, gbc);
        this._stopButton.setEnabled(false);
        this._progress.setMaximum(100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int numberOfSteps) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            this._jumpPerStep = 100000 / numberOfSteps;
            System.err.println(numberOfSteps + " steps at " + this._jumpPerStep + " ticks per step");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicProgressMonitor.this._stopButton.setEnabled(true);
                BasicProgressMonitor.this._progress.setValue(0);
            }
        });
    }

    @Override
    public void finished() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicProgressMonitor.this._stopButton.setEnabled(false);
                BasicProgressMonitor.this._progress.setValue(100000);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advanced(int steps) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            this._stepsElapsed += steps;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BasicProgressMonitor basicProgressMonitor = BasicProgressMonitor.this;
                synchronized (basicProgressMonitor) {
                    BasicProgressMonitor.this._progress.setValue(BasicProgressMonitor.this._stepsElapsed * BasicProgressMonitor.this._jumpPerStep);
                }
            }
        });
    }

    @Override
    public synchronized boolean isCanceled() {
        return this._canceled;
    }

    @Override
    public synchronized void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }

    @Override
    public void setMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicProgressMonitor.this._message.setText(message);
            }
        });
    }

    @Override
    public void setDetailMessage(final String detailMessage) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicProgressMonitor.this._note.setText(detailMessage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressMonitor createSubMonitor(int steps) {
        BasicProgressMonitor basicProgressMonitor = this;
        synchronized (basicProgressMonitor) {
            return new SubMonitor(this, steps * this._jumpPerStep, this._stepsElapsed * this._jumpPerStep);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        final BasicProgressMonitor mon = new BasicProgressMonitor();
        f.setContentPane(mon);
        mon.setMessage("Test Message");
        mon.setDetailMessage("Test Note");
        final Random random = new Random();
        Thread t = new Thread(){

            @Override
            public void run() {
                mon.start(10);
                for (int i = 0; i < 10; ++i) {
                    mon.setMessage("Step " + (i + 1) + " of 10");
                    this.subtask(mon);
                    mon.advanced(1);
                }
                mon.finished();
            }

            private void subtask(ProgressMonitor parent) {
                int steps = random.nextInt(100);
                steps = Math.max(steps, 1);
                ProgressMonitor monitor = parent.createSubMonitor(1);
                monitor.start(steps);
                for (int i = 0; i < steps; ++i) {
                    monitor.setDetailMessage("SubStep " + (i + 1) + " of " + steps);
                    try {
                        Thread.sleep(random.nextInt(200));
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    monitor.advanced(1);
                }
                monitor.finished();
            }
        };
        t.start();
        f.pack();
        f.setVisible(true);
    }

    private static class SubMonitor
    implements ProgressMonitor {
        private final ProgressMonitor _parent;
        private final int _allocatedTicks;
        private int _jumpPerStep;
        private int _startProgress;
        private int _stepsElapsed;

        SubMonitor(ProgressMonitor parent, int allocatedTicks, int startProgress) {
            this._parent = parent;
            this._allocatedTicks = allocatedTicks;
            this._startProgress = startProgress;
        }

        private ProgressMonitor getParent() {
            return this._parent;
        }

        private BasicProgressMonitor getRootMonitor() {
            ProgressMonitor pm = this;
            while (!(pm instanceof BasicProgressMonitor)) {
                pm = pm.getParent();
            }
            return (BasicProgressMonitor)pm;
        }

        @Override
        public synchronized void start(int numberOfSteps) {
            this._jumpPerStep = this._allocatedTicks / numberOfSteps;
        }

        @Override
        public void finished() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JProgressBar pb = this.getRootMonitor()._progress;
                    pb.setValue(_startProgress + _allocatedTicks);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void advanced(int steps) {
            SubMonitor subMonitor = this;
            synchronized (subMonitor) {
                ++this._stepsElapsed;
            }
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SubMonitor subMonitor = this;
                    synchronized (subMonitor) {
                        JProgressBar pb = this.getRootMonitor()._progress;
                        pb.setValue(_startProgress + _stepsElapsed * _jumpPerStep);
                    }
                }
            });
        }

        @Override
        public boolean isCanceled() {
            return this.getRootMonitor().isCanceled();
        }

        @Override
        public void setCanceled(boolean canceled) {
            this.getRootMonitor().setCanceled(canceled);
        }

        @Override
        public void setMessage(String message) {
            this.getRootMonitor().setMessage(message);
        }

        @Override
        public void setDetailMessage(String detailMessage) {
            this.getRootMonitor().setDetailMessage(detailMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProgressMonitor createSubMonitor(int steps) {
            SubMonitor subMonitor = this;
            synchronized (subMonitor) {
                return new SubMonitor(this, steps * this._jumpPerStep, this._stepsElapsed * this._jumpPerStep);
            }
        }
    }
}

