/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.util.NameValuePair;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointStreamBCOp;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;

public class StreamDebuggingManager
implements StreamDebugger {
    private static final String FEATURE_PROPERTY = "StreamDebugger";
    private static Map<LambdaKey, List<MethodResult>> lambdaMethodInvocationResults = new HashMap<LambdaKey, List<MethodResult>>();
    private static Map<Integer, List<LambdaKey>> lambdaKeysByLine = new HashMap<Integer, List<LambdaKey>>();
    private static Map<LineKey, Boolean> isCovered = new HashMap<LineKey, Boolean>();
    private static Map<Long, Boolean> isMidStream = new HashMap<Long, Boolean>();
    private static Map<Integer, List<Integer>> streamRange = new HashMap<Integer, List<Integer>>();
    private static Map<Long, List<DebugJDIBreakpointStreamBCOp>> breakpoints = new HashMap<Long, List<DebugJDIBreakpointStreamBCOp>>();
    private static StreamDebuggingManager instance;
    private static Log logger;
    private static boolean onByDefault;
    private static Boolean featureIsOn;

    private StreamDebuggingManager() {
    }

    public static StreamDebuggingManager getInstance() {
        if (instance == null) {
            instance = new StreamDebuggingManager();
        }
        return instance;
    }

    public static boolean isFeatureEnabled() {
        if (featureIsOn != null) {
            return featureIsOn;
        }
        String value = System.getProperty(FEATURE_PROPERTY);
        if (value == null) {
            featureIsOn = onByDefault;
            StreamDebugger.getLogger().trace("Stream Debugging feature is " + onByDefault + " by default");
            return onByDefault;
        }
        if (value.toUpperCase().equals("TRUE") || value.toUpperCase().equals("ON") || value.toUpperCase().equals("YES")) {
            featureIsOn = true;
            StreamDebugger.getLogger().trace("Stream Debugging feature is on via property setting");
            return true;
        }
        if (value.toUpperCase().equals("FALSE") || value.toUpperCase().equals("OFF") || value.toUpperCase().equals("NO")) {
            featureIsOn = false;
            StreamDebugger.getLogger().trace("Stream Debugging feature is off via property setting");
            return false;
        }
        StreamDebugger.getLogger().trace("Unexpected value for property StreamDebugger: [" + value + "]");
        return onByDefault;
    }

    public boolean isCovered(Node node, DebugThreadInfo thread, int line) {
        LineKey key = new LineKey(node, thread.getThreadId(), line);
        Boolean lineIsCovered = isCovered.get(key);
        return lineIsCovered == null ? false : lineIsCovered;
    }

    public void markCovered(Node node, DebugThreadInfo thread, int entryLine, int currentLine) {
        LineKey key = new LineKey(node, thread.getThreadId(), currentLine);
        isCovered.put(key, true);
        List<Integer> lineRange = streamRange.get(entryLine);
        if (lineRange == null) {
            lineRange = new ArrayList<Integer>();
            streamRange.put(entryLine, lineRange);
        }
        lineRange.add(currentLine);
    }

    public void markUncovered(Node node, DebugThreadInfo thread, int line) {
        LineKey key = new LineKey(node, thread.getThreadId(), line);
        isCovered.remove(key);
        logger.trace(key + " now marked uncovered");
    }

    public void markEnteredStream(DebugThreadInfo thread) {
        isMidStream.put(thread.getThreadId(), true);
    }

    public void markExitedStream(DebugThreadInfo thread) {
        isMidStream.remove(thread.getThreadId());
        logger.trace("Thread " + thread.getThreadId() + " has exited stream, clearing results");
        StreamDebuggingManager.clearBreakpointsForThread(thread);
        this.clearResultsForThread(thread);
    }

    public boolean isMidStream(DebugThreadInfo thread) {
        Boolean threadIsMidStream = isMidStream.get(thread.getThreadId());
        return threadIsMidStream == null ? false : threadIsMidStream;
    }

    public static void addBreakpoint(DebugThreadInfo thread, DebugJDIBreakpointStreamBCOp bp) {
        List<DebugJDIBreakpointStreamBCOp> bpsForThread = breakpoints.get(thread.getThreadId());
        if (bpsForThread == null) {
            bpsForThread = new ArrayList<DebugJDIBreakpointStreamBCOp>();
            breakpoints.put(thread.getThreadId(), bpsForThread);
        }
        bpsForThread.add(bp);
    }

    public static void clearBreakpointsForThread(DebugThreadInfo thread) {
        List<DebugJDIBreakpointStreamBCOp> bpsForThread = breakpoints.remove(thread.getThreadId());
        if (bpsForThread != null) {
            logger.trace("Cleared " + bpsForThread.size() + " breakpoints");
        }
    }

    public static void clearAllBreakpoints() {
        breakpoints.clear();
    }

    private void addLambdaKeyToLine(LambdaKey key, int line) {
        List<LambdaKey> currentKeys = lambdaKeysByLine.get(line);
        if (currentKeys == null) {
            currentKeys = new ArrayList<LambdaKey>();
            lambdaKeysByLine.put(line, currentKeys);
        } else if (!currentKeys.contains(key)) {
            currentKeys.add(key);
        }
    }

    public void clearResultsForThread(DebugThreadInfo thread) {
        Iterator<LambdaKey> iterator = lambdaMethodInvocationResults.keySet().iterator();
        while (iterator.hasNext()) {
            LambdaKey key = iterator.next();
            if (key.threadID != thread.getThreadId()) continue;
            iterator.remove();
        }
    }

    public void recordArgument(Node node, long threadID, int line, String signature, String operationText, String argName, Object argValue) {
        LambdaKey key = new LambdaKey(node, threadID, signature);
        this.addLambdaKeyToLine(key, line);
        MethodResult mr = this.addMethodResultArgValue(key, operationText, argName, argValue);
    }

    public void recordReturnValue(Node node, long threadID, String signature, Object returnValue) {
        LambdaKey key = new LambdaKey(node, threadID, signature);
        List<MethodResult> lambdaResults = lambdaMethodInvocationResults.get(key);
        if (lambdaResults == null || lambdaResults.size() == 0) {
            logger.trace("ERROR: no lambda results when trying to attach return value for " + key);
            return;
        }
        MethodResult lambdaResult = lambdaResults.get(lambdaResults.size() - 1);
        lambdaResult.attachReturnValue(returnValue);
    }

    private MethodResult addMethodResultArgValue(LambdaKey key, String text, String argName, Object argValue) {
        List<MethodResult> methodResults = lambdaMethodInvocationResults.get(key);
        if (methodResults == null) {
            methodResults = new ArrayList<MethodResult>();
            lambdaMethodInvocationResults.put(key, methodResults);
        }
        if (methodResults.size() == 0) {
            MethodResult methodResult = new MethodResult(key.helperSignature, text, argName, argValue);
            methodResults.add(methodResult);
            return methodResult;
        }
        MethodResult lastRecordedResult = methodResults.get(methodResults.size() - 1);
        boolean createNewMethodResult = true;
        if (lastRecordedResult != null) {
            for (NameValuePair<Object> nvp : lastRecordedResult.arguments) {
                if (!nvp.getName().equals(argName)) continue;
                createNewMethodResult = true;
                break;
            }
        }
        if (createNewMethodResult) {
            MethodResult mr = new MethodResult(key.helperSignature, text, argName, argValue);
            methodResults.add(mr);
            return mr;
        }
        lastRecordedResult.addArgument(argName, argValue);
        logger.trace("Added argument to methodResult " + lastRecordedResult);
        return lastRecordedResult;
    }

    public static void dumpResults(Node node, long threadID, int fromLine, int toLine) {
        logger.trace("============== RESULTS ===============");
        for (int line = fromLine; line < toLine; ++line) {
            List<LambdaKey> keysForLine = lambdaKeysByLine.get(line);
            if (keysForLine != null) {
                logger.trace("Results for line " + line);
                Iterator<LambdaKey> lkiter = keysForLine.iterator();
                while (lkiter.hasNext()) {
                    LambdaKey key = lkiter.next();
                    List<MethodResult> resultsForKey = lambdaMethodInvocationResults.get(key);
                    for (MethodResult mr : resultsForKey) {
                        logger.trace(" " + mr);
                    }
                    lkiter.remove();
                }
                continue;
            }
            logger.trace("dumpResults: no results for line: " + line);
        }
        logger.trace("======================================");
    }

    static {
        logger = StreamDebugger.getLogger();
        onByDefault = false;
        featureIsOn = null;
    }

    static class LambdaKey {
        String path;
        String name;
        long threadID;
        String helperSignature;

        public LambdaKey(Node node, long threadID, String helperSignature) {
            this.path = node.getLongLabel();
            this.name = node.getShortLabel();
            this.threadID = threadID;
            this.helperSignature = helperSignature;
        }

        public boolean equals(Object o) {
            if (o instanceof LambdaKey) {
                LambdaKey other = (LambdaKey)o;
                if (this.threadID != other.threadID) {
                    return false;
                }
                if (this.helperSignature != other.helperSignature) {
                    return false;
                }
                return this.path.equals(other.path);
            }
            return false;
        }

        public int hashCode() {
            return (int)((long)this.path.hashCode() + this.threadID + (long)this.helperSignature.hashCode());
        }

        public String toString() {
            return this.name + ":" + this.helperSignature + " (thread:" + this.threadID + ")";
        }
    }

    static class MethodResult {
        String helperSignature;
        String operationText;
        List<NameValuePair<Object>> arguments = new ArrayList<NameValuePair<Object>>();
        Object returnValue;

        public MethodResult(String signature, String text, String argName, Object argValue) {
            this.helperSignature = signature;
            this.operationText = text;
            this.addArgument(argName, argValue);
        }

        public void addArgument(String argName, Object argValue) {
            this.arguments.add((NameValuePair<Object>)new NameValuePair(argName, argValue));
        }

        public void attachReturnValue(Object result) {
            this.returnValue = result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nStream Operation: " + this.operationText);
            for (NameValuePair<Object> nvp : this.arguments) {
                sb.append("\n  " + nvp.getName() + " = " + nvp.getValue());
            }
            if (this.returnValue != null) {
                sb.append("\n  return value = " + this.returnValue);
            }
            return sb.toString();
        }
    }

    static class LineKey {
        String path;
        String name;
        long threadID;
        int line;

        public LineKey(Node node, long threadID, int line) {
            this.path = node.getLongLabel();
            this.name = node.getShortLabel();
            this.threadID = threadID;
            this.line = line;
        }

        public boolean equals(Object o) {
            if (o instanceof LineKey) {
                LineKey other = (LineKey)o;
                if (this.threadID != other.threadID) {
                    return false;
                }
                if (this.line != other.line) {
                    return false;
                }
                return this.path.equals(other.path);
            }
            return false;
        }

        public int hashCode() {
            return (int)((long)this.path.hashCode() + this.threadID + (long)this.line);
        }

        public String toString() {
            return this.name + ":" + this.line + " (thread:" + this.threadID + ")";
        }
    }
}

