/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.debugger.plugin.breakpoint.MethodDescriptor;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethod;
import oracle.jdevimpl.debugger.jdi.JDIMethodSignatureMatcher;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerHelperHook;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerLanguageHelper;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodSignature;
import oracle.jdevimpl.runner.debug.JDebugger;

public class DebugJDIBreakpointMethodSignature
extends DebugJDIBreakpointMethod
implements DebugBreakpointMethodSignature {
    private MethodDescriptor methodDescriptor;

    public DebugJDIBreakpointMethodSignature(DebugJDI debugJDI, MethodDescriptor method) {
        super(debugJDI, method.getFQMethodName());
        this.methodDescriptor = method;
    }

    public static MethodDescriptor createMethodDescriptor(String packageName, String filename, int line) {
        Object md = null;
        Context context = Context.newIdeContext();
        Project project = context.getProject();
        URL sourceURL = Source.findSourceFile((Workspace)context.getWorkspace(), (Project)project, (String)packageName, (String)filename);
        int extensionStart = filename.lastIndexOf(46);
        String className = extensionStart == -1 ? filename : filename.substring(0, filename.lastIndexOf(46));
        List helpers = DebuggerHelperHook.getLanguageSpecificHelpers((Project)project);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canGetMethodDescriptorEnclosingLine(project, sourceURL)) continue;
            md = helper.getMethodDescriptorEnclosingLine(project, sourceURL, packageName, line);
            break;
        }
        JDebugger.logger.trace("Created MethodDescriptor: " + md.toString() + " for " + packageName + "." + className + ":" + line);
        return md;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        boolean identified = false;
        if (this.getClassName().equals(rtName)) {
            List<Method> methods = rt.methods();
            for (int im = 0; im < methods.size(); ++im) {
                Method m = methods.get(im);
                if (!this.getMethod().equals(this.getClassName() + "." + m.name()) || !JDIMethodSignatureMatcher.matchesJNISignature(this.methodDescriptor, m.signature())) continue;
                try {
                    List<Location> list = m.allLineLocations();
                    Location location = DebugJDI.getFirstLocation(list);
                    if (location != null) {
                        this.locationIdentified(location);
                        identified = true;
                        return identified;
                    }
                    continue;
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
            }
        }
        return identified;
    }
}

