/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml.switchable;

import java.awt.EventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.XMLFilter;

public class SwitchableTransformerFactory
extends SAXTransformerFactory {
    private static final Logger LOG = Logger.getLogger("oracle.ide.xml");
    private static final String JDK_TRANSFORMER_FACTORY = System.getProperty("oracle.ide.xml.SwitchableTransformer.jdk", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
    private static final String XDK_TRANSFORMER_FACTORY = System.getProperty("oracle.ide.xml.SwitchableTransformer.xdk", "oracle.xml.jaxp.JXSAXTransformerFactory");
    private static final ThreadLocal<AtomicInteger> useJDKTransformerOnThisTread = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    private final ThreadLocal<SAXTransformerFactory> alternativeTransformer = new ThreadLocal();
    private SAXTransformerFactory _xdk;

    private static SAXTransformerFactory getTransformerFactory(String name) {
        try {
            ClassLoader cc = Thread.currentThread().getContextClassLoader();
            cc = cc != null ? cc : SwitchableTransformerFactory.class.getClassLoader();
            Class<?> jdkTransformerClass = cc.loadClass(name);
            return (SAXTransformerFactory)jdkTransformerClass.newInstance();
        }
        catch (Exception ex) {
            if (!JDK_TRANSFORMER_FACTORY.equals(name)) {
                LOG.log(Level.INFO, "Can't get hold of XML transfromer " + name + " falling back to JDK transformer");
                try {
                    Class<?> jdkTransformerClass = Class.forName(JDK_TRANSFORMER_FACTORY);
                    return (SAXTransformerFactory)jdkTransformerClass.newInstance();
                }
                catch (Exception ex2) {
                    LOG.log(Level.SEVERE, "Can't get hold of XML transfromer which appears to be the JDK transformer, can now only fail", ex);
                }
            } else {
                LOG.log(Level.SEVERE, "Can't get hold of XML transfromer which appears to be the JDK transformer, can now only fail", ex);
            }
            throw new TypeNotPresentException("Cannot find suitable transformer " + name, ex);
        }
    }

    public static <T> T invokeWithJDKTransformerNewInstances(Callable<T> call) throws Exception {
        try {
            useJDKTransformerOnThisTread.get().incrementAndGet();
            T t = call.call();
            return t;
        }
        finally {
            useJDKTransformerOnThisTread.get().decrementAndGet();
        }
    }

    public <T> T invokeWithJDKTransformer(Callable<T> call) throws Exception {
        try {
            this.setJDKTransformerFactory();
            T t = call.call();
            return t;
        }
        finally {
            this.clearTransformerFactory();
        }
    }

    public void setTransformerFactory(SAXTransformerFactory tf) {
        if (tf == null) {
            throw new IllegalArgumentException("TransactionFactory argument should not be null, did you mean to invoke clear instead?");
        }
        if (EventQueue.isDispatchThread()) {
            LOG.info("Resetting the transformer factory on the event queue, should be followed by a clear " + tf.getClass().getName());
        }
        this.alternativeTransformer.set(tf);
    }

    public void setJDKTransformerFactory() {
        this.setTransformerFactory(SwitchableTransformerFactory.getTransformerFactory(JDK_TRANSFORMER_FACTORY));
    }

    public void clearTransformerFactory() {
        if (EventQueue.isDispatchThread()) {
            TransformerFactory tf = this.alternativeTransformer.get();
            LOG.info("Clearing the TransformerFactory on the event queue " + tf != null ? tf.getClass().getName() : "[was null]");
        }
        this.alternativeTransformer.set(null);
    }

    public SwitchableTransformerFactory() {
        if (useJDKTransformerOnThisTread.get().get() > 0) {
            this.setJDKTransformerFactory();
        }
    }

    private SAXTransformerFactory getXDK() {
        return this._xdk != null ? this._xdk : (this._xdk = SwitchableTransformerFactory.getTransformerFactory(XDK_TRANSFORMER_FACTORY));
    }

    private SAXTransformerFactory get() {
        SAXTransformerFactory factory = this.alternativeTransformer.get();
        return factory != null ? factory : this.getXDK();
    }

    @Override
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        return this.get().newTransformer(source);
    }

    @Override
    public Transformer newTransformer() throws TransformerConfigurationException {
        return this.get().newTransformer();
    }

    @Override
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        return this.get().newTemplates(source);
    }

    @Override
    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        return this.get().getAssociatedStylesheet(source, media, title, charset);
    }

    @Override
    public void setURIResolver(URIResolver resolver) {
        this.get().setURIResolver(resolver);
    }

    @Override
    public URIResolver getURIResolver() {
        return this.get().getURIResolver();
    }

    @Override
    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        this.get().setFeature(name, value);
    }

    @Override
    public boolean getFeature(String name) {
        return this.get().getFeature(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.get().setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.get().getAttribute(name);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.get().setErrorListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.get().getErrorListener();
    }

    @Override
    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        return this.get().newTransformerHandler(src);
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        return this.get().newTransformerHandler(templates);
    }

    @Override
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return this.get().newTransformerHandler();
    }

    @Override
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return this.get().newTemplatesHandler();
    }

    @Override
    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        return this.get().newXMLFilter(src);
    }

    @Override
    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        return this.get().newXMLFilter(templates);
    }
}

