/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.persistence.ApplicationCacheSettings;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.persistence.ApplicationCacheSettingsArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.RichHintLabel;

public final class ApplicationCacheSettingsPanel
extends ProjectSettingsTraversablePanel {
    private JLabel _lblDefaultStorageDirectory = new JLabel();
    private JLabel _lblOverrideStorageDirectory = new JLabel();
    private URLTextField _tfDefaultStorageDirectory = new URLTextField(null, true, false);
    private URLTextField _tfOverrideStorageDirectory = new URLTextField(null, true, false);
    private JButton _browseStorageDirectory = new JButton();
    private static final String[] PROPERTY_KEYS = new String[]{"application-storage-directory"};

    public ApplicationCacheSettingsPanel() {
        RichHintLabel hintText = new RichHintLabel();
        hintText.setText(ApplicationCacheSettingsArb.getString(4));
        ResourceUtils.resLabel((JLabel)this._lblDefaultStorageDirectory, (Component)this._tfDefaultStorageDirectory, (String)ApplicationCacheSettingsArb.getString(0));
        ResourceUtils.resLabel((JLabel)this._lblOverrideStorageDirectory, (Component)this._tfOverrideStorageDirectory, (String)ApplicationCacheSettingsArb.getString(1));
        ResourceUtils.resButton((AbstractButton)this._browseStorageDirectory, (String)ApplicationCacheSettingsArb.getString(3));
        this._tfDefaultStorageDirectory.setEditable(false);
        this._tfOverrideStorageDirectory.setDirectoryOnly(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)hintText, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 10, 0), 0, 0));
        this.add(this._lblDefaultStorageDirectory, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this._tfDefaultStorageDirectory, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._lblOverrideStorageDirectory, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this._tfOverrideStorageDirectory, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._browseStorageDirectory, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JLabel(""), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._browseStorageDirectory.addActionListener((ActionListener)this._tfOverrideStorageDirectory);
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        this.setHelpID("f1_appcachesettings_html");
        ApplicationCacheSettings content = this.getApplicationCacheSettings(tc);
        this._tfDefaultStorageDirectory.setURL(content.getDefaultApplicationStorageURL());
        this._tfOverrideStorageDirectory.setURL(content.getOverrideApplicationStorageURL());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ApplicationCacheSettings content = this.getApplicationCacheSettings(tc);
        URL defaultStorageDirectoryURL = this._tfDefaultStorageDirectory.getURL();
        URL overrideStorageDirectoryURL = this._tfOverrideStorageDirectory.getURL();
        String overrideStorageDirectoryText = this._tfOverrideStorageDirectory.getText();
        boolean valid = true;
        if (overrideStorageDirectoryURL == null) {
            if (overrideStorageDirectoryText != null && overrideStorageDirectoryText.length() > 0) {
                valid = false;
            }
        } else if (overrideStorageDirectoryURL.getPath().length() > 0 && !URLFileSystem.isValid((URL)overrideStorageDirectoryURL)) {
            valid = false;
        }
        if (!valid) {
            String directory = this._tfOverrideStorageDirectory.getText().trim();
            this._tfOverrideStorageDirectory.requestFocus();
            throw new TraversalException(ApplicationCacheSettingsArb.format(5, directory), ApplicationCacheSettingsArb.getString(7));
        }
        if (overrideStorageDirectoryURL != null && overrideStorageDirectoryURL.equals(defaultStorageDirectoryURL)) {
            String directory = this._tfOverrideStorageDirectory.getText().trim();
            this._tfOverrideStorageDirectory.requestFocus();
            throw new TraversalException(ApplicationCacheSettingsArb.format(6, directory), ApplicationCacheSettingsArb.getString(7));
        }
        content.setStorageURL(overrideStorageDirectoryURL);
    }

    public ApplicationCacheSettings getApplicationCacheSettings(TraversableContext tc) {
        Workspace ws = (Workspace)tc.find("Application");
        PropertyStorage ps = ApplicationCacheSettingsPanel.getPropertyData((Namespace)tc);
        return ApplicationCacheSettings.getInstance(ps, ws.getURL());
    }

    public String getDataKey() {
        return "Application";
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }
}

