/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dbtools.crest.util.logging.Logger;

public class TimeLog {
    private static final Logger LOGGER = new Logger(TimeLog.class);
    private static final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    public static boolean debug = false;

    public static void log() {
        try {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements.length >= 3) {
                StackTraceElement el = stackTraceElements[2];
                if (debug) {
                    LOGGER.info(el);
                } else {
                    LOGGER.fine(el);
                }
            } else {
                LOGGER.fine(format.format(new Date(System.currentTimeMillis())));
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }

    public static void log(String note) {
        try {
            if (debug) {
                LOGGER.info(note + " - " + format.format(new Date(System.currentTimeMillis())));
            } else {
                LOGGER.fine(note + " - " + format.format(new Date(System.currentTimeMillis())));
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }

    public static void error(String message) {
        try {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements.length >= 3) {
                StackTraceElement el = stackTraceElements[2];
                LOGGER.error(el, message);
            } else {
                LOGGER.error(message);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }
}

