/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class SchedulerWindowGroupCompare
extends SchedulerObjectCompare {
    List<String> toAdd = new ArrayList<String>();
    List<String> toRemove = new ArrayList<String>();

    public SchedulerWindowGroupCompare(SchedulerObject source, SchedulerObject target) {
        super(source, target);
        if (source instanceof SchedulerWindowGroup && target instanceof SchedulerWindowGroup) {
            SchedulerWindowGroup s = (SchedulerWindowGroup)source;
            SchedulerWindowGroup t = (SchedulerWindowGroup)target;
            List<String> snames = s.getSortedWindows();
            List<String> tnames = t.getSortedWindows();
            this.toAdd.addAll(snames);
            this.toAdd.removeAll(tnames);
            ArrayList<String> tn = new ArrayList<String>();
            tn.addAll(tnames);
            tn.retainAll(snames);
            tnames.removeAll(tn);
            this.toRemove.addAll(tnames);
        }
    }

    @Override
    public void initExcludeNulls() {
        this.excludeNulls.add("NUMBER_OF_WINDOWS");
    }

    public List<String> getToRemove() {
        return this.toRemove;
    }

    public List<String> getToAdd() {
        return this.toAdd;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.toAdd.size() > 0 || this.toRemove.size() > 0;
    }
}

