/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;

public class XMLObjToStreamTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final String SLASH_CLOSE_CHAR = "/>";
    private static final String OPEN_CHAR_SLASH = "</";
    private static final String CLOSE_CHAR = ">";
    private static final String NEWLINE_OPEN_SLASH = "\n</";
    private static final String NEWLINE_OPEN = "\n<";
    private static final String SLASHED_QUOTE = "\"";
    private static final String EQUAL_SLASH = "=\"";
    private static final String SPACE = " ";
    private static final String INNER_CLASS = "innerClass";
    public static boolean includeLoggingProps = true;
    public static boolean includeID = true;
    public static String header = "<?xml version = '1.0' encoding = 'UTF-8'?>";

    public void transformFromObject(Object object, Writer sb) {
        this.transformFromObject(object, sb, false, null);
    }

    public void transformFromObject(Object object, Writer sb, boolean processExternals, List excludeProps_Collections) {
        try {
            sb.write(header);
        }
        catch (IOException e) {
            Logger.error(e);
        }
        this.transformFromObject(object, null, sb, processExternals, excludeProps_Collections);
    }

    public void transformFromListOfObjects(List list, Writer sb, boolean processExternals, List excludeProps_Collections) {
        try {
            sb.write(header);
            sb.write("<objects>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
        for (Object object : list) {
            this.transformFromObject(object, null, sb, processExternals, excludeProps_Collections);
        }
        try {
            sb.write("</objects>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public void transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, List excludeProps_Collections) {
        String name = this.transformFromObject(object, tagName, sb, processExternals, false, excludeProps_Collections);
        this.addCloseTag(name, sb);
    }

    public String transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName) {
        return this.transformFromObject(object, tagName, sb, processExternals, skipClassName, null);
    }

    public String transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName, List excludeProps_Collections) {
        String name = "";
        try {
            ClassDescription cd = this.getClassDescription();
            String xmlName = "";
            if (tagName != null) {
                this.addOpenTag(tagName, sb);
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                this.addOpenTag(xmlName, sb);
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb);
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb);
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            ArrayList<ClassDescription.PropertyDescription> properties = new ArrayList<ClassDescription.PropertyDescription>();
            ArrayList<ClassDescription.PropertyDescription> afterCollectionsProcessing = new ArrayList<ClassDescription.PropertyDescription>();
            ArrayList<ClassDescription.PropertyDescription> collectionDependentProcessing = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                if (pd.isExternalProperty && !processExternals || excludeProps_Collections != null && excludeProps_Collections.contains(pd.name)) continue;
                if (pd.isAfterCollectionProcessing) {
                    afterCollectionsProcessing.add(pd);
                    continue;
                }
                if (pd.beforeCollection != null && !"".equals(pd.beforeCollection) || pd.afterCollection != null && !"".equals(pd.afterCollection)) {
                    collectionDependentProcessing.add(pd);
                    continue;
                }
                properties.add(pd);
            }
            this.processProperties(object, sb, cd, properties, processExternals, excludeProps_Collections);
            this.processClassPropertyMap(object, sb, cd);
            this.processCollections(object, sb, cd, processExternals, collectionDependentProcessing, afterCollectionsProcessing, excludeProps_Collections);
            name = tagName != null ? tagName : xmlName;
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return name;
    }

    public void transformFromObjectAttributesOnly(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName) {
        String name = "";
        try {
            ClassDescription cd = this.getClassDescription();
            String xmlName = "";
            if (tagName != null) {
                this.addOpenTag(tagName, sb);
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                this.addOpenTag(xmlName, sb);
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb);
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb);
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                String value;
                if (!pd.isAttribute() || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = this.getProperty(object, pd)) == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                value = StringUtilities.encodeAttributeValue(value);
                this.addAttribute(pd.xmlName, value, sb);
            }
            name = tagName != null ? tagName : xmlName;
            this.addCloseSlashChar(sb);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private void addAttribute(String name, String value, Writer sb) {
        try {
            String code = MetaDataManager.getCodeForTag(name);
            sb.write(SPACE);
            sb.write(code);
            sb.write(EQUAL_SLASH);
            sb.write(value);
            sb.write(SLASHED_QUOTE);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addOpenTag(String tagname, Writer sb) {
        try {
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(NEWLINE_OPEN);
            sb.write(code);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCloseTag(String tagname, Writer sb) {
        try {
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(NEWLINE_OPEN_SLASH);
            sb.write(code);
            sb.write(CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addElement(String tagname, String value, Writer sb) {
        try {
            sb.write(NEWLINE_OPEN);
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(code);
            sb.write(CLOSE_CHAR);
            sb.write(value);
            sb.write(OPEN_CHAR_SLASH);
            sb.write(code);
            sb.write(CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCloseChar(Writer sb) {
        try {
            sb.write(CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCloseSlashChar(Writer sb) {
        try {
            sb.write(SLASH_CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void processProperties(Object object, Writer sb, ClassDescription cd, List properties, boolean processExternals, List excludeProps_Collections) {
        for (ClassDescription.PropertyDescription pd : properties) {
            String value;
            if (!pd.isAttribute() || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = this.getProperty(object, pd)) == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
            value = StringUtilities.encodeAttributeValue(value);
            this.addAttribute(pd.xmlName, value, sb);
        }
        this.addCloseChar(sb);
        for (ClassDescription.PropertyDescription pd : properties) {
            this.processProperty(object, pd, sb, processExternals, excludeProps_Collections);
        }
    }

    private void processProperty(Object object, ClassDescription.PropertyDescription pd, Writer sb, boolean processExternals, List excludeProps_Collections) {
        if (pd.isAttribute()) {
            return;
        }
        if (pd.isLoggingProp && !includeLoggingProps) {
            return;
        }
        if (!includeID && "id".equalsIgnoreCase(pd.xmlName)) {
            return;
        }
        if (pd.isExternalProperty && !processExternals) {
            return;
        }
        if (pd.isRectangle) {
            Object obj = XMLObjToStreamTransformer.getObjectForProperty(object, pd);
            if (obj != null && obj instanceof Rectangle) {
                this.appendBounds(sb, pd.xmlName, (Rectangle)obj);
            }
        } else if (pd.isPropertyMap) {
            this.processPropertyAsPropertyMap(object, sb, pd);
        } else if (pd.isMap) {
            this.processMapProperty(object, sb, pd);
        } else if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
            String value = this.getProperty(object, pd);
            if (!(value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue))) {
                value = StringUtilities.encodeAttributeValue(value);
                if (!pd.isAttribute()) {
                    this.addElement(pd.xmlName, value, sb);
                }
            }
        } else {
            MDTransformationManager.TrObjects tr;
            Object nested = XMLObjToStreamTransformer.getObjectForProperty(object, pd);
            if (nested != null && (tr = this.getTransformationManager().getTransformersFor(nested.getClass())) != null && tr.getFromObjectToStreamTransformer() != null && tr.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
                XMLObjToStreamTransformer xmltr = (XMLObjToStreamTransformer)tr.getFromObjectToStreamTransformer();
                xmltr.transformFromObject(nested, pd.xmlName, sb, processExternals, excludeProps_Collections);
            }
        }
    }

    private void processPropertyAsPropertyMap(Object object, Writer sb, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isPropertyMap && (obj = XMLObjToStreamTransformer.getObjectForProperty(object, pd)) != null && obj instanceof PropertyMap) {
            PropertyMap pm = (PropertyMap)obj;
            boolean pmadded = false;
            Iterator it = pm.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pm.getProperty(key);
                if (value == null) continue;
                if (!pmadded) {
                    this.addOpenTag(pd.xmlName, sb);
                    this.addCloseChar(sb);
                    pmadded = true;
                }
                this.addOpenTag(pd.pmItemName, sb);
                this.addAttribute(pd.pmKeyName, StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute(pd.pmValueName, StringUtilities.encodeAttributeValue(value), sb);
                this.addCloseSlashChar(sb);
            }
            if (pmadded) {
                this.addCloseTag(pd.xmlName, sb);
            }
        }
    }

    private void processMapProperty(Object object, Writer sb, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isMap && (obj = XMLObjToStreamTransformer.getObjectForProperty(object, pd)) != null && obj instanceof Map) {
            Map map = (Map)obj;
            boolean pmadded = false;
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value == null) continue;
                if (!pmadded) {
                    this.addOpenTag(pd.xmlName, sb);
                    this.addCloseChar(sb);
                    pmadded = true;
                }
                this.addOpenTag(pd.pmItemName, sb);
                this.addAttribute("key", StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(value.toString()), sb);
                this.addCloseSlashChar(sb);
            }
            if (pmadded) {
                this.addCloseTag(pd.xmlName, sb);
            }
        }
    }

    private void processClassPropertyMap(Object object, Writer sb, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap pmap = (PropertyMap)object;
            Iterator it = pmap.getPropertyNames();
            boolean pmadded = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.skipProperty(key)) continue;
                String value = pmap.getProperty(key);
                if (value == null) {
                    value = "";
                }
                if (!pmadded) {
                    this.addOpenTag("propertyMap", sb);
                    this.addCloseChar(sb);
                    pmadded = true;
                }
                this.addOpenTag("property", sb);
                this.addAttribute("name", StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(value), sb);
                this.addCloseSlashChar(sb);
            }
            if (pmadded) {
                this.addCloseTag("propertyMap", sb);
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Object object, Writer sb, ClassDescription cd, boolean processExternals, List collectionDependent, List afterCollections, List excludeProps_Collections) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object sourceCol;
            Collection col;
            if (excludeProps_Collections != null && excludeProps_Collections.contains(cold.name)) continue;
            this.processBeforeCollection(object, sb, cold, collectionDependent, processExternals, null);
            if (!(cold.isExternalCollection && !processExternals || (col = this.getObjectList(sourceCol = XMLObjToStreamTransformer.getCollection(object, cold), cold)) == null || !(col instanceof Collection) || SKP_DEFAULTS && col.size() <= 0)) {
                if (cold.itemIsRef) {
                    this.processCollectionWithRefs(object, col, sb, cold, processExternals);
                } else {
                    this.processCollectionWithContained(col, sb, cold, processExternals, excludeProps_Collections);
                }
            }
            this.processAfterCollection(object, sb, cold, collectionDependent, processExternals, null);
        }
        for (ClassDescription.PropertyDescription pd : afterCollections) {
            if (pd.isExternalProperty && !processExternals) continue;
            this.processProperty(object, pd, sb, processExternals, excludeProps_Collections);
        }
    }

    private void processBeforeCollection(Object container, Writer sb, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.beforeCollection == null || cold.name == null || !cold.name.equals(pd.beforeCollection)) continue;
            this.processProperty(container, pd, sb, processExternals, excludeProps);
        }
    }

    private void processAfterCollection(Object container, Writer sb, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.afterCollection == null || cold.name == null || !cold.name.equals(pd.afterCollection)) continue;
            this.processProperty(container, pd, sb, processExternals, excludeProps);
        }
    }

    private void processCollectionWithRefs(Object object, Collection col, Writer sb, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addOpenTag(cold.xmlName, sb);
        if (!cold.listOfRefs) {
            this.addCloseChar(sb);
            for (Object item : col) {
                if (item == null) continue;
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                this.addElement(cold.itemXmlName, id, sb);
            }
            this.addCloseTag(cold.xmlName, sb);
        } else {
            StringBuffer sbi = new StringBuffer();
            boolean first = true;
            for (Object item : col) {
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                if (id == null) continue;
                if (first) {
                    sbi.append(id);
                    first = false;
                    continue;
                }
                sbi.append(' ').append(id);
            }
            String idrefs = sbi.toString();
            this.addAttribute(cold.refsXMLName, idrefs, sb);
            this.addCloseSlashChar(sb);
        }
    }

    private void processCollectionWithContained(Collection col, Writer sb, ClassDescription.CollectionDescription cold, boolean processExternals, List excludeProps_Collections) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addOpenTag(cold.xmlName, sb);
        boolean skipClassName = false;
        if (cold.itemClassName != null && !"".equals(cold.itemClassName)) {
            skipClassName = true;
            this.addAttribute("itemClass", cold.itemClassName, sb);
        }
        this.addCloseChar(sb);
        if (cold.isEngPropertyHolderItem) {
            for (Object item : col) {
                if (!(item instanceof EngPropertyHolder)) continue;
                EngPropertyHolder ph = (EngPropertyHolder)item;
                this.addOpenTag(cold.itemXmlName, sb);
                this.addAttribute("name", ph.getName(), sb);
                this.addAttribute("selected", String.valueOf(ph.isSelected()), sb);
                this.addCloseSlashChar(sb);
            }
        }
        boolean first = true;
        boolean mapItem = cold.isMapItem;
        MDTransformationManager.TrObjects tr = null;
        Class<?> currentClass = null;
        if (!mapItem) {
            for (Object item : col) {
                if (item instanceof Map) {
                    mapItem = true;
                    continue;
                }
                if (first || currentClass != null && !item.getClass().equals(currentClass)) {
                    tr = this.getTransformationManager().getTransformersFor(item.getClass());
                    first = false;
                    currentClass = item.getClass();
                }
                String name = null;
                if (tr != null && tr.getFromObjectToStreamTransformer() != null && tr.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
                    XMLObjToStreamTransformer xmltr = (XMLObjToStreamTransformer)tr.getFromObjectToStreamTransformer();
                    ClassDescription cd = xmltr.getClassDescription();
                    if (cd != null && !cd.isHasElementsOrCollections()) {
                        xmltr.transformFromObjectAttributesOnly(item, cold.itemXmlName, sb, processExternals, skipClassName);
                    } else {
                        name = xmltr.transformFromObject(item, cold.itemXmlName, sb, processExternals, skipClassName, excludeProps_Collections);
                    }
                }
                if (name == null) continue;
                this.addCloseTag(name, sb);
            }
        }
        if (mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                mapItem = true;
                Map map = (Map)item;
                if (map.entrySet().size() <= 0) continue;
                this.addOpenTag(cold.itemXmlName, sb);
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    this.addAttribute(StringUtilities.encodeAttributeValue((String)key), StringUtilities.encodeAttributeValue((String)value), sb);
                }
                this.addCloseSlashChar(sb);
            }
        }
        this.addCloseTag(cold.xmlName, sb);
    }

    private void appendBounds(Writer sb, String elemName, Rectangle bounds) {
        this.addOpenTag(elemName, sb);
        this.addAttribute("x", String.valueOf(bounds.x), sb);
        this.addAttribute("y", String.valueOf(bounds.y), sb);
        this.addAttribute("width", String.valueOf(bounds.width), sb);
        this.addAttribute("height", String.valueOf(bounds.height), sb);
        this.addCloseSlashChar(sb);
    }

    private void addCollectionOfPoints(Writer sb, String elemName, Collection points) {
        if (points.size() > 0) {
            this.addOpenTag(elemName, sb);
            this.addCloseChar(sb);
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                this.addOpenTag("point", sb);
                Point2D p = (Point2D)obj;
                this.addAttribute("x", String.valueOf((int)p.getX()), sb);
                this.addAttribute("y", String.valueOf((int)p.getY()), sb);
                this.addCloseSlashChar(sb);
            }
            this.addCloseTag(elemName, sb);
        }
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        return "";
    }
}

