/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class TriggerOracle
extends Trigger
implements OwnedObjectOracle {
    protected TableProxyOracle table;
    protected TableViewProxyOracle view;
    protected UserOracle owner;
    private String ownerName = "";
    private String columns = "";
    private ArraySet columnSet = null;
    protected String scope = SCOPE_TYPES[0];
    protected String state = "";
    protected String ref_OLD_AS = "";
    protected String ref_NEW_AS = "";
    protected String ref_PARENT_AS = "";
    protected String condition = "";
    protected String crossEdition = "NO";
    public static final String FORWARD = "FORWARD";
    public static final String REVERSE = "REVERSE";
    private static final String[] CROSS_EDITIONS = new String[]{"NO", "FORWARD", "REVERSE"};
    private static List crossEditionsList = Arrays.asList(CROSS_EDITIONS);
    public static final String BEFORE = "BEFORE";
    public static final String AFTER = "AFTER";
    public static final String INSTEAD_OF = "INSTEAD OF";
    public static final String COMPOUND = "COMPOUND";
    private static final String[] TRIGGER_TIMES = new String[]{"BEFORE", "AFTER", "INSTEAD OF", "COMPOUND"};
    private static Set triggerTimeSet = null;
    public static final String[] SCOPE_TYPES = new String[]{"FOR EACH ROW", "FOR EACH STATEMENT"};
    private static List scopeList = Arrays.asList(SCOPE_TYPES);
    public static final String[] STATE_TYPES = new String[]{"", "ENABLE", "DISABLE"};
    private static List stateList = Arrays.asList(STATE_TYPES);
    private String tempTableOwner;

    public TriggerOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime(BEFORE);
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle table) {
        if (this.table != null) {
            this.table.removeObject(this);
        }
        this.table = table;
        if (table != null) {
            table.addObject(this);
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyOracle getView() {
        return this.view;
    }

    public void setView(TableViewProxyOracle view) {
        if (this.view != view) {
            this.view = view;
            if (view != null && !this.getStorageDesign().isLoading()) {
                this.setTriggerTime(INSTEAD_OF);
            }
            this.fireDataFieldChange();
        }
    }

    public static String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    @Override
    protected boolean checkTriggerTime(String value) {
        if (triggerTimeSet == null) {
            triggerTimeSet = new HashSet();
            triggerTimeSet.addAll(Arrays.asList(TriggerOracle.getTriggerTimes()));
        }
        return triggerTimeSet.contains(value);
    }

    public static String[] getScopeTypes() {
        return SCOPE_TYPES;
    }

    public static List getScopeValues() {
        return scopeList;
    }

    protected boolean checkScope(String value) {
        return scopeList.contains(value);
    }

    private void addColumn(String column) {
        if (!this.getColumnSet().contains(column)) {
            this.getColumnSet().add(column);
        }
    }

    private void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ArraySet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ArraySet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
        this.fireDataFieldChange();
    }

    public String getRef_PARENT_AS() {
        return this.ref_PARENT_AS;
    }

    public void setRef_PARENT_AS(String ref_PARENT_AS) {
        this.ref_PARENT_AS = ref_PARENT_AS;
        this.fireDataFieldChange();
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        this.owner = owner;
    }

    public String getOwnerName() {
        UserOracle user = this.getOwner();
        if (user != null) {
            return user.getName();
        }
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
        ModelObject user = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(name);
        if (user != null) {
            this.setOwner((UserOracle)user);
        }
    }

    public String getRef_NEW_AS() {
        return this.ref_NEW_AS;
    }

    public void setRef_NEW_AS(String ref_NEW_AS) {
        this.ref_NEW_AS = ref_NEW_AS;
        this.fireDataFieldChange();
    }

    public String getRef_OLD_AS() {
        return this.ref_OLD_AS;
    }

    public void setRef_OLD_AS(String ref_OLD_AS) {
        this.ref_OLD_AS = ref_OLD_AS;
        this.fireDataFieldChange();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.checkScope(scope)) {
            this.scope = scope;
            this.fireDataFieldChange();
        }
    }

    public boolean isScopeForEachRow() {
        return this.getScope().equalsIgnoreCase(SCOPE_TYPES[0]);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        if (stateList.contains(state)) {
            this.state = state;
        }
    }

    public String getCrossEdition() {
        return this.crossEdition;
    }

    public void setCrossEdition(String crossEdition) {
        if (crossEditionsList.contains(crossEdition)) {
            this.crossEdition = crossEdition;
        }
    }

    public static String[] getCrossEditions() {
        return CROSS_EDITIONS;
    }

    @Override
    public void remove() {
        if (this.table != null) {
            this.table.removeObject(this);
        }
        super.remove();
    }

    public String getColumnsNames() {
        Object names = "";
        if (this.getTable() != null) {
            boolean first = true;
            ColumnProxy[] columnSet = this.getTable().getColumnProxies();
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy column = columnSet[i];
                if (!this.getColumnSet().contains(column.getObjectID())) continue;
                if (first) {
                    names = column.getName();
                    first = false;
                    continue;
                }
                names = (String)names + "," + column.getName();
            }
        }
        return names;
    }

    public void setColumnsNames(String names) {
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null) {
            name = this.getOwner().getLongName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    @Override
    public void setUser(UserOracle user) {
        this.setOwner(user);
    }

    @Override
    public UserOracle getUser() {
        return this.getOwner();
    }

    public String getTempTableOwner() {
        return this.tempTableOwner;
    }

    public void setTempTableOwner(String tempTableOwner) {
        this.tempTableOwner = tempTableOwner;
    }

    public AutoIncDetails checkAutoIncTrigger() {
        String body;
        if (this.getTriggerTime().equals(BEFORE) && this.getActions().equals(ACTION_TYPES[0]) && this.isScopeForEachRow() && (body = this.getBody()).toUpperCase().indexOf(".NEXTVAL") > -1) {
            int semicolonIndex;
            String bodyStatement = body.trim();
            if (bodyStatement.endsWith(";")) {
                bodyStatement = bodyStatement.substring(0, bodyStatement.length() - 1);
            }
            if (bodyStatement.substring((semicolonIndex = bodyStatement.lastIndexOf(59)) + 1).trim().equalsIgnoreCase("END") && Token.getFirstToken(bodyStatement).equalsIgnoreCase("BEGIN")) {
                int endLabelIndex;
                String statement = Token.cutTokenFromFront(bodyStatement.substring(0, semicolonIndex), "BEGIN");
                if (statement.startsWith("<<") && (endLabelIndex = statement.indexOf(">>")) > 0) {
                    String label = statement.substring(2, endLabelIndex).trim();
                    int endLabelStart = statement.length() - label.length();
                    if (statement.substring(endLabelStart).equalsIgnoreCase(label)) {
                        statement = statement.substring(0, endLabelStart);
                    }
                    statement = (statement = statement.substring(endLabelIndex + 2).trim()).substring((semicolonIndex = statement.lastIndexOf(59)) + 1).trim().equalsIgnoreCase("END") && Token.getFirstToken(statement).equalsIgnoreCase("BEGIN") ? Token.cutTokenFromFront(statement.substring(0, semicolonIndex), "BEGIN") : "";
                }
                String ifCondition = null;
                if (Token.getFirstToken(statement).equalsIgnoreCase("IF") && statement.toUpperCase().endsWith("END IF")) {
                    if ((statement = statement.substring(3, statement.length() - 6).trim()).endsWith(";")) {
                        statement = statement.substring(0, statement.length() - 1);
                    }
                    ifCondition = Token.getStringBeforeToken(statement, "THEN");
                    statement = Token.getStringAfter(statement, "THEN");
                }
                if (statement.indexOf(59) == -1) {
                    String afterInto;
                    String afterSelect;
                    String nameAfterSelect;
                    String columnName = null;
                    String sequenceName = null;
                    int colonEqualIndex = statement.indexOf(":=");
                    if (colonEqualIndex > -1) {
                        String beforeColonEqual = statement.substring(0, colonEqualIndex).trim();
                        if (beforeColonEqual.toUpperCase().startsWith(":NEW.")) {
                            String afterColonEqual;
                            String nameAfterColonEqual;
                            columnName = Token.getFirstName(beforeColonEqual.substring(5), '\"', '\"');
                            if (beforeColonEqual.length() <= columnName.length() + 7 && (nameAfterColonEqual = Token.getFirstName(afterColonEqual = statement.substring(colonEqualIndex + 2).trim(), '\"', '\"')).toUpperCase().endsWith(".NEXTVAL") && afterColonEqual.length() <= nameAfterColonEqual.length() + 4) {
                                sequenceName = nameAfterColonEqual.substring(0, nameAfterColonEqual.length() - 8);
                            }
                        }
                    } else if (Token.getFirstToken(statement).equalsIgnoreCase("SELECT") && Token.getNameAfterToken(statement, "FROM", '\"', '\"').toUpperCase().endsWith("DUAL") && (nameAfterSelect = Token.getFirstName(afterSelect = Token.cutTokenFromFront(statement, "SELECT"), '\"', '\"')).toUpperCase().endsWith(".NEXTVAL") && Token.getStringBeforeToken(afterSelect, "INTO").length() <= nameAfterSelect.length() + 4 && (afterInto = Token.getStringAfter(statement, "INTO")).toUpperCase().startsWith(":NEW.")) {
                        columnName = Token.getFirstName(afterInto.substring(5), '\"', '\"');
                        if (Token.getStringBeforeToken(afterInto, "FROM").length() <= columnName.length() + 7) {
                            sequenceName = nameAfterSelect.substring(0, nameAfterSelect.length() - 8);
                        }
                    }
                    if (sequenceName != null) {
                        String whenCondition;
                        String conditionPattern = ":NEW." + columnName + " IS NULL";
                        boolean conditionValid = false;
                        if (ifCondition != null) {
                            if ((ifCondition = ifCondition.toUpperCase()).startsWith("INSERTING AND ")) {
                                ifCondition = ifCondition.substring(14);
                            }
                            if (Token.removeQuotes(ifCondition).equalsIgnoreCase(conditionPattern)) {
                                conditionValid = true;
                            } else {
                                return null;
                            }
                        }
                        if ((whenCondition = this.getCondition()).length() > 0) {
                            conditionValid = Token.removeQuotes(whenCondition).equalsIgnoreCase(conditionPattern.substring(1));
                        }
                        if (conditionValid) {
                            return new AutoIncDetails(columnName, sequenceName);
                        }
                    }
                }
            }
        }
        return null;
    }

    public class AutoIncDetails {
        private String columnName;
        private String sequenceName;

        private AutoIncDetails(String columnName, String sequenceName) {
            this.columnName = columnName;
            this.sequenceName = sequenceName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }
    }

    public class ArraySet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

