/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;

public abstract class IndexGlobalPartitionsListOracle
extends AbstractStorageObjectOracle {
    protected IndexProxy index = null;
    private String globalPartColumns = "";
    private InlineList columnsSet = null;
    public static final String TYPE_NAME = "IndexGlobalPartitionsList";

    @Override
    public String getIDPrefix() {
        return "IGPL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getGlobalPartColumns() {
        return this.globalPartColumns;
    }

    public String getAllGlobalPartColumns() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.globalPartColumns, ",");
        while (st.hasMoreTokens()) {
            String cID = st.nextToken().trim();
            ColumnProxyOracle column = (ColumnProxyOracle)this.getStorageDesignOracle().getColumnProxySet().getProxy(cID);
            if (column == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(column.getName());
        }
        return result.toString();
    }

    public String columnNamesToColumnIDs(String columnNames) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(columnNames, ",");
        while (st.hasMoreTokens()) {
            String name = Token.getName(st.nextToken());
            ColumnProxyOracle column = (ColumnProxyOracle)this.getIndex().getTableProxy().getColumnProxyByName(name);
            if (column == null) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getObjectID());
        }
        return buffer.toString();
    }

    public void setGlobalPartColumns(String globalPartColumns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(globalPartColumns);
        } else {
            this.addColumn(globalPartColumns);
        }
        this.globalPartColumns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addColumn(String columnID) {
        if (!this.getColumnSet().contains(columnID)) {
            this.getColumnSet().add(columnID);
        }
    }

    protected void recreateColumnsSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    public InlineList getColumnSet() {
        if (this.columnsSet == null) {
            this.columnsSet = new InlineList();
        }
        return this.columnsSet;
    }

    public void clear() {
        this.getColumnSet().clear();
        this.globalPartColumns = "";
    }

    public IndexProxy getIndex() {
        return this.index;
    }

    public void setIndex(IndexProxy index) {
        if (this.index != index) {
            this.index = index;
            if (index != null) {
                this.setPAC_Element(index.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

