/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public class CollectionTypeProxySet
extends ProxyDesignObjectSet {
    public CollectionTypeProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getDesign().getDataTypesDesign().getCollectionTypeSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new CollectionTypeProxy((CollectionType)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new CollectionTypeProxy(design, id, longName, this.getStorageDesign());
    }

    @Override
    public CollectionTypeProxy getByName(String name) {
        Iterator it = this.getElements().iterator();
        CollectionTypeProxy proxy = null;
        while (it.hasNext()) {
            proxy = (CollectionTypeProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName())) continue;
            return proxy;
        }
        return null;
    }

    public CollectionTypeProxy getByOwnerAndName(String owner, String name) {
        Iterator it = this.getElements().iterator();
        CollectionTypeProxy proxy = null;
        while (it.hasNext()) {
            StorageObject sto;
            proxy = (CollectionTypeProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName()) || (sto = proxy.getSchemaOrOwner()) == null || !sto.getName().equals(owner)) continue;
            return proxy;
        }
        return null;
    }
}

