/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

public class AVT
implements Comparable {
    private String beginValue = "";
    private String endValue = "";
    private String description;

    public AVT() {
        this("", "", "");
    }

    public AVT(String beginValue, String endValue, String description) {
        this.beginValue = beginValue;
        this.endValue = endValue;
        this.description = description;
    }

    public String getBeginValue() {
        return this.beginValue;
    }

    public void setBeginValue(String beginValue) {
        this.beginValue = !beginValue.equals(beginValue.trim()) ? "'" + beginValue + "'" : beginValue;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public void setEndValue(String endValue) {
        this.endValue = !endValue.equals(endValue.trim()) ? "'" + endValue + "'" : endValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AVT)) {
            return false;
        }
        AVT avtObj = (AVT)obj;
        if (!this.beginValue.equals(avtObj.getBeginValue())) {
            return false;
        }
        if (!this.endValue.equals(avtObj.getEndValue())) {
            return false;
        }
        return this.description.equalsIgnoreCase(avtObj.getDescription());
    }

    public String getValuesAsString() {
        return this.beginValue + " - " + this.endValue;
    }

    public String toString() {
        return this.beginValue + " - " + this.endValue + " | " + this.description;
    }

    public int compareTo(Object o) {
        if (o instanceof AVT) {
            AVT avt = (AVT)o;
            return this.getBeginValue().compareTo(avt.getBeginValue());
        }
        return -1;
    }

    public void copyTo(AVT avt) {
        avt.setBeginValue(this.beginValue);
        avt.setEndValue(this.endValue);
        avt.setDescription(this.description);
    }
}

