/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;

public class PartitioningComparatorOracle
extends StoragePropertiesComparator {
    public static final String PARTITION_TYPE = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.PartitionType");
    public static final String SUBPARTITION_TYPE = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev11g.SubpartitionType");
    public static final String USE_SUBPARTITION_TEMPLATE = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.UseSPTemplate");
    public static final String HASH_PART_QUANTITY = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.HashPQuantity");
    public static final String SUBPART_QUANTITY = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.SubPartQuantity");
    public static final String REFERENCE_CONSTRAINT = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev11g.ReferenceConstraint");
    public static final String SYSTEM_PARTITIONS = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev11g.SystemPartitions");
    public static final String PARTITIONING_COLUMNS = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.PartitioningColumns");
    public static final String SUBPART_COLUMNS = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.SubPartColumns");
    public static final String INTERVAL_EXPRESSION = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev11g.IntervalExpression");
    public static final String INTERVAL_TABLESPACES = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev11g.IntervalTableSpaces");
    public static final String HASH_PART_TABLESPACES = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.HashPartTableSpaces");
    public static final String HASH_SUBPART_TABLESPACES = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.HashSubPartTableSpaces");
    public static final String IOT_OVERFLOW_TABLESPACES = PartitioningComparatorOracle.getPropertyNameOracle("PartitionPropertyTabOraclev10g.IOTOverflowTS");
    private StorageDesign storageDesign;

    public PartitioningComparatorOracle(PartitionListOracle sourcePartList, PartitionListOracle targetPartList) {
        super(sourcePartList, targetPartList);
        if (sourcePartList != null) {
            this.storageDesign = sourcePartList.getStorageDesign();
        } else if (targetPartList != null) {
            this.storageDesign = targetPartList.getStorageDesign();
        }
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initProperty(PARTITION_TYPE, "partitionType");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(SUBPARTITION_TYPE, "subpartitionType");
        }
        this.initProperty(USE_SUBPARTITION_TEMPLATE, "useSubpartStorageTemplate");
        this.initProperty(HASH_PART_QUANTITY, "hashPQuantity");
        this.initProperty(SUBPART_QUANTITY, "subPartitionsQuantity");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(REFERENCE_CONSTRAINT, "refConstraint");
            this.initProperty(SYSTEM_PARTITIONS, "systemPartitions");
        }
        this.initProperty(PARTITIONING_COLUMNS, "columnList", "columnIDs");
        this.initProperty(SUBPART_COLUMNS, "subPartitionsColumnList", "subPartitionsColumnIDs");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(INTERVAL_EXPRESSION, "intervalExpression");
            this.initProperty(INTERVAL_TABLESPACES, "allIntervalTablespaces", "intervalTablespaces");
        }
        this.initProperty(HASH_PART_TABLESPACES, "allHashPTableSpaces", "hashPTableSpaces");
        this.initProperty(HASH_SUBPART_TABLESPACES, "allSubPartitionsTableSpaces", "subPartitionsTablespaces");
        this.initProperty(IOT_OVERFLOW_TABLESPACES, "allIOTOverflowHashPTS", "iotOverflowHashPTS");
    }
}

