/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class ListPartitionComparatorOracle
extends StoragePropertiesComparator {
    public static final String VALUE_LIST = ListPartitionComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.ValueList");
    public static final String POSITION = ListPartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.Position");
    public static final String COMPRESSION = ListPartitionComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.Compression");
    public static final String LOGGING = ListPartitionComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.Logging");
    public static final String STORAGE = ListPartitionComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.Segment");
    public static final String SUBPART_QUANTITY = ListPartitionComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.SubPartQuantity");
    public static final String SUBPARTITION_TABLESPACES = ListPartitionComparatorOracle.getPropertyNameOracle("ListPartitionPropertyDialogOracle.SubPartitionTableSpaces");
    private StorageDesign storageDesign;

    public ListPartitionComparatorOracle(ListPartitionOracle sourcePartition, ListPartitionOracle targetPartition) {
        super(sourcePartition, targetPartition);
        if (sourcePartition != null) {
            this.storageDesign = sourcePartition.getStorageDesign();
        } else if (targetPartition != null) {
            this.storageDesign = targetPartition.getStorageDesign();
        }
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(VALUE_LIST, "valueList");
        this.initProperty(POSITION, "position");
        this.initProperty(COMPRESSION, "dataSegmentCompression");
        this.initProperty(TABLESPACE, "tablespace");
        this.initProperty(LOGGING, "logging");
        this.initStorageProperty();
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(SUBPART_QUANTITY, "subPartitionsQuantity");
            this.initProperty(SUBPARTITION_TABLESPACES, "allSubPartitionsTableSpaces", "subPartitionsTablespaces");
        }
    }

    private void initStorageProperty() {
        PropertyHolder ph = new PropertyHolder(STORAGE);
        ModelIDObject leftObj = this.getLeftObject();
        ModelIDObject rightObj = this.getRightObject();
        SegmentOracle leftSegment = leftObj != null ? ((ListPartitionOracle)leftObj).getSegment() : null;
        SegmentOracle rightSegment = rightObj != null ? ((ListPartitionOracle)rightObj).getSegment() : null;
        ph.setLeftValue(leftSegment != null ? leftSegment.getName() : "");
        ph.setRightValue(rightSegment != null ? rightSegment.getName() : "");
        if (this.isExcludedFromComparison(STORAGE)) {
            ph.setExcluded(true);
        } else if (!(leftObj == null || rightObj == null || leftSegment == null && rightSegment == null || leftSegment != null && rightSegment != null && leftSegment.isEqualTo(rightSegment))) {
            if (leftObj.getDesign().getSettings().isIncludeStoragePropertiesInCompare()) {
                ph.setModified(true);
                ph.setSelected(true);
                if (this.classDescr != null) {
                    ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("segment");
                    ph.setPropertyDescription(propDescr);
                }
            } else {
                ph.setExcluded(true);
            }
        }
        this.propertiesList.add(ph);
    }
}

