/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public abstract class AbstractRangePartitionComparatorOracle
extends StoragePropertiesComparator {
    public static final String VALUE_LIST = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.ValueList");
    public static final String POSITION = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.Position");
    public static final String LOGGING = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.Logging");
    public static final String STORAGE = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.Segment");
    public static final String DATA_COMPRESSION = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.SegCompression");
    public static final String IOT_KEY_COMPRESSION = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.IOTCompress");
    public static final String OVERFLOW_STORAGE = AbstractRangePartitionComparatorOracle.getPropertyNameOracle("TBPartitionPropertyDialogOracle.OverflowSegment");

    public AbstractRangePartitionComparatorOracle(PartitionOracle sourcePartition, PartitionOracle targetPartition) {
        super(sourcePartition, targetPartition);
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(VALUE_LIST, "valueList");
        this.initProperty(POSITION, "position");
        this.initProperty(TABLESPACE, "tableSpace");
        this.initProperty(LOGGING, "logging");
        this.initStorageProperty();
        this.initProperty(DATA_COMPRESSION, "dataSegmentCompression");
        this.initProperty(IOT_KEY_COMPRESSION, "iotCompress");
        this.initOverflowStorageProperty();
    }

    private void initStorageProperty() {
        PropertyHolder ph = new PropertyHolder(STORAGE);
        ModelIDObject leftObj = this.getLeftObject();
        ModelIDObject rightObj = this.getRightObject();
        SegmentOracle leftSegment = leftObj != null ? ((PartitionOracle)leftObj).getSegment() : null;
        SegmentOracle rightSegment = rightObj != null ? ((PartitionOracle)rightObj).getSegment() : null;
        ph.setLeftValue(leftSegment != null ? leftSegment.getName() : "");
        ph.setRightValue(rightSegment != null ? rightSegment.getName() : "");
        if (this.isExcludedFromComparison(STORAGE)) {
            ph.setExcluded(true);
        } else if (!(leftObj == null || rightObj == null || leftSegment == null && rightSegment == null || leftSegment != null && rightSegment != null && leftSegment.isEqualTo(rightSegment))) {
            if (leftObj.getDesign().getSettings().isIncludeStoragePropertiesInCompare()) {
                ph.setModified(true);
                ph.setSelected(true);
                if (this.classDescr != null) {
                    ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("segment");
                    ph.setPropertyDescription(propDescr);
                }
            } else {
                ph.setExcluded(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private void initOverflowStorageProperty() {
        PropertyHolder ph = new PropertyHolder(OVERFLOW_STORAGE);
        ModelIDObject leftObj = this.getLeftObject();
        ModelIDObject rightObj = this.getRightObject();
        SegmentOracle leftOverflowSegment = leftObj != null ? ((PartitionOracle)leftObj).getIOTOverflowSegment() : null;
        SegmentOracle rightOverflowSegment = rightObj != null ? ((PartitionOracle)rightObj).getIOTOverflowSegment() : null;
        ph.setLeftValue(leftOverflowSegment != null ? leftOverflowSegment.getName() : "");
        ph.setRightValue(rightOverflowSegment != null ? rightOverflowSegment.getName() : "");
        if (this.isExcludedFromComparison(OVERFLOW_STORAGE)) {
            ph.setExcluded(true);
        } else if (!(leftObj == null || rightObj == null || leftOverflowSegment == null && rightOverflowSegment == null || leftOverflowSegment != null && rightOverflowSegment != null && leftOverflowSegment.isEqualTo(rightOverflowSegment))) {
            if (leftObj.getDesign().getSettings().isIncludeStoragePropertiesInCompare()) {
                ph.setModified(true);
                ph.setSelected(true);
                if (this.classDescr != null) {
                    ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("iotOverflowSegment");
                    ph.setPropertyDescription(propDescr);
                }
            } else {
                ph.setExcluded(true);
            }
        }
        this.propertiesList.add(ph);
    }
}

