/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBSnapshotOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;

public class CSSBSnapshotOraclev10g
extends AbstractCSSBOracle {
    protected Map fkList;
    protected SSBSnapshotOraclev10g ssbSnapshotOracle;

    public CSSBSnapshotOraclev10g(Map fkList) {
        this.fkList = fkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        PropertiesComparator propsComp;
        CompareObjectSelection topNode;
        CompareObjectSelection tablesNode;
        CompareObjectSelection sSnapSel = (CompareObjectSelection)object;
        CompareObjectSelection tSnapSel = sSnapSel.getCorrespondentNode();
        SnapshotOraclev10g tSnapshot = (SnapshotOraclev10g)tSnapSel.getObject();
        SnapshotOraclev10g sSnapshot = (SnapshotOraclev10g)sSnapSel.getObject();
        TableProxyOracle tTableProxy = null;
        TableProxyOracle sTableProxy = null;
        StorageDesignOracle tStorageDesign = null;
        if (tSnapshot != null) {
            tStorageDesign = (StorageDesignOracle)tSnapshot.getStorageDesign();
        }
        if (tSnapshot != null && (tTableProxy = tSnapshot.getOnPrebuildTable()) == null) {
            tTableProxy = tSnapshot.getImplementedTable();
        }
        if (sSnapshot != null && (sTableProxy = sSnapshot.getOnPrebuildTable()) == null) {
            sTableProxy = sSnapshot.getImplementedTable();
        }
        TableSelection tTableSel = null;
        CompareObjectSelection sTableSel = null;
        Table tTable = tTableProxy != null ? (Table)tTableProxy.getObject() : null;
        Table stable = null;
        if (sTableProxy != null) {
            stable = (Table)sTableProxy.getObject();
        }
        if (tTable != null && (tTableSel = (TableSelection)(tablesNode = (CompareObjectSelection)(topNode = tSnapSel.getTableNode()).getChild(1)).getChild(tTable)) != null) {
            sTableSel = (TableSelection)tTableSel.getCorrespondentNode();
        }
        boolean snapshotDropped = false;
        if (sTableSel != null && (propsComp = sTableSel.getPropertiesComparator()) instanceof TableComparator) {
            snapshotDropped = ((TableComparator)propsComp).isSnapshotDropped();
        }
        boolean recreateMV = snapshotDropped;
        if (sSnapSel.isSelected() && (sSnapSel.canBeCreate() || sSnapSel.isDDLModified())) {
            recreateMV = true;
        } else if (sTableSel != null && sTableSel.isSelected()) {
            List tableChildNodes;
            PropertiesComparator tableComp = sTableSel.getPropertiesComparator();
            if (tableComp != null) {
                for (EngPropertyHolder ph : tableComp.getPropertiesList()) {
                    if (!ph.isSelected() || !ph.getName().equals(PropertyNames.NAME) && !ph.getName().equals(PropertyNames.STRUCTURED_TYPE) && !ph.getName().equals(PropertyNames.COLUMNS_ORDER) && !ph.getName().equals(PropertyNames.MATERIALIZED_QUERY) && !ph.getName().equals(PropertyNames.ON_PREBUILT_TABLE) && !ph.getName().equals(PropertyNames.MATERIALIZED_QUERY_TABLE)) continue;
                    recreateMV = true;
                    break;
                }
            }
            if (!recreateMV && (tableChildNodes = sTableSel.getChilds()).size() > 0) {
                CompareObjectSelection columnsSel = (CompareObjectSelection)tableChildNodes.get(0);
                block4: for (CompareObjectSelection columnSel : columnsSel.getChilds()) {
                    PropertiesComparator propsComp2;
                    if (!columnSel.isSelected() || (propsComp2 = columnSel.getPropertiesComparator()) == null) continue;
                    for (EngPropertyHolder ph : propsComp2.getPropertiesList()) {
                        if (!ph.getName().equals(PropertyNames.NAME)) continue;
                        if (!ph.isSelected()) continue block4;
                        recreateMV = true;
                        continue block4;
                    }
                }
            }
        }
        if (recreateMV) {
            List list = null;
            HashMap<Index, Index> map = new HashMap<Index, Index>();
            Table table = tTable;
            if (table == null) {
                table = stable;
            }
            if (!sSnapSel.canBeCreate() && tSnapshot != null) {
                String advancedComment;
                StringBuffer dropbuffer = new StringBuffer();
                if (!snapshotDropped) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "MATERIALIZED");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "VIEW");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, tStorageDesign.getFormatedLongNameDDL(tSnapshot));
                    advancedComment = dropbuffer.toString();
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "PRESERVE TABLE");
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CSSBSnapshotOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
                    CSSBSnapshotOraclev10g.appendLineFinisher(dropbuffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    this.getStatus().incrementDropSnapshot();
                }
                if (sSnapshot.getOnPrebuildTable() == null) {
                    if (sTableSel != null && tTableSel != null) {
                        list = table.getPK_UKList();
                        ModelIdObjectSelection mtsel = tTableSel.getChildByType("PK_UK_Indexes");
                        for (ModelIdObjectSelection ms : mtsel.getChilds()) {
                            Index tind;
                            if (ms == null || !(ms.getObject() instanceof Index) || (tind = (Index)ms.getObject()) == null) continue;
                            ModelIdObjectSelection ssel = ms.getCorrespondentObjectSelection();
                            if (ssel != null && ssel.getObject() instanceof Index) {
                                Index sind = (Index)ssel.getObject();
                                if (sind == null || sind.getElementsCollection().size() != tind.getElementsCollection().size() || sind.getName().startsWith("SYS_C_SNAP$")) {
                                    list.remove(tind);
                                    continue;
                                }
                                map.put(tind, sind);
                                continue;
                            }
                            list.remove(tind);
                        }
                    }
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "TABLE");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, tStorageDesign.getFormatedLongNameDDL(tSnapshot));
                    advancedComment = dropbuffer.toString();
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "CASCADE CONSTRAINTS");
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CSSBSnapshotOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
                    CSSBSnapshotOraclev10g.appendLineFinisher(dropbuffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    this.getStatus().incrementDropTable();
                }
            }
            boolean oldMarkedGen = sSnapshot.isMarkedGenerate();
            try {
                sSnapshot.setMarkedGenerate(true);
                SSBSnapshotOraclev10g ssbSnapshotOracle = this.getSSBSnapshotOracle();
                ssbSnapshotOracle.doAppend(oldbuffer, sSnapshot, prettyPrint);
                if (list == null || list.size() <= 0) return;
                this.appendRestoreFKs(list, map, oldbuffer, tStorageDesign, table, false, this.getStatus());
                return;
            }
            finally {
                sSnapshot.setMarkedGenerate(oldMarkedGen);
            }
        } else {
            List tableChildNodes;
            PropertiesComparator propsComp3;
            EngPropertyHolder ph;
            if (tSnapshot == null) return;
            if (sTableSel != null && (ph = (propsComp3 = sTableSel.getPropertiesComparator()).getPropertyHolderByName(PropertyNames.COMMENT_IN_RDBMS)).isSelected()) {
                TableProxyOracle tp = (TableProxyOracle)sTableSel.getProxy();
                this.appendCommentOn(oldbuffer, tp, prettyPrint, false, true);
            }
            if ((tableChildNodes = sTableSel.getChilds()).size() <= 0) return;
            CompareObjectSelection columnsSel = (CompareObjectSelection)tableChildNodes.get(0);
            for (CompareObjectSelection columnSel : columnsSel.getChilds()) {
                PropertiesComparator propsComp4;
                if (!columnSel.isSelected() || (propsComp4 = columnSel.getPropertiesComparator()) == null) continue;
                for (EngPropertyHolder ph2 : propsComp4.getPropertiesList()) {
                    if (!ph2.getName().equals(PropertyNames.COMMENT_IN_RDBMS) || !ph2.isSelected()) continue;
                    ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)columnSel.getProxy();
                    this.appendCommentOnColumn(oldbuffer, tStorageDesign.getFormatedLongNameDDL(tSnapshot), columnSel, columnProxy, prettyPrint, tStorageDesign);
                }
            }
        }
    }

    private void appendCommentOnColumn(StringBuffer oldbuffer, String formattedTableName, CompareObjectSelection columnObj, ColumnProxyOracle columnProxy, boolean prettyPrint, StorageDesignOracle storageDesign) {
        String commentOn = columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnObj.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS);
        if (commentOn.trim().length() > 0 || columnObj.isModified() && columnObj.getStatus() != 2) {
            if (!commentOn.isEmpty()) {
                commentOn = commentOn.trim();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "COMMENT ON");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "COLUMN");
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, formattedTableName + "." + CSSBSnapshotOraclev10g.getFormattedSelectedName(columnObj, storageDesign));
            String advancedComment = buffer.toString();
            CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "IS");
            CSSBSnapshotOraclev10g.appendString(buffer, '\'');
            CSSBSnapshotOraclev10g.appendString(buffer, this.replaceSingleQuote(commentOn));
            CSSBSnapshotOraclev10g.appendString(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBSnapshotOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SnapshotOraclev10g;
    }

    private void appendDropFKs(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, StringBuffer oldbuffer, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        Iterator it = storageDesign.getFKProxySet().iterator();
        while (it.hasNext()) {
            FKProxyOracle fk = (FKProxyOracle)it.next();
            FKIndexAssociation fkind = fk.getIndex().getFKAssociation();
            if (this.fkList.get(fkind.getObjectID()) != null || this.fkList.get(fk.getObjectID()) != null || fk.getFKTable() != table && fk.getTable() != table) continue;
            this.appendDropObject((TableProxyOracle)fk.getTableProxy(), storageDesign.getFormatedName(fk), storageDesign, oldbuffer, prettyPrint);
            this.fkList.put(fkind.getObjectID(), tableProxy);
        }
    }

    private void appendDropObject(TableProxyOracle tableProxy, String name, StorageDesignOracle storageDesign, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "DROP");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, name);
        String advancedComment = buffer.toString();
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CASCADE");
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBSnapshotOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        this.getStatus().incrementAlterTable();
    }

    protected SSBSnapshotOraclev10g getSSBSnapshotOracle() {
        if (this.ssbSnapshotOracle == null) {
            this.ssbSnapshotOracle = new SSBSnapshotOraclev10g();
            this.ssbSnapshotOracle.setSSBTableOraclev10g(new SSBTableOraclev10g());
        }
        return this.ssbSnapshotOracle;
    }
}

