/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;

public class CSSBIndexOraclev10g
extends AbstractCSSBOracle {
    private DesignObject sType;
    protected StorageDesignOraclev10g storageDesign;
    private boolean isRenamed = false;
    private StringBuffer columnList = new StringBuffer();
    private String restoredExpression = null;
    private String tableName = "";

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index) {
            return true;
        }
        return object instanceof IndexProxyOracle;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        Index index = null;
        IndexProxyOraclev10g indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            Design design = index.getDesign();
            RDBMSSite site = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site);
            indexProxy = (IndexProxyOraclev10g)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev10g) {
            indexProxy = (IndexProxyOraclev10g)object;
            index = (Index)indexProxy.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxy != null && (index.shouldBeMerge() || this.isRenamed())) {
            if (indexProxy.isCommentChanged()) {
                this.appendComment(oldbuffer, indexProxy);
            } else {
                this.appendComment(oldbuffer, index);
            }
            this.storageDesign = (StorageDesignOraclev10g)indexProxy.getStorageDesign();
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "CREATE");
            if (indexProxy.isUnique()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
            } else if (indexProxy.getBitmapIndex()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "BITMAP");
            }
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEX");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
            String advancedComment = buffer.toString();
            this.appendTable(buffer, indexProxy);
            if (this.restoredExpression != null || this.isNotEmpty(this.getRestoredColumns().toString())) {
                this.appendElementListRestored(buffer, index, indexProxy, true);
            } else {
                this.appendElementList(buffer, index, indexProxy, true);
            }
            this.appendGlobalOrLocal(buffer, indexProxy, prettyPrint);
            if (!index.isSpatialIndex() && indexProxy.getIndexType().equals("")) {
                this.appendIndexAttributes(buffer, indexProxy, prettyPrint);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementCreateIndex();
        }
        this.isRenamed = false;
        this.tableName = "";
    }

    private void appendTable(StringBuffer buffer, IndexProxyOraclev10g indexProxy) {
        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "ON");
        if (this.isNotEmpty(this.getFormattedTableName())) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.getFormattedTableName());
        } else {
            TableProxy tableProxy = indexProxy.getTableProxy();
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        }
    }

    private void appendElementList(StringBuffer buffer, Index index, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if (index.hasIndexExpression()) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBIndexOraclev10g.appendString(buffer, index.getIndexExpression());
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            ColumnProxy column = null;
            ColumnProxy[] columns = indexProxy.getColumnProxies();
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (columns.length < 1) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "-- No Columns");
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < columns.length; ++i) {
                if (i != 0) {
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
                }
                column = columns[i];
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendString(buffer, ' ');
                String columnName = this.storageDesign.getFormatedName(column);
                if (index.isSpatialIndex()) {
                    Datatype colType = column.getDataType();
                    if (this.sType == null) {
                        this.sType = column.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (colType instanceof StructuredType) {
                        StructuredType st = (StructuredType)colType;
                        for (TypeElement te : st.getAllElements()) {
                            if (te.getType() != this.sType) continue;
                            columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                            break;
                        }
                    }
                }
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, columnName);
                if (index.isSpatialIndex() || !indexProxy.getIndexType().equals("")) continue;
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
        if (indexProxy != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(buffer, index, indexProxy, prettyPrint);
            } else {
                this.appendDomainIndexProps(buffer, index, indexProxy, prettyPrint);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer buffer, Index index, IndexProxyOracle indexProxy, boolean prettyPrint) {
        String type;
        if (!index.isSpatialIndex() && !(type = indexProxy.getIndexType()).equals("")) {
            if (!type.equalsIgnoreCase("XMLINDEX") && !type.equalsIgnoreCase("XDB.XMLINDEX")) {
                type = this.storageDesign.getFormatedName(type);
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEXTYPE");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "IS");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, type);
            String params = indexProxy.getIndexDomainParameters();
            if (!params.equals("")) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                CSSBIndexOraclev10g.appendString(buffer, '(');
                CSSBIndexOraclev10g.appendString(buffer, '\'');
                CSSBIndexOraclev10g.appendString(buffer, params);
                CSSBIndexOraclev10g.appendString(buffer, '\'');
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer buffer, Index index, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if (index.isSpatialIndex()) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEXTYPE");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "IS");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2 || indexProxy.getNonLeaf().equalsIgnoreCase("YES") || indexProxy.getTableSpace() != null || indexProxy.getBatchSize() != 1000 || indexProxy.getWorkTablespace() != null) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                CSSBIndexOraclev10g.appendString(buffer, '(');
                CSSBIndexOraclev10g.appendString(buffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    CSSBIndexOraclev10g.appendString(buffer, "geodetic");
                    CSSBIndexOraclev10g.appendString(buffer, '=');
                    this.appendString(buffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "layer_gtype");
                    CSSBIndexOraclev10g.appendString(buffer, '=');
                    CSSBIndexOraclev10g.appendString(buffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "sdo_indx_dims");
                    CSSBIndexOraclev10g.appendString(buffer, '=');
                    CSSBIndexOraclev10g.appendString(buffer, index.getDimensionsNumber());
                }
                if (indexProxy.getBatchSize() != 1000) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "sdo_dml_batch_size=");
                    CSSBIndexOraclev10g.appendString(buffer, indexProxy.getBatchSize());
                }
                if (indexProxy.getTableSpace() != null) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "tablespace=");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
                }
                if (indexProxy.getWorkTablespace() != null) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "work_tablespace=");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getWorkTablespace()));
                }
                if (indexProxy.getNonLeaf().equalsIgnoreCase("YES")) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "sdo_non_leaf_tbl=TRUE");
                }
                CSSBIndexOraclev10g.appendString(buffer, '\'');
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            this.appendSpatialIndexPartitions(buffer, indexProxy, prettyPrint);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if ("LOCAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)indexProxy.getTableProxy();
            PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
            if (partitionList != null) {
                this.appendSpatialPartitions(buffer, indexProxy, partitionList, prettyPrint);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer buffer, IndexProxyOraclev10g indexProxy, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        PartitionSetOraclev10g partitionSet = (PartitionSetOraclev10g)((StorageDesignOraclev10g)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            String lipPName;
            PartitionOraclev10g partition = (PartitionOraclev10g)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().getObjectID().equalsIgnoreCase(partitionList.getObjectID())) continue;
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
            CSSBIndexOraclev10g.appendString(buffer, '(');
            CSSBIndexOraclev10g.appendString(buffer, '\'');
            if (lip != null) {
                SegmentOraclev10g indexSegment;
                if (lip.getTableSpace() != null) {
                    CSSBIndexOraclev10g.appendString(buffer, "tablespace=");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lip.getTableSpace()));
                }
                if ((indexSegment = (SegmentOraclev10g)lip.getSegment()) != null) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "sdo_rdr_pctfree=");
                    CSSBIndexOraclev10g.appendString(buffer, String.valueOf(indexSegment.getPCTFree()).trim());
                    if (indexSegment.getSCInitialExtent() > 0L) {
                        CSSBIndexOraclev10g.appendSpace(buffer);
                        CSSBIndexOraclev10g.appendString(buffer, "initial=");
                        CSSBIndexOraclev10g.appendString(buffer, String.valueOf(indexSegment.getSCInitialExtent()).trim());
                    }
                    if (indexSegment.getSCNextExtent() > 0L) {
                        CSSBIndexOraclev10g.appendSpace(buffer);
                        CSSBIndexOraclev10g.appendString(buffer, "next=");
                        CSSBIndexOraclev10g.appendString(buffer, String.valueOf(indexSegment.getSCNextExtent()).trim());
                    }
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "pctincrease=");
                    CSSBIndexOraclev10g.appendString(buffer, indexSegment.getSCPctIncrease());
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "minextents=");
                    CSSBIndexOraclev10g.appendString(buffer, indexSegment.getSCMinExtents());
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "maxextents=");
                    CSSBIndexOraclev10g.appendString(buffer, indexSegment.getSCMaxExtents());
                }
                if (lip.getWorkTablespace() != null) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "work_tablespace=");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lip.getWorkTablespace()));
                }
                if (lip.getLayerType() != null && !lip.getLayerType().equals("")) {
                    CSSBIndexOraclev10g.appendSpace(buffer);
                    CSSBIndexOraclev10g.appendString(buffer, "layer_gtype=");
                    CSSBIndexOraclev10g.appendString(buffer, lip.getLayerType());
                }
            }
            if (indexProxy.getNonLeaf().equalsIgnoreCase("YES")) {
                CSSBIndexOraclev10g.appendSpace(buffer);
                CSSBIndexOraclev10g.appendString(buffer, "sdo_non_leaf_tbl=TRUE");
            }
            CSSBIndexOraclev10g.appendString(buffer, '\'');
            CSSBIndexOraclev10g.appendString(buffer, ')');
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendString(buffer, ')');
        }
    }

    private void appendGlobalOrLocal(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        String partitionType = indexProxy.getIndexPartitioned();
        if ("LOCAL".equalsIgnoreCase(partitionType)) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, indexProxy, (TableProxyOraclev10g)indexProxy.getTableProxy(), prettyPrint);
        } else {
            IndexGlobalPartitionsListOraclev10g globalPartitionList = (IndexGlobalPartitionsListOraclev10g)indexProxy.getIndexGlobalPartitionsList();
            if (globalPartitionList != null) {
                String rangeOrHash = "";
                if ("GLOBAL BY RANGE".equalsIgnoreCase(partitionType)) {
                    rangeOrHash = "RANGE";
                } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(partitionType) || "GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(partitionType)) {
                    rangeOrHash = "HASH";
                } else {
                    return;
                }
                Index index = (Index)indexProxy.getObject();
                if (!index.isSpatialIndex() && indexProxy.getIndexType().equals("")) {
                    CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "BY");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, rangeOrHash);
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(globalPartitionList.getGlobalPartColumns()));
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
                    if ("GLOBAL BY RANGE".equalsIgnoreCase(partitionType)) {
                        this.appendGlobalRangePartitions(buffer, indexProxy, prettyPrint);
                    } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(partitionType)) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, globalPartitionList.getHashPQuantity());
                        if (!"".equals(globalPartitionList.getHashPTableSpaces())) {
                            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(globalPartitionList.getHashPTableSpaces()));
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
                        }
                        if (!"".equals(globalPartitionList.getIOTOverflowHashPTS())) {
                            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(globalPartitionList.getIOTOverflowHashPTS()));
                            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
                        }
                    } else if ("GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(partitionType)) {
                        this.appendGlobalHashPartitions(buffer, indexProxy, prettyPrint);
                    }
                }
            }
        }
    }

    protected void appendGlobalRangePartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        StorageObjectCollection globalPartitions = indexProxy.getGlobalPartitions();
        Object[] partitionsArray = globalPartitions.toArray();
        for (int i = 0; i < partitionsArray.length; ++i) {
            if (partitionsArray[i] instanceof IndexGlobalPartitionOraclev10g) continue;
            return;
        }
        Arrays.sort(partitionsArray, new CSSBCreateTableOraclev10g.GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>(partitionsArray.length);
        for (int i = 0; i < partitionsArray.length; ++i) {
            sortedList.add(partitionsArray[i]);
        }
        Iterator it = sortedList.iterator();
        boolean first = true;
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev10g globalPartition = (IndexGlobalPartitionOraclev10g)it.next();
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, globalPartition.getValueList());
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            if (globalPartition.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev10g)globalPartition.getSegment(), prettyPrint, 2);
            if (!this.storageDesign.isOpen() || !this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendGlobalHashPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, boolean prettyPrint) {
        Iterator it = indexProxy.getGlobalPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Object partition = it.next();
            if (!(partition instanceof IndexHashPartitionOraclev10g)) continue;
            IndexHashPartitionOraclev10g hashPartition = (IndexHashPartitionOraclev10g)partition;
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                if (hashPartition.getTableSpace() != null) {
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
                }
                if (hashPartition.getOverflowTableSpace() != null) {
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getOverflowTableSpace()));
                }
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPLobItems(StringBuffer buffer, IndexHashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        IndexHashPartitionLobItemSetOraclev10g hashPLobItemSet = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getIndexHashPartitionLobItemSet();
        for (IndexHashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getIndexHashPartition() == null || !hashPLobItem.getIndexHashPartition().getObjectID().equalsIgnoreCase(hashPartition.getObjectID())) continue;
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, ColumnProxy columnProxy, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOB");
        CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
        if (columnProxy != null) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        } else {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("--  ERROR: Lob ");
            buffer.append(lobObject.getName());
            buffer.append(" has no Column specified");
            this.getStatus().incrementErrors();
        }
        CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendSegment(StringBuffer buffer, SegmentOraclev10g segment, boolean prettyPrint, int indent) {
        if (segment != null && this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getDesign().getSettings().isIncludePctFreeInDDL()) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "2");
                }
                if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                    if (segment.getMaxTrans() > 2) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NEXT");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        boolean inclLogging = false;
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        boolean temporaryTable = tableProxy.getTemporary().equalsIgnoreCase("YES");
        if (!temporaryTable) {
            if (indexProxy.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev10g)indexProxy.getSegment(), prettyPrint, 1);
            if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL() && inclLogging) {
                if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
        }
        if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        if (indexProxy.getCompress() > 0) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, indexProxy.getCompress());
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!indexProxy.getBitmapIndex()) {
            if ("NO".equalsIgnoreCase(indexProxy.getSortedRows())) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOSORT");
            } else if ("REVERSE".equalsIgnoreCase(indexProxy.getSortedRows())) {
                buffer.append(NEWLINE).append("    ");
                if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                }
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "REVERSE");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
            }
        }
        if (indexProxy.getInvisible().equalsIgnoreCase("YES") && this.storageDesign instanceof StorageDesignOraclev11g) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "INVISIBLE");
        }
        if (!temporaryTable) {
            if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
                if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                    CSSBIndexOraclev10g.appendStringWithSpace(buffer, indexProxy.getDegree());
                }
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                buffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
            }
        }
    }

    protected void appendPartitionList(StringBuffer buffer, IndexProxyOracle indexProxy, TableProxyOracle tableProxy, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
        if (partitionList != null) {
            boolean composite;
            String subPartitionTableSpaceIDs;
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            if ((partitionType.equalsIgnoreCase("HASH BY QUANTITY") || subpartitionType.equalsIgnoreCase("HASH")) && !"".equals(subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces())) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            boolean bl = composite = !subpartitionType.equals("");
            if ("RANGE".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, indexProxy, partitionList, composite, prettyPrint);
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, indexProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, indexProxy, prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, IndexProxyOracle indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
                String logging = lip.getLogging();
                SegmentOraclev10g indexSegment = (SegmentOraclev10g)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint, 2);
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                    if (ts != null) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(logging)) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
                if (indexProxy.getCompress() > 0) {
                    if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else if ("NO".equalsIgnoreCase(lip.getKeyCompress())) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                    }
                }
            }
            if (partitionList.getSubpartitionType().equals("")) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, IndexProxyOracle indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            HashPartitionOraclev10g partition = (HashPartitionOraclev10g)it.next();
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
            if (ts != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionListOraclev10g partitionList, boolean composite, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            PartitionOraclev10g partition = (PartitionOraclev10g)it.next();
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                TableSpaceOracle ts = lip.getTableSpace();
                String logging = lip.getLogging();
                SegmentOraclev10g indexSegment = (SegmentOraclev10g)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint, 2);
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                    if (ts != null) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(logging)) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
                if (indexProxy.getCompress() > 0) {
                    if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else if ("NO".equalsIgnoreCase(lip.getKeyCompress())) {
                        CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                    }
                }
            }
            if (!composite) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, StorageObject partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, indexProxy);
    }

    protected void appendIndexSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionListOraclev10g partitionList, AbstractStorageObjectOracle partition, String tablespaceIDs, boolean prettyPrint) {
        String subPartType = partitionList.getSubpartitionType();
        if (subPartType.equalsIgnoreCase("HASH")) {
            PartitionOraclev10g rangePartition;
            if (partition instanceof PartitionOraclev10g && !this.appendHashSubPartitions(buffer, indexProxy, (rangePartition = (PartitionOraclev10g)partition).getPartitions(), prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else if (subPartType.equalsIgnoreCase("LIST") && partition instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(buffer, indexProxy, ((PartitionOraclev10g)partition).getListPartitions(), prettyPrint);
        }
    }

    protected void appendListSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean first = true;
        for (ListStorageTemplatePartitionOraclev10g listPartition : subpartitions) {
            String lipPName;
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String lpName = listPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(listPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, listPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !lpName.equals(lipPName)) {
                lpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!lpName.toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOracle ts = lip.getTableSpace();
            if (ts != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean result = false;
        Iterator it = subpartitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
            if (first) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String pName = hashPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(hashPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, hashPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
            if (ts != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                CSSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    private void appendElementListRestored(StringBuffer buffer, Index index, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if (this.restoredExpression != null && !this.restoredExpression.trim().equals("")) {
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBIndexOraclev10g.appendString(buffer, this.restoredExpression);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendString(buffer, ' ');
            this.appendString(buffer, this.getRestoredColumns());
            CSSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            if (indexProxy != null) {
                if (index.isSpatialIndex()) {
                    this.appendSpatialIndex(buffer, index, indexProxy, prettyPrint);
                } else {
                    this.appendDomainIndexProps(buffer, index, indexProxy, prettyPrint);
                }
            }
        }
        this.getRestoredColumns().setLength(0);
        this.restoredExpression = null;
    }

    public void setRenamed(boolean renamed) {
        this.isRenamed = renamed;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRestoredExpression(String restoredExpression) {
        this.restoredExpression = restoredExpression;
    }

    public void setRestoredColumns(StringBuffer columnList) {
        this.columnList = columnList;
    }

    public StringBuffer getRestoredColumns() {
        return this.columnList;
    }

    private String getFormattedTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setStorageDesign(StorageDesignOraclev10g storageDesign) {
        this.storageDesign = storageDesign;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (one instanceof PartitionOraclev10g && two instanceof PartitionOraclev10g) {
                if (((PartitionOraclev10g)one).getPosition() > ((PartitionOraclev10g)two).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev10g)one).getPosition() < ((PartitionOraclev10g)two).getPosition()) {
                    return -1;
                }
            } else if (one instanceof ListPartitionOraclev10g && two instanceof ListPartitionOraclev10g) {
                if (((ListPartitionOraclev10g)one).getPosition() > ((ListPartitionOraclev10g)two).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev10g)one).getPosition() < ((ListPartitionOraclev10g)two).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

