/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateRenameTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.FKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;

public class CSSBRenameTable
extends AbstractCSSBOracle {
    private StorageDesignOracle storageDesign;
    private Map fkList = new TreeMap();
    private CSSBCreateRenameTable createTable = new CSSBCreateRenameTable();

    public CSSBRenameTable(Map fkList) {
        this.fkList = fkList;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        String unloadDir;
        String backupOption;
        RDBMSSite site;
        Design design;
        if (object == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Table table = null;
        TableSelection tableObj = (TableSelection)object;
        TableSelection targetObject = (TableSelection)((CompareObjectSelection)object).getCorrespondentNode();
        TableProxyOracle tableProxy = null;
        TableProxyOracle sourceProxy = null;
        ModelObject objTable = null;
        if (((CompareObjectSelection)object).getObject() instanceof Table) {
            table = (Table)((CompareObjectSelection)object).getCorrespondentNode().getObject();
            design = table.getDesign();
            site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            objTable = (Table)((CompareObjectSelection)object).getObject();
        } else if (((CompareObjectSelection)object).getObject() instanceof TableProxyOracle) {
            tableProxy = (TableProxyOracle)((CompareObjectSelection)object).getCorrespondentNode().getObject();
            table = (Table)tableProxy.getObject();
            design = table.getDesign();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(table.getSelectedRDBMSSite(), table);
            objTable = (Table)((TableProxyOracle)((CompareObjectSelection)object).getObject()).getObject();
        }
        if (objTable != null) {
            design = objTable.getDesign();
            site = objTable.getSelectedRDBMSSite();
            StorageDesign sourceSD = design.getStorageDesign(site, (FKContainer)objTable);
            sourceProxy = (TableProxyOracle)sourceSD.getTableProxySet().getProxy(((ModelIDObject)objTable).getObjectID());
        }
        if (((CompareObjectSelection)object).canBeRenameOnly()) {
            this.appendRenameTableOnly(table, (Table)objTable, sourceProxy, tableProxy, oldbuffer, prettyPrint);
            this.getSuccessor().appendTo(oldbuffer, object, prettyPrint);
            return;
        }
        if (targetObject.getScriptExecuteOption().equals(TableSelection.STOP_BEFORE_BACKUP) && (TableSelection.BACKUP_RENAME.equals(backupOption = targetObject.getBackupOption()) || TableSelection.BACKUP_UNLOAD.equals(backupOption) || TableSelection.BACKUP_UNLOAD_PARTITION.equals(backupOption))) {
            this.appendScriptExecution(oldbuffer, this.storageDesign.getFormatedName(targetObject.getName()));
        }
        CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
        this.appendDropFK(tableProxy, (CompareObjectSelection)object, oldbuffer, prettyPrint);
        this.appendDropPK(tableProxy, oldbuffer, prettyPrint);
        this.appendDropUK(tableProxy, oldbuffer, prettyPrint);
        this.appendDropConstraint(tableProxy, oldbuffer, prettyPrint);
        this.appendDropColumnConstraints(tableProxy, oldbuffer, prettyPrint);
        CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
        this.appendDropIndex(tableProxy, oldbuffer, prettyPrint);
        this.appendDropTriggers(tableProxy, oldbuffer, prettyPrint);
        this.appendDropBitmapJoinIndexes(tableProxy, oldbuffer, prettyPrint);
        if (TableSelection.BACKUP_RENAME.equals(targetObject.getBackupOption())) {
            this.appendRenameTable(tableProxy, oldbuffer, prettyPrint);
            if (targetObject.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(oldbuffer, this.storageDesign.getFormatedName(targetObject.getName()));
            }
        } else if (TableSelection.BACKUP_UNLOAD.equals(targetObject.getBackupOption())) {
            unloadDir = targetObject.getUnloadDirectory();
            if ("".equals(unloadDir)) {
                unloadDir = table.getDesign().getUnloadDirectory();
            }
            this.addUnloadExecution(oldbuffer, tableObj, tableProxy, unloadDir);
            if (targetObject.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(oldbuffer, this.storageDesign.getFormatedName(targetObject.getName()));
            }
            this.appendDropTable(oldbuffer, tableProxy, prettyPrint);
        } else if (TableSelection.BACKUP_UNLOAD_PARTITION.equals(targetObject.getBackupOption())) {
            unloadDir = targetObject.getUnloadDirectory();
            if ("".equals(unloadDir)) {
                unloadDir = table.getDesign().getUnloadDirectory();
            }
            this.addUnloadPerPartitionExecution(oldbuffer, tableObj, tableProxy, unloadDir);
            if (targetObject.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(oldbuffer, this.storageDesign.getFormatedName(targetObject.getName()));
            }
            this.appendDropTable(oldbuffer, tableProxy, prettyPrint);
        } else if (TableSelection.NONE.equals(targetObject.getBackupOption())) {
            this.appendDropTable(oldbuffer, tableProxy, prettyPrint);
        }
        this.appendCreateTable(object, oldbuffer, prettyPrint);
    }

    private void appendDropTable(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBRenameTable.appendStringWithSpace(buffer, "DROP");
        CSSBRenameTable.appendStringWithSpace(buffer, "TABLE");
        CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.getStatus().incrementDropTable();
    }

    private void appendCreateTable(Object object, StringBuffer oldbuffer, boolean prettyPrint) {
        this.createTable.setRenamed(true);
        this.createTable.doAppend(oldbuffer, object, prettyPrint);
    }

    private void appendRenameTable(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        CSSBRenameTable.appendStringWithSpace(buffer, "ALTER");
        CSSBRenameTable.appendStringWithSpace(buffer, "TABLE");
        CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBRenameTable.appendStringWithSpace(buffer, "RENAME");
        CSSBRenameTable.appendStringWithSpace(buffer, "TO");
        Object backupTableName = "bcp_" + tableProxy.getName();
        if (((String)backupTableName).length() > 30) {
            backupTableName = ((String)backupTableName).substring(0, 30);
        }
        CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((String)backupTableName));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
        CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        this.getStatus().incrementAlterTable();
    }

    private void appendRenameTableOnly(Table table, Table objTable, TableProxy sourceProxy, TableProxy targetProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
        CSSBRenameTable.appendStringWithSpace(buffer, "ALTER");
        CSSBRenameTable.appendStringWithSpace(buffer, "TABLE");
        if (targetProxy != null) {
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(targetProxy));
        } else {
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
        }
        CSSBRenameTable.appendStringWithSpace(buffer, "RENAME");
        CSSBRenameTable.appendStringWithSpace(buffer, "TO");
        if (sourceProxy != null) {
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sourceProxy));
        } else {
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(objTable));
        }
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
        CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
        this.getStatus().incrementAlterTable();
    }

    private void appendDropConstraint(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        for (TableLevelConstraint constraint : table.getCheckConstraints()) {
            this.appendDropObject(tableProxy, this.storageDesign.getFormatedName(constraint), oldbuffer, prettyPrint);
        }
    }

    private void appendDropIndex(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        for (IndexProxyOraclev9i index : tableProxy.getIndexes()) {
            CSSBRenameTable.appendStringWithSpace(buffer, "DROP");
            CSSBRenameTable.appendStringWithSpace(buffer, "INDEX");
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendDropUK(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        for (UniqueOraclev9i index : tableProxy.getUniqueKeys()) {
            this.appendDropObject(tableProxy, this.storageDesign.getFormatedName(index), oldbuffer, prettyPrint);
        }
    }

    private void appendDropPK(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        Iterator it = tableProxy.getPrimaryKeys().iterator();
        if (it.hasNext()) {
            PKProxyOraclev9i pk = (PKProxyOraclev9i)it.next();
            this.appendDropObject(tableProxy, this.storageDesign.getFormatedName(pk), oldbuffer, prettyPrint);
        }
    }

    private void appendDropObject(TableProxyOracle tableProxy, String name, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        CSSBRenameTable.appendStringWithSpace(buffer, "ALTER");
        CSSBRenameTable.appendStringWithSpace(buffer, "TABLE");
        CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBRenameTable.appendStringWithSpace(buffer, "DROP");
        CSSBRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBRenameTable.appendStringWithSpace(buffer, name);
        String advancedComment = buffer.toString();
        CSSBRenameTable.appendStringWithSpace(buffer, "CASCADE");
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        this.getStatus().incrementAlterTable();
    }

    private void appendDropFK(TableProxyOracle tableProxy, CompareObjectSelection object, StringBuffer oldbuffer, boolean prettyPrint) {
        Iterator it = this.storageDesign.getFKProxySet().iterator();
        while (it.hasNext()) {
            FKProxyOraclev9i fk = (FKProxyOraclev9i)it.next();
            FKIndexAssociation fkind = fk.getIndex().getFKAssociation();
            if (this.fkList.get(fkind.getObjectID()) != null || this.fkList.get(fk.getObjectID()) != null || fk.getFKTable() != tableProxy.getObject() && fk.getTable() != tableProxy.getObject()) continue;
            this.appendDropObject((TableProxyOracle)fk.getTableProxy(), this.storageDesign.getFormatedName(fk), oldbuffer, prettyPrint);
            this.fkList.put(fkind.getObjectID(), tableProxy);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof Table && (((CompareObjectSelection)object).canBeRename() || ((CompareObjectSelection)object).canBeRenameOnly());
    }

    public void addUnloadExecution(StringBuffer oldbuffer, TableSelection tableObj, TableProxy tableProxy, String unloadDir) {
        StringBuffer buffer = new StringBuffer();
        String tableName = tableProxy.getName();
        this.appendUnloadHeader(oldbuffer, buffer, this.storageDesign.getFormatedName(tableProxy), "");
        oldbuffer.append(this.newline()).append(this.newTab());
        oldbuffer.append("query:=   '");
        oldbuffer.append(this.newline()).append(this.newTab());
        oldbuffer.append("  select ");
        this.addColumns(oldbuffer, tableProxy, tableObj);
        oldbuffer.append(this.newline()).append(this.newTab());
        File file = new File(unloadDir, tableName + ".txt");
        oldbuffer.append("  from ").append(this.storageDesign.getFormatedLongNameDDL(tableProxy));
        oldbuffer.append(this.newline());
        oldbuffer.append("  ';");
        oldbuffer.append(this.newline());
        oldbuffer.append("    cwd_query_to_file( query ,'" + file.getAbsolutePath() + "'," + this.getStatus().getReplaceOption() + ");");
        oldbuffer.append(this.newline());
        if (this.getStatus().getddlAdvancedGenenerator() != null) {
            oldbuffer.append("   end if;");
            oldbuffer.append(this.newline());
        }
        oldbuffer.append("  end;");
        oldbuffer.append(this.newline());
        oldbuffer.append("/");
        oldbuffer.append(this.newline());
        oldbuffer.append(this.newline());
    }

    private void addColumns(StringBuffer buffer, TableProxy tableproxy, TableSelection object) {
        List columns = object.getChildObjects(0);
        String colpref = "col";
        int k = 1;
        Design design = tableproxy.getDesign();
        if (columns.size() > 0) {
            boolean first = true;
            for (CompareObjectSelection column : columns) {
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected()) continue;
                CompareObjectSelection targetColumn = column.getCorrespondentNode();
                String name = CSSBRenameTable.getFormattedSelectedName(column, this.storageDesign);
                Object ndata_type = targetColumn.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                Column col = (Column)targetColumn.getObject();
                if (col != null) {
                    ndata_type = col.getDatatypeString(tableproxy.getStorageDesign().getRDBMSType().getName());
                    if ((((String)ndata_type).equals("CHAR") || ((String)ndata_type).equals("NCHAR")) && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        ndata_type = (String)ndata_type + " (1)";
                    } else if (((String)ndata_type).equals("UROWID") && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        ndata_type = (String)ndata_type + " (4000)";
                    }
                }
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(this.newline()).append(this.newTab()).append(this.newTab());
                if (((String)ndata_type).startsWith("NUMBER") || ((String)ndata_type).startsWith("DATE") || ((String)ndata_type).startsWith("TIMESTAMP")) {
                    buffer.append("to_char(" + CSSBRenameTableOraclev10g.getColumnPresentation(name, (String)ndata_type, design) + ") ").append(colpref + k);
                } else {
                    buffer.append(name + " ").append(colpref + k);
                }
                ++k;
            }
        }
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public void addUnloadPerPartitionExecution(StringBuffer oldbuffer, TableSelection tableObj, TableProxy tableProxy, String unloadDir) {
        StringBuffer buffer = new StringBuffer();
        String tableName = tableProxy.getName();
        for (PartitionOracle partition : ((TableProxyOracle)tableProxy).getPartitions()) {
            this.appendUnloadHeader(oldbuffer, buffer, this.storageDesign.getFormatedName(tableProxy), this.storageDesign.getFormatedName(partition));
            oldbuffer.append(this.newline()).append(this.newTab());
            oldbuffer.append("query:=   '");
            oldbuffer.append(this.newline()).append(this.newTab());
            oldbuffer.append("  select ");
            this.addColumns(oldbuffer, tableProxy, tableObj);
            oldbuffer.append(this.newline()).append(this.newTab());
            File file = new File(unloadDir, tableName + "_" + partition.getName() + ".txt");
            oldbuffer.append("    from ").append(this.storageDesign.getFormatedLongNameDDL(tableProxy)).append(' ');
            oldbuffer.append("PARTITION").append('(').append(this.storageDesign.getFormatedName(partition)).append(')');
            oldbuffer.append(this.newline());
            oldbuffer.append("  ';");
            oldbuffer.append(this.newline());
            oldbuffer.append("    cwd_query_to_file( query ,'" + file.getAbsolutePath() + "'," + this.getStatus().getReplaceOption() + ");");
            oldbuffer.append(this.newline());
            if (this.getStatus().getddlAdvancedGenenerator() != null) {
                oldbuffer.append("   end if;");
                oldbuffer.append(this.newline());
            }
            oldbuffer.append("  end;");
            oldbuffer.append(this.newline());
            oldbuffer.append("/");
            oldbuffer.append(this.newline());
            oldbuffer.append(this.newline());
        }
    }

    private void appendDropColumnConstraints(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxy[] cols = tableProxy.getColumnProxies();
        for (int i = 0; i < cols.length; ++i) {
            ColumnProxyOracle cp = (ColumnProxyOracle)cols[i];
            Column col = cp.getColumn();
            String cname = col.getConstraintName();
            if (cname != null && !"".equals(cname)) {
                this.appendDropConstraintsNoCascade(tableProxy, cname, oldbuffer, prettyPrint);
            }
            if (col.getNullsAllowed() || tableProxy.getDesign().getDesign().getSettings().notNullShortFormGeneration()) continue;
            String string = cname = cp.isNotNullConstraintNameChanged() ? cp.getNncName() : cp.getColumn().getNotNullConstraintName();
            if (cname == null || "".equals(cname)) continue;
            this.appendDropConstraintsNoCascade(tableProxy, cname, oldbuffer, prettyPrint);
        }
    }

    private void appendDropConstraintsNoCascade(TableProxyOracle tableProxy, String name, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        CSSBRenameTable.appendStringWithSpace(buffer, "ALTER");
        CSSBRenameTable.appendStringWithSpace(buffer, "TABLE");
        CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBRenameTable.appendStringWithSpace(buffer, "DROP");
        CSSBRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(name));
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        this.getStatus().incrementAlterTable();
    }

    private void appendDropTriggers(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        for (TriggerOracle trigger : tableProxy.getTriggers()) {
            CSSBRenameTable.appendStringWithSpace(buffer, "DROP");
            CSSBRenameTable.appendStringWithSpace(buffer, "TRIGGER");
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(trigger));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendDropBitmapJoinIndexes(TableProxyOracle tableProxy, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        for (BitmapJoinIndexOracle bji : tableProxy.getBjIndexes()) {
            CSSBRenameTable.appendStringWithSpace(buffer, "DROP");
            CSSBRenameTable.appendStringWithSpace(buffer, "INDEX");
            CSSBRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(bji));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBRenameTable.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }
}

