/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.persistence.ConfigurationFileLoader;
import oracle.dbtools.crest.util.logging.Logger;

public class WordMapper
extends ConfigurationFileLoader {
    private static final Logger LOGGER = new Logger(WordMapper.class);
    private Map stringMapF = new TreeMap();
    private Map stringMapR = new TreeMap();

    public void initializeWith() {
        this.stringMapF.put("ENTITY", "TABLE");
        this.stringMapF.put("ATTRIBUTE", "COLUMN");
        this.stringMapF.put("KEY", "INDEX");
        this.stringMapF.put("Entity", "Table");
        this.stringMapF.put("Attribute", "Column");
        this.stringMapF.put("Key", "Index");
        this.stringMapF.put("entity", "table");
        this.stringMapF.put("attribute", "column");
        this.stringMapF.put("key", "index");
        this.stringMapR.put("TABLE", "ENTITY");
        this.stringMapR.put("COLUMN", "ATTRIBUTE");
        this.stringMapR.put("INDEX", "KEY");
        this.stringMapR.put("Table", "Entity");
        this.stringMapR.put("Column", "Attribute");
        this.stringMapR.put("Index", "Key");
        this.stringMapR.put("table", "entity");
        this.stringMapR.put("column", "column");
        this.stringMapR.put("index", "key");
    }

    public Map getStringMap() {
        return this.stringMapF;
    }

    public String get(String logicalName) {
        return (String)this.getStringMap().get(logicalName);
    }

    public int size() {
        return this.getStringMap().size();
    }

    public String getContent() {
        StringBuffer dataBuffer = new StringBuffer();
        for (String key : this.stringMapF.keySet()) {
            dataBuffer.append(key);
            dataBuffer.append('=');
            dataBuffer.append((String)this.stringMapF.get(key));
            dataBuffer.append(NEWLINE);
        }
        return dataBuffer.toString();
    }

    @Override
    protected void createDefaultFile(File directory) {
        File file = new File(directory, "logtophys.properties");
        try {
            file.createNewFile();
            this.storeMap(this.getStringMap(), file);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }

    public String transformFromLogical(String logicalName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(logicalName.trim(), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (this.getStringMap().containsKey(tok)) {
                buf.append(this.getStringMap().get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public String transformFromRelational(String relationalName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(relationalName.trim(), "_", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken().trim();
            if (this.stringMapR.containsKey(tok)) {
                buf.append(this.stringMapR.get(tok));
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }
}

