/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.logging.Logger;

public class LogicalDatatype
extends DesignObject {
    public static final String[] UNITS = new String[]{"", "BYTE", "CHAR"};
    public static final ObjectChangeEvent FILENAME_CHANGED = new ObjectChangeEvent(Messages.getString("LogicalDatatype.DomainFilenameChanged"));
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SIZE = "size";
    private static final Logger LOGGER = new Logger(LogicalDatatype.class);
    private static final String[] STRING_PROTO = new String[0];
    private Set requiredParameterNamesSet = new HashSet();
    private String[] requiredParameterNames = null;
    private Map toPhysical = new TreeMap();
    private Class javaType = String.class;
    private static final String DEFAULT_FILE = "types";
    private String fileName = "types";
    private boolean readonly = false;
    private Map defaultValues = new TreeMap();

    public LogicalDatatype(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return "Logical Datatype";
    }

    public void put(String rdbmsName, String stringEncodedType) {
        this.toPhysical.put(rdbmsName, stringEncodedType);
        this.addParameterNames(stringEncodedType);
    }

    protected void addParameterNames(String stringEncodedType) {
        String[] tokenized = MDDataTypeFactory.tokenize(stringEncodedType);
        if (tokenized.length > 1) {
            this.requiredParameterNames = null;
        }
        this.requiredParameterNamesSet.clear();
        for (int i = 1; i < tokenized.length; ++i) {
            this.requiredParameterNamesSet.add(tokenized[i]);
        }
    }

    public MDDataType createDataType(String rdbmsName, Map parameterMap) {
        if (!this.toPhysical.containsKey(rdbmsName)) {
            throw new RuntimeException("rdbmsName not known: " + rdbmsName);
        }
        MDDataTypeFactory factory = this.getDesign().getDTFactoryInstance(rdbmsName);
        String[] params = this.substituteParametersByValue((String)this.toPhysical.get(rdbmsName), parameterMap);
        return factory.createStringEncodedType(params);
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("log datatype id prefix");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void setJavaType(Class javaClass) {
        this.javaType = javaClass;
    }

    public boolean setJavaType(String javaClassName) {
        try {
            this.javaType = Class.forName(javaClassName);
        }
        catch (Exception e) {
            LOGGER.error("setJavaType(String): ", e);
            return false;
        }
        return true;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeClassName() {
        return this.javaType.getName();
    }

    @Override
    public int getNumberOfChildren() {
        return this.toPhysical.size();
    }

    @Override
    public Object getChildPlain(int index) {
        Iterator it = this.toPhysical.keySet().iterator();
        for (int i = 0; i <= index && it.hasNext(); ++i) {
            Object object = this.toPhysical.get(it.next());
            if (i != index) continue;
            return object;
        }
        return null;
    }

    @Override
    public int getIndexForChild(Object child) {
        Iterator it = this.toPhysical.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            ModelObject object = (ModelObject)this.toPhysical.get(it.next());
            if (object.equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    protected String[] substituteParametersByValue(String parameterized, Map parameterMap) {
        String[] parts = MDDataTypeFactory.tokenize(parameterized);
        return this.substituteParametersByValue(parts, parameterMap);
    }

    protected String[] substituteParametersByValue(String[] parameterized, Map parameterMap) {
        String[] result = new String[parameterized.length];
        System.arraycopy(parameterized, 0, result, 0, parameterized.length);
        for (int i = 0; i < parameterized.length; ++i) {
            Object value = parameterMap.get(parameterized[i]);
            if (value == null) continue;
            result[i] = (String)value;
        }
        return result;
    }

    public String[] getRequiredParameters() {
        if (this.requiredParameterNames == null) {
            this.requiredParameterNames = this.requiredParameterNamesSet.toArray(STRING_PROTO);
        }
        return this.requiredParameterNames;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileNameNoExtension) {
        if (!this.fileName.equals(fileNameNoExtension)) {
            this.fileName = fileNameNoExtension;
            if (DEFAULT_FILE.equals(fileNameNoExtension)) {
                this.setOwnerDesignName(Design.getSystemDesignName());
            }
            this.fireChange(FILENAME_CHANGED);
        }
    }

    public Map getToPhysical() {
        return this.toPhysical;
    }

    @Override
    public void showPropertyDialog() {
    }

    public static LogicalDatatype getLogicalDatatype(Design design, String typeName, String typeID) {
        LogicalDatatype type = null;
        if (typeID != null) {
            type = (LogicalDatatype)design.getDesignObject(typeID);
        }
        if (type == null && typeName != null) {
            type = design.getLogicalDatatypeSet().getLogTypeByName(typeName);
        }
        if (type == null && typeID != null) {
            if ("LOGDT002".equals(typeID) || "LOGDT004".equals(typeID) || "LOGDT012".equals(typeID)) {
                type = design.getLogicalDatatypeSet().getLogTypeByName("VARCHAR");
            } else if ("LOGDT001".equals(typeID) || "LOGDT003".equals(typeID)) {
                type = design.getLogicalDatatypeSet().getLogTypeByName("CHAR");
            }
        }
        return type;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public void addDefaults(String rdbmsName, TreeMap defaults) {
        this.defaultValues.put(rdbmsName, defaults);
    }

    public Map getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(Map defaultValues) {
        this.defaultValues = defaultValues;
    }

    public Map getLTDefaultValues() {
        Design design = this.getDesign();
        Integer defaultRDBMStype = 9;
        TreeMap<Integer, String> typesRDBMSSites = new TreeMap<Integer, String>();
        Iterator defaultRDBMSTypeSetIterator = Design.getDefaultRDBMSTypeSet().iterator();
        while (defaultRDBMSTypeSetIterator.hasNext()) {
            RDBMSType rdbmsType = (RDBMSType)defaultRDBMSTypeSetIterator.next();
            typesRDBMSSites.put(rdbmsType.getType(), rdbmsType.getName());
        }
        Map defaults = (Map)this.getDefaultValues().get(typesRDBMSSites.get(defaultRDBMStype));
        if (defaults == null) {
            defaults = Collections.emptyMap();
        }
        return defaults;
    }

    public static boolean canBeUsedForPK(String dataTypeName) {
        return !dataTypeName.equalsIgnoreCase("BINARY") && !dataTypeName.equalsIgnoreCase("BLOB") && !dataTypeName.equalsIgnoreCase("CLOB") && !dataTypeName.equalsIgnoreCase("NCLOB") && !dataTypeName.equalsIgnoreCase("BFILE") && !dataTypeName.equalsIgnoreCase("XML") && !dataTypeName.equalsIgnoreCase("XMLTYPE") && !dataTypeName.equalsIgnoreCase("URITYPE") && !dataTypeName.equalsIgnoreCase("DBURITYPE") && !dataTypeName.equalsIgnoreCase("HTTPURITYPE") && !dataTypeName.equalsIgnoreCase("LONG") && !dataTypeName.equalsIgnoreCase("LONG RAW") && !dataTypeName.equalsIgnoreCase("XDBURITYPE") && !dataTypeName.equalsIgnoreCase("SYS.ANYDATA") && !dataTypeName.equalsIgnoreCase("SYS.ANYTYPE") && !dataTypeName.equalsIgnoreCase("SYS.ANYDATASET") && !dataTypeName.equalsIgnoreCase("ORDAudio") && !dataTypeName.equalsIgnoreCase("ORDDoc") && !dataTypeName.equalsIgnoreCase("ORDImage") && !dataTypeName.equalsIgnoreCase("ORDImageSignature") && !dataTypeName.equalsIgnoreCase("ORDSYS.ORDAudio") && !dataTypeName.equalsIgnoreCase("ORDSYS.ORDDoc") && !dataTypeName.equalsIgnoreCase("ORDSYS.ORDImage") && !dataTypeName.equalsIgnoreCase("ORDSYS.ORDImageSignature") && !dataTypeName.equalsIgnoreCase("ORDSYS.ORDVideo") && !dataTypeName.equalsIgnoreCase("ORDVideo") && !dataTypeName.equalsIgnoreCase("DATALINK") && !dataTypeName.equalsIgnoreCase("GRAPHIC") && !dataTypeName.equalsIgnoreCase("DBCLOB") && !dataTypeName.equalsIgnoreCase("LONG VARCHAR") && !dataTypeName.equalsIgnoreCase("LONG VARGRAPHIC") && !dataTypeName.equalsIgnoreCase("VARGRAPHIC") && !dataTypeName.equalsIgnoreCase("IMAGE") && !dataTypeName.equalsIgnoreCase("XDBURITYPE");
    }

    public boolean isNumeric() {
        String dataTypeName = this.getName();
        return dataTypeName.equalsIgnoreCase("BIGINT") || dataTypeName.equalsIgnoreCase("BINARY_DOUBLE") || dataTypeName.equalsIgnoreCase("BINARY_FLOAT") || dataTypeName.equalsIgnoreCase("DECIMAL") || dataTypeName.equalsIgnoreCase("DOUBLE") || dataTypeName.equalsIgnoreCase("FLOAT") || dataTypeName.equalsIgnoreCase("INTEGER") || dataTypeName.equalsIgnoreCase("MONEY") || dataTypeName.equalsIgnoreCase("NUMERIC") || dataTypeName.equalsIgnoreCase("REAL") || dataTypeName.equalsIgnoreCase("SMALLINT") || dataTypeName.equalsIgnoreCase("SMALLMONEY") || dataTypeName.equalsIgnoreCase("TINYINT");
    }

    public boolean isHiveName(String dataTypeName) {
        return dataTypeName.equalsIgnoreCase("BIGINT") || dataTypeName.equalsIgnoreCase("STRING") || dataTypeName.equalsIgnoreCase("BOOLEAN") || dataTypeName.equalsIgnoreCase("DECIMAL") || dataTypeName.equalsIgnoreCase("DOUBLE") || dataTypeName.equalsIgnoreCase("FLOAT") || dataTypeName.equalsIgnoreCase("INT") || dataTypeName.equalsIgnoreCase("INTEGER") || dataTypeName.equalsIgnoreCase("VARCHAR") || dataTypeName.equalsIgnoreCase("CHAR") || dataTypeName.equalsIgnoreCase("BINARY") || dataTypeName.equalsIgnoreCase("SMALLINT") || dataTypeName.equalsIgnoreCase("TIMESTAMP") || dataTypeName.equalsIgnoreCase("DATE") || dataTypeName.equalsIgnoreCase("TINYINT");
    }

    public static void clearEvents() {
        FILENAME_CHANGED.setAffected(null);
    }

    public String getDataTypeForHive(Map parameters) {
        String type = this.getName();
        if ("Numeric".equalsIgnoreCase(type)) {
            type = "DECIMAL";
        }
        if (this.isHiveName(type)) {
            String precision;
            if (type.equalsIgnoreCase("INTEGER")) {
                type = "INT";
            }
            if (type.equalsIgnoreCase("VARCHAR") || type.equalsIgnoreCase("CHAR")) {
                String size = (String)parameters.get(PARAM_SIZE);
                if ("max".equalsIgnoreCase(size)) {
                    size = null;
                }
                if (size != null && !"".equals(size)) {
                    try {
                        size = size.replaceFirst(" BYTE", "");
                        size = size.replaceFirst(" CHAR", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return type + "(" + size + ")";
                }
            } else if (type.equalsIgnoreCase("DECIMAL") && (precision = (String)parameters.get(PARAM_PRECISION)) != null && !"".equals(precision) && !"0".equals(precision)) {
                String scale = (String)parameters.get(PARAM_SCALE);
                if (scale != null && !"".equals(scale) && !"0".equals(scale)) {
                    return type + "(" + precision + "," + scale + ")";
                }
                return type + "(" + precision + ")";
            }
            return type;
        }
        return null;
    }

    public String transformOracleTypeToHive(String oracleBuiltinType) {
        Object type = oracleBuiltinType;
        int ind = ((String)type).indexOf(40);
        String p1 = type;
        String p2 = "";
        if (ind > 0) {
            p1 = ((String)type).substring(0, ind);
            p2 = ((String)type).substring(ind);
        }
        if (p1.equalsIgnoreCase("CHAR") || p1.equalsIgnoreCase("NCHAR")) {
            type = "CHAR";
            type = (String)type + p2;
        } else if (p1.equalsIgnoreCase("VARCHAR2") || p1.equalsIgnoreCase("NVARCHAR2")) {
            type = "VARCHAR";
            type = (String)type + p2;
        } else {
            type = p1.equalsIgnoreCase("LONG RAW") || p1.equalsIgnoreCase("BLOB") || p1.equalsIgnoreCase("RAW") ? "BINARY" : (p1.equalsIgnoreCase("FLOAT") || p1.equalsIgnoreCase("BINARY_FLOAT") ? "FLOAT" : (p1.equalsIgnoreCase("BINARY_DOUBLE") ? "DOUBLE" : (p1.equalsIgnoreCase("LONG") || p1.equalsIgnoreCase("CLOB") || p1.equalsIgnoreCase("NCLOB") ? "STRING" : (p1.equalsIgnoreCase("DATE") ? "DATE" : (p1.toUpperCase().startsWith("TIMESTAMP") ? "TIMESTAMP" : "STRING")))));
        }
        return type;
    }
}

