/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.util.GUID;

public class DomainFileWrapper {
    private Design design;
    private String fileName;
    private List domains = new ArrayList();
    private DomainSet domainSet;
    private boolean useDomainSet = true;

    public DomainFileWrapper(Design design) {
        this.design = design;
        this.domainSet = design.getDomainSet();
    }

    public DomainFileWrapper(Design design, String fileName) {
        this(design);
        this.fileName = fileName;
        this.synchronizeWithdomainSet();
    }

    public DomainFileWrapper(Design design, String fileName, boolean useDomainSet) {
        this(design);
        this.fileName = fileName;
        this.useDomainSet = useDomainSet;
        if (useDomainSet) {
            this.synchronizeWithdomainSet();
        }
    }

    public DomainFileWrapper(Design design, String fileName, DomainSet domainSet) {
        this.design = design;
        this.domainSet = domainSet;
        this.fileName = fileName;
        this.synchronizeWithdomainSet();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List getDomains() {
        return this.domains;
    }

    public Domain createDomain() {
        Domain domain = null;
        if (this.useDomainSet) {
            domain = this.domainSet.createDomain();
        } else {
            domain = new Domain(this.design.getLogicalDesign());
            domain.setObjectID(new GUID().toString());
        }
        return domain;
    }

    private void synchronizeWithdomainSet() {
        if (this.fileName != null && !"".equals(this.fileName)) {
            Iterator it = this.domainSet.iterator();
            while (it.hasNext()) {
                Domain domain = (Domain)it.next();
                if (!this.fileName.equals(domain.getFileName())) continue;
                this.domains.add(domain);
            }
        }
    }

    public List getIDSortedDomains() {
        Collections.sort(this.domains, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return this.domains;
    }

    public Domain getDomainByID(String id) {
        if (id != null && !"".equals(id)) {
            if (this.useDomainSet) {
                return (Domain)this.domainSet.getObjectByID(id);
            }
            for (Domain domain : this.domains) {
                if (!id.equals(domain.getObjectID())) continue;
                return domain;
            }
        }
        return null;
    }

    public void presetDomainsFileName() {
        if (this.fileName != null && !"".equals(this.fileName)) {
            for (Domain domain : this.domains) {
                domain.setFileName(this.fileName);
            }
        }
    }

    public void removeDomain(Domain domain) {
        this.domains.remove(domain);
        domain.remove();
    }
}

