/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.logging.Logger;

public class ModelIdObjectSelection
extends ModelObject {
    public static final int STATE_UNCHANGED = 0;
    public static final int STATE_MODIFIED = 1;
    public static final int STATE_NEW = 2;
    public static final int STATE_DELETED = 3;
    public static final int NO_FILTER = -1;
    public static final String TO_DROP = Messages.getString("ModelIdObjectSelection.ToDrop");
    public static final String NEW_TABLE = Messages.getString("ModelIdObjectSelection.NewTable");
    public static final String NEW_COLUMN = Messages.getString("ModelIdObjectSelection.NewColumn");
    public static final String NEW_INDEX = Messages.getString("ModelIdObjectSelection.NewIndex");
    public static final String NEW_KEY = Messages.getString("ModelIdObjectSelection.NewKey");
    public static final String NEW_CONSTRAINT = Messages.getString("ModelIdObjectSelection.NewConstraint");
    public static final String NEW_VALID_TIME = Messages.getString("ModelIdObjectSelection.NewValidTime");
    public static final String NEW_TRIGGER = Messages.getString("ModelIdObjectSelection.NewTrigger");
    public static final String NEW_RELATION = Messages.getString("ModelIdObjectSelection.NewRelation");
    public static final String NEW_INHERITANCE = Messages.getString("ModelIdObjectSelection.NewInheritance");
    public static final String NEW_VIEW = Messages.getString("ModelIdObjectSelection.NewVIEW");
    public static final String NEW_ARC = Messages.getString("ModelIdObjectSelection.NewArc");
    public static final String NEW_NOTE = Messages.getString("ModelIdObjectSelection.NewNote");
    public static final String VALID_TIME_DIMENSIONS = Messages.getString("CompareModelToModel.ValidTimeDimensions");
    public static final String ARCS = Messages.getString("RelationalDesign.Arcs");
    public static final String TRIGGERS = Messages.getString("CompareModelToModel.Triggers");
    public static final String BITMAP_JOIN_INDEXES = Messages.getString("TableProxyOracle.BitmapJoinIndexes");
    public static final String LOB_STORAGES = Messages.getString("TableProxyOracle.LobStorages");
    public static final String PACKAGES = Messages.getString("StorageDesignOracle.Packages");
    public static final String FUNCTIONS = Messages.getString("StorageDesignOracle.Functions");
    public static final String STORED_PROCEDURES = Messages.getString("StorageDesignOracle.StoredProcedures");
    public static final String CONTEXTS = Messages.getString("StorageDesignOracle.Contexts");
    public static final String DIRECTORIES = Messages.getString("StorageDesignOracle.Directories");
    public static final String DISK_GROUPS = Messages.getString("StorageDesignOracle.DiskGroups");
    public static final String DIMENSIONS = Messages.getString("StorageDesignOracle.Dimensions");
    public static final String HIERARCHIES = Messages.getString("DimensionOracle.Hierarchies");
    public static final String LEVELS = Messages.getString("DimensionOracle.Levels");
    public static final String SYNONYMS = Messages.getString("StorageDesignOracle.Synonyms");
    public static final String ROLES = Messages.getString("StorageDesignOracle.Roles");
    public static final String USERS = Messages.getString("StorageDesignOracle.Users");
    public static final String QUOTAS = Messages.getString("UserOracle.Quotas");
    public static final String PERMISSIONS = Messages.getString("PermissionsComparatorOracle.Permissions");
    public static final String TABLESPACES = Messages.getString("StorageDesignOracle.Tablespaces");
    public static final String TEMP_TABLESPACES = Messages.getString("StorageDesignOracle.TempTablespaces");
    public static final String UNDO_TABLESPACES = Messages.getString("StorageDesignOracle.UndoTablespaces");
    public static final String DATA_FILES = Messages.getString("TableSpaceOracle.DataFiles");
    public static final String MVIEW_LOGS = Messages.getString("StorageDesignOracle.MViewLogs");
    protected int status = 0;
    private static final String ASSIGNED_TO_SCHEMAS = "Assigned To Schemas";
    private static final String NOT_ASSIGNED_TO_SCHEMAS = "Not Assigned To Schemas";
    private Set listeners = new HashSet();
    private boolean collection;
    protected ModelIDObject object;
    protected List<ModelIdObjectSelection> childs = new ArrayList<ModelIdObjectSelection>();
    protected Object elDescriptor;
    protected boolean selected = true;
    private static final Logger LOGGER = new Logger(ModelIdObjectSelection.class);
    private boolean applySelectionImmediate = false;
    private boolean oldSelection;
    protected boolean loaded = true;
    private List tableList;
    private List viewList;
    private List constraintList;
    private List indexList;
    private List fkList;
    private List schemaList;
    private boolean inSyncOperation = true;
    Design design = null;
    private String type = "";

    public ModelIdObjectSelection(ModelIDObject object) {
        this.object = object;
        this.elDescriptor = object.getClass();
        this.oldSelection = this.selected = object.isMarkedGenerate();
        if (object != null) {
            this.design = object.getDesign();
        }
    }

    public ModelIdObjectSelection(ModelIDObject object, boolean applySelectionImmediate) {
        this.object = object;
        this.elDescriptor = object.getClass();
        this.oldSelection = this.selected = object.isMarkedGenerate();
        this.applySelectionImmediate = applySelectionImmediate;
        if (object != null) {
            this.design = object.getDesign();
        }
    }

    public ModelIdObjectSelection(String name) {
        super.setName(name);
        this.collection = true;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public void addChild(ModelIdObjectSelection child) {
        child.setParent(this);
        this.childs.add(child);
    }

    @Override
    public String getName() {
        if (this.object != null) {
            return this.object.getName();
        }
        return super.getName();
    }

    public void setElementDescriptor(Object elementDescriptor) {
        this.elDescriptor = elementDescriptor;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    protected void propagateSelection() {
        for (ModelIdObjectSelection selob : this.childs) {
            selob.setSelected(this.selected);
        }
    }

    public boolean isSelected() {
        if (this.applySelectionImmediate && this.object != null) {
            return this.object.isMarkedGenerate();
        }
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (this.applySelectionImmediate && this.object != null) {
            this.object.setMarkedGenerate(selected);
        }
        this.propagateSelection();
    }

    public void setSelectedNoPropagateSelection(boolean selected) {
        this.selected = selected;
        if (this.applySelectionImmediate && this.object != null) {
            this.object.setMarkedGenerate(selected);
        }
    }

    public boolean checkSelected() {
        ModelIdObjectSelection root = this.getRoot(this);
        return true;
    }

    private ModelIdObjectSelection getRoot(ModelIdObjectSelection node) {
        Object parObj = node.getParent();
        if (parObj != null && parObj instanceof ModelIdObjectSelection) {
            ModelIdObjectSelection parNode = (ModelIdObjectSelection)parObj;
            return parNode.getRoot(parNode);
        }
        return node;
    }

    private boolean hasGenerate(ModelIdObjectSelection node) {
        ModelIDObject obj = node.getObject();
        if (obj != null && obj.isMarkedGenerate() && node.isSelected()) {
            return true;
        }
        List children = node.getChilds();
        if (children.size() > 0) {
            for (ModelIdObjectSelection child : children) {
                if (!this.hasGenerate(child)) continue;
                return true;
            }
        }
        return false;
    }

    public void applySelectionToObjects() {
        if (this.object != null) {
            if (this.applySelectionImmediate) {
                this.oldSelection = this.selected = this.object.isMarkedGenerate();
            }
            this.object.setMarkedGenerate(this.selected);
        }
        for (ModelIdObjectSelection sel : this.childs) {
            sel.applySelectionToObjects();
        }
    }

    public boolean hasSelectedChildren(ModelIdObjectSelection sel) {
        boolean hasSelectedChild = false;
        for (ModelIdObjectSelection subSel : sel.childs) {
            if (subSel.childs.size() > 0) {
                hasSelectedChild = this.hasSelectedChildren(subSel);
            } else if (subSel.object != null) {
                hasSelectedChild = subSel.isSelected();
            }
            if (!hasSelectedChild) continue;
            return hasSelectedChild;
        }
        return hasSelectedChild;
    }

    public void restoreOldSelectionToObjects() {
        if (this.object != null) {
            this.object.setMarkedGenerate(this.oldSelection);
        }
        for (ModelIdObjectSelection sel : this.childs) {
            sel.restoreOldSelectionToObjects();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.childs.size();
    }

    @Override
    public ModelObject getChild(int index) {
        if (this.childs.size() > 0 && index < this.childs.size()) {
            return this.childs.get(index);
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (this.childs.size() > 0) {
            return this.childs.indexOf(child);
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (this.childs.size() > 0) {
            return this.childs.indexOf(child);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        if (!this.loaded) {
            return false;
        }
        return this.childs.size() == 0;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public ModelIDObject getObject() {
        return this.object;
    }

    protected Set getListeners() {
        return this.listeners;
    }

    public void removeChild(ModelIdObjectSelection child) {
        if (this.childs.remove(child)) {
            // empty if block
        }
    }

    public List getChilds() {
        return this.childs;
    }

    public boolean isFiltered(List filters) {
        for (Integer filter : filters) {
            if (filter.intValue() != this.getStatus()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFilteredChilds(List filters) {
        for (ModelIdObjectSelection object : this.getChilds()) {
            if (!object.isFiltered(filters) && !object.hasFilteredChilds(filters)) continue;
            return true;
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public void sort() {
        Collections.sort(this.childs, ModelObjectSet.NAME_COMPARATOR);
    }

    public void sortAsString() {
        Collections.sort(this.childs, ModelObjectSet.TOSTRING_COMPARATOR);
    }

    public boolean hasAsParent(ModelIDObject idObject) {
        ModelIDObject obj = this.getObject();
        if (obj == idObject) {
            return true;
        }
        if (obj != null && obj instanceof DesignObjectPlaceHolder && ((DesignObjectPlaceHolder)obj).getObject() == idObject) {
            return true;
        }
        Object parent = this.getParent();
        if (parent != null && parent instanceof ModelIdObjectSelection) {
            return ((ModelIdObjectSelection)parent).hasAsParent(idObject);
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    protected void addObjectsAssignedToSchemas(RelationalDesign phdes, DesignPartView selectedSubView, String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection schemaSel = new ModelIdObjectSelection(nodeName);
        schemaSel.setElementDescriptor(SchemaObjectSet.class);
        for (SchemaObject so : list) {
            ModelIdObjectSelection isel = new ModelIdObjectSelection(so.getName());
            isel.setElementDescriptor(SchemaObject.class);
            this.addSchemaDetails(phdes, selectedSubView, so, isel);
            schemaSel.addChild(isel);
        }
        selection.addChild(schemaSel);
    }

    protected void addSchemaDetails(RelationalDesign phdes, DesignPartView selectedSubView, SchemaObject so, ModelIdObjectSelection parent) {
        ModelIdObjectSelection sel;
        int i;
        List list = null;
        list = so != null ? (selectedSubView == null ? this.getTableForSchema(phdes, so) : this.getTableForSubView(so, selectedSubView)) : this.getTableWithNoSchema(phdes, selectedSubView);
        if (list.size() > 0) {
            ModelIdObjectSelection tsel = new ModelIdObjectSelection("Tables");
            tsel.setElementDescriptor(TableSet.class);
            for (i = 0; i < list.size(); ++i) {
                Table table = (Table)list.get(i);
                sel = new ModelIdObjectSelection(table);
                this.addTableDetails(table, sel);
                tsel.addChild(sel);
                this.getTableList().add(sel);
            }
            parent.addChild(tsel);
        }
        list = so != null ? (selectedSubView == null ? this.getViewForSchema(phdes, so) : this.getViewForSubView(so, selectedSubView)) : this.getViewWithNoSchema(phdes, selectedSubView);
        if (list.size() > 0) {
            ModelIdObjectSelection vsel = new ModelIdObjectSelection("Views");
            vsel.setElementDescriptor(TableViewSet.class);
            for (i = 0; i < list.size(); ++i) {
                TableView view = (TableView)list.get(i);
                sel = new ModelIdObjectSelection(view);
                vsel.addChild(sel);
                this.getViewList().add(sel);
            }
            parent.addChild(vsel);
        }
        parent.sort();
    }

    private List getTableForSchema(RelationalDesign phdes, SchemaObject so) {
        ArrayList<Table> list = new ArrayList<Table>();
        Iterator it = phdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (table.getSchema() == null || !table.getSchema().equals(so.getName())) continue;
            list.add(table);
        }
        return list;
    }

    private List getTableForSubView(SchemaObject so, DesignPartView selectedSubView) {
        ArrayList list = new ArrayList();
        if (selectedSubView != null) {
            // empty if block
        }
        return list;
    }

    private List getTableWithNoSchema(RelationalDesign phdes, DesignPartView selectedSubView) {
        ArrayList list = new ArrayList();
        return list;
    }

    private List getViewForSchema(RelationalDesign phdes, SchemaObject so) {
        ArrayList<TableView> list = new ArrayList<TableView>();
        Iterator it = phdes.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            if (view.getSchema() == null || !view.getSchema().equals(so.getName())) continue;
            list.add(view);
        }
        return list;
    }

    private List getViewForSubView(SchemaObject so, DesignPartView selectedSubView) {
        ArrayList list = new ArrayList();
        return list;
    }

    private List getViewWithNoSchema(RelationalDesign phdes, DesignPartView selectedSubView) {
        ArrayList list = new ArrayList();
        return list;
    }

    private void addTableDetails(Table table, ModelIdObjectSelection parent) {
        FKIndexAssociation[] fkeys;
        ModelIdObjectSelection isel;
        ModelIdObjectSelection sel;
        if (table.getPKandUKConstraints().size() > 0) {
            sel = new ModelIdObjectSelection("PK/UK Constraints");
            for (KeyObject key : table.getPKandUKConstraints()) {
                ModelIdObjectSelection isel2 = new ModelIdObjectSelection(key);
                if (key.isPK()) {
                    isel2.setName("(PK) " + key.getName());
                }
                sel.addChild(isel2);
                this.getConstraintList().add(isel2);
            }
            parent.addChild(sel);
        }
        if (table.getIndexes().size() > 0) {
            sel = new ModelIdObjectSelection("Indexes");
            for (ContainerObjectPlaceHolder ph : table.getIndexes()) {
                Index ind = (Index)ph.getDesignObject();
                isel = new ModelIdObjectSelection(ind);
                sel.addChild(isel);
                if (this.indexList == null) {
                    this.indexList = new ArrayList();
                }
                this.getIndexList().add(isel);
            }
            parent.addChild(sel);
        }
        if ((fkeys = table.getFKAssociations()).length > 0) {
            ModelIdObjectSelection sel2 = new ModelIdObjectSelection("Foreign Keys");
            for (int i = 0; i < fkeys.length; ++i) {
                FKIndexAssociation fk = fkeys[i];
                isel = new ModelIdObjectSelection(fk);
                sel2.addChild(isel);
                if (this.fkList == null) {
                    this.fkList = new ArrayList();
                }
                this.getFkList().add(isel);
            }
            parent.addChild(sel2);
        }
    }

    public List getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    public List getConstraintList() {
        if (this.constraintList == null) {
            this.constraintList = new ArrayList();
        }
        return this.constraintList;
    }

    public List getViewList() {
        if (this.viewList == null) {
            this.viewList = new ArrayList();
        }
        return this.viewList;
    }

    public List getFkList() {
        if (this.fkList == null) {
            this.fkList = new ArrayList();
        }
        return this.fkList;
    }

    public List getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList();
        }
        return this.indexList;
    }

    public List getSchemaList() {
        if (this.schemaList == null) {
            this.schemaList = new ArrayList();
        }
        return this.schemaList;
    }

    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isInSyncOperation() {
        return this.inSyncOperation;
    }

    public void setInSyncOperation(boolean inSyncOperation) {
        this.inSyncOperation = inSyncOperation;
    }

    public ModelIdObjectSelection getContainerSelectionObject() {
        ModelIdObjectSelection parent = (ModelIdObjectSelection)this.getParent();
        while (parent != null) {
            ModelIDObject obj = parent.getObject();
            if (obj instanceof Table || obj instanceof TableView || obj instanceof StructuredType || obj instanceof CollectionType) {
                return parent;
            }
            Object par = parent.getParent();
            if (par instanceof ModelIdObjectSelection) {
                parent = (ModelIdObjectSelection)par;
                continue;
            }
            parent = null;
        }
        return null;
    }

    @Override
    public Design getDesign() {
        if (this.design == null) {
            if (this.object != null) {
                this.design = this.object.getDesign();
            } else {
                Object par = this.getParent();
                if (par != null && par instanceof ModelIdObjectSelection) {
                    this.design = ((ModelIdObjectSelection)par).getDesign();
                }
            }
        }
        return this.design;
    }

    @Override
    public void setDesign(Design design) {
        this.design = design;
    }

    public String getType() {
        if (this.type == null || this.type.isEmpty()) {
            if (this.object != null) {
                return this.object.getObjectTypeName();
            }
            return "";
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ModelIdObjectSelection getChildByType(String type) {
        if (type != null && !type.isEmpty()) {
            for (ModelIdObjectSelection obj : this.childs) {
                if (!type.equalsIgnoreCase(obj.getType())) continue;
                return obj;
            }
        }
        return null;
    }
}

