/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHUserOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "USER";
    private static final Logger LOGGER = new Logger(MOHUserOracle.class);
    protected boolean dbaUser;
    PreparedStatement objectPrivilegesStmt = null;
    PreparedStatement columnPrivilegesStmt = null;
    PreparedStatement systemPrivilegesStmt = null;
    PreparedStatement rolesStmt = null;
    PreparedStatement quotasStmt = null;
    Set<String> allUserNames = new TreeSet<String>();

    public MOHUserOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHUserOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        boolean dba_users_ok = true;
        Statement statement = null;
        this.systemPrivilegesStmt = null;
        this.rolesStmt = null;
        this.quotasStmt = null;
        TreeMap<String, UserOracle> map = new TreeMap<String, UserOracle>();
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo;
                block27: {
                    block26: {
                        ResultSet rs;
                        block23: {
                            UserOracle user;
                            dbo = (DBObject)selectedObjects.get(i);
                            String userName = dbo.getSchema();
                            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
                            if (userName != null && !"".equals(userName)) {
                                user = (UserOracle)map.get(userName);
                                if (user == null) {
                                    if (storageDesign != null && (user = (UserOracle)storageDesign.getUserSet().getByName(userName)) == null) {
                                        user = storageDesign.getUserSet().createUser();
                                        user.setName(userName);
                                        this.stampModelObject((ModelObject)user, "", userName);
                                    }
                                    if (user != null) {
                                        map.put(userName, user);
                                    }
                                }
                                if (user != null && !userName.equals(userName.toUpperCase())) {
                                    user.setNameHasQuotes(true);
                                }
                            }
                            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                            userName = dbo.getName();
                            if (storageDesign == null) break block26;
                            user = (UserOracle)storageDesign.getUserSet().getByName(userName);
                            if (user == null) {
                                user = storageDesign.getUserSet().createUser();
                                user.setName(userName);
                            }
                            this.stampModelObject((ModelObject)user, "", userName);
                            if (!dba_users_ok) break block27;
                            rs = null;
                            try {
                                if (statement == null) {
                                    StringBuffer buffer = new StringBuffer();
                                    buffer.append("SELECT").append(' ');
                                    buffer.append(this.dbaUser ? "PASSWORD" : "NULL").append(' ').append("AS").append(' ').append("PASSWORD").append(',');
                                    buffer.append("DEFAULT_TABLESPACE").append(',');
                                    buffer.append("TEMPORARY_TABLESPACE").append(',');
                                    buffer.append(this.dbaUser ? "PROFILE" : "NULL").append(' ').append("AS").append(' ').append("PROFILE").append(',');
                                    buffer.append("EXTERNAL_NAME").append(' ');
                                    buffer.append("FROM").append(' ');
                                    buffer.append(this.dbaUser ? "dba_users" : "user_users").append(' ');
                                    buffer.append("WHERE").append(' ');
                                    buffer.append("USERNAME").append('=').append('?');
                                    statement = sqlConnection.prepareStatement(buffer.toString());
                                }
                                statement.setString(1, userName);
                                rs = statement.executeQuery();
                                if (rs == null) break block23;
                                if (rs.next()) {
                                    this.setProperties(user, storageDesign, rs);
                                    this.setSystemPrivileges(user, sqlConnection);
                                    this.setRoles(user, sqlConnection);
                                    this.setQuotas(user, sqlConnection);
                                }
                                rs.close();
                            }
                            catch (SQLException se) {
                                block24: {
                                    if (se.getMessage().startsWith("ORA-00942")) {
                                        dba_users_ok = false;
                                        LOGGER.error("MOHUserOracle.generate(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_users" : "user_users"));
                                        break block24;
                                    }
                                    LOGGER.error("MOHUserOracle.generate():", se);
                                }
                                Closeables.close((Object)rs);
                            }
                            catch (Exception e) {
                                LOGGER.error("MOHUserOracle.generate():", e);
                                {
                                    catch (Throwable throwable) {
                                        Closeables.close(rs);
                                        throw throwable;
                                    }
                                }
                                Closeables.close((Object)rs);
                            }
                        }
                        Closeables.close((Object)rs);
                        break block27;
                        break block27;
                    }
                    LOGGER.error("Unable to find Storage Design");
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
        }
        finally {
            if (this.rolesStmt != null) {
                this.rolesStmt.close();
                this.rolesStmt = null;
            }
            if (this.quotasStmt != null) {
                this.quotasStmt.close();
                this.quotasStmt = null;
            }
            if (this.systemPrivilegesStmt != null) {
                this.systemPrivilegesStmt.close();
                this.systemPrivilegesStmt = null;
            }
            if (statement != null) {
                statement.close();
            }
            map.clear();
        }
    }

    private void setProperties(UserOracle user, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        TemporaryTablespaceOracle tempTableSpace;
        TableSpaceOracle defTableSpace;
        String password = resultSet.getString("PASSWORD");
        String defaultTS = resultSet.getString("DEFAULT_TABLESPACE");
        String tempTS = resultSet.getString("TEMPORARY_TABLESPACE");
        String profile = resultSet.getString("PROFILE");
        String externalName = resultSet.getString("EXTERNAL_NAME");
        if (password != null) {
            if ("EXTERNAL".equalsIgnoreCase(password.trim())) {
                user.setAuthType("EXTERNALLY");
            } else if ("GLOBAL".equalsIgnoreCase(password.trim())) {
                user.setAuthType("GLOBALLY");
            }
        }
        if (defaultTS != null && !"".equalsIgnoreCase(defaultTS) && (defTableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(defaultTS)) != null) {
            user.setDefTableSpace(defTableSpace);
        }
        if (tempTS != null && !"".equalsIgnoreCase(tempTS) && (tempTableSpace = (TemporaryTablespaceOracle)storageDesign.getTemporaryTablespaceSet().getByName(tempTS)) != null) {
            user.setTempTableSpace(tempTableSpace);
        }
        if (profile != null) {
            user.setProfile(profile);
        }
        if (externalName != null) {
            user.setExternalName(externalName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setRoles(UserOracle user, Connection sqlConnection) throws Exception {
        block13: {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            if (storageDesign != null) {
                ResultSet rs = null;
                try {
                    if (this.rolesStmt == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT");
                        buffer.append(' ').append("GRANTED_ROLE");
                        buffer.append(',').append("ADMIN_OPTION");
                        buffer.append(',').append("DEFAULT_ROLE");
                        buffer.append(' ').append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_role_privs" : "user_role_privs").append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append(this.dbaUser ? "GRANTEE" : "USERNAME").append('=').append('?');
                        this.rolesStmt = sqlConnection.prepareStatement(buffer.toString());
                    }
                    this.rolesStmt.setString(1, user.getName());
                    rs = this.rolesStmt.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            RoleOracle role;
                            String grantedRoleName = rs.getString("GRANTED_ROLE");
                            String adminOption = rs.getString("ADMIN_OPTION");
                            if (grantedRoleName == null || "".equalsIgnoreCase(grantedRoleName) || (role = (RoleOracle)storageDesign.getRoleSet().getByName(grantedRoleName)) == null) continue;
                            if ("YES".equalsIgnoreCase(adminOption)) {
                                user.setRolesWithAdminOption(role.getObjectID());
                                continue;
                            }
                            user.setRoles(role.getObjectID());
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (SQLException se) {
                    block14: {
                        if (se.getMessage().startsWith("ORA-00942")) {
                            LOGGER.error("MOHUserOracle.setRoles(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_role_privs" : "user_role_privs"));
                            break block14;
                        }
                        LOGGER.error("MOHUserOracle.setRoles():", se);
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHUserOracle.setRoles():", e);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setSystemPrivileges(UserOracle user, Connection sqlConnection) throws Exception {
        block12: {
            ResultSet rs = null;
            try {
                if (this.systemPrivilegesStmt == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("PRIVILEGE").append(',');
                    buffer.append("ADMIN_OPTION").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? "dba_sys_privs" : "user_sys_privs").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append(this.dbaUser ? "GRANTEE" : "USERNAME").append('=').append('?');
                    this.systemPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
                }
                this.systemPrivilegesStmt.setString(1, user.getName());
                rs = this.systemPrivilegesStmt.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        String privilege = rs.getString("PRIVILEGE");
                        String adminOption = rs.getString("ADMIN_OPTION");
                        if ("YES".equalsIgnoreCase(adminOption)) {
                            user.setPrivilegesWithAdminOption(privilege);
                            continue;
                        }
                        user.setPrivileges(privilege);
                    }
                    rs.close();
                }
                Closeables.close((Object)rs);
            }
            catch (SQLException se) {
                block13: {
                    if (se.getMessage().startsWith("ORA-00942")) {
                        LOGGER.error("MOHUserOracle.setSystemPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_sys_privs" : "user_sys_privs"));
                        break block13;
                    }
                    LOGGER.error("MOHUserOracle.setSystemPrivileges():", se);
                }
                Closeables.close((Object)rs);
            }
            catch (Exception e) {
                LOGGER.error("MOHUserOracle.setSystemPrivileges():", e);
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closeables.close(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processObjectPrivileges(Connection con, List selectedObjects, boolean dbaUser) {
        HashMap<String, ArrayList<String>> tmap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap<CallSite, DBObject> nmap = new HashMap<CallSite, DBObject>();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String objectType = dbo.getType();
            String schema = dbo.getSchema();
            if ("DIRECTORY".equals(objectType)) {
                schema = "SYS";
            }
            String name = dbo.getName();
            nmap.put((CallSite)((Object)(schema + "." + name)), dbo);
            ArrayList<String> list = (ArrayList<String>)tmap.get(schema);
            if (list == null) {
                list = new ArrayList<String>();
                tmap.put(schema, list);
            }
            list.add(name);
            if (schList.contains(schema)) continue;
            schList.add(schema);
        }
        ResultSet rs = null;
        for (String schema : schList) {
            List list = (List)tmap.get(schema);
            String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
            String sql = "select table_name," + (dbaUser ? "OWNER" : "TABLE_SCHEMA") + ", grantee, PRIVILEGE, GRANTABLE, HIERARCHY from " + (dbaUser ? "dba_tab_privs" : "all_tab_privs");
            sql = sql + " where " + (dbaUser ? "OWNER" : "TABLE_SCHEMA") + " = ? and " + incl;
            try {
                statement = con.prepareStatement(sql);
                statement.setString(1, schema);
                int k = 1;
                for (String tname : list) {
                    statement.setString(++k, tname);
                }
                rs = statement.executeQuery();
                while (rs.next()) {
                    String tname = rs.getString(1);
                    DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                    try {
                        this.setPrivilege(rs, dbo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processColumnPrivileges(Connection con, List selectedObjects, boolean dbaUser) {
        HashMap<String, ArrayList<String>> tmap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap<CallSite, DBObject> nmap = new HashMap<CallSite, DBObject>();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String schema = dbo.getSchema();
            if (dbo.getTable() == null) continue;
            String name = dbo.getName();
            nmap.put((CallSite)((Object)(schema + "." + name)), dbo);
            ArrayList<String> list = (ArrayList<String>)tmap.get(schema);
            if (list == null) {
                list = new ArrayList<String>();
                tmap.put(schema, list);
            }
            list.add(name);
            if (schList.contains(schema)) continue;
            schList.add(schema);
        }
        ResultSet rs = null;
        for (String schema : schList) {
            List list = (List)tmap.get(schema);
            String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
            String sql = "select table_name," + (dbaUser ? "OWNER" : "TABLE_SCHEMA") + ",column_name, grantee, PRIVILEGE, GRANTABLE from " + (dbaUser ? "dba_col_privs" : "all_col_privs");
            sql = sql + " where " + (dbaUser ? "OWNER" : "TABLE_SCHEMA") + " = ? and " + incl;
            try {
                statement = con.prepareStatement(sql);
                statement.setString(1, schema);
                int k = 1;
                for (String tname : list) {
                    statement.setString(++k, tname);
                }
                rs = statement.executeQuery();
                while (rs.next()) {
                    String tname = rs.getString(1);
                    DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                    try {
                        this.setColPrivileges(rs, dbo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void setPrivilege(ResultSet rs, DBObject dbo) throws Exception {
        if (rs != null) {
            String objectType = dbo.getType();
            StorageObject storageObject = null;
            if (storageObject == null && (storageObject = this.findStorageObject(dbo)) == null) {
                return;
            }
            String grantee = rs.getString("GRANTEE");
            String privilegeName = rs.getString("PRIVILEGE");
            String withGrantOption = rs.getString("GRANTABLE");
            String withHierarchyOption = rs.getString("HIERARCHY");
            UserOracle user = null;
            RoleOracle role = null;
            if (grantee.equals("PUBLIC") || this.allUserNames.contains(grantee)) {
                UserSetOracle userSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet();
                user = (UserOracle)userSetOracle.getByName(grantee);
                if (user == null) {
                    user = userSetOracle.createUser();
                    user.setName(grantee);
                    this.stampModelObject((ModelObject)user, "", grantee);
                }
            } else {
                RoleSetOracle roleSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getRoleSet();
                role = (RoleOracle)roleSetOracle.getByName(grantee);
                if (role == null) {
                    role = roleSetOracle.createRole();
                    role.setName(grantee);
                    this.stampModelObject((ModelObject)role, "", grantee);
                }
            }
            PermissionsOracle perm = this.getPermissionsObject(objectType, storageObject, user, role);
            if (perm == null) {
                perm = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                perm.setUser(user);
                perm.setRole(role);
                if ("TABLE".equals(objectType)) {
                    if (storageObject instanceof SnapshotOracle) {
                        perm.setSnapshot((SnapshotOracle)storageObject);
                    } else {
                        perm.setTable((TableProxyOracle)storageObject);
                    }
                } else if ("VIEW".equals(objectType)) {
                    perm.setView((TableViewProxyOracle)storageObject);
                } else if ("SEQUENCE".equals(objectType)) {
                    perm.setSequence((SequenceOracle)storageObject);
                } else if ("FUNCTION".equals(objectType)) {
                    perm.setFunctionOracle((FunctionOracle)storageObject);
                } else if ("PACKAGE".equals(objectType)) {
                    perm.setPackage((PackageOracle)storageObject);
                } else if ("PROCEDURE".equals(objectType)) {
                    perm.setProc((StoredProcedureOracle)storageObject);
                } else if ("COLLECTION".equals(objectType)) {
                    perm.setCollectionTypeOracle((CollectionTypeProxyOracle)storageObject);
                } else if ("OBJECT".equals(objectType)) {
                    perm.setStructuredTypeOracle((StructuredTypeProxyOracle)storageObject);
                } else if ("EXTERNAL TABLE".equals(objectType)) {
                    perm.setExternalTableOracle((ExternalTableOracle)storageObject);
                } else if ("DIRECTORY".equals(objectType)) {
                    perm.setDirectoryOracle((DirectoryOracle)storageObject);
                } else {
                    perm.remove(true);
                }
            }
            if (withGrantOption.equals("YES")) {
                perm.setPrivilegesWithGrantOption(privilegeName);
            } else {
                perm.setPrivileges(privilegeName);
            }
            if (withHierarchyOption.equals("YES")) {
                perm.setPrivilegesWithHierarchyOption(privilegeName);
            }
        }
    }

    private void setColPrivileges(ResultSet rs, DBObject dbo) throws Exception {
        if (rs != null) {
            TableProxyOracle tableProxy = null;
            if (tableProxy == null && (tableProxy = (TableProxyOracle)this.findStorageObject(dbo)) == null) {
                return;
            }
            String grantee = rs.getString("GRANTEE");
            String columnName = rs.getString("COLUMN_NAME");
            String privilegeName = rs.getString("PRIVILEGE");
            String withGrantOption = rs.getString("GRANTABLE");
            UserOracle user = null;
            RoleOracle role = null;
            if (grantee.equals("PUBLIC") || this.allUserNames.contains(grantee)) {
                UserSetOracle userSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet();
                user = (UserOracle)userSetOracle.getByName(grantee);
                if (user == null) {
                    user = userSetOracle.createUser();
                    user.setName(grantee);
                    this.stampModelObject((ModelObject)user, "", grantee);
                }
            } else {
                RoleSetOracle roleSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getRoleSet();
                role = (RoleOracle)roleSetOracle.getByName(grantee);
                if (role == null) {
                    role = roleSetOracle.createRole();
                    role.setName(grantee);
                    this.stampModelObject((ModelObject)role, "", grantee);
                }
            }
            PermissionsOracle perm = this.getColumnPermissionsObject(columnName, tableProxy, user, role);
            if (perm == null) {
                perm = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                perm.setUser(user);
                perm.setRole(role);
                perm.setColumnsTable(tableProxy);
            }
            String colNameAndPrivilege = columnName + ", " + privilegeName;
            if (withGrantOption.equals("YES")) {
                perm.setColumnListWithGrantOption(colNameAndPrivilege);
            } else {
                perm.setColumnList(colNameAndPrivilege);
            }
        }
    }

    boolean shouldProcess(AbstractMOHandler mh) {
        String objectType = mh.getType();
        return "TABLE".equals(objectType) || "VIEW".equals(objectType) || "SEQUENCE".equals(objectType) || "FUNCTION".equals(objectType) || "PACKAGE".equals(objectType) || "PROCEDURE".equals(objectType) || "COLLECTION".equals(objectType) || "OBJECT".equals(objectType) || "EXTERNAL TABLE".equals(objectType) || "DIRECTORY".equals(objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setObjectPrivileges(DBObject dbo, Connection sqlConnection) throws Exception {
        block43: {
            ResultSet rs = null;
            String objectType = dbo.getType();
            if ("TABLE".equals(objectType) || "VIEW".equals(objectType) || "SEQUENCE".equals(objectType) || "FUNCTION".equals(objectType) || "PACKAGE".equals(objectType) || "PROCEDURE".equals(objectType) || "COLLECTION".equals(objectType) || "OBJECT".equals(objectType) || "EXTERNAL TABLE".equals(objectType) || "DIRECTORY".equals(objectType)) {
                try {
                    if (this.objectPrivilegesStmt == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("GRANTEE").append(',');
                        buffer.append("PRIVILEGE").append(',');
                        buffer.append("GRANTABLE").append(',');
                        buffer.append("HIERARCHY").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_tab_privs" : "all_tab_privs").append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append(this.dbaUser ? "OWNER" : "TABLE_SCHEMA").append('=').append('?').append(' ');
                        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
                        this.objectPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
                    }
                    String schema = dbo.getSchema();
                    if ("DIRECTORY".equals(objectType)) {
                        schema = "SYS";
                    }
                    this.objectPrivilegesStmt.setString(1, schema);
                    this.objectPrivilegesStmt.setString(2, dbo.getName());
                    rs = this.objectPrivilegesStmt.executeQuery();
                    if (rs != null) {
                        StorageObject storageObject = null;
                        while (rs.next() && (storageObject != null || (storageObject = this.findStorageObject(dbo)) != null)) {
                            String grantee = rs.getString("GRANTEE");
                            String privilegeName = rs.getString("PRIVILEGE");
                            String withGrantOption = rs.getString("GRANTABLE");
                            String withHierarchyOption = rs.getString("HIERARCHY");
                            UserOracle user = null;
                            RoleOracle role = null;
                            if (grantee.equals("PUBLIC") || this.allUserNames.contains(grantee)) {
                                UserSetOracle userSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet();
                                user = (UserOracle)userSetOracle.getByName(grantee);
                                if (user == null) {
                                    user = userSetOracle.createUser();
                                    user.setName(grantee);
                                    this.stampModelObject((ModelObject)user, "", grantee);
                                }
                            } else {
                                RoleSetOracle roleSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getRoleSet();
                                role = (RoleOracle)roleSetOracle.getByName(grantee);
                                if (role == null) {
                                    role = roleSetOracle.createRole();
                                    role.setName(grantee);
                                    this.stampModelObject((ModelObject)role, "", grantee);
                                }
                            }
                            PermissionsOracle perm = this.getPermissionsObject(objectType, storageObject, user, role);
                            if (perm == null) {
                                perm = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                                perm.setUser(user);
                                perm.setRole(role);
                                if ("TABLE".equals(objectType)) {
                                    if (storageObject instanceof SnapshotOracle) {
                                        perm.setSnapshot((SnapshotOracle)storageObject);
                                    } else {
                                        perm.setTable((TableProxyOracle)storageObject);
                                    }
                                } else if ("VIEW".equals(objectType)) {
                                    perm.setView((TableViewProxyOracle)storageObject);
                                } else if ("SEQUENCE".equals(objectType)) {
                                    perm.setSequence((SequenceOracle)storageObject);
                                } else if ("FUNCTION".equals(objectType)) {
                                    perm.setFunctionOracle((FunctionOracle)storageObject);
                                } else if ("PACKAGE".equals(objectType)) {
                                    perm.setPackage((PackageOracle)storageObject);
                                } else if ("PROCEDURE".equals(objectType)) {
                                    perm.setProc((StoredProcedureOracle)storageObject);
                                } else if ("COLLECTION".equals(objectType)) {
                                    perm.setCollectionTypeOracle((CollectionTypeProxyOracle)storageObject);
                                } else if ("OBJECT".equals(objectType)) {
                                    perm.setStructuredTypeOracle((StructuredTypeProxyOracle)storageObject);
                                } else if ("EXTERNAL TABLE".equals(objectType)) {
                                    perm.setExternalTableOracle((ExternalTableOracle)storageObject);
                                } else if ("DIRECTORY".equals(objectType)) {
                                    perm.setDirectoryOracle((DirectoryOracle)storageObject);
                                } else {
                                    perm.remove(true);
                                }
                            }
                            if (withGrantOption.equals("YES")) {
                                perm.setPrivilegesWithGrantOption(privilegeName);
                            } else {
                                perm.setPrivileges(privilegeName);
                            }
                            if (!withHierarchyOption.equals("YES")) continue;
                            perm.setPrivilegesWithHierarchyOption(privilegeName);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (SQLException se) {
                    if (se.getMessage().startsWith("ORA-00942")) {
                        LOGGER.error("MOHUserOracle.setObjectPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_tab_privs" : "all_tab_privs"));
                    } else {
                        LOGGER.error("MOHUserOracle.setObjectPrivileges():", se);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHUserOracle.setObjectPrivileges():", e);
                    break block43;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
    }

    private StorageObject findStorageObject(DBObject dbObject) {
        return this.findStorageObject(dbObject, false);
    }

    private StorageObject findStorageObject(DBObject dbObject, boolean useSnapshot) {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        String objectType = dbObject.getType();
        String objectName = dbObject.getName();
        String owner = dbObject.getSchema();
        if ("TABLE".equals(objectType)) {
            SnapshotOracle snapshot;
            TableProxyOracle tableProxy = (TableProxyOracle)dbObject.getTableProxy();
            if (tableProxy == null) {
                tableProxy = (TableProxyOracle)storageDesign.getTableProxySet().getByUserSchemaAndName(owner, objectName);
            }
            if (tableProxy != null && useSnapshot && (snapshot = tableProxy.getSnapshot()) != null) {
                return snapshot;
            }
            return tableProxy;
        }
        if ("VIEW".equals(objectType)) {
            return storageDesign.getTableViewProxySet().getBySchemaAndName(owner, objectName);
        }
        if ("SEQUENCE".equals(objectType)) {
            return (SequenceOracle)storageDesign.getSequenceSet().getByUserSchemaAndName(owner, objectName);
        }
        if ("FUNCTION".equals(objectType)) {
            return storageDesign.getFunctionSet().getByOwnerAndName(owner, objectName);
        }
        if ("PACKAGE".equals(objectType)) {
            return storageDesign.getPackageSet().getByOwnerAndName(owner, objectName);
        }
        if ("PROCEDURE".equals(objectType)) {
            return storageDesign.getStoredProcedureSet().getByOwnerAndName(owner, objectName);
        }
        if ("COLLECTION".equals(objectType)) {
            return storageDesign.getCollectionTypeProxySet().getByOwnerAndName(owner, objectName);
        }
        if ("OBJECT".equals(objectType)) {
            return storageDesign.getStructuredTypeProxySet().getBySchemaAndName(owner, objectName);
        }
        if ("EXTERNAL TABLE".equals(objectType)) {
            return storageDesign.getExternalTableSet().getByOwnerAndName(owner, objectName);
        }
        if ("DIRECTORY".equals(objectType)) {
            return (DirectoryOracle)storageDesign.getDirectorySet().getByName(objectName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setColumnPrivileges(DBObject dbo, Connection sqlConnection) throws Exception {
        block19: {
            if ("TABLE".equals(dbo.getType())) {
                ResultSet rs = null;
                try {
                    if (this.columnPrivilegesStmt == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("GRANTEE").append(',');
                        buffer.append("COLUMN_NAME").append(',');
                        buffer.append("PRIVILEGE").append(',');
                        buffer.append("GRANTABLE").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_col_privs" : "all_col_privs").append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append(this.dbaUser ? "OWNER" : "TABLE_SCHEMA").append('=').append('?').append(' ');
                        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
                        this.columnPrivilegesStmt = sqlConnection.prepareStatement(buffer.toString());
                    }
                    this.columnPrivilegesStmt.setString(1, dbo.getSchema());
                    this.columnPrivilegesStmt.setString(2, dbo.getName());
                    rs = this.columnPrivilegesStmt.executeQuery();
                    if (rs != null) {
                        TableProxyOracle tableProxy = null;
                        while (rs.next() && (tableProxy != null || (tableProxy = (TableProxyOracle)this.findStorageObject(dbo)) != null)) {
                            String grantee = rs.getString("GRANTEE");
                            String columnName = rs.getString("COLUMN_NAME");
                            String privilegeName = rs.getString("PRIVILEGE");
                            String withGrantOption = rs.getString("GRANTABLE");
                            UserOracle user = null;
                            RoleOracle role = null;
                            if (grantee.equals("PUBLIC") || this.allUserNames.contains(grantee)) {
                                UserSetOracle userSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet();
                                user = (UserOracle)userSetOracle.getByName(grantee);
                                if (user == null) {
                                    user = userSetOracle.createUser();
                                    user.setName(grantee);
                                    this.stampModelObject((ModelObject)user, "", grantee);
                                }
                            } else {
                                RoleSetOracle roleSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getRoleSet();
                                role = (RoleOracle)roleSetOracle.getByName(grantee);
                                if (role == null) {
                                    role = roleSetOracle.createRole();
                                    role.setName(grantee);
                                    this.stampModelObject((ModelObject)role, "", grantee);
                                }
                            }
                            PermissionsOracle perm = this.getColumnPermissionsObject(columnName, tableProxy, user, role);
                            if (perm == null) {
                                perm = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                                perm.setUser(user);
                                perm.setRole(role);
                                perm.setColumnsTable(tableProxy);
                            }
                            String colNameAndPrivilege = columnName + ", " + privilegeName;
                            if (withGrantOption.equals("YES")) {
                                perm.setColumnListWithGrantOption(colNameAndPrivilege);
                                continue;
                            }
                            perm.setColumnList(colNameAndPrivilege);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (SQLException se) {
                    if (se.getMessage().startsWith("ORA-00942")) {
                        LOGGER.error("MOHUserOracle.setColumnPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_col_privs" : "all_col_privs"));
                    } else {
                        LOGGER.error("MOHUserOracle.setColumnPrivileges():", se);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHUserOracle.setColumnPrivileges():", e);
                    break block19;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
    }

    private PermissionsOracle getColumnPermissionsObject(String columnName, TableProxyOracle tableProxy, UserOracle user, RoleOracle role) {
        for (PermissionsOracle perm : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            String permColumnName;
            if (perm.getColumnsTable() != tableProxy || perm.getUser() != user || perm.getRole() != role) continue;
            String permColumnList = perm.getColumnList();
            if (permColumnList.isEmpty()) {
                permColumnList = perm.getColumnWithGrantOptionList();
            }
            if (!(permColumnName = permColumnList.substring(0, permColumnList.indexOf(44))).equalsIgnoreCase(columnName)) continue;
            return perm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract User begin");
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        try (Statement statement = sqlConnection.createStatement();){
            ResultSet rs = null;
            try {
                String filterCondition = this.getFilterConditionOracle("USERNAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("USERNAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_users" : "all_users").append(' ');
                if (filterCondition != null) {
                    buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ').append("USERNAME");
                rs = statement.executeQuery(buffer.toString());
                if (rs != null) {
                    while (rs.next()) {
                        String userName = rs.getString(1);
                        this.allUserNames.add(userName);
                        DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), userName, OBJECT_TYPE);
                        list.add(dboUser);
                    }
                    rs.close();
                }
                Closeables.close((Object)rs);
            }
            catch (Exception e) {
                LOGGER.error("MOHUserOracle.extract():", e);
            }
            finally {
                Closeables.close(rs);
            }
            statement.close();
        }
        TimeLog.log("Extract User end");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        this.objectPrivilegesStmt = null;
        this.columnPrivilegesStmt = null;
        TimeLog.log("User - postgenerate start");
        try {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            if (storageDesign != null) {
                UserSetOracle userSet = storageDesign.getUserSet();
                for (DBObject dbObj : this.handledObjects) {
                    UserOracle user;
                    if (dbObj == null || (user = (UserOracle)userSet.getByName(dbObj.getName())) == null) continue;
                    RelationalDesign rd = this.getDesign().getRelationalDesign();
                    SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(user.getName());
                    if (so == null) {
                        so = rd.getSchemaObjectSet().createSchemaObject(null);
                        so.setName(user.getName());
                        if (!user.getName().equals(user.getName().toUpperCase())) {
                            so.setNameHasQuotes(true);
                        }
                        this.stampModelObject((ModelObject)so, "", user.getName());
                    }
                    user.setSchemaObject(so);
                }
                for (AbstractMOHandler mohObject : this.getDbmeHandler().getMOHObjects()) {
                    Iterator<DBObject> objectIterator = mohObject.getHandledObjects().iterator();
                    ArrayList<DBObject> selected = new ArrayList<DBObject>();
                    ArrayList<DBObject> tables = new ArrayList<DBObject>();
                    while (objectIterator.hasNext()) {
                        DBObject dbo = objectIterator.next();
                        if (!dbo.isSelected()) continue;
                        selected.add(dbo);
                        if (!"TABLE".equals(dbo.getType())) continue;
                        tables.add(dbo);
                    }
                    this.processObjectPrivileges(sqlConnection, selected, this.dbaUser);
                    if (tables.size() <= 0) continue;
                    this.processColumnPrivileges(sqlConnection, tables, this.dbaUser);
                }
                if (this.objectPrivilegesStmt != null) {
                    try {
                        this.objectPrivilegesStmt.close();
                    }
                    catch (Exception mohObject) {
                        // empty catch block
                    }
                    this.objectPrivilegesStmt = null;
                }
                if (this.columnPrivilegesStmt != null) {
                    try {
                        this.columnPrivilegesStmt.close();
                    }
                    catch (Exception mohObject) {
                        // empty catch block
                    }
                    this.columnPrivilegesStmt = null;
                }
                this.allUserNames.clear();
                Iterator it = this.getDesign().getRelationalDesign().getSchemaObjectSet().iterator();
                while (it.hasNext()) {
                    SchemaObject so = (SchemaObject)it.next();
                    UserOracle user = (UserOracle)userSet.getByName(so.getName());
                    if (user == null) continue;
                    user.setSchemaObject(so);
                }
            }
            TimeLog.log("User - postgenerate end");
        }
        catch (Exception exception) {
            Closeables.close((Object[])new PreparedStatement[]{this.objectPrivilegesStmt, this.columnPrivilegesStmt});
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{this.objectPrivilegesStmt, this.columnPrivilegesStmt});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.objectPrivilegesStmt, this.columnPrivilegesStmt});
    }

    private PermissionsOracle getPermissionsObject(String objectType, StorageObject storageObject, UserOracle user, RoleOracle role) {
        for (PermissionsOracle perm : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (perm.getUser() != user || perm.getRole() != role) continue;
            StorageObject permissionObject = null;
            if ("TABLE".equals(objectType)) {
                permissionObject = storageObject instanceof SnapshotOracle ? perm.getSnapshot() : perm.getTable();
            } else if ("VIEW".equals(objectType)) {
                permissionObject = perm.getView();
            } else if ("SEQUENCE".equals(objectType)) {
                permissionObject = perm.getSequence();
            } else if ("FUNCTION".equals(objectType)) {
                permissionObject = perm.getFunctionOracle();
            } else if ("PACKAGE".equals(objectType)) {
                permissionObject = perm.getPackage();
            } else if ("PROCEDURE".equals(objectType)) {
                permissionObject = perm.getProc();
            } else if ("COLLECTION".equals(objectType)) {
                permissionObject = perm.getCollectionTypeOracle();
            } else if ("OBJECT".equals(objectType)) {
                permissionObject = perm.getStructuredTypeOracle();
            } else if ("EXTERNAL TABLE".equals(objectType)) {
                permissionObject = perm.getExternalTableOracle();
            } else if ("DIRECTORY".equals(objectType)) {
                permissionObject = perm.getDirectoryOracle();
            }
            if (permissionObject != storageObject) continue;
            return perm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setQuotas(UserOracle user, Connection sqlConnection) throws Exception {
        block17: {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            if (storageDesign != null) {
                ResultSet rs = null;
                try {
                    if (this.quotasStmt == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT");
                        buffer.append(' ').append("TABLESPACE_NAME");
                        if (this.dbaUser) {
                            buffer.append(',').append("USERNAME");
                        }
                        buffer.append(',').append("MAX_BYTES");
                        buffer.append(' ').append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_ts_quotas" : "user_ts_quotas").append(' ');
                        String whereKeyword = "WHERE";
                        if (storageDesign instanceof StorageDesignOraclev11g) {
                            buffer.append("WHERE").append(' ');
                            buffer.append("DROPPED").append('=').append("'").append("NO").append("'").append(' ');
                            whereKeyword = "AND";
                        }
                        if (this.dbaUser) {
                            buffer.append(whereKeyword).append(' ');
                            buffer.append("USERNAME").append('=').append('?');
                        }
                        this.quotasStmt = sqlConnection.prepareStatement(buffer.toString());
                    }
                    if (this.dbaUser) {
                        this.quotasStmt.setString(1, user.getName());
                    }
                    if ((rs = this.quotasStmt.executeQuery()) != null) {
                        while (rs.next()) {
                            String tsName = rs.getString("TABLESPACE_NAME");
                            String maxBytes = rs.getString("MAX_BYTES");
                            if (maxBytes.trim().equals("-1")) {
                                maxBytes = "UNLIMITED";
                            }
                            QuotaItemOracle qi = storageDesign.getQuotaItemSet().createQuotaItem();
                            TableSpaceOracle tSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                            qi.setTableSpace(tSpace);
                            qi.setSize(maxBytes);
                            qi.setUser(user);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (SQLException se) {
                    block18: {
                        if (se.getMessage().startsWith("ORA-00942")) {
                            LOGGER.error("MOHUserOracle.setQuotas(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_ts_quotas" : "user_ts_quotas"));
                            break block18;
                        }
                        LOGGER.error("MOHUserOracle.setQuotas():", se);
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHUserOracle.setQuotas():", e);
                    break block17;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
    }
}

