/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHTempTableSpaceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TEMP TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTempTableSpaceOracle.class);
    protected boolean dbaUser;

    public MOHTempTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHTempTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ResultSet rs;
        Statement statement;
        ArrayList<DBObject> list;
        block6: {
            list = new ArrayList<DBObject>();
            statement = sqlConnection.createStatement();
            rs = null;
            try {
                String filterCondition = this.getFilterConditionOracle("TABLESPACE_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLESPACE_NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("TABLESPACE_NAME").append(' ');
                buffer.append("NOT").append(' ').append("IN").append(' ');
                buffer.append('(').append('\'');
                buffer.append("SYSTEM").append('\'').append(')').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("CONTENTS").append('=').append('\'');
                buffer.append("TEMPORARY").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
                buffer.append("LOCAL").append('\'').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append("TABLESPACE_NAME");
                rs = statement.executeQuery(buffer.toString());
                if (rs == null) break block6;
                while (rs.next()) {
                    String clusterName = rs.getString(1);
                    DBObject dboSynonym = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), clusterName, OBJECT_TYPE);
                    list.add(dboSynonym);
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("MOHTempTableSpaceOracle.extract():", e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        PreparedStatement statement = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("INITIAL_EXTENT");
        boolean includeGroupName = false;
        if (storageDesign instanceof StorageDesignOraclev10g) {
            includeGroupName = this.dbaUser;
            buffer.append(',');
            buffer.append("BIGFILE");
            if (includeGroupName) {
                buffer.append(',').append("GROUP_NAME");
            }
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ').append("a");
        if (includeGroupName) {
            buffer.append(',').append("dba_tablespace_groups").append(' ').append("b");
        }
        buffer.append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a").append('.').append("TABLESPACE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("CONTENTS").append('=').append('\'');
        buffer.append("TEMPORARY").append('\'').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
        buffer.append("LOCAL").append('\'');
        if (includeGroupName) {
            buffer.append("AND").append(' ');
            buffer.append("a.").append("TABLESPACE_NAME").append('=').append("b.").append("TABLESPACE_NAME").append(' ').append("(+)");
        }
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo = (DBObject)selectedObjects.get(i);
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    statement.setString(1, dbo.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        if (rs.next()) {
                            if (storageDesign instanceof StorageDesignOracle) {
                                long bytes;
                                TemporaryTablespaceOracle tableSpace = ((StorageDesignOracle)storageDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
                                tableSpace.setName(dbo.getName());
                                String size = rs.getString("INITIAL_EXTENT");
                                try {
                                    bytes = Long.parseLong(size);
                                }
                                catch (Exception e1) {
                                    LOGGER.error("MOHTempTableSpaceOracle.generate(): Error parsing \"INITIAL_EXTENT\" - " + size);
                                    bytes = 1024L;
                                }
                                if (bytes % 1024L == 0L) {
                                    tableSpace.setUniformSize(bytes / 1024L);
                                    tableSpace.setMeasureUnitUniformSize("K");
                                } else {
                                    tableSpace.setUniformSize(bytes);
                                    tableSpace.setMeasureUnitUniformSize("");
                                }
                                if (tableSpace instanceof TemporaryTablespaceOraclev10g) {
                                    String groupName;
                                    TemporaryTablespaceOraclev10g tablespace10g = (TemporaryTablespaceOraclev10g)tableSpace;
                                    String bigfile = rs.getString("BIGFILE");
                                    if ("YES".equals(bigfile)) {
                                        tablespace10g.setFileType(TemporaryTablespaceOraclev10g.BIGFILE);
                                    } else if ("NO".equals(bigfile)) {
                                        tablespace10g.setFileType(TemporaryTablespaceOraclev10g.SMALLFILE);
                                    }
                                    if (includeGroupName && (groupName = rs.getString("GROUP_NAME")) != null) {
                                        tablespace10g.setTableSpaceGroup(groupName);
                                    }
                                }
                                this.stampModelObject(tableSpace, dbo);
                            } else {
                                LOGGER.error("Unable to find Storage Design!");
                            }
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTempTableSpaceOracle.generate():", e);
                }
                finally {
                    Closeables.close(rs);
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
        }
        finally {
            Closeables.close(statement);
        }
    }
}

