/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.lang.invoke.CallSite;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.imports.metadata.oracle.CheckConstraintsImport;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.UpdatableStatus;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SupplementalLogGroup;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.TableProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.TableProxyOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;

public abstract class MOHTableOracle
extends MOHTable {
    private boolean isPartitioned;
    private boolean containsClusterRefs;
    private boolean containsXMLTypeTables;
    private boolean maskTemplatesAdded = false;
    private static final Logger LOGGER = new Logger(MOHTableOracle.class);
    private final String NOT_NULL_PATTERN = " IS NOT NULL";
    private final Map ukMap = new TreeMap();
    private final List fkTempList = new ArrayList();
    protected Map colMap = new TreeMap();
    private PreparedStatement reg_mview_statement = null;
    private PreparedStatement mview_comments = null;
    private PreparedStatement rb_st = null;
    public static final String NEW_AS = "NEW AS";
    public static final String OLD_AS = "OLD AS";
    public static final String PARENT_AS = "PARENT AS";
    public final String DESC = "DESC";
    protected static String SYSTEM_NAME_PREFIX = "SYS_";
    protected boolean dbaUser;
    protected MOHViewOracle viewHandlerOracle;
    protected MOHBitmapIndexesv10g bitmapJoinIndexHandler;
    static int batchCount = 800;
    private PreparedStatement indpartype_st = null;
    private PreparedStatement indglobpartcols_st = null;
    private PreparedStatement indpart_st = null;
    PreparedStatement part_statement = null;
    PreparedStatement partLS_statement = null;
    PreparedStatement subpartCol_statement = null;
    PreparedStatement subpartTemplate_statement = null;
    PreparedStatement subPartTemplateLS_statement = null;
    PreparedStatement subPart_statement = null;
    PreparedStatement subPartLS_statement = null;
    String CWD_TS_TAB_META = "<cwd_ts_tab ";
    String CWD_TS_COLUMN_META = "<cwd_ts_column ";

    public MOHTableOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHTableOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    private String getTablesQuery(StorageDesign storageDesign, String inClause) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("a.").append("OWNER").append(',');
        buffer.append("a.").append("TABLE_NAME").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("CLUSTER_NAME").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("PCT_USED").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("DEGREE").append(',');
        buffer.append("CACHE").append(',');
        buffer.append("PARTITIONED").append(',');
        buffer.append("IOT_TYPE").append(',');
        buffer.append("OBJECT_ID_TYPE").append(',');
        buffer.append("TABLE_TYPE_OWNER").append(',');
        buffer.append("a.").append("TABLE_TYPE").append(',');
        buffer.append("TEMPORARY").append(',');
        buffer.append("DURATION").append(',');
        buffer.append("BUFFER_POOL").append(',');
        buffer.append("ROW_MOVEMENT").append(',');
        if (storageDesign instanceof StorageDesignOraclev9i) {
            buffer.append("MONITORING").append(',');
        } else {
            buffer.append("DEPENDENCIES").append(',');
            buffer.append("COMPRESSION").append(',');
            if (storageDesign instanceof StorageDesignOraclev11g) {
                buffer.append("COMPRESS_FOR").append(',');
                if (storageDesign instanceof StorageDesignOraclev12cR2) {
                    buffer.append("INMEMORY").append(',');
                    buffer.append("INMEMORY_PRIORITY").append(',');
                    buffer.append("INMEMORY_DISTRIBUTE").append(',');
                    buffer.append("INMEMORY_COMPRESSION").append(',');
                    buffer.append("INMEMORY_DUPLICATE").append(',');
                }
            }
        }
        buffer.append("QUERY").append(',');
        buffer.append("UPDATABLE").append(',');
        buffer.append("MASTER_ROLLBACK_SEG").append(',');
        buffer.append("REWRITE_ENABLED").append(',');
        buffer.append("REFRESH_MODE").append(',');
        buffer.append("REFRESH_METHOD").append(',');
        buffer.append("BUILD_MODE").append(',');
        buffer.append("USE_NO_INDEX").append(',');
        buffer.append("UNKNOWN_TRUSTED_FD").append(' ');
        if (storageDesign instanceof StorageDesignOraclev12cR2) {
            buffer.append(',').append("ON_QUERY_COMPUTATION").append(' ');
        }
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ').append("a").append(',');
        buffer.append(this.dbaUser ? "dba_mviews" : "all_mviews").append(' ').append("b").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("OWNER").append('=');
        buffer.append('?').append(' ');
        buffer.append("AND").append(' ').append(inClause);
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=').append("b.").append("MVIEW_NAME").append(' ').append("(+)").append(' ');
        return buffer.toString();
    }

    @Override
    public int getCountOfObjectsToProcess(List selected) {
        int res = 0;
        for (DBObject dbo : selected) {
            if (!"TABLE".equalsIgnoreCase(dbo.getType()) && !"EXTERNAL TABLE".equalsIgnoreCase(dbo.getType())) continue;
            ++res;
        }
        return res;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        try {
            this.generate(sqlConnection, selectedObjects, importLog, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(Connection sqlConnection, List objects, ImportLogger importLog, String indexOwner, String indName) throws Exception {
        List list;
        Iterator iterator;
        List lists;
        String schema;
        Iterator iterator2;
        List<DBObject> dbos;
        int processedCount;
        ArrayList<String> schList;
        HashMap<String, List<List<DBObject>>> masterMap;
        StorageDesignOracle storageDesign;
        block74: {
            this.maskTemplatesAdded = false;
            this.containsClusterRefs = false;
            this.containsXMLTypeTables = false;
            String extCheckDDL = "select 1 from " + (this.dbaUser ? "dba_external_tables" : "all_external_tables") + " where owner = ? and table_name = ?";
            this.ukMap.clear();
            this.fkTempList.clear();
            boolean checkExt = this.getDesign().getSettings().isCheckForExternalTable();
            boolean columnsOnly = this.getDesign().getSettings().isImportColumnsOnly();
            PreparedStatement ext_statement = null;
            storageDesign = (StorageDesignOracle)this.getStorageDesign();
            int cont_id = 0;
            boolean importCommentsInRDBMS = this.getDesign().getSettings().isImportCommentsInRDBMS();
            if (importCommentsInRDBMS && storageDesign instanceof StorageDesignOraclev12c) {
                String sql = "select SYS_CONTEXT('USERENV', 'CON_ID') ID FROM DUAL";
                PreparedStatement ps = null;
                try {
                    ps = sqlConnection.prepareStatement(sql);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs != null && rs.next()) {
                            cont_id = rs.getInt(1);
                        }
                        rs.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.Error in getting container ID", e);
                }
                finally {
                    Closeables.close((Object)ps);
                }
            }
            PreparedStatement statement = null;
            boolean allProps = true;
            long allObjects = this.getDbmeHandler().getAllObjects();
            long allProcessed = this.getDbmeHandler().getAllProcessed();
            UpdatableStatus upst = this.getDbmeHandler().getUpdatableStatus();
            ArrayList<DBObject> selectedObjects = new ArrayList<DBObject>();
            for (int i = 0; i < objects.size(); ++i) {
                DBObject dbo = (DBObject)objects.get(i);
                if (!"TABLE".equalsIgnoreCase(dbo.getType()) && !"EXTERNAL TABLE".equalsIgnoreCase(dbo.getType())) continue;
                if ("EXTERNAL TABLE".equalsIgnoreCase(dbo.getType())) {
                    dbo.externalTable = true;
                }
                selectedObjects.add(dbo);
            }
            if (selectedObjects.size() == 1) {
                DBObject dbo = (DBObject)selectedObjects.get(0);
                if (checkExt && !dbo.externalTable) {
                    ResultSet rs;
                    block71: {
                        rs = null;
                        try {
                            ext_statement = sqlConnection.prepareStatement(extCheckDDL);
                            ext_statement.setString(1, dbo.getSchema());
                            ext_statement.setString(2, dbo.getName());
                            rs = ext_statement.executeQuery();
                            if (!rs.next()) break block71;
                            dbo.setType("EXTERNAL TABLE");
                            dbo.externalTable = true;
                            rs.close();
                        }
                        catch (Exception exception) {
                            Closeables.close((Object[])new AutoCloseable[]{rs, ext_statement});
                            catch (Throwable throwable) {
                                Closeables.close((Object[])new AutoCloseable[]{rs, ext_statement});
                                throw throwable;
                            }
                        }
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, ext_statement});
                }
            }
            TimeLog.log("Tables begin");
            masterMap = new HashMap<String, List<List<DBObject>>>();
            schList = new ArrayList<String>();
            HashMap<String, DBObject> nmap = new HashMap<String, DBObject>();
            MOHTableOracle.prepareNameMapsRestricted(schList, masterMap, nmap, selectedObjects, batchCount);
            int count = this.getCountOfObjectsToProcess(selectedObjects);
            processedCount = 0;
            dbos = new ArrayList();
            try {
                iterator2 = schList.iterator();
                block24: while (true) {
                    block76: {
                        if (iterator2.hasNext()) break block76;
                        {
                            Closeables.close((Object[])new PreparedStatement[]{statement, this.reg_mview_statement, this.mview_comments, this.rb_st, ext_statement});
                            TimeLog.log("End Tables");
                            if (dbos.size() == 0) {
                                return;
                            }
                            if (indexOwner != null && indName != null && !indexOwner.isEmpty() && !indName.isEmpty()) {
                                this.initColumns(sqlConnection, dbos);
                                this.initIndexes(sqlConnection, dbos, importLog, indexOwner, indName);
                                this.setPartitionInfo(sqlConnection, storageDesign, dbos);
                                this.setIndexPartitioning(sqlConnection, storageDesign, dbos);
                                return;
                            }
                            break block77;
                        }
                    }
                    schema = (String)iterator2.next();
                    lists = (List)masterMap.get(schema);
                    iterator = lists.iterator();
                    {
                        block77: {
                            ResultSet rs;
                            while (true) {
                                block72: {
                                    if (!iterator.hasNext()) continue block24;
                                    list = (List)iterator.next();
                                    String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
                                    rs = null;
                                    String stat = this.getTablesQuery(storageDesign, incl);
                                    statement = sqlConnection.prepareStatement(stat);
                                    statement.setFetchSize(100);
                                    statement.setString(1, schema);
                                    int k = 1;
                                    for (DBObject d : list) {
                                        statement.setString(++k, d.getName());
                                    }
                                    rs = statement.executeQuery();
                                    Table table = null;
                                    TableProxyOracle tableProxy = null;
                                    try {
                                        if (rs == null) break block72;
                                        while (rs.next()) {
                                            String tname = rs.getString("TABLE_NAME");
                                            DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                                            if (dbo == null) continue;
                                            String ownerName = dbo.getSchema();
                                            String tableName = dbo.getName();
                                            this.isPartitioned = false;
                                            table = this.getDesign().getRelationalDesign().createTable();
                                            table.setSchema(dbo.getSchema());
                                            table.setDwhType(dbo.dwhType);
                                            if (dbo.joins != null && dbo.joins.size() > 0) {
                                                table.getImpliedFKeys().addAll(dbo.joins);
                                            }
                                            if (!dbo.getSchema().equals(dbo.getSchema().toUpperCase()) && table.getSchemaObject() != null) {
                                                table.getSchemaObject().setNameHasQuotes(true);
                                            }
                                            table.setName(dbo.getName());
                                            if (!dbo.getName().equals(dbo.getName().toUpperCase())) {
                                                table.setNameHasQuotes(true);
                                            }
                                            dbo.setTable(table);
                                            dbos.add(dbo);
                                            this.stampModelObject(table, dbo);
                                            String ob_id = rs.getString("OBJECT_ID_TYPE");
                                            String towner = rs.getString("TABLE_TYPE_OWNER");
                                            String type = rs.getString("TABLE_TYPE");
                                            this.initObjectType(table, towner, type, ob_id, dbo);
                                            if (storageDesign instanceof StorageDesignOracle) {
                                                tableProxy = (TableProxyOracle)table.getPhysicalPropertiesObject();
                                                if (tableProxy == null) {
                                                    tableProxy = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                                                }
                                                if (tableProxy == null) {
                                                    storageDesign.getTableProxySet().add(table);
                                                    tableProxy = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                                                }
                                                dbo.setTableProxy(tableProxy);
                                                if (tableProxy != null) {
                                                    tableProxy.setName(dbo.getName());
                                                    if (table.getSchemaObject() == null) {
                                                        this.setUser(tableProxy, storageDesign, dbo.getSchema());
                                                    }
                                                    this.setCluster(tableProxy, storageDesign, rs);
                                                    this.setProperties(tableProxy, storageDesign, rs, allProps);
                                                    this.setTableSpace(tableProxy, storageDesign, rs.getString("TABLESPACE_NAME"));
                                                } else {
                                                    LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID() + "  name " + table.getLongName());
                                                }
                                            } else {
                                                LOGGER.error("Unable to find Storage Design!");
                                            }
                                            if (this.isPartitioned && tableProxy != null) {
                                                dbo.partitioned = true;
                                            }
                                            if (dbo.externalTable) continue;
                                            if (!columnsOnly) {
                                                this.initSnapshot(sqlConnection, rs, tableProxy, dbo);
                                            }
                                            importLog.incrementImportedStatements();
                                            this.addToHandledObjects(dbo);
                                            if (upst == null || ++processedCount % 20 != 0) continue;
                                            int compl = processedCount * 100 / count;
                                            compl = (int)((double)compl * 0.6);
                                            upst.updateStatus(allProcessed + (long)processedCount, allObjects, "Import of tables - " + dbo.getSchema() + "." + dbo.getName());
                                        }
                                        rs.close();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        LOGGER.error("MOHTableOracle.generate():", e);
                                    }
                                    finally {
                                        Closeables.close((Object)rs);
                                    }
                                }
                                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                            }
                            catch (Throwable throwable) {}
                            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                            throw throwable;
                        }
                        iterator2 = schList.iterator();
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new PreparedStatement[]{statement, this.reg_mview_statement, this.mview_comments, this.rb_st, ext_statement});
                throw throwable;
            }
            block28: while (true) {
                if (!iterator2.hasNext()) {
                    if (this.getDesign().getSettings().isImportConstraints()) {
                        this.createFKeys(sqlConnection, this.fkTempList, this.ukMap);
                    }
                    break block74;
                }
                schema = (String)iterator2.next();
                lists = (List)masterMap.get(schema);
                iterator = lists.iterator();
                while (true) {
                    int size;
                    if (!iterator.hasNext()) continue block28;
                    list = (List)iterator.next();
                    dbos = list;
                    TimeLog.log("process Snapshot Refresh");
                    MOHTableOracle.processSnapshotRefresh(sqlConnection, dbos, this.dbaUser);
                    TimeLog.log("process Snapshot Comments");
                    MOHTableOracle.processSnapshotComments(sqlConnection, dbos, this.dbaUser);
                    if (storageDesign instanceof StorageDesignOraclev20c) {
                        MOHTableOracle.processBlockChainTables(sqlConnection, dbos, this.dbaUser);
                    }
                    if (this.containsXMLTypeTables && !columnsOnly) {
                        this.initXMLTypeTables(sqlConnection, dbos);
                        TimeLog.log("End XMLType Tables");
                    }
                    this.initColumns(sqlConnection, dbos);
                    TimeLog.log("End Columns");
                    if (importCommentsInRDBMS) {
                        MOHTableOracle.processTableComments(sqlConnection, dbos, cont_id, this.dbaUser);
                        MOHTableOracle.processColumnComments(sqlConnection, dbos, cont_id, this.dbaUser);
                        TimeLog.log("End Column comments");
                    }
                    if (columnsOnly) {
                        return;
                    }
                    if (this.containsClusterRefs) {
                        this.initClusterColumns(sqlConnection, dbos);
                        TimeLog.log("End Cluster Columns");
                    }
                    this.initSpatialTable(sqlConnection, dbos);
                    TimeLog.log("End Spatial");
                    if (this.getDesign().getSettings().isImportIndexes()) {
                        this.initIndexes(sqlConnection, dbos, importLog, indexOwner, indName);
                        TimeLog.log("End Indexes");
                    }
                    if (this.getDesign().getSettings().isImportConstraints()) {
                        TimeLog.log("End Indexes");
                        this.initUK_PK_FK_Constraints(sqlConnection, dbos, this.ukMap, this.fkTempList);
                        TimeLog.log("End Constraints");
                        TimeLog.log("End Constraints");
                        TimeLog.log("Check Constraints begin");
                        CheckConstraintsImport ci = new CheckConstraintsImport(storageDesign, this.dbaUser, this.dbmeHandler);
                        ci.initCHECK_Constraints(sqlConnection, dbos);
                        TimeLog.log("Check Constraints  end");
                        if (this.getDesign().getSettings().isImportJSON_DataGuide()) {
                            this.initJSON_DataGuides(sqlConnection, dbos, this.dbaUser);
                        }
                    }
                    if (!this.getDbmeHandler().isTriggers()) continue;
                    this.initTableTriggers(sqlConnection, dbos, true);
                    TimeLog.log("End Triggers");
                    if (upst == null || (size = storageDesign.getTriggerSet().size()) <= 0) continue;
                    upst.updateStatus(allProcessed + (long)(processedCount += size), allObjects + (long)size, "Import of tables - processing triggers");
                    if (upst.isCancelled()) break block28;
                }
                break;
            }
            return;
        }
        this.fkTempList.clear();
        TimeLog.log("End FKeys");
        iterator2 = schList.iterator();
        block30: while (true) {
            if (!iterator2.hasNext()) {
                this.setCountOfProcessedObjedcts(processedCount);
                return;
            }
            schema = (String)iterator2.next();
            lists = (List)masterMap.get(schema);
            iterator = lists.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block30;
                list = (List)iterator.next();
                dbos = list;
                if (this.getDbmeHandler().isPartitions()) {
                    this.setPartitionInfo(sqlConnection, storageDesign, dbos);
                    TimeLog.log("End Table Partitions");
                    this.setIndexPartitioning(sqlConnection, storageDesign, dbos);
                    TimeLog.log("End Index Partitions");
                } else {
                    this.setSegmentForPartitionedTable(sqlConnection, storageDesign, dbos);
                }
                if (this.getDesign().getSettings().isIncludeStorageInDDL()) {
                    this.setTableLobStorage(storageDesign, sqlConnection, dbos);
                    if (this.getDbmeHandler().isPartitions()) {
                        this.setTablePartLobStorage(storageDesign, sqlConnection, dbos);
                    }
                    TimeLog.log("End Lob Storage");
                }
                if (this.getDesign().getSettings().isIncludeSupplementalLogInDDL()) {
                    this.initSupplementalLog(sqlConnection, dbos);
                    TimeLog.log("End SupplementalLog");
                }
                if (this.dbaUser && this.getDesign().getSettings().isIncludeRedactionInDDL()) {
                    this.addRedactionPolicies(sqlConnection, dbos);
                }
                if (this.maskTemplatesAdded) {
                    // empty if block
                }
                TimeLog.log("End Redaction Policies");
                TimeLog.log("Tables end");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processBlockChainTables(Connection con, List selectedObjects, boolean dbaUser) {
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, selectedObjects);
        ResultSet rs = null;
        for (String schema : schList) {
            List list = (List)tmap.get(schema);
            String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
            String sql = "select table_name, TABLE_INACTIVITY_RETENTION, ROW_RETENTION , ROW_RETENTION_LOCKED , HASH_ALGORITHM from " + (dbaUser ? "DBA_BLOCKCHAIN_TABLES" : "ALL_BLOCKCHAIN_TABLES");
            sql = sql + " where schema_name = ? and " + incl;
            try {
                statement = con.prepareStatement(sql);
                statement.setString(1, schema);
                int k = 1;
                for (String tname : list) {
                    statement.setString(++k, tname);
                }
                rs = statement.executeQuery();
                if (rs == null) continue;
                while (rs.next()) {
                    String tname = rs.getString(1);
                    String tret = rs.getString(2);
                    String rowret = rs.getString(3);
                    String locked = rs.getString(4);
                    String hash = rs.getString(5);
                    DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                    TableProxy t = dbo.getTableProxy();
                    if (t == null || !(t instanceof TableProxyOraclev20c)) continue;
                    TableProxyOraclev20c tp = (TableProxyOraclev20c)t;
                    tp.setBlockChainTable(true);
                    if (tret != null) {
                        tp.setTableDropRetentionDays(tret);
                    }
                    if (rowret != null) {
                        tp.setRowDeleteRetentionDays(rowret);
                    }
                    if ("YES".equalsIgnoreCase(locked)) {
                        tp.setRowDeleteRetentionLock(true);
                    }
                    tp.setBlockChainHashAlgorithm(hash);
                }
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                Logger.error(e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    Logger.error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processSnapshotRefresh(Connection con, List<DBObject> selectedObjects, boolean dbaUser) {
        ArrayList<DBObject> mviews = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObjects) {
            SnapshotOracle sn;
            if (dbo.getTableProxy() == null || ((TableProxyOracle)dbo.getTableProxy()).getSnapshot() == null || (sn = ((TableProxyOracle)dbo.getTableProxy()).getSnapshot()).getOnPrebuildTable() != null) continue;
            sn.setRefreshQueryProcessed(false);
            mviews.add(dbo);
        }
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, mviews);
        for (String schema : schList) {
            ResultSet rs;
            block13: {
                List list = (List)tmap.get(schema);
                String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "name", 600) : MOHTableOracle.getInParamExpr(list.size(), "name");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("NAME").append(',');
                buffer.append("REFRESH_METHOD").append(' ');
                buffer.append("FROM").append(' ').append(dbaUser ? "dba_registered_mviews" : "all_registered_mviews").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append(incl);
                rs = null;
                try {
                    statement = con.prepareStatement(buffer.toString());
                    statement.setString(1, schema);
                    statement.setFetchSize(200);
                    int k = 1;
                    for (String tname : list) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    if (rs == null) break block13;
                    while (rs.next()) {
                        String tname = rs.getString("NAME");
                        DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                        SnapshotOracle snapshot = ((TableProxyOracle)dbo.getTableProxy()).getSnapshot();
                        if (snapshot == null) continue;
                        String refreshMethod = rs.getString("REFRESH_METHOD");
                        if (refreshMethod != null) {
                            if (refreshMethod.equalsIgnoreCase("PRIMARY KEY")) {
                                snapshot.setWith("PRIMARY KEY");
                            } else if (refreshMethod.equalsIgnoreCase("ROWID")) {
                                snapshot.setWith("ROWID");
                            }
                        }
                        snapshot.setRefreshQueryProcessed(true);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("MOHTableOracle.processSnapshotRefresh():", e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    continue;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
        for (DBObject dbo : mviews) {
            ContainerWithKeyObject cont;
            TableProxyOracle tp;
            SnapshotOracle sn;
            if (dbo.getTableProxy() == null || ((TableProxyOracle)dbo.getTableProxy()).getSnapshot() == null || (sn = ((TableProxyOracle)dbo.getTableProxy()).getSnapshot()).getOnPrebuildTable() != null || sn.isRefreshQueryProcessed() || (tp = sn.getImplementedTable()) == null || (cont = (ContainerWithKeyObject)tp.getObject()).getPK() == null) continue;
            sn.setWith("ROWID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processSnapshotComments(Connection con, List<DBObject> selectedObjects, boolean dbaUser) {
        ArrayList<DBObject> mviews = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObjects) {
            if (dbo.getTableProxy() == null || !((Table)dbo.getTable()).isMaterializedQueryTable()) continue;
            mviews.add(dbo);
        }
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, mviews);
        ResultSet rs = null;
        for (String schema : schList) {
            block8: {
                List list = (List)tmap.get(schema);
                String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "mview_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "mview_name");
                String sql = "select mview_name, comments from " + (dbaUser ? "dba_mview_comments" : "all_mview_comments");
                sql = sql + " where owner = ? and " + incl + " and comments is not null and instr(comments,'snapshot table for snapshot ') <> 1";
                try {
                    statement = con.prepareStatement(sql);
                    statement.setString(1, schema);
                    int k = 1;
                    for (String tname : list) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    if (rs == null) break block8;
                    while (rs.next()) {
                        String tname = rs.getString(1);
                        String comments = rs.getString(2);
                        DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                        if (dbo == null) continue;
                        dbo.getTable().setCommentInRDBMS(comments);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    try {
                        Logger.error(e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    continue;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
    }

    static void prepareNameMapsRestricted(List<String> schList, Map<String, List<List<DBObject>>> masterMap, Map<String, DBObject> nmap, List selectedObjects, int batchCount) {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String schema = dbo.getSchema();
            String name = dbo.getName();
            nmap.put(schema + "." + name, dbo);
            List<List<DBObject>> master = masterMap.get(schema);
            if (master == null) {
                master = new ArrayList<List<DBObject>>();
                masterMap.put(schema, master);
            }
            List<DBObject> list = MOHTableOracle.getFreeList(master, batchCount);
            list.add(dbo);
            if (schList.contains(schema)) continue;
            schList.add(schema);
        }
    }

    static List<DBObject> getFreeList(List<List<DBObject>> master, int batchCount) {
        for (List<DBObject> l : master) {
            if (l.size() >= batchCount) continue;
            return l;
        }
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        master.add(list);
        return list;
    }

    static void prepareNameMaps(List<String> schList, Map<String, List<String>> tmap, Map nmap, List selectedObjects) {
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, selectedObjects, false);
    }

    static void prepareNameMaps(List<String> schList, Map<String, List<String>> tmap, Map nmap, List selectedObjects, boolean skipExternal) {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (dbo.getTable() == null || skipExternal && dbo.externalTable) continue;
            String schema = dbo.getSchema();
            String name = dbo.getName();
            nmap.put(schema + "." + name, dbo);
            List<String> list = tmap.get(schema);
            if (list == null) {
                list = new ArrayList<String>();
                tmap.put(schema, list);
            }
            list.add(name);
            if (schList.contains(schema)) continue;
            schList.add(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processColumnComments(Connection con, List selectedObjects, int con_id, boolean dbaUser) {
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, selectedObjects);
        ResultSet rs = null;
        for (String schema : schList) {
            List list = (List)tmap.get(schema);
            String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
            String sql = "select table_name, column_name, comments from " + (dbaUser ? "dba_col_comments" : "all_col_comments");
            sql = sql + " where owner = ? and " + incl + " and comments is not null";
            if (con_id > 0) {
                sql = sql + " and ORIGIN_CON_ID = ? ";
            }
            try {
                statement = con.prepareStatement(sql);
                statement.setFetchSize(100);
                statement.setString(1, schema);
                int k = 1;
                for (String tname : list) {
                    statement.setString(++k, tname);
                }
                if (con_id > 0) {
                    statement.setInt(k + 1, con_id);
                }
                if ((rs = statement.executeQuery()) == null) continue;
                while (rs.next()) {
                    FKElement col;
                    String tname = rs.getString(1);
                    String cname = rs.getString(2);
                    String comments = rs.getString(3);
                    DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                    FKContainer table = dbo.getTable();
                    if (table == null || (col = (FKElement)table.getElementByName(cname)) == null) continue;
                    col.setCommentInRDBMS(comments);
                }
                rs.close();
            }
            catch (SQLException e) {
                Logger.error(e);
            }
            finally {
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    Logger.error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processTableComments(Connection con, List selectedObjects, int con_id, boolean dbaUser) {
        String schema;
        HashMap<String, ArrayList<String>> tmap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap<CallSite, FKContainer> nmap = new HashMap<CallSite, FKContainer>();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (dbo.getTable() == null || dbo.getTable() instanceof Table && ((Table)dbo.getTable()).isMaterializedQueryTable()) continue;
            schema = dbo.getSchema();
            String name = dbo.getName();
            nmap.put((CallSite)((Object)(schema + "." + name)), dbo.getTable());
            ArrayList<String> list = (ArrayList<String>)tmap.get(schema);
            if (list == null) {
                list = new ArrayList<String>();
                tmap.put(schema, list);
            }
            list.add(name);
            if (schList.contains(schema)) continue;
            schList.add(schema);
        }
        ResultSet rs = null;
        Iterator iterator = schList.iterator();
        while (iterator.hasNext()) {
            schema = (String)iterator.next();
            List list = (List)tmap.get(schema);
            String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
            String sql = "select table_name,  comments from " + (dbaUser ? "dba_tab_comments" : "all_tab_comments");
            sql = sql + " where owner = ? and " + incl + " and comments is not null";
            if (con_id > 0) {
                sql = sql + " and ORIGIN_CON_ID = ? ";
            }
            try {
                statement = con.prepareStatement(sql);
                statement.setFetchSize(100);
                statement.setString(1, schema);
                int k = 1;
                for (String tname : list) {
                    statement.setString(++k, tname);
                }
                if (con_id > 0) {
                    statement.setInt(k + 1, con_id);
                }
                rs = statement.executeQuery();
                while (rs.next()) {
                    String tname = rs.getString(1);
                    String comments = rs.getString(2);
                    FKContainer table = (FKContainer)nmap.get(schema + "." + tname);
                    if (table == null) continue;
                    table.setCommentInRDBMS(comments);
                }
                rs.close();
                Closeables.close((Object)rs);
                if (statement == null) continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                continue;
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            continue;
            finally {
                Closeables.close(rs);
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getInExpr(List<String> tables, String col) {
        Object res = "";
        boolean first = true;
        res = col + " in (";
        for (String t : tables) {
            if (first) {
                res = (String)res + "'" + StringUtilities.fixSingleQuoteInName(t) + "'";
                first = false;
                continue;
            }
            res = (String)res + ",'" + StringUtilities.fixSingleQuoteInName(t) + "'";
        }
        res = (String)res + ")";
        return res;
    }

    private String getInExpr(List<String> tables, String col, int num) {
        Object res = "(";
        boolean first = true;
        String cx = "(" + col + " in (";
        res = (String)res + cx;
        int k = 0;
        int rem = 1;
        for (String t : tables) {
            if (first) {
                res = (String)res + "'" + StringUtilities.fixSingleQuoteInName(t) + "'";
                first = false;
            } else {
                res = (String)res + ",'" + StringUtilities.fixSingleQuoteInName(t) + "'";
            }
            if ((rem = ++k % num) != 0) continue;
            res = (String)res + "))";
            if (k < tables.size()) {
                res = (String)res + " OR " + cx;
            }
            first = true;
        }
        if (rem > 0) {
            res = (String)res + "))";
        }
        res = (String)res + ")";
        return res;
    }

    public static String getInParamExpr(int tablesNum, String col) {
        Object res = "";
        boolean first = true;
        res = col + " in (";
        for (int i = 0; i < tablesNum; ++i) {
            if (first) {
                res = (String)res + " ? ";
                first = false;
                continue;
            }
            res = (String)res + ", ? ";
        }
        res = (String)res + ")";
        return res;
    }

    public static String getInParamExpr(int tablesNum, String col, int num) {
        Object res = "(";
        boolean first = true;
        String cx = "(" + col + " in (";
        res = (String)res + cx;
        int k = 0;
        int rem = 1;
        for (int i = 0; i < tablesNum; ++i) {
            if (first) {
                res = (String)res + " ? ";
                first = false;
            } else {
                res = (String)res + ", ? ";
            }
            rem = ++k % num;
            if (rem != 0) continue;
            res = (String)res + "))";
            if (k < tablesNum) {
                res = (String)res + " OR " + cx;
            }
            first = true;
        }
        if (rem > 0) {
            res = (String)res + "))";
        }
        res = (String)res + ")";
        return res;
    }

    public static String getInParamExprTwoNames(int tablesNum) {
        Object res = "";
        boolean first = true;
        res = "(";
        for (int i = 0; i < tablesNum; ++i) {
            if (first) {
                res = (String)res + "(?,?)";
                first = false;
                continue;
            }
            res = (String)res + ",(?,?)";
        }
        res = (String)res + ")";
        return res;
    }

    private void processObjects(Map<String, List<String>> tmap, Map<String, List<String>> vmap, List<String> schList, List<String> tables, List<String> views) {
        List<String> list;
        String name;
        String schema;
        int ind;
        if (tables != null) {
            for (String s : tables) {
                ind = s.indexOf(46);
                if (ind <= 0) continue;
                schema = s.substring(0, ind);
                name = s.substring(ind + 1);
                list = tmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
        }
        if (views != null) {
            for (String s : views) {
                ind = s.indexOf(46);
                if (ind <= 0) continue;
                schema = s.substring(0, ind);
                name = s.substring(ind + 1);
                list = vmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    vmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
        }
    }

    private void initSnapshot(Connection sqlConnection, ResultSet rs, TableProxyOracle tableProxy, DBObject dbo) throws SQLException {
        String query = rs.getString("QUERY");
        if (query != null) {
            String rt;
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            SnapshotOracle sn = storageDesign.getSnapshotSet().createSnapshot();
            sn.setUser(tableProxy.getUser());
            sn.setName(tableProxy.getName());
            sn.setNameHasQuotes(tableProxy.getNameHasQuotes());
            tableProxy.setSnapshot(sn);
            sn.setImplementedTableProxy(tableProxy);
            this.stampModelObject((ModelObject)sn, dbo.getSchema(), tableProxy.getName());
            ((Table)tableProxy.getObject()).setTypeID("4");
            String updatable = rs.getString("UPDATABLE");
            String rollback_seg = rs.getString("MASTER_ROLLBACK_SEG");
            String rewrite = rs.getString("REWRITE_ENABLED");
            String refresh_mode = rs.getString("REFRESH_MODE");
            String refresh_method = rs.getString("REFRESH_METHOD");
            String build_mode = rs.getString("BUILD_MODE");
            String no_index = rs.getString("USE_NO_INDEX");
            boolean realTime = false;
            if (storageDesign instanceof StorageDesignOraclev12cR2 && "Y".equalsIgnoreCase(rt = rs.getString("ON_QUERY_COMPUTATION"))) {
                realTime = true;
            }
            String trustedConstraints = rs.getString("UNKNOWN_TRUSTED_FD");
            Table table = (Table)tableProxy.getObject();
            if (table != null) {
                table.setMaterializedQueryTable(true);
                table.setUserDefinedSQL(query);
                table.setSnapshot(sn);
                if (table.getPK() == null) {
                    KeyObject[] keys = table.getKeys();
                    KeyObject key = null;
                    for (int k = 0; k < keys.length; ++k) {
                        Index ind = (Index)keys[k];
                        if ("".equals(ind.getIndexExpression()) || !"M_ROW$$".equalsIgnoreCase(ind.getIndexExpression().trim())) continue;
                        key = keys[k];
                        break;
                    }
                    if (key != null) {
                        sn.setWith("ROWID");
                        key.remove();
                    }
                }
            }
            if ("N".equals(updatable)) {
                sn.setForUpdate("NO");
            } else {
                sn.setForUpdate("YES");
            }
            if (sn instanceof SnapshotOraclev10g) {
                if ("Y".equals(trustedConstraints)) {
                    ((SnapshotOraclev10g)sn).setUsingConstraint(SnapshotOraclev10g.TRUSTED);
                } else {
                    ((SnapshotOraclev10g)sn).setUsingConstraint(SnapshotOraclev10g.ENFORCED);
                }
            }
            if (rollback_seg != null && !"".equals(rollback_seg)) {
                sn.setDefaultSegment("NO");
                sn.setSegmentType("MASTER");
                sn.setRollbackSegmentName(rollback_seg);
            }
            if (this.rb_st == null) {
                String view_name = this.dbaUser ? "sys.dba_refresh" : "sys.all_refresh";
                String sql = "select rollback_seg, to_char(next_date,'YYYY-MM-DD'), INTERVAL from " + view_name + " where rowner = ? and rname = ?";
                this.rb_st = sqlConnection.prepareStatement(sql);
            }
            this.rb_st.setString(1, dbo.getSchema());
            this.rb_st.setString(2, dbo.getName());
            try (ResultSet rsr = this.rb_st.executeQuery();){
                if (rsr != null && rsr.next()) {
                    rollback_seg = rsr.getString(1);
                    String startDate = rsr.getString(2);
                    String interval = rsr.getString(3);
                    if (rollback_seg != null && !rollback_seg.isEmpty()) {
                        sn.setDefaultSegment("NO");
                        sn.setSegmentType("LOCAL");
                        sn.setRollbackSegmentName(rollback_seg);
                    }
                    sn.setStartDate((String)(startDate != null ? "TO_DATE('" + startDate + "','YYYY-MM-DD')" : ""));
                    sn.setNextDate(interval != null ? interval.trim() : "");
                    if (startDate != null && !startDate.isEmpty() || interval != null && !interval.isEmpty()) {
                        sn.setAction("");
                    }
                }
            }
            if ("N".equalsIgnoreCase(rewrite)) {
                sn.setQueryRewrite("DISABLE");
            } else {
                sn.setQueryRewrite("ENABLE");
            }
            if ("N".equals(no_index)) {
                sn.setUseIndex("YES");
            } else {
                sn.setUseIndex("NO");
            }
            if (storageDesign instanceof StorageDesignOraclev12cR2) {
                ((SnapshotOraclev10g)sn).setOnQueryComputation(realTime);
            }
            if ("NEVER".equalsIgnoreCase(refresh_mode)) {
                sn.setRefresh("NEVER");
            } else {
                sn.setRefresh("YES");
                sn.setRefreshType(refresh_method);
                sn.setAction("ON " + refresh_mode);
            }
            if (build_mode.equalsIgnoreCase("PREBUILT")) {
                table.setOnPrebuiltTable(true);
                tableProxy.setSnapshot(null);
                sn.setOnPrebuildTable(tableProxy);
            } else {
                sn.setBuild(build_mode);
                sn.setTablespace(tableProxy.getTableSpace());
                sn.setParalelClause(tableProxy.getParallel());
                sn.setCache(tableProxy.getCache());
                try {
                    sn.setDegree(Integer.parseInt(tableProxy.getDegree()));
                }
                catch (NumberFormatException rsr) {
                    // empty catch block
                }
            }
            if (sn.getOnPrebuildTable() == null) {
                if (this.reg_mview_statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("REFRESH_METHOD").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_registered_mviews" : "all_registered_mviews").append(' ');
                    buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                    buffer.append("AND").append(' ').append("NAME").append('=').append('?');
                    this.reg_mview_statement = sqlConnection.prepareStatement(buffer.toString());
                }
                this.addRefreshMethod(this.reg_mview_statement, dbo.getSchema(), sn);
            }
            if (this.mview_comments == null) {
                String sql = "select comments from " + (this.dbaUser ? "dba_mview_comments" : "all_mview_comments") + " where owner = ? and mview_name = ?";
                this.mview_comments = sqlConnection.prepareStatement(sql);
            }
            this.mview_comments.setString(1, dbo.getSchema());
            this.mview_comments.setString(2, dbo.getName());
            try (ResultSet rsc = this.mview_comments.executeQuery();){
                if (rsc != null) {
                    while (rsc.next()) {
                        String comments = rsc.getString(1);
                        table.setCommentInRDBMS(comments);
                    }
                    rsc.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRefreshMethod(PreparedStatement reg_mview_statement, String owner, SnapshotOracle snapshot) throws SQLException {
        ContainerWithKeyObject cont;
        TableProxyOracle tp;
        ResultSet rs = null;
        boolean processed = false;
        try {
            reg_mview_statement.setString(1, owner);
            reg_mview_statement.setString(2, snapshot.getName());
            rs = reg_mview_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    processed = true;
                    String refreshMethod = rs.getString("REFRESH_METHOD");
                    if (refreshMethod == null) continue;
                    if (refreshMethod.equalsIgnoreCase("PRIMARY KEY")) {
                        snapshot.setWith("PRIMARY KEY");
                        continue;
                    }
                    if (!refreshMethod.equalsIgnoreCase("ROWID")) continue;
                    snapshot.setWith("ROWID");
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.addRefreshMethod():", e);
        }
        finally {
            Closeables.close(rs);
        }
        snapshot.setRefreshQueryProcessed(processed);
        if (!processed && (tp = snapshot.getImplementedTable()) != null && (cont = (ContainerWithKeyObject)tp.getObject()).getPK() != null) {
            snapshot.setWith("ROWID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSpatialTable(Connection sqlConnection, List dbos) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("DIMINFO").append(',');
        buffer.append("SRID").append(' ');
        buffer.append("FROM").append(' ').append("all_sdo_geom_metadata").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
        String sql = buffer.toString();
        PreparedStatement statement = null;
        try {
            for (DBObject dbo : dbos) {
                if (dbo.externalTable || dbo.getTable() == null) continue;
                Table table = (Table)dbo.getTable();
                boolean doQuery = this.getDbmeHandler().isSpatialProperties();
                if (!doQuery) {
                    for (Column column : table.getElementsCollection()) {
                        String type = column.getNativeDataType();
                        StructuredType colStructType = column.getStructuredType();
                        if (colStructType != null && column.getUse() == 3 && colStructType.getName().equals("SDO_GEOMETRY")) {
                            doQuery = true;
                            break;
                        }
                        if (this.getDesign().getSettings().isScanForUsedStructuredTypes() || type == null || !"MDSYS.SDO_GEOMETRY".equals(type) && !"SDO_GEOMETRY".equals(type)) continue;
                        doQuery = true;
                        break;
                    }
                }
                if (!doQuery) continue;
                String ownerName = dbo.getSchema();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, ownerName.toUpperCase());
                    statement.setString(2, table.getName().toUpperCase());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            Column column;
                            String table_name = rs.getString("TABLE_NAME");
                            String column_name = rs.getString("COLUMN_NAME");
                            if (table_name.equals("")) continue;
                            table.setSpatialTable(true);
                            SpatialColumnDefObject spaObject = new SpatialColumnDefObject(table);
                            table.addSpatialDefinition(spaObject);
                            Array diminfo = (Array)rs.getObject("DIMINFO");
                            Object[] objects = (Object[])diminfo.getArray();
                            for (int i = 0; i < objects.length; ++i) {
                                Struct str = (Struct)objects[i];
                                Object[] elems = str.getAttributes();
                                SpatialColumnDefObject.TableDimension dimension = new SpatialColumnDefObject.TableDimension(spaObject);
                                dimension.setName(elems[0].toString());
                                dimension.setLowBoundary(elems[1].toString());
                                dimension.setUpperBoundary(elems[2].toString());
                                dimension.setTolerance(elems[3].toString());
                            }
                            diminfo.free();
                            String srid = rs.getString("SRID");
                            if (srid != null) {
                                spaObject.setSystemID(srid);
                            }
                            if ((column = (Column)table.getElementByName(column_name)) != null) {
                                spaObject.setSpatialColumn(column);
                                continue;
                            }
                            spaObject.setFunction(true);
                            spaObject.setFuncExpression(column_name);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.initSpatialTable():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
    }

    private void initObjectType(Table table, String typeOwner, String typeName, String objectIDType, DBObject dbo) {
        if (typeName != null) {
            StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(typeName, typeOwner);
            if (stp != null && stp.getStructuredType() != null) {
                table.setBasedOnStructuredType(stp.getStructuredType());
                table.setBasedOnStructuredTypeLongName(typeOwner + "." + typeName);
            } else {
                table.setBasedOnStructuredTypeLongName(typeOwner + "." + typeName);
            }
            table.setOidIsPK("USER-DEFINED".equals(objectIDType));
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.containsXMLTypeTables = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initXMLTypeTables(Connection sqlConnection, List dbos) throws Exception {
        boolean oraclev11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("XMLSCHEMA").append(',');
        buffer.append("ELEMENT_NAME").append(',');
        buffer.append("STORAGE_TYPE");
        if (oraclev11g) {
            buffer.append(',');
            buffer.append("ANYSCHEMA").append(',');
            buffer.append("NONSCHEMA");
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_xml_tables" : "all_xml_tables").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append('?').append(' ');
        String sql = buffer.toString();
        PreparedStatement statement = null;
        try {
            for (DBObject dbo : dbos) {
                TableProxyOracle tableProxy;
                String basedOnTypeName;
                Table table;
                if (dbo.externalTable || !(table = (Table)dbo.getTable()).isBST()) continue;
                StructuredType basedOnType = table.getBasedOnStructuredType();
                if (basedOnType != null) {
                    basedOnTypeName = basedOnType.getName();
                } else {
                    String basedOnTypeLongName = table.getBasedOnStructuredTypeLongName();
                    basedOnTypeName = basedOnTypeLongName.substring(basedOnTypeLongName.indexOf(46) + 1);
                }
                if (!basedOnTypeName.equalsIgnoreCase("XMLTYPE") || (tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID())) == null) continue;
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, table.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        if (rs.next()) {
                            String xmlSchema = rs.getString("XMLSCHEMA");
                            String xmlElementName = rs.getString("ELEMENT_NAME");
                            String xmlStorageType = rs.getString("STORAGE_TYPE");
                            String anySchema = null;
                            String nonSchema = null;
                            if (oraclev11g) {
                                anySchema = rs.getString("ANYSCHEMA");
                                nonSchema = rs.getString("NONSCHEMA");
                            }
                            if (xmlSchema != null) {
                                tableProxy.setXmlSchemaUrl(xmlSchema);
                            }
                            if (xmlElementName != null) {
                                tableProxy.setXmlSchemaElement(xmlElementName);
                            }
                            if (xmlStorageType != null) {
                                if (xmlStorageType.equals("BINARY")) {
                                    xmlStorageType = "BINARY XML";
                                } else if (xmlStorageType.equals("OBJECT-RELATIONAL")) {
                                    xmlStorageType = "OBJECT RELATIONAL";
                                }
                                tableProxy.setStoreAs(xmlStorageType);
                            }
                            if (anySchema != null) {
                                ((TableProxyOraclev11g)tableProxy).setAllowAnySchema(anySchema);
                            }
                            if (nonSchema != null) {
                                ((TableProxyOraclev11g)tableProxy).setAllowNonSchema(nonSchema);
                            }
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOraclev9i.initXMLTypeTables():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FKTemp> getFKDefinitionsForPK_UK(Connection conn, Map<String, PK_UK_helper> keysMap, boolean dbaUser) {
        String sql = "SELECT\n    owner,\n    constraint_name,\n    table_name,\n    r_owner,\n    r_constraint_name,\n    delete_rule,\n    status,\n    deferrable,\n    deferred,\n    validated,\n    rely,\n    view_related\nFROM\n" + (dbaUser ? "   sys.dba_constraints\n" : "   sys.all_constraints\n") + "    where constraint_type = 'R'\n";
        ArrayList<FKTemp> list = null;
        for (int i = 0; i < keysMap.size(); ++i) {
            if (i == 0) {
                sql = sql + " and ( ";
                sql = sql + "(r_owner = ? and r_constraint_name =?)";
                continue;
            }
            sql = sql + " or (r_owner = ? and r_constraint_name =?)";
        }
        sql = sql + " )";
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sql);
                int k = 1;
                for (PK_UK_helper hlp : keysMap.values()) {
                    ps.setString(k, hlp.owner);
                    ps.setString(k + 1, hlp.name);
                    k += 2;
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (rs != null) {
                        while (rs.next()) {
                            FKTemp fk = new FKTemp();
                            if (list == null) {
                                list = new ArrayList<FKTemp>();
                            }
                            list.add(fk);
                            fk.owner = rs.getString(1);
                            fk.name = rs.getString(2);
                            fk.tname = rs.getString(3);
                            fk.UK_Owner = rs.getString(4);
                            fk.UK_Name = rs.getString(5);
                            fk.delete_rule = rs.getString(6);
                            fk.status = rs.getString(7);
                            fk.deferrable = rs.getString(8);
                            fk.deferred = rs.getString(9);
                            fk.validated = rs.getString(10);
                            fk.rely = rs.getString(11);
                            fk.onView = rs.getString(12) != null;
                            fk.hlp = keysMap.get(fk.UK_Owner + "." + fk.UK_Name);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        MOHTableOracle.processFKColomns(conn, list, dbaUser);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey_Providers(Connection conn, String schema) {
        ResultSet rs;
        PreparedStatement statement;
        Object res;
        block20: {
            res = "{\"items\":[";
            statement = null;
            rs = null;
            try {
                if (statement == null) {
                    Object sql = "select distinct  table_name,view_related \r\n";
                    sql = (String)sql + " from " + (this.dbaUser ? "dba_constraints" : "all_constraints") + " \r\n where owner = ? and constraint_type in ('P','U') and not (table_name like 'BIN%')\r\n order by table_name";
                    statement = conn.prepareStatement((String)sql);
                }
                statement.setString(1, schema);
                rs = statement.executeQuery();
                if (rs == null) break block20;
                boolean first = true;
                try {
                    while (rs.next()) {
                        String name = rs.getString(1);
                        String view_rel = rs.getString(2);
                        if (first) {
                            first = false;
                        } else {
                            res = (String)res + ",";
                        }
                        res = (String)res + "{\"schema\":\"" + schema + "\",";
                        res = (String)res + "\"name\":\"" + name + "\",";
                        String type = "TABLE";
                        if (view_rel != null && !view_rel.isEmpty()) {
                            type = "VIEW";
                        }
                        res = (String)res + "\"type\":\"" + type + "\"}";
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("MOHTableOracle.getMViews() - rs.next():", e);
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.error("MOHTableOracle.getMViews():", e);
                }
                catch (Throwable throwable) {
                    Closeables.close(rs);
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2) {
                            LOGGER.error("MOHTableOracle.getMViews():", e2);
                        }
                    }
                    throw throwable;
                }
                Closeables.close((Object)rs);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e3) {
                        LOGGER.error("MOHTableOracle.getMViews():", e3);
                    }
                }
            }
        }
        Closeables.close((Object)rs);
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableOracle.getMViews():", e);
            }
        }
        return (String)res + "]}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey_Provider(Connection conn, String schema, String name) {
        ResultSet rs;
        PreparedStatement statement;
        Object res;
        block13: {
            res = "{";
            statement = null;
            Settings s = this.getDesign().getSettings();
            ArrayList tables = new ArrayList();
            rs = null;
            try {
                if (statement == null) {
                    Object sql = "select a.constraint_name, column_name \n";
                    sql = (String)sql + " from " + (this.dbaUser ? "dba_constraints" : "all_constraints") + " a, " + (this.dbaUser ? "dba_cons_columns" : "all_cons_columns") + " b \n where a.owner = ? and a.table_name = ? and  constraint_type in ('P','U') \n and a.owner = b.owner and a.table_name = b.table_name and a.constraint_name = b.constraint_name \n order by constraint_name, position";
                    statement = conn.prepareStatement((String)sql);
                }
                statement.setString(1, schema);
                statement.setString(2, name);
                rs = statement.executeQuery();
                if (rs == null) break block13;
                String cur = "";
                boolean first = true;
                boolean cfirst = true;
                res = (String)res + "\"schema\":\"" + schema + "\",";
                res = (String)res + "\"name\":\"" + name + "\",";
                res = (String)res + "\"keys\": [";
                int count = 0;
                try {
                    while (rs.next()) {
                        String cname = rs.getString(1);
                        String column = rs.getString(2);
                        if (!cur.equals(cname)) {
                            cfirst = true;
                            cur = cname;
                            if (first) {
                                first = false;
                            } else {
                                res = (String)res + "]},";
                            }
                            res = (String)res + "{\"constraint\":\"" + cname + "\",";
                            res = (String)res + "\"columns\":[";
                        }
                        if (cfirst) {
                            cfirst = false;
                        } else {
                            res = (String)res + ",";
                        }
                        res = (String)res + "\"" + column + "\"";
                        ++count;
                    }
                    res = count > 0 ? (String)res + "]}]" : (String)res + "]";
                }
                catch (SQLException e) {
                    LOGGER.error("MOHTableOracle.getKey_Provider() - rs.next():", e);
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.error("MOHTableOracle.getMViews():", e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return (String)res + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConstraintColumns(Connection sqlConnection, List dbos, Map ukMap, List<FKTemp> fkTempList, List<ConstrHelper> clist) {
        if (fkTempList.size() > 0 || clist.size() > 0) {
            List<String> list;
            String name;
            String schema;
            HashMap tmap = new HashMap();
            ArrayList<String> schList = new ArrayList<String>();
            HashMap<CallSite, Object> nmap = new HashMap<CallSite, Object>();
            HashMap<CallSite, ArrayList<String>> cmap = new HashMap<CallSite, ArrayList<String>>();
            for (FKTemp fKTemp : fkTempList) {
                schema = fKTemp.owner;
                name = fKTemp.name;
                nmap.put((CallSite)((Object)(schema + "." + name)), fKTemp);
                list = (ArrayList<String>)tmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
            for (ConstrHelper constrHelper : clist) {
                schema = constrHelper.owner;
                name = constrHelper.cname;
                nmap.put((CallSite)((Object)(schema + "." + name)), constrHelper);
                list = (List)tmap.get(schema);
                if (list == null) {
                    list = new ArrayList();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
            for (String string : schList) {
                List list2 = (List)tmap.get(string);
                String incl = list2.size() > 990 ? MOHTableOracle.getInParamExpr(list2.size(), "CONSTRAINT_NAME", 600) : MOHTableOracle.getInParamExpr(list2.size(), "CONSTRAINT_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("OWNER").append(',');
                buffer.append("CONSTRAINT_NAME").append(',');
                buffer.append("COLUMN_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append(" and " + incl).append(' ');
                buffer.append("ORDER BY").append(' ').append("OWNER").append(',').append("CONSTRAINT_NAME").append(',').append("POSITION");
                String ncol_sql = buffer.toString();
                PreparedStatement ncol_st = null;
                ResultSet nrs = null;
                try {
                    ncol_st = sqlConnection.prepareStatement(ncol_sql);
                    ncol_st.setFetchSize(100);
                    ncol_st.setString(1, string);
                    int k = 1;
                    for (String string2 : list2) {
                        ncol_st.setString(++k, string2);
                    }
                    nrs = ncol_st.executeQuery();
                    if (nrs != null) {
                        String temp = "";
                        while (nrs.next()) {
                            String string3 = nrs.getString(1);
                            String cname = nrs.getString(2);
                            String colName = Token.removeQuotes(nrs.getString(3));
                            String lname = string3 + "." + cname;
                            ArrayList<String> cols = (ArrayList<String>)cmap.get(lname);
                            if (cols == null) {
                                cols = new ArrayList<String>();
                                cmap.put((CallSite)((Object)lname), cols);
                            }
                            cols.add(colName);
                        }
                        nrs.close();
                    }
                    for (Map.Entry entry : cmap.entrySet()) {
                        boolean valid;
                        Object obj = nmap.get(entry.getKey());
                        if (obj instanceof FKTemp) {
                            ((FKTemp)obj).columns.addAll((Collection)entry.getValue());
                            continue;
                        }
                        if (!(obj instanceof ConstrHelper)) continue;
                        ConstrHelper ch = (ConstrHelper)obj;
                        FKContainer table = (FKContainer)ch.key.getContainerWithKeyObject();
                        if (table == null || (valid = MOHTableOracle.initPK_UK_Columns(ch.key, (List)entry.getValue(), ch.cname))) continue;
                        ukMap.put(entry.getKey(), table);
                        ch.key.remove();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", e);
                }
                finally {
                    if (nrs != null) {
                        try {
                            nrs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (ncol_st == null) continue;
                    try {
                        ncol_st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUK_PK_FK_Constraints(Connection sqlConnection, List dbos, Map ukMap, List fkTempList) throws Exception {
        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("COLUMN_NAME").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME").append(',').append("POSITION").append(',').append("COLUMN_NAME");
        String ncol_sql = buffer.toString();
        Object ncol_st = null;
        TreeMap map = new TreeMap();
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        ArrayList<ConstrHelper> clist = new ArrayList<ConstrHelper>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, dbos);
        for (String schema : schList) {
            ResultSet rs;
            block79: {
                List tlist = (List)tmap.get(schema);
                String incl = tlist.size() > 990 ? MOHTableOracle.getInParamExpr(tlist.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(tlist.size(), "table_name");
                Table temp = null;
                statement = null;
                buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLE_NAME").append(',').append(' ');
                buffer.append("CONSTRAINT_NAME").append(',').append(' ');
                buffer.append("CONSTRAINT_TYPE").append(',').append(' ');
                buffer.append("DEFERRED").append(',').append(' ');
                buffer.append("STATUS").append(',').append(' ');
                buffer.append("DEFERRABLE").append(',').append(' ');
                buffer.append("VALIDATED").append(',').append(' ');
                if (storage instanceof StorageDesignOraclev12c) {
                    // empty if block
                }
                buffer.append("R_OWNER").append(',').append(' ');
                buffer.append("R_CONSTRAINT_NAME").append(',').append(' ');
                buffer.append("DELETE_RULE").append(',').append(' ');
                buffer.append("INDEX_NAME").append(',').append(' ');
                buffer.append("GENERATED").append(',').append(' ');
                buffer.append("RELY").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append("IN").append(' ');
                buffer.append('(').append("'P','U','R'").append(')').append(' ');
                buffer.append("AND").append(' ').append(incl);
                buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
                String sql = buffer.toString();
                boolean first = true;
                int uk_count = 0;
                String ownerName = schema;
                rs = null;
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    statement.setFetchSize(100);
                    statement.setString(1, ownerName);
                    int k = 1;
                    for (String tname : tlist) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    first = true;
                    if (rs == null) break block79;
                    while (rs.next()) {
                        String t_name = rs.getString(1);
                        DBObject dbo = (DBObject)nmap.get(schema + "." + t_name);
                        Table table = (Table)dbo.getTable();
                        TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                        if (table != temp) {
                            first = true;
                            temp = table;
                            uk_count = 0;
                        }
                        String constrName = rs.getString("CONSTRAINT_NAME");
                        String constrType = rs.getString("CONSTRAINT_TYPE");
                        String deferred = rs.getString("DEFERRED");
                        String status = rs.getString("STATUS");
                        String deferrable = rs.getString("DEFERRABLE");
                        String validated = rs.getString("VALIDATED");
                        String rely = rs.getString("RELY");
                        if (first) {
                            // empty if block
                        }
                        if ("R".equalsIgnoreCase(constrType)) {
                            FKTemp fktemp = new FKTemp();
                            fkTempList.add(fktemp);
                            fktemp.owner = ownerName;
                            fktemp.name = constrName;
                            fktemp.UK_Owner = rs.getString("R_OWNER");
                            fktemp.UK_Name = rs.getString("R_CONSTRAINT_NAME");
                            fktemp.delete_rule = rs.getString("DELETE_RULE");
                            fktemp.table = (Table)dbo.getTable();
                            this.initFK_Columns(map, constrName, fktemp.columns);
                            fktemp.deferred = deferred;
                            fktemp.status = status;
                            fktemp.deferrable = deferrable;
                            fktemp.validated = validated;
                            fktemp.rely = rely;
                            continue;
                        }
                        ConstrHelper ch = new ConstrHelper();
                        ch.owner = schema;
                        ch.cname = constrName;
                        clist.add(ch);
                        String ind_name = rs.getString("INDEX_NAME");
                        String generated = rs.getString("GENERATED");
                        Index index = null;
                        Index supportInd = null;
                        if (ind_name != null) {
                            supportInd = table.getIndexByName(ind_name);
                            if (!generated.equalsIgnoreCase("USER NAME")) {
                                if (constrName.equals(ind_name)) {
                                    index = table.getIndexByName(ind_name);
                                }
                            } else if (!constrName.equals(ind_name) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "P".equalsIgnoreCase(constrType)) {
                                index = table.getIndexByName(constrName);
                            }
                            if ("INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "P".equalsIgnoreCase(constrType)) {
                                if (index == null) {
                                    index = supportInd;
                                }
                                supportInd = null;
                            }
                        }
                        boolean newIndexCreated = false;
                        if ("P".equalsIgnoreCase(constrType) && table.isBST()) {
                            if (index != null) {
                                Index existingPK = (Index)table.getPK();
                                if (existingPK != null) {
                                    existingPK.getElementsCollection().clear();
                                    if (index != existingPK) {
                                        index.remove();
                                        index = existingPK;
                                    }
                                    ch.key = existingPK;
                                }
                                if (generated.equalsIgnoreCase("USER NAME")) {
                                    index.setName(constrName);
                                } else {
                                    index.setName(ind_name);
                                }
                            } else {
                                Index pk = (Index)table.getPK();
                                if (pk == null) {
                                    pk = table.createIndex();
                                }
                                String pkName = generated.equalsIgnoreCase("USER NAME") ? constrName : ind_name;
                                ch.key = pk;
                                pk.setName(pkName);
                                if (!pkName.equals(pkName.toUpperCase())) {
                                    pk.setNameHasQuotes(true);
                                }
                                this.stampModelObject((ModelObject)pk, table.getSchema(), pk.getName());
                                if ("".equals(pk.getIndexExpression())) {
                                    Column col = (Column)table.getOidElement();
                                    if (col != null) {
                                        pk.remove(col);
                                    }
                                    ArrayList<String> colNames = new ArrayList<String>();
                                    for (Column column : pk.getElementsCollection()) {
                                        colNames.add(column.getName());
                                    }
                                    Index idx = this.getIndexForColumnNames(table, colNames, pk);
                                    if (idx != null) {
                                        idx.remove();
                                    }
                                }
                            }
                        } else if (index == null) {
                            index = table.createIndex();
                            newIndexCreated = true;
                        }
                        if (index == null) continue;
                        ukMap.put(ownerName + constrName, index);
                        ch.key = index;
                        TableSpaceOracle tableSpace = null;
                        SegmentOracle segment = null;
                        String logging = "";
                        UserOracle user = null;
                        int compress = 0;
                        boolean partitioned = false;
                        IndexProxyOracle indexProxy = null;
                        IndexProxyOracle supIndProxy = null;
                        if (supportInd != null) {
                            indexProxy = (IndexProxyOracle)storage.getIndexProxySet().getProxy(supportInd.getObjectID());
                        } else {
                            supIndProxy = indexProxy = (IndexProxyOracle)storage.getIndexProxySet().getProxy(index.getObjectID());
                        }
                        if (indexProxy != null) {
                            tableSpace = indexProxy.getTableSpace();
                            segment = indexProxy.getSegment();
                            logging = indexProxy.getLogging();
                            user = indexProxy.getUser();
                            compress = indexProxy.getCompress();
                            partitioned = indexProxy.isPartitioned();
                        }
                        PKProxyOracle pkProxy = null;
                        UniqueOracle ukProxy = null;
                        IndexProxyOracle PKorUKProxy = null;
                        if ("U".equalsIgnoreCase(constrType)) {
                            index.setIndexState("Unique Constraint");
                            ukProxy = (UniqueOracle)storage.getUniqueSet().getProxy(index.getObjectID());
                            PKorUKProxy = ukProxy;
                            ++uk_count;
                        } else if ("P".equalsIgnoreCase(constrType) && !table.isBST()) {
                            SnapshotOracle sn;
                            index.setIndexState("Primary Constraint");
                            pkProxy = (PKProxyOracle)storage.getPKProxySet().getProxy(index.getObjectID());
                            PKorUKProxy = pkProxy;
                            if (tableProxy != null && (sn = tableProxy.getSnapshot()) != null && !sn.isRefreshQueryProcessed()) {
                                sn.setWith("ROWID");
                            }
                        }
                        if (PKorUKProxy != null) {
                            PKorUKProxy.setTableSpace(tableSpace);
                            PKorUKProxy.setLogging(logging);
                            PKorUKProxy.setUser(user);
                            PKorUKProxy.setCompress(compress);
                            PKorUKProxy.setPartitioned(partitioned);
                            if (pkProxy != null) {
                                pkProxy.setIndexSegment(segment);
                                if (status.equals("ENABLED")) {
                                    pkProxy.setEnable("YES");
                                } else {
                                    pkProxy.setEnable("NO");
                                }
                                if (deferrable.equals("DEFERRABLE")) {
                                    pkProxy.setDeferrable("YES");
                                } else {
                                    pkProxy.setDeferrable("NO");
                                }
                                if (deferred.equals("DEFERRED")) {
                                    pkProxy.setInitially("DEFERRED");
                                } else {
                                    pkProxy.setInitially("IMMEDIATE");
                                }
                                if (validated.equals("VALIDATED")) {
                                    pkProxy.setValidate("YES");
                                } else {
                                    pkProxy.setValidate("NO");
                                    if ("RELY".equals(rely)) {
                                        pkProxy.setRely("YES");
                                    }
                                }
                            } else if (ukProxy != null) {
                                ukProxy.setIndexSegment(segment);
                                if (status.equals("ENABLED")) {
                                    ukProxy.setEnable("YES");
                                } else {
                                    ukProxy.setEnable("NO");
                                }
                                if (deferrable.equals("DEFERRABLE")) {
                                    ukProxy.setDeferrable("YES");
                                } else {
                                    ukProxy.setDeferrable("NO");
                                }
                                if (deferred.equals("DEFERRED")) {
                                    ukProxy.setInitially("DEFERRED");
                                } else {
                                    ukProxy.setInitially("IMMEDIATE");
                                }
                                if (validated.equals("VALIDATED")) {
                                    ukProxy.setValidate("YES");
                                } else {
                                    ukProxy.setValidate("NO");
                                    if ("RELY".equals(rely)) {
                                        ukProxy.setRely("YES");
                                    }
                                }
                            }
                        }
                        boolean valid = true;
                        if (index.getElementsCollection().size() == 0) {
                            // empty if block
                        }
                        if (!valid || table.isBST() && !"".equals(index.getIndexExpression())) {
                            ukMap.put(ownerName + constrName, index.getTable());
                            index.remove();
                        } else if (PKorUKProxy != null) {
                            IndexProxyOracle idxProxy = null;
                            if (supIndProxy != null) {
                                idxProxy = supIndProxy;
                            } else {
                                Index idx = null;
                                idx = user != null ? table.getIndexByNameAndSchema(user.getName(), ind_name) : table.getIndexByName(ind_name);
                                if (idx == null) {
                                    ArrayList<String> colNames = new ArrayList<String>();
                                    for (Column column : index.getElementsCollection()) {
                                        colNames.add(column.getName());
                                    }
                                    idx = this.getIndexForColumnNames(table, colNames, index);
                                }
                                if (idx != null) {
                                    idxProxy = (IndexProxyOracle)storage.getIndexProxySet().getProxy(idx.getObjectID());
                                }
                            }
                            if (!newIndexCreated || supportInd != null) {
                                if (pkProxy != null) {
                                    if (!"INDEX".equalsIgnoreCase(tableProxy.getOrganization())) {
                                        pkProxy.setUsingIndex("BY INDEX NAME");
                                        pkProxy.setExistingIndex(idxProxy);
                                    }
                                } else if (ukProxy != null) {
                                    ukProxy.setUsingIndex("BY INDEX NAME");
                                    ukProxy.setExistingIndex(idxProxy);
                                }
                            }
                        }
                        if (index.isRemoved()) continue;
                        if (generated.equalsIgnoreCase("USER NAME")) {
                            index.setName(constrName);
                            if (!constrName.equals(constrName.toUpperCase())) {
                                index.setNameHasQuotes(true);
                            }
                            this.stampModelObject((ModelObject)index, table.getSchema(), index.getName());
                            continue;
                        }
                        String tname = table.getName();
                        String abbrname = table.getAbbreviation();
                        if (abbrname == null || "".equals(abbrname)) {
                            abbrname = tname;
                        }
                        index.setName(constrName);
                        this.stampModelObject((ModelObject)index, table.getSchema(), constrName);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    continue;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
        TimeLog.log("ConstraintColumns begin");
        MOHTableOracle.initConstraintColumns(sqlConnection, ukMap, fkTempList, clist, this.dbaUser);
        TimeLog.log("ConstraintColumns end");
    }

    private void processCheckConstr(Map map, DBObject dbo, String constrName, String deferred, String status, String deferrable, String validated, String condition) {
        Object colName;
        Column column;
        List columns = (List)map.get(constrName);
        TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
        Table table = (Table)dbo.getTable();
        if (columns != null && columns.size() == 1 && (column = (Column)table.getElementByName((String)(colName = (String)columns.get(0)))) != null) {
            String nn_pat = (String)colName + " IS NOT NULL";
            if (condition != null && nn_pat.equalsIgnoreCase(condition.trim().replaceAll("\"", ""))) {
                ColumnProxyOracle cp;
                column.setNullsAllowed(false);
                Column colOrNestedCol = (Column)table.getElementByName((String)colName);
                if (colOrNestedCol != null && (cp = (ColumnProxyOracle)tableProxy.getColumnProxy(colOrNestedCol.getObjectID())) != null) {
                    if ("ENABLED".equalsIgnoreCase(status)) {
                        cp.setNncEnable("YES");
                    } else {
                        cp.setNncEnable("NO");
                    }
                    if (deferrable.equals("DEFERRABLE")) {
                        cp.setNncDeferrable("YES");
                    } else {
                        cp.setNncDeferrable("NO");
                    }
                    if (deferred.equals("DEFERRED")) {
                        cp.setNncInitially("DEFERRED");
                    } else {
                        cp.setNncInitially("IMMEDIATE");
                    }
                    if (validated.equals("VALIDATED")) {
                        cp.setNncValidate("YES");
                    } else {
                        cp.setNncValidate("NO");
                    }
                    if (!constrName.startsWith("SYS_C") || !column.getDesign().getSettings().isReplaceSystemNamesDuringImport()) {
                        column.setNotNullConstraintName(constrName);
                    }
                }
                return;
            }
            if (column.getCheck() == null) {
                ColumnProxyOracle cp;
                String checkPart = condition;
                boolean separated = column.setSeparatedConstraints(condition);
                if (separated) {
                    checkPart = column.getSeparatedCheckConstraint();
                }
                if (!"".equals(checkPart)) {
                    CheckConstraint cconstraint = new CheckConstraint();
                    cconstraint.setDesign(table.getDesign());
                    cconstraint.setName(constrName);
                    this.stampModelObject((ModelObject)cconstraint, table.getName(), constrName);
                    RDBMSType rdbmsType = StorageDesignOraclev12c.RDBMS_TYPE;
                    if (this.getStorageDesign() != null) {
                        rdbmsType = this.getStorageDesign().getRDBMSType();
                    }
                    cconstraint.add(rdbmsType, checkPart);
                    column.setUseDomainConstraints(false);
                    column.setCheck(cconstraint);
                    column.setConstraintName(constrName);
                    column.setCheckConstraintValue(checkPart);
                }
                if (separated) {
                    String rangeList = column.getSeparatedRangeConstraint();
                    if (!"".equals(rangeList)) {
                        String[] rangeParts = rangeList.split(",");
                        int i = 0;
                        while (i < rangeParts.length) {
                            String rangeFrom = rangeParts[i++];
                            String rangeTo = rangeParts[i++];
                            AVT avt = new AVT(rangeFrom.trim(), rangeTo.trim(), "");
                            column.setUseDomainConstraints(false);
                            column.addAVT(avt);
                            column.setConstraintName(constrName);
                        }
                    }
                    String valueList = column.getSeparatedValueConstraint();
                    String likeList = column.getSeparatedLikeConstraint();
                    if (!"".equals(valueList) || !"".equals(likeList)) {
                        ConstraintEnumeration lov = new ConstraintEnumeration();
                        if (!valueList.isEmpty()) {
                            String[] valueParts = valueList.split(",");
                            for (int i = 0; i < valueParts.length; ++i) {
                                lov.add(valueParts[i].trim());
                            }
                        }
                        if (!likeList.isEmpty()) {
                            String[] likeParts = likeList.split(",");
                            for (int i = 0; i < likeParts.length; ++i) {
                                lov.add(likeParts[i].trim(), "LIKE");
                            }
                        }
                        column.setUseDomainConstraints(false);
                        column.setValueList(lov);
                        column.setConstraintName(constrName);
                    }
                }
                if ((cp = (ColumnProxyOracle)tableProxy.getColumnProxyByName((String)colName)) != null) {
                    if ("ENABLED".equalsIgnoreCase(status)) {
                        cp.setEnable("YES");
                    } else {
                        cp.setEnable("NO");
                    }
                    if (deferrable.equals("DEFERRABLE")) {
                        cp.setDeferrable("YES");
                    } else {
                        cp.setDeferrable("NO");
                    }
                    if (deferred.equals("DEFERRED")) {
                        cp.setInitially("DEFERRED");
                    } else {
                        cp.setInitially("IMMEDIATE");
                    }
                    if (validated.equals("VALIDATED")) {
                        cp.setValidate("YES");
                    } else {
                        cp.setValidate("NO");
                    }
                }
                return;
            }
        }
        if (columns != null && columns.size() > 1) {
            for (ValidTimeDimension validTimeDimension : table.getValidTimeDimensions()) {
                int lessThanIndex;
                String vdtName = validTimeDimension.getName();
                if (!constrName.startsWith(vdtName)) continue;
                boolean hasVDTRef = false;
                boolean hasOtherRef = false;
                for (String colName2 : columns) {
                    if (colName2.equals(vdtName)) {
                        hasVDTRef = true;
                        continue;
                    }
                    if (colName2.startsWith(vdtName + "_")) continue;
                    hasOtherRef = true;
                }
                if (!hasVDTRef && hasOtherRef) continue;
                String text = condition;
                if (text.startsWith("(")) {
                    text = Token.getValBetweenBrackets(text, 1);
                }
                if ((lessThanIndex = text.indexOf(60)) > -1) {
                    String startColName = Token.getFirstName(text.substring(0, lessThanIndex), '\"', '\"');
                    String endColName = Token.getFirstName(text.substring(lessThanIndex + 1), '\"', '\"');
                    Column startCol = (Column)table.getElementByName(startColName);
                    Column endCol = (Column)table.getElementByName(endColName);
                    if (startCol != null && endCol != null) {
                        validTimeDimension.setStartTimeColumn(startCol);
                        validTimeDimension.setEndTimeColumn(endCol);
                    }
                }
                return;
            }
        }
        TableLevelConstraint constraint = table.createCheckConstraint(constrName, condition);
        if (!constrName.equals(constrName.toUpperCase())) {
            constraint.setNameHasQuotes(true);
        }
        table.addCheckConstraint(constraint);
        this.stampModelObject((ModelObject)constraint, table.getSchema(), constrName);
        TableCheckConstraintOracle proxy = tableProxy.getTableConstraint(constraint);
        if (proxy != null) {
            if (status.equals("ENABLED")) {
                proxy.setEnable("YES");
            } else {
                proxy.setEnable("NO");
            }
            if (deferrable.equals("DEFERRABLE")) {
                proxy.setDeferrable("YES");
            } else {
                proxy.setDeferrable("NO");
            }
            if (deferred.equals("DEFERRED")) {
                proxy.setInitially("DEFERRED");
            } else {
                proxy.setInitially("IMMEDIATE");
            }
            if (validated.equals("VALIDATED")) {
                proxy.setValidate("YES");
            } else {
                proxy.setValidate("NO");
            }
        }
    }

    private static boolean initPK_UK_Columns(KeyObject index, List<String> list, String constrName) throws Exception {
        boolean valid = true;
        if (list != null) {
            Object ind_expr = "";
            boolean expr = false;
            boolean first = true;
            FKContainer table = (FKContainer)index.getContainerWithKeyObject();
            for (int i = 0; i < list.size(); ++i) {
                String colName = list.get(i);
                if (first) {
                    ind_expr = colName;
                    first = false;
                } else {
                    ind_expr = (String)ind_expr + "," + colName;
                }
                FKElement column = (FKElement)table.getElementByName(colName);
                if (column != null) {
                    if (column.getCollectionType() != null || column.getStructuredType() != null) {
                        valid = false;
                    }
                    index.add(column);
                    continue;
                }
                if (colName.startsWith("SYS_NC")) {
                    valid = false;
                }
                expr = true;
            }
            if (expr) {
                index.getElementsCollection().clear();
                index.setIndexExpression((String)ind_expr);
            }
        }
        return valid;
    }

    private void initFK_Columns(Map map, String constrName, List columns) throws Exception {
        List list = (List)map.get(constrName);
        if (list != null) {
            columns.addAll(list);
        }
    }

    public abstract void initColumns(Connection var1, List var2) throws Exception;

    protected void initClusterColumns(Connection sqlConnection, List dbos) throws Exception {
        String viewName = this.dbaUser ? "dba_clu_columns" : "user_clu_columns";
        String sql = this.getClusterColumnSql(viewName);
        try (PreparedStatement statement = sqlConnection.prepareStatement(sql);){
            for (DBObject dbo : dbos) {
                if (dbo.externalTable) continue;
                Table table = (Table)dbo.getTable();
                TableProxyOracle tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
                ClusterOracle cluster = tableProxy.getCluster();
                if (cluster == null) continue;
                String tableName = table.getName();
                String clusterName = cluster.getName();
                try {
                    statement.setString(1, tableName);
                    statement.setString(2, clusterName);
                    if (viewName.equals("dba_clu_columns")) {
                        statement.setString(3, dbo.getSchema());
                    }
                    ResultSet rs = statement.executeQuery();
                    try {
                        if (rs == null) continue;
                        HashMap<ClusterColumnOracle, ColumnProxy> map = new HashMap<ClusterColumnOracle, ColumnProxy>();
                        while (rs.next()) {
                            String tableColName = rs.getString("TAB_COLUMN_NAME");
                            String clusterColName = rs.getString("CLU_COLUMN_NAME");
                            ClusterColumnOracle clusterColumn = (ClusterColumnOracle)cluster.getColumnsCollection().getByName(clusterColName);
                            if (clusterColumn == null) continue;
                            map.put(clusterColumn, tableProxy.getColumnProxyByName(tableColName));
                        }
                        rs.close();
                        Iterator clusterColIt = cluster.getColumnsCollection().iterator();
                        while (clusterColIt.hasNext()) {
                            ColumnProxyOracle columnProxy = (ColumnProxyOracle)map.get(clusterColIt.next());
                            if (columnProxy == null) continue;
                            tableProxy.setClusterColumns(columnProxy.getObjectID());
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.initClusterColumns():", e);
                }
            }
        }
    }

    protected void initJSON_DataGuides(Connection sqlConnection, List dbos, boolean dbaUser) throws Exception {
        String json;
        Clob clob;
        ResultSet rs;
        String tableName;
        List<Column> columns;
        Table table;
        PreparedStatement statement;
        String sql;
        String schemaName = "";
        String cur_schema = "";
        try {
            schemaName = sqlConnection.getMetaData().getUserName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<DBObject> flat_dgs = new ArrayList<DBObject>();
        ArrayList<DBObject> hier_dgs = new ArrayList<DBObject>();
        for (DBObject dbo : dbos) {
            List<Column> columns2;
            Table table2;
            if (dbo.externalTable || (table2 = (Table)dbo.getTable()) == null || (columns2 = table2.getJSONColumnsIndexed()).size() <= 0) continue;
            if (!dbo.getSchema().equalsIgnoreCase(schemaName)) {
                flat_dgs.add(dbo);
                continue;
            }
            hier_dgs.add(dbo);
        }
        if (hier_dgs.size() > 0) {
            sql = "select DBMS_JSON.GET_INDEX_DATAGUIDE(?,?,DBMS_JSON.FORMAT_HIERARCHICAL, DBMS_JSON.PRETTY) from dual";
            statement = sqlConnection.prepareStatement(sql);
            try {
                for (DBObject dbo : hier_dgs) {
                    table = (Table)dbo.getTable();
                    columns = table.getJSONColumnsIndexed();
                    if (columns.size() <= 0) continue;
                    tableName = table.getName();
                    for (Column col : columns) {
                        try {
                            statement.setString(1, tableName);
                            statement.setString(2, col.getName());
                            rs = statement.executeQuery();
                            try {
                                if (rs == null) continue;
                                if (rs.next() && (clob = rs.getClob(1)) != null && (json = clob.getSubString(1L, (int)clob.length())) != null) {
                                    col.setJsonDataGuide(json);
                                }
                                rs.close();
                            }
                            finally {
                                if (rs == null) continue;
                                rs.close();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHTableOracle.initJSON_DataGuides(): hier dg", e);
                        }
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (flat_dgs.size() > 0) {
            sql = "select dataguide from all_json_dataguides where owner = ? and table_name= ? and column_name = ?";
            if (dbaUser) {
                sql = "select dataguide from dba_json_dataguides where owner = ? and table_name= ? and column_name = ?";
            }
            statement = sqlConnection.prepareStatement(sql);
            try {
                for (DBObject dbo : flat_dgs) {
                    table = (Table)dbo.getTable();
                    columns = table.getJSONColumnsIndexed();
                    if (columns.size() <= 0) continue;
                    tableName = table.getName();
                    for (Column col : columns) {
                        try {
                            statement.setString(1, table.getSchema());
                            statement.setString(2, tableName);
                            statement.setString(3, col.getName());
                            rs = statement.executeQuery();
                            try {
                                if (rs == null) continue;
                                if (rs.next() && (json = (clob = rs.getClob(1)).getSubString(1L, (int)clob.length())) != null) {
                                    col.setJsonDataGuide(json);
                                }
                                rs.close();
                            }
                            finally {
                                if (rs == null) continue;
                                rs.close();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHTableOracle.initJSON_DataGuides(): flat dg", e);
                        }
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    private String getClusterColumnSql(String viewName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CLU_COLUMN_NAME").append(',');
        buffer.append("TAB_COLUMN_NAME").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(viewName).append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("CLUSTER_NAME").append('=').append('?').append(' ');
        if (viewName.equals("dba_clu_columns")) {
            buffer.append("AND").append(' ');
            buffer.append("OWNER").append('=').append('?');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBObject> getIndexes(Connection sqlConnection, String schema) {
        ResultSet rs;
        PreparedStatement statement;
        ArrayList<DBObject> list;
        block8: {
            list = new ArrayList<DBObject>();
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("OWNER").append(',');
            buffer.append("a.").append("INDEX_NAME").append(',');
            buffer.append("INDEX_TYPE").append(',');
            buffer.append("a.").append("TABLE_OWNER").append(',');
            buffer.append("a.").append("TABLE_NAME").append(',');
            buffer.append("JOIN_INDEX").append(',');
            buffer.append("UNIQUENESS").append(',');
            buffer.append("PARTITIONED").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ').append("a").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("a.").append("INDEX_NAME");
            String sql = buffer.toString();
            int limit = this.getDbmeHandler().getLimit();
            if (limit > 0) {
                sql = this.getDbmeHandler().getPaginatedQuery(sql);
            }
            statement = null;
            rs = null;
            try {
                statement = sqlConnection.prepareStatement(sql);
                statement.setString(1, schema);
                rs = statement.executeQuery();
                if (rs == null) break block8;
                while (rs.next()) {
                    String name = rs.getString("INDEX_NAME");
                    String towner = rs.getString("TABLE_OWNER");
                    String tname = rs.getString("TABLE_NAME");
                    String itype = rs.getString("INDEX_TYPE");
                    String join = rs.getString("JOIN_INDEX");
                    String unique = rs.getString("UNIQUENESS");
                    String partitioned = rs.getString("PARTITIONED");
                    DBObject dbo = new DBObject(true, name, "INDEX", schema);
                    if ("YES".equalsIgnoreCase(partitioned)) {
                        dbo.partitioned = true;
                    }
                    if ("YES".equalsIgnoreCase(join)) {
                        dbo.join_index = true;
                    }
                    dbo.table_owner = towner;
                    dbo.table_name = tname;
                    dbo.index_type = itype;
                    dbo.uniqueness = unique;
                    list.add(dbo);
                }
            }
            catch (SQLException e) {
                try {
                    Logger.error(e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return list;
    }

    public void initIndexes(Connection sqlConnection, List dbos) throws Exception {
        this.initIndexes(sqlConnection, dbos, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initIndexes(Connection sqlConnection, List dbos, ImportLogger importLog, String indexOwner, String indName) throws Exception {
        PreparedStatement indexp_st = null;
        PSHolder psh = new PSHolder();
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("PCT_USED").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("IOT_TYPE").append(',');
        buffer.append("BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append('?').append(' ').append(" and TABLE_NAME like 'SYS\\_IOT\\_%' escape '\\' ");
        buffer.append("AND").append(' ');
        buffer.append("IOT_NAME").append('=').append('?');
        String overflowsql = buffer.toString();
        PreparedStatement overflow_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("OWNER").append(',');
        buffer.append("a.").append("INDEX_NAME").append(',');
        buffer.append("INDEX_TYPE").append(',');
        buffer.append("JOIN_INDEX").append(',');
        buffer.append("UNIQUENESS").append(',');
        buffer.append("PREFIX_LENGTH").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("PCT_THRESHOLD").append(',');
        buffer.append("INCLUDE_COLUMN").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("DEGREE").append(',');
        buffer.append("PARTITIONED").append(',');
        buffer.append("BUFFER_POOL").append(',');
        buffer.append("ITYP_OWNER").append(',');
        buffer.append("ITYP_NAME").append(',');
        buffer.append("PARAMETERS").append(',');
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append("VISIBILITY").append(',');
        }
        buffer.append("b").append('.').append("TABLE_OWNER").append(',');
        buffer.append("b").append('.').append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("DESCEND").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ').append("a").append(',');
        buffer.append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ').append("b").append(' ');
        buffer.append("WHERE").append(' ');
        if (indexOwner != null && indName != null && !indexOwner.isEmpty() && !indName.isEmpty()) {
            buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("a.").append("INDEX_NAME").append('=').append('?').append(' ');
        } else {
            buffer.append("a.").append("TABLE_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
        }
        buffer.append("AND").append(' ');
        buffer.append("OWNER").append('=').append("INDEX_OWNER").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("INDEX_NAME").append('=');
        buffer.append("b.").append("INDEX_NAME").append(' ').append("(+)").append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("OWNER").append(',').append("a.").append("INDEX_NAME").append(',').append("COLUMN_POSITION");
        String sql = buffer.toString();
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        try {
            for (DBObject dbo : dbos) {
                Table table;
                if (dbo.externalTable || (table = (Table)dbo.getTable()) == null) continue;
                try {
                    if (indexOwner != null && indName != null && !indexOwner.isEmpty() && !indName.isEmpty()) {
                        dbo.getTableProxy().setMarkedGenerate(false);
                        statement.setString(1, indexOwner);
                        statement.setString(2, indName);
                    } else {
                        statement.setString(1, dbo.getSchema());
                        statement.setString(2, dbo.getName());
                    }
                    ResultSet rs = statement.executeQuery();
                    try {
                        if (rs == null) continue;
                        boolean moreRows = rs.next();
                        while (moreRows) {
                            IndexProxyOracle indexProxy;
                            BitmapJoinIndexOracle bitmapIndex = null;
                            String indexName = rs.getString("INDEX_NAME");
                            String owner = rs.getString("OWNER");
                            String indexType = rs.getString("INDEX_TYPE");
                            String join = rs.getString("JOIN_INDEX");
                            if ("YES".equalsIgnoreCase(join)) {
                                UserOracle user;
                                bitmapIndex = ((StorageDesignOracle)this.getStorageDesign()).getBitmapJoinIndexSet().createBitmapJoinIndex();
                                bitmapIndex.setName(indexName);
                                bitmapIndex.setTableName(dbo.getName());
                                bitmapIndex.setTableOwner(dbo.getSchema());
                                bitmapIndex.setTable((TableProxyOracle)dbo.getTableProxy());
                                if (!indexName.equals(indexName.toUpperCase())) {
                                    bitmapIndex.setNameHasQuotes(true);
                                }
                                if ((user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(owner)) == null) {
                                    user = storageDesign.getUserSet().createUser();
                                    user.setName(owner);
                                    this.stampModelObject((ModelObject)user, "", owner);
                                }
                                bitmapIndex.setUser(user);
                            }
                            Index index = table.createIndex();
                            index.setName(indexName);
                            index.setSchemaObject(table.getSchemaObject());
                            if (!indexName.equals(indexName.toUpperCase())) {
                                index.setNameHasQuotes(true);
                            }
                            this.stampModelObject((ModelObject)index, table.getSchema(), indexName);
                            String uniquness = rs.getString("UNIQUENESS");
                            if ("UNIQUE".equalsIgnoreCase(uniquness)) {
                                index.setIndexState("Unique Plain Index");
                            }
                            if ((indexProxy = (IndexProxyOracle)storageDesign.getIndexProxySet().getProxy(index.getObjectID())) != null) {
                                SnapshotOracle sn;
                                String tableSpaceName = rs.getString("TABLESPACE_NAME");
                                this.setIndexTableSpace(indexProxy, storageDesign, tableSpaceName);
                                TableProxyOracle tp = (TableProxyOracle)dbo.getTableProxy();
                                if (bitmapIndex != null) {
                                    bitmapIndex.setTablespace(tableSpaceName);
                                }
                                List expressions = null;
                                boolean toremove = false;
                                if (indexType != null) {
                                    if (indexType.indexOf("FUNCTION") > -1 || indexType.indexOf("DOMAIN") > -1) {
                                        if (indexp_st == null) {
                                            StringBuffer ibuff = new StringBuffer();
                                            ibuff.append("SELECT").append(' ');
                                            ibuff.append("COLUMN_EXPRESSION").append(',').append("COLUMN_POSITION").append(' ');
                                            ibuff.append("FROM").append(' ');
                                            ibuff.append(this.dbaUser ? "dba_ind_expressions" : "all_ind_expressions").append(' ');
                                            ibuff.append("WHERE").append(' ').append("INDEX_OWNER").append('=').append('?').append(' ');
                                            ibuff.append("AND").append(' ').append("INDEX_NAME").append('=').append('?').append(' ');
                                            ibuff.append("ORDER BY").append(' ');
                                            ibuff.append("COLUMN_POSITION");
                                            String sqle = ibuff.toString();
                                            indexp_st = sqlConnection.prepareStatement(sqle);
                                        }
                                        expressions = this.setIndexExpression(sqlConnection, index, owner, indexName, indexp_st);
                                    } else if ("BITMAP".equalsIgnoreCase(indexType)) {
                                        indexProxy.setBitmapIndex(true);
                                        index.setBitmapIndex(true);
                                    } else {
                                        indexProxy.setBitmapIndex(false);
                                        if ("NORMAL/REV".equalsIgnoreCase(indexType)) {
                                            indexProxy.setSortedRows(IndexProxyOracle.REVERSE);
                                        }
                                    }
                                }
                                if ((sn = tp.getSnapshot()) != null && "YES".equalsIgnoreCase(sn.getUseIndex())) {
                                    Index pk = (Index)tp.getTable().getPK();
                                    boolean pkind = false;
                                    if (pk != null && pk.getUsingIndex() != null && index.getName().equalsIgnoreCase(pk.getUsedIndexName())) {
                                        pkind = true;
                                    }
                                    if (!pkind) {
                                        sn.setIndexTablespace(indexProxy.getTableSpace());
                                    }
                                }
                                String expres = index.getIndexExpression();
                                boolean is_expr = false;
                                if (!"".equals(expres)) {
                                    is_expr = true;
                                    if (sn != null) {
                                        if (expres.indexOf("SYS_OP_MAP_NONNULL") > -1) {
                                            toremove = true;
                                        } else if ("M_ROW$$".equalsIgnoreCase(expres.trim())) {
                                            toremove = true;
                                            sn.setWith("ROWID");
                                        }
                                        if (toremove) {
                                            index.remove();
                                            moreRows = rs.next();
                                            continue;
                                        }
                                    }
                                }
                                this.setIndexProperties(sqlConnection, table, indexProxy, storageDesign, rs, psh, bitmapIndex);
                                if (indexType != null && indexType.startsWith("IOT") && tp != null && "INDEX".equals(tp.getOrganization())) {
                                    String colMapKey;
                                    String colObjId;
                                    if (tp.getTableSpace() == null) {
                                        tp.setTableSpace(indexProxy.getTableSpace());
                                    }
                                    tp.setLogging(indexProxy.getLogging());
                                    tp.setSegment(indexProxy.getSegment());
                                    tp.setIotCompress(indexProxy.getCompress());
                                    tp.setIotPctThreshold(rs.getInt("PCT_THRESHOLD"));
                                    int includeColumn = rs.getInt("INCLUDE_COLUMN");
                                    if (includeColumn > 0 && this.colMap != null && (colObjId = (String)this.colMap.get(colMapKey = dbo.getSchema() + ":" + dbo.getName() + ":" + Integer.toString(includeColumn))) != null) {
                                        tp.setIotIncluding(tp.getColumnProxy(colObjId));
                                    }
                                    if (overflow_st == null) {
                                        overflow_st = sqlConnection.prepareStatement(overflowsql);
                                    }
                                    try {
                                        overflow_st.setString(1, dbo.getSchema());
                                        overflow_st.setString(2, dbo.getName());
                                        try (ResultSet overflowRS = overflow_st.executeQuery();){
                                            if (overflowRS != null) {
                                                while (overflowRS.next()) {
                                                    String iotType = overflowRS.getString("IOT_TYPE");
                                                    if (iotType == null) continue;
                                                    if (iotType.equals("IOT_OVERFLOW")) {
                                                        this.setOverflowProperties(tp, storageDesign, overflowRS);
                                                        continue;
                                                    }
                                                    if (!iotType.equals("IOT_MAPPING")) continue;
                                                    tp.setIOTMappingTable("YES");
                                                }
                                                overflowRS.close();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("MOHTableOracle.initIndexes():", e);
                                    }
                                }
                                Object ind_expr = "";
                                boolean hasUnrecognizedCol = false;
                                boolean first = true;
                                int col_pos = 1;
                                while (moreRows) {
                                    ExprHelp eh;
                                    if (first) {
                                        first = false;
                                    } else {
                                        moreRows = rs.next();
                                        if (!moreRows || !indexName.equals(rs.getString("INDEX_NAME")) || !owner.equals(rs.getString("OWNER"))) break;
                                    }
                                    if (bitmapIndex != null) {
                                        Column column;
                                        String descend;
                                        String oname = rs.getString("TABLE_OWNER");
                                        String tname = rs.getString("TABLE_NAME");
                                        String cname = rs.getString("COLUMN_NAME");
                                        ind_expr = cname;
                                        BitmapJoinIndexOracle.ColumnHolder ch = new BitmapJoinIndexOracle.ColumnHolder(oname, tname, cname);
                                        ch.sort = descend = rs.getString("DESCEND");
                                        bitmapIndex.getIndexColumnHolders().add(ch);
                                        Table ctable = this.getRelationalDesign().getTableSet().getBySchemaAndName(oname, tname);
                                        if (ctable == null || (column = (Column)ctable.getElementByName(cname)) == null) continue;
                                        bitmapIndex.setIndexColumns(column.getObjectID());
                                        bitmapIndex.setIndexColumns(descend);
                                        continue;
                                    }
                                    Object cname = rs.getString("COLUMN_NAME");
                                    if (cname == null) continue;
                                    String sortOrder = rs.getString("DESCEND");
                                    Column column = (Column)table.getElementByName((String)cname);
                                    String ciname = null;
                                    if (column == null && (eh = this.getExprByColPos(expressions, col_pos)) != null && (ciname = Token.getName(eh.expr)) != null) {
                                        column = (Column)table.getElementByName(ciname);
                                    }
                                    if (ciname != null) {
                                        cname = ciname;
                                        if (column == null && "DESC".equalsIgnoreCase(sortOrder)) {
                                            cname = (String)cname + " DESC";
                                        }
                                    }
                                    if (column != null) {
                                        if (!(column.getCollectionType() == null && column.getStructuredType() == null || indexType.equals("DOMAIN"))) {
                                            toremove = true;
                                        }
                                        index.add(column);
                                        index.setColumnSortOrder(column, sortOrder);
                                        if (is_expr) {
                                            index.setIndexExpression("");
                                        }
                                    } else {
                                        if (!is_expr && ((String)cname).indexOf("SYS_NC") > -1) {
                                            toremove = true;
                                        }
                                        hasUnrecognizedCol = true;
                                    }
                                    ind_expr = ((String)ind_expr).isEmpty() ? cname : (String)ind_expr + ", " + (String)cname;
                                    ++col_pos;
                                }
                                if (!is_expr && ((String)ind_expr).isEmpty()) {
                                    toremove = true;
                                }
                                if (hasUnrecognizedCol) {
                                    index.getElementsCollection().clear();
                                    index.setIndexExpression((String)ind_expr);
                                    if ("M_ROW$$".equals(ind_expr) && index.getName().startsWith("I_SNAP$_")) {
                                        toremove = true;
                                    }
                                }
                                if (toremove) {
                                    index.remove();
                                } else {
                                    this.setIndexUser(indexProxy, storageDesign, owner);
                                }
                                if (bitmapIndex == null || indexProxy == null) continue;
                                indexProxy.setBitmapJoinIndex(bitmapIndex);
                                continue;
                            }
                            moreRows = rs.next();
                        }
                        rs.close();
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.initIndexes():", e);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{overflow_st, indexp_st, psh.indspat_st, statement});
            this.colMap.clear();
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{overflow_st, indexp_st, psh.indspat_st, statement});
        this.colMap.clear();
    }

    private ExprHelp getExprByColPos(List expressions, int pos) {
        if (expressions != null) {
            for (ExprHelp eh : expressions) {
                if (eh.col_pos != pos) continue;
                return eh;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List setIndexExpression(Connection sqlConnection, Index index, String indexOwner, String indexName, PreparedStatement indexp_st) throws SQLException {
        ArrayList<ExprHelp> list = new ArrayList<ExprHelp>();
        ResultSet rs = null;
        try {
            indexp_st.setString(1, indexOwner);
            indexp_st.setString(2, indexName);
            rs = indexp_st.executeQuery();
            if (rs != null) {
                Object funct_expr = "";
                boolean first = true;
                while (rs.next()) {
                    String col_expr = rs.getString("COLUMN_EXPRESSION");
                    int col_pos = rs.getInt("COLUMN_POSITION");
                    if (first) {
                        funct_expr = col_expr;
                        first = false;
                    } else {
                        funct_expr = (String)funct_expr + ", " + col_expr;
                    }
                    ExprHelp eh = new ExprHelp();
                    eh.expr = col_expr;
                    eh.col_pos = col_pos;
                    list.add(eh);
                }
                if (!"".equals(funct_expr)) {
                    index.setIndexExpression((String)funct_expr);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setIndexExpression():", e);
        }
        finally {
            Closeables.close(rs);
        }
        return list;
    }

    private void setIndexUser(IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, String userName) {
        SchemaObjectSet schemaSet;
        SchemaObject so;
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        if (user == null) {
            user = storageDesign.getUserSet().createUser();
            user.setName(userName);
            this.stampModelObject((ModelObject)user, "", userName);
        }
        if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)indexProxy.getIndex().getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null) {
            so = schemaSet.createSchemaObject(null);
            so.setName(userName);
            this.stampModelObject((ModelObject)so, "", userName);
        }
        if (user.getSchemaObject() == null) {
            user.setSchemaObject(so);
        }
        if (user.getSchemaObject() != so) {
            indexProxy.setUser(user);
        }
        indexProxy.getIndex().setSchemaObject(so);
    }

    private void setIndexTableSpace(IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, String tsName) {
        if (tsName != null && !"".equalsIgnoreCase(tsName)) {
            TableProxyOracle tableProxy;
            TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
            if (tableSpace == null && (tableProxy = (TableProxyOracle)indexProxy.getTableProxy()) != null && tableProxy.getTemporary().equals("NO")) {
                tableSpace = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                tableSpace.setName(tsName);
                this.stampModelObject((ModelObject)tableSpace, indexProxy, tsName);
            }
            indexProxy.setTableSpace(tableSpace);
        }
    }

    private void setIndexProperties(Connection sqlConnection, Table table, IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, ResultSet resultSet, PSHolder psh, BitmapJoinIndexOracle bitmapIndex) throws Exception {
        SegmentOracle tsegment;
        String compression;
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        int iniTrans = resultSet.getInt("INI_TRANS");
        int maxTrans = resultSet.getInt("MAX_TRANS");
        long initialExtent = resultSet.getLong("INITIAL_EXTENT");
        long nextExtent = resultSet.getLong("NEXT_EXTENT");
        int minExtents = Integer.MAX_VALUE;
        String maxExtents = "";
        try {
            minExtents = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in min_extent", e);
        }
        try {
            maxExtents = resultSet.getString("MAX_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in max_extent", e);
        }
        int pctIncrease = resultSet.getInt("PCT_INCREASE");
        int freeLists = resultSet.getInt("FREELISTS");
        int freeListGroups = resultSet.getInt("FREELIST_GROUPS");
        int pctFree = resultSet.getInt("PCT_FREE");
        String logging = resultSet.getString("LOGGING");
        String parallel = resultSet.getString("DEGREE");
        String partitioned = resultSet.getString("PARTITIONED");
        String bufferPool = resultSet.getString("BUFFER_POOL");
        String itypeOwner = resultSet.getString("ITYP_OWNER");
        String itypeName = resultSet.getString("ITYP_NAME");
        String parameters = resultSet.getString("PARAMETERS");
        String visibility = "";
        if (storageDesign instanceof StorageDesignOraclev11g) {
            visibility = resultSet.getString("VISIBILITY");
        }
        if ((compression = resultSet.getString("PREFIX_LENGTH")) != null) {
            try {
                indexProxy.setCompress(Integer.parseInt(compression));
            }
            catch (NumberFormatException e) {
                LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value for KeyCompression", e);
            }
        }
        if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        if (segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
            segment.setSCInitialExtent(initialExtent);
        }
        if (segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
            segment.setSCNextExtent(nextExtent);
        }
        if (segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
            segment.setSCMinExtents(minExtents);
        }
        if (segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(String.valueOf(maxExtents));
        }
        if (segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
            segment.setSCPctIncrease(pctIncrease);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("PCT_FREE") != null) && segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (logging != null) {
            indexProxy.setLogging(logging.trim().toUpperCase());
        }
        if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim());
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        indexProxy.setSegment(segment);
        if (bitmapIndex != null) {
            bitmapIndex.setSegment(tsegment);
            bitmapIndex.setLocalPartitioning(partitioned);
            bitmapIndex.setLogging(logging);
        }
        if ("1".equals(parallel.trim())) {
            indexProxy.setParallel("NO");
        } else {
            indexProxy.setParallel("YES");
            indexProxy.setDegree(parallel.trim());
        }
        if ("INVISIBLE".equalsIgnoreCase(visibility)) {
            ((IndexProxyOraclev10g)indexProxy).setInvisible("YES");
        }
        if (itypeOwner != null && itypeName != null && itypeOwner.equalsIgnoreCase("MDSYS") && itypeName.equals("SPATIAL_INDEX")) {
            String name = this.getSpatialColumnName(sqlConnection, table, indexProxy, psh);
            Index index = indexProxy.getIndex();
            index.setSpatialIndex(true);
            Column spaColumn = (Column)table.getElementByName(name);
            Iterator it = table.getSpatialDefinitions().iterator();
            SpatialColumnDefObject spaColumnDef2 = null;
            boolean funcind = false;
            if (spaColumn != null) {
                while (it.hasNext() && (spaColumnDef2 = (SpatialColumnDefObject)it.next()).getSpatialColumn() != spaColumn) {
                    spaColumnDef2 = null;
                }
            } else {
                while (it.hasNext()) {
                    spaColumnDef2 = (SpatialColumnDefObject)it.next();
                    if (spaColumnDef2.getFuncExpression().equals(name)) {
                        funcind = true;
                        break;
                    }
                    spaColumnDef2 = null;
                }
                if (spaColumnDef2 == null && index.hasIndexExpression()) {
                    for (SpatialColumnDefObject spaColumnDef2 : table.getSpatialDefinitions()) {
                        if (spaColumnDef2.isFunction()) {
                            funcind = true;
                            break;
                        }
                        spaColumnDef2 = null;
                    }
                }
            }
            if (spaColumnDef2 != null && !funcind) {
                indexProxy.getIndex().setSpatialColumnDefiniton(spaColumnDef2);
                spaColumnDef2.setSpatialIndex(index);
                if (spaColumn != null) {
                    spaColumnDef2.setFunction(false);
                    spaColumnDef2.setFuncExpression("");
                    if (indexProxy.getIndex().getElementsCollection().size() == 0) {
                        indexProxy.getIndex().add(spaColumn);
                    }
                } else if (spaColumnDef2.isFunction()) {
                    indexProxy.getIndex().setIndexExpression(name);
                }
                if (spaColumnDef2.getSpatialColumn() != null) {
                    indexProxy.getIndex().add(spaColumnDef2.getSpatialColumn());
                }
            } else {
                if (spaColumnDef2 == null) {
                    spaColumnDef2 = new SpatialColumnDefObject(table);
                    table.addSpatialDefinition(spaColumnDef2);
                }
                spaColumnDef2.setSpatialIndex(index);
                if (index.hasIndexExpression()) {
                    index.setSpatialColumnDefiniton(spaColumnDef2);
                    if (!spaColumnDef2.isFunction()) {
                        spaColumnDef2.setFunction(true);
                        spaColumnDef2.setFuncExpression(index.getIndexExpression());
                    }
                }
            }
            if (parameters != null) {
                parameters = Token.replaceAll(parameters, "\n", "");
                StringTokenizer tokens = new StringTokenizer(parameters, " ");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    String[] param = token.split("=");
                    if (param.length != 2) continue;
                    String paramName = param[0];
                    String paramValue = param[1];
                    if (paramValue.equals("")) continue;
                    if (paramName.equalsIgnoreCase("tablespace")) {
                        TableSpaceOracle tablespace = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(paramValue);
                        if (tablespace == null) {
                            tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                            tablespace.setName(paramValue);
                            this.stampModelObject((ModelObject)tablespace, indexProxy, paramValue);
                        }
                        indexProxy.setTableSpace(tablespace);
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("work_tablespace")) {
                        TableSpaceOracle tbSpace = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(paramValue);
                        if (tbSpace == null) {
                            tbSpace = storageDesign.getTableSpaceSet().createTableSpace();
                            tbSpace.setName(paramValue);
                            this.stampModelObject((ModelObject)tbSpace, indexProxy, paramValue);
                        }
                        if (storageDesign instanceof StorageDesignOraclev9i) {
                            ((IndexProxyOraclev9i)indexProxy).setWorkTablespace(tbSpace);
                            continue;
                        }
                        ((IndexProxyOraclev10g)indexProxy).setWorkTablespace(tbSpace);
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("layer_gtype")) {
                        indexProxy.getIndex().setLayerType(paramValue);
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("sdo_indx_dims")) {
                        try {
                            indexProxy.getIndex().setDimensionsNumber(Integer.parseInt(paramValue));
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value.", e);
                        }
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("geodetic")) {
                        indexProxy.getIndex().setGeodetic("NO");
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("sdo_non_leaf_tbl") && paramValue.equalsIgnoreCase("TRUE")) {
                        if (storageDesign instanceof StorageDesignOraclev9i) {
                            ((IndexProxyOraclev9i)indexProxy).setNonLeaf("YES");
                            continue;
                        }
                        ((IndexProxyOraclev10g)indexProxy).setNonLeaf("YES");
                        continue;
                    }
                    try {
                        if (paramName.equalsIgnoreCase("initial") && segment.getDesign().getSettings().isIncludeInitransInDDL()) {
                            segment.setInitrans(Integer.parseInt(paramValue));
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("next") && segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                            segment.setSCNextExtent(Long.parseLong(paramValue));
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("minextents") && segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                            segment.setSCMinExtents(Integer.parseInt(paramValue));
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("maxextents") && segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                            segment.setSCMaxExtents(paramValue);
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("pctincrease") && segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                            segment.setSCPctIncrease(Integer.parseInt(paramValue));
                            continue;
                        }
                        if (!paramName.equalsIgnoreCase("sdo_rdr_pctfree") || !segment.getDesign().getSettings().isIncludePctFreeInDDL()) continue;
                        segment.setPCTFree(Integer.parseInt(paramValue));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value.", e);
                    }
                }
            }
        }
        if (itypeOwner != null && itypeName != null) {
            indexProxy.setIndexType(itypeOwner + "." + itypeName);
            if (parameters != null) {
                indexProxy.setIndexDomainParameters(parameters);
            }
        }
        if ("YES".equalsIgnoreCase(partitioned.trim())) {
            indexProxy.setPartitioned(true);
        } else {
            indexProxy.setPartitioned(false);
        }
    }

    private void setDefIndexProperties(IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws SQLException {
        SegmentOracle tsegment;
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        int iniTrans = resultSet.getInt("DEF_INI_TRANS");
        int maxTrans = resultSet.getInt("DEF_MAX_TRANS");
        String initialExtent = resultSet.getString("DEF_INITIAL_EXTENT");
        String nextExtent = resultSet.getString("DEF_NEXT_EXTENT");
        String minExtents = resultSet.getString("DEF_MIN_EXTENTS");
        String maxExtents = resultSet.getString("DEF_MAX_EXTENTS");
        String pctIncrease = resultSet.getString("DEF_PCT_INCREASE");
        int freeLists = resultSet.getInt("DEF_FREELISTS");
        int freeListGroups = resultSet.getInt("DEF_FREELIST_GROUPS");
        int pctFree = resultSet.getInt("DEF_PCT_FREE");
        String bufferPool = resultSet.getString("DEF_BUFFER_POOL");
        String logging = resultSet.getString("DEF_LOGGING");
        if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        try {
            if (!initialExtent.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                segment.setSCInitialExtent(Long.parseLong(initialExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_INITIAL_EXTENT", e);
        }
        try {
            if (!nextExtent.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                segment.setSCNextExtent(Long.parseLong(nextExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_NEXT_EXTENT", e);
        }
        try {
            if (!minExtents.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                segment.setSCMinExtents(Integer.parseInt(minExtents.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_MIN_EXTENTS", e);
        }
        if (maxExtents != null && !maxExtents.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(maxExtents.trim());
        }
        try {
            if (!pctIncrease.equals("DEFAULT") && segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                segment.setSCPctIncrease(Integer.parseInt(pctIncrease.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_PCT_INCREASE", e);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("DEF_PCT_FREE") != null) && segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim().toUpperCase());
        }
        if (logging != null) {
            indexProxy.setLogging(logging.trim().toUpperCase());
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        indexProxy.setSegment(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSpatialColumnName(Connection sqlConnection, Table table, IndexProxyOracle indexProxy, PSHolder psh) throws SQLException {
        if (psh.indspat_st == null) {
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("SELECT").append(' ').append("COLUMN_NAME").append(' ');
            sbuff.append("FROM").append(' ').append("all_sdo_index_info").append(' ');
            sbuff.append("WHERE").append(' ').append("SDO_INDEX_OWNER").append('=').append('?').append(' ');
            sbuff.append("AND").append(' ').append("INDEX_NAME").append('=').append('?').append(' ');
            sbuff.append("AND").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
            String sql = sbuff.toString();
            psh.indspat_st = sqlConnection.prepareStatement(sql);
        }
        String spaColumnName = null;
        String tableOwner = table.getSchema();
        UserOracle user = indexProxy.getUser();
        String indexOwner = user != null ? user.getName() : indexProxy.getIndex().getSchema();
        ResultSet rs = null;
        try {
            psh.indspat_st.setString(1, indexOwner);
            psh.indspat_st.setString(2, indexProxy.getName());
            psh.indspat_st.setString(3, tableOwner);
            rs = psh.indspat_st.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    spaColumnName = rs.getString("COLUMN_NAME");
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.getSpatialColumnName():", e);
        }
        finally {
            Closeables.close(rs);
        }
        return spaColumnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexPartitioning(Connection sqlConnection, IndexProxyOracle indexProxy, String partitionType) throws SQLException {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        if (this.indpart_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("PARTITION_NAME").append(',');
            buffer.append("HIGH_VALUE").append(',');
            buffer.append("PARTITION_POSITION").append(',');
            buffer.append("TABLESPACE_NAME").append(',');
            buffer.append("PCT_FREE").append(',');
            buffer.append("INI_TRANS").append(',');
            buffer.append("MAX_TRANS").append(',');
            buffer.append("INITIAL_EXTENT").append(',');
            buffer.append("NEXT_EXTENT").append(',');
            buffer.append("MIN_EXTENT").append(',');
            buffer.append("MAX_EXTENT").append(',');
            buffer.append("PCT_INCREASE").append(',');
            buffer.append("FREELISTS").append(',');
            buffer.append("FREELIST_GROUPS").append(',');
            buffer.append("LOGGING").append(',');
            buffer.append("COMPRESSION").append(',');
            buffer.append("BUFFER_POOL").append(',');
            buffer.append("PARAMETERS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_ind_partitions" : "all_ind_partitions").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("INDEX_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("PARTITION_POSITION");
            String sql = buffer.toString();
            this.indpart_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            UserOracle user = indexProxy.getUser();
            String ownerName = "";
            if (user != null) {
                ownerName = user.getName();
            } else {
                SchemaObject schema = indexProxy.getIndex().getSchemaObject();
                if (schema != null) {
                    ownerName = schema.getName();
                }
            }
            this.indpart_st.setString(1, ownerName);
            this.indpart_st.setString(2, indexProxy.getName());
            rs = this.indpart_st.executeQuery();
            if (rs != null) {
                if (partitionType.equals("LOCAL")) {
                    TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
                    while (rs.next()) {
                        SegmentOracle segment;
                        StorageObject partition;
                        int partitionPos = rs.getInt("PARTITION_POSITION") - 1;
                        String parameters = rs.getString("PARAMETERS");
                        String partitionName = rs.getString("PARTITION_NAME");
                        String compression = rs.getString("COMPRESSION");
                        if (partitionPos < 0 || (partition = (StorageObject)tableProxy.getPartitions().getElement(partitionPos)) == null) continue;
                        LocalIndexProperties lip = storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, indexProxy);
                        if (lip == null) {
                            lip = storageDesign.getLocalIndexPropertiesSet().createLocalIndexProperties();
                            lip.setIndex(indexProxy);
                            if (indexProxy.getBitmapJoinIndex() != null) {
                                lip.setIndex(indexProxy.getBitmapJoinIndex());
                            }
                            lip.setPartition(partition);
                            lip.setLogging(indexProxy.getLogging());
                        }
                        lip.setPartitionName(partitionName);
                        if (compression != null && indexProxy.getCompress() > 0 && compression.equalsIgnoreCase("DISABLED")) {
                            lip.setKeyCompress("NO");
                        }
                        if (parameters != null) {
                            StringTokenizer tokens = new StringTokenizer(parameters, " ");
                            while (tokens.hasMoreTokens()) {
                                String token = tokens.nextToken();
                                String[] param = token.split("=");
                                if (param.length != 2) continue;
                                String paramName = param[0];
                                String paramValue = param[1];
                                if (paramValue.equals("")) continue;
                                if (paramName.equalsIgnoreCase("tablespace")) {
                                    TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(paramValue);
                                    if (tablespace == null) {
                                        tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                                        tablespace.setName(paramValue);
                                        this.stampModelObject((ModelObject)tablespace, indexProxy, paramValue);
                                    }
                                    lip.setTableSpace(tablespace);
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("work_tablespace")) {
                                    TableSpaceOracle tempTBSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(paramValue);
                                    if (tempTBSpace == null) {
                                        tempTBSpace = storageDesign.getTableSpaceSet().createTableSpace();
                                        tempTBSpace.setName(paramValue);
                                        this.stampModelObject((ModelObject)tempTBSpace, indexProxy, paramValue);
                                    }
                                    lip.setWorkTablespace(tempTBSpace);
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("layer_gtype")) {
                                    lip.setLayerType(paramValue);
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("sdo_non_leaf_tbl") && paramValue.equalsIgnoreCase("TRUE")) {
                                    if (storageDesign instanceof StorageDesignOraclev9i) {
                                        ((IndexProxyOraclev9i)indexProxy).setNonLeaf("YES");
                                        continue;
                                    }
                                    if (!(storageDesign instanceof StorageDesignOraclev10g)) continue;
                                    ((IndexProxyOraclev10g)indexProxy).setNonLeaf("YES");
                                    continue;
                                }
                                SegmentOracle segment2 = lip.getSegment();
                                if (segment2 == null) {
                                    segment2 = storageDesign.getSegmentSet().createSegment();
                                    lip.setSegment(segment2);
                                }
                                try {
                                    if (paramName.equalsIgnoreCase("initial") && segment2.getDesign().getSettings().isIncludeInitransInDDL()) {
                                        segment2.setInitrans(Integer.parseInt(paramValue));
                                        continue;
                                    }
                                    if (paramName.equalsIgnoreCase("next") && segment2.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                                        segment2.setSCNextExtent(Long.parseLong(paramValue));
                                        continue;
                                    }
                                    if (paramName.equalsIgnoreCase("minextents") && segment2.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                                        segment2.setSCMinExtents(Integer.parseInt(paramValue));
                                        continue;
                                    }
                                    if (paramName.equalsIgnoreCase("maxextents") && segment2.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                                        segment2.setSCMaxExtents(paramValue);
                                        continue;
                                    }
                                    if (paramName.equalsIgnoreCase("pctincrease") && segment2.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                                        segment2.setSCPctIncrease(Integer.parseInt(paramValue));
                                        continue;
                                    }
                                    if (!paramName.equalsIgnoreCase("sdo_rdr_pctfree") || !segment2.getDesign().getSettings().isIncludePctFreeInDDL()) continue;
                                    segment2.setPCTFree(Integer.parseInt(paramValue));
                                }
                                catch (NumberFormatException e) {
                                    LOGGER.error("MOHTableOracle.initIndexPartitioning(): Can not parse string value", e);
                                }
                            }
                            continue;
                        }
                        String tablespaceName = rs.getString("TABLESPACE_NAME");
                        int iniTrans = rs.getInt("INI_TRANS");
                        int maxTrans = rs.getInt("MAX_TRANS");
                        long initialExtent = rs.getLong("INITIAL_EXTENT");
                        long nextExtent = rs.getLong("NEXT_EXTENT");
                        int minExtents = Integer.MAX_VALUE;
                        int maxExtents = Integer.MAX_VALUE;
                        try {
                            minExtents = rs.getInt("MIN_EXTENT");
                        }
                        catch (Exception e) {
                            LOGGER.error("error in min_extent", e);
                        }
                        try {
                            maxExtents = rs.getInt("MAX_EXTENT");
                        }
                        catch (Exception e) {
                            LOGGER.error("error in max_extent", e);
                        }
                        int pctIncrease = rs.getInt("PCT_INCREASE");
                        int freeLists = rs.getInt("FREELISTS");
                        int freeListGroups = rs.getInt("FREELIST_GROUPS");
                        int pctFree = rs.getInt("PCT_FREE");
                        String logging = rs.getString("LOGGING");
                        String bufferPool = rs.getString("BUFFER_POOL");
                        if (tablespaceName != null && tablespaceName.length() > 0) {
                            TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName);
                            if (tablespace == null) {
                                tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                                tablespace.setName(tablespaceName);
                                this.stampModelObject((ModelObject)tablespace, indexProxy, tablespaceName);
                            }
                            lip.setTableSpace(tablespace);
                        }
                        if ((segment = storageDesign.getSegmentSet().createSegment()).getDesign().getSettings().isIncludeInitransInDDL()) {
                            segment.setInitrans(iniTrans);
                            segment.setMaxTrans(maxTrans);
                        }
                        if (segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                            segment.setSCInitialExtent(initialExtent);
                        }
                        if (segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                            segment.setSCNextExtent(nextExtent);
                        }
                        if (segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                            segment.setSCMinExtents(minExtents);
                        }
                        if (segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                            segment.setSCMaxExtents(String.valueOf(maxExtents));
                        }
                        if (segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                            segment.setSCPctIncrease(pctIncrease);
                        }
                        if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                            segment.setSCFreeLists(freeLists);
                        }
                        if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                            segment.setSCFreelistGroups(freeListGroups);
                        }
                        if (segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
                            segment.setPCTFree(pctFree);
                        }
                        if (logging != null) {
                            lip.setLogging(logging.trim().toUpperCase());
                        }
                        if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                            segment.setSCBufferPool(bufferPool.trim());
                        }
                        SegmentOracle tsegment = storageDesign.getSegmentSet().findEqual(segment);
                        lip.setSegment(tsegment);
                        if (tsegment == segment) continue;
                        segment.remove(true);
                    }
                } else {
                    IndexGlobalPartitionsListOracle globalPartList = indexProxy.getIndexGlobalPartitionsList();
                    if (globalPartList != null) {
                        while (rs.next()) {
                            SegmentOracle tsegment;
                            SegmentOracle segment;
                            String high_value = rs.getString("HIGH_VALUE");
                            String parameters = rs.getString("PARAMETERS");
                            if (parameters != null) continue;
                            String partitionName = rs.getString("PARTITION_NAME");
                            int position = rs.getInt("PARTITION_POSITION");
                            String tablespaceName = rs.getString("TABLESPACE_NAME");
                            int pctFree = rs.getInt("PCT_FREE");
                            int iniTrans = rs.getInt("INI_TRANS");
                            int maxTrans = rs.getInt("MAX_TRANS");
                            long initialExtent = rs.getLong("INITIAL_EXTENT");
                            long nextExtent = rs.getLong("NEXT_EXTENT");
                            int minExtents = Integer.MAX_VALUE;
                            int maxExtents = Integer.MAX_VALUE;
                            try {
                                minExtents = rs.getInt("MIN_EXTENT");
                            }
                            catch (Exception e) {
                                LOGGER.error("error in min_extent", e);
                            }
                            try {
                                maxExtents = rs.getInt("MAX_EXTENT");
                            }
                            catch (Exception e) {
                                LOGGER.error("error in max_extent", e);
                            }
                            int pctIncrease = rs.getInt("PCT_INCREASE");
                            int freeLists = rs.getInt("FREELISTS");
                            int freeListGroups = rs.getInt("FREELIST_GROUPS");
                            String logging = rs.getString("LOGGING");
                            String bufferPool = rs.getString("BUFFER_POOL");
                            TableSpaceOracle tablespace = null;
                            if (tablespaceName != null && !"".equalsIgnoreCase(tablespaceName) && (tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName)) == null) {
                                tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                                tablespace.setName(tablespaceName);
                                this.stampModelObject((ModelObject)tablespace, indexProxy, tablespaceName);
                            }
                            if ((segment = storageDesign.getSegmentSet().createSegment()).getDesign().getSettings().isIncludePctFreeInDDL()) {
                                segment.setPCTFree(pctFree);
                            }
                            if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
                                segment.setInitrans(iniTrans);
                                segment.setMaxTrans(maxTrans);
                            }
                            if (segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                                segment.setSCInitialExtent(initialExtent);
                            }
                            if (segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                                segment.setSCNextExtent(nextExtent);
                            }
                            if (segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                                segment.setSCMinExtents(minExtents);
                            }
                            if (segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment.setSCMaxExtents(String.valueOf(maxExtents));
                            }
                            if (segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                                segment.setSCPctIncrease(pctIncrease);
                            }
                            if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                                segment.setSCFreeLists(freeLists);
                            }
                            if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                                segment.setSCFreelistGroups(freeListGroups);
                            }
                            if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                                segment.setSCBufferPool(bufferPool.trim());
                            }
                            if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                                segment.remove(true);
                            }
                            segment = tsegment;
                            IndexGlobalPartitionOracle partition = storageDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                            partition.setName(partitionName);
                            partition.setIndexGlobalPartList(globalPartList);
                            indexProxy.getGlobalPartitions().add(partition);
                            this.stampModelObject((ModelObject)partition, indexProxy, partitionName);
                            partition.setPosition(position);
                            if (high_value != null) {
                                partition.setValueList(high_value);
                            }
                            if (tablespace != null) {
                                partition.setTableSpace(tablespace);
                            }
                            if (!"NONE".equalsIgnoreCase(logging)) {
                                partition.setLogging(logging);
                            }
                            partition.setSegment(segment);
                        }
                    }
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.initIndexPartitioning():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexPartitioning(Connection sqlConnection, StorageDesignOracle storageDesign, List dbos) throws Exception {
        this.indpartype_st = null;
        this.indglobpartcols_st = null;
        this.indpart_st = null;
        try {
            for (DBObject dbo : dbos) {
                if (dbo.externalTable) continue;
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                for (PKProxyOracle pkProxy : tableProxy.getPrimaryKeys()) {
                    if (!pkProxy.isPartitioned()) continue;
                    this.setIndexPartitioningInfo(sqlConnection, pkProxy, storageDesign);
                }
                for (UniqueOracle ukProxy : tableProxy.getUniqueKeys()) {
                    if (!ukProxy.isPartitioned()) continue;
                    this.setIndexPartitioningInfo(sqlConnection, ukProxy, storageDesign);
                }
                for (IndexProxyOracle indexProxy : tableProxy.getIndexes()) {
                    if (!indexProxy.isPartitioned()) continue;
                    this.setIndexPartitioningInfo(sqlConnection, indexProxy, storageDesign);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{this.indpartype_st, this.indglobpartcols_st, this.indpart_st});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.indpartype_st, this.indglobpartcols_st, this.indpart_st});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIndexPartitioningInfo(Connection sqlConnection, IndexProxyOracle indexProxy, StorageDesignOracle storageDesign) throws SQLException {
        UserOracle user = indexProxy.getUser();
        String ownerName = "";
        if (user != null) {
            ownerName = user.getName();
        } else {
            SchemaObject schema = indexProxy.getIndex().getSchemaObject();
            if (schema != null) {
                ownerName = schema.getName();
            }
        }
        if (this.indpartype_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("LOCALITY").append(',');
            buffer.append("PARTITIONING_TYPE").append(',');
            buffer.append("PARTITION_COUNT").append(',');
            buffer.append("DEF_TABLESPACE_NAME").append(',');
            buffer.append("DEF_PCT_FREE").append(',');
            buffer.append("DEF_INI_TRANS").append(',');
            buffer.append("DEF_MAX_TRANS").append(',');
            buffer.append("DEF_INITIAL_EXTENT").append(',');
            buffer.append("DEF_NEXT_EXTENT").append(',');
            buffer.append("DEF_MIN_EXTENTS").append(',');
            buffer.append("DEF_MAX_EXTENTS").append(',');
            buffer.append("DEF_PCT_INCREASE").append(',');
            buffer.append("DEF_FREELISTS").append(',');
            buffer.append("DEF_FREELIST_GROUPS").append(',');
            buffer.append("DEF_LOGGING").append(',');
            buffer.append("DEF_BUFFER_POOL").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_part_indexes" : "all_part_indexes").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append('?').append(' ');
            String sql = buffer.toString();
            this.indpartype_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.indpartype_st.setString(1, ownerName);
            this.indpartype_st.setString(2, indexProxy.getName());
            rs = this.indpartype_st.executeQuery();
            if (rs != null) {
                if (rs.next()) {
                    String partitionType = "";
                    String tablespaceName = rs.getString("DEF_TABLESPACE_NAME");
                    String locality = rs.getString("LOCALITY");
                    if ("LOCAL".equalsIgnoreCase(locality)) {
                        partitionType = "LOCAL";
                        this.setPartitionType(indexProxy, partitionType);
                        this.setIndexTableSpace(indexProxy, storageDesign, tablespaceName);
                        this.setDefIndexProperties(indexProxy, storageDesign, rs);
                    } else if ("GLOBAL".equalsIgnoreCase(locality)) {
                        IndexGlobalPartitionsListOracle igpl = storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        indexProxy.setIndexGlobalPartitionsList(igpl);
                        igpl.setIndex(indexProxy);
                        if (storageDesign instanceof StorageDesignOraclev10g) {
                            String partitioningType = rs.getString("PARTITIONING_TYPE");
                            if (partitioningType.equalsIgnoreCase("RANGE")) {
                                partitionType = "GLOBAL BY RANGE";
                            } else {
                                partitionType = "GLOBAL HASH PARTITIONED BY QUANTITY";
                                ((IndexGlobalPartitionsListOraclev10g)igpl).setHashPQuantity(rs.getInt("PARTITION_COUNT"));
                            }
                        } else {
                            partitionType = "GLOBAL";
                        }
                        this.setPartitionType(indexProxy, partitionType);
                        this.setIndexTableSpace(indexProxy, storageDesign, tablespaceName);
                        this.setDefIndexProperties(indexProxy, storageDesign, rs);
                        if (this.indglobpartcols_st == null) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("COLUMN_NAME").append(',');
                            buffer.append("COLUMN_POSITION").append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_part_key_columns" : "all_part_key_columns").append(' ');
                            buffer.append("WHERE").append(' ');
                            buffer.append("OWNER").append('=').append('?').append(' ');
                            buffer.append("AND").append(' ');
                            buffer.append("NAME").append('=').append('?').append(' ');
                            buffer.append("AND").append(' ');
                            buffer.append("OBJECT_TYPE").append('=').append('\'');
                            buffer.append("INDEX").append('\'').append(' ');
                            buffer.append("ORDER BY").append(' ');
                            buffer.append("COLUMN_POSITION");
                            String sql = buffer.toString();
                            this.indglobpartcols_st = sqlConnection.prepareStatement(sql);
                        }
                        ResultSet indglobpartcols_rs = null;
                        try {
                            this.indglobpartcols_st.setString(1, ownerName);
                            this.indglobpartcols_st.setString(2, indexProxy.getName());
                            indglobpartcols_rs = this.indglobpartcols_st.executeQuery();
                            if (indglobpartcols_rs != null) {
                                while (indglobpartcols_rs.next()) {
                                    String name = indglobpartcols_rs.getString("COLUMN_NAME");
                                    igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(name));
                                }
                                indglobpartcols_rs.close();
                            }
                            Closeables.close((Object)indglobpartcols_rs);
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHTableOracle.setIndexPartitioningInfo():", e);
                        }
                        finally {
                            Closeables.close(indglobpartcols_rs);
                        }
                    }
                    if (this.getDbmeHandler().isPartitions() && (partitionType.equals("LOCAL") || partitionType.equals("GLOBAL BY RANGE") || partitionType.equals("GLOBAL"))) {
                        this.initIndexPartitioning(sqlConnection, indexProxy, partitionType);
                    }
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setIndexPartitioningInfo():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private void setPartitionType(IndexProxyOracle indexProxy, String partitionType) {
        boolean pk = indexProxy instanceof PKProxyOracle;
        boolean uk = indexProxy instanceof UniqueOracle;
        if (pk || uk) {
            if (indexProxy instanceof PKProxyOraclev9i || indexProxy instanceof UniqueOraclev9i) {
                if (partitionType.equals("LOCAL")) {
                    partitionType = "LOCAL PARTITIONED";
                } else if (partitionType.startsWith("GLOBAL")) {
                    partitionType = "GLOBAL PARTITIONED";
                }
            }
            if (pk) {
                ((PKProxyOracle)indexProxy).setUsingIndex(partitionType);
            } else {
                ((UniqueOracle)indexProxy).setUsingIndex(partitionType);
            }
        } else {
            indexProxy.setIndexPartitioned(partitionType);
        }
    }

    private void setUser(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        tableProxy.setUser(user);
    }

    private void setTableSpace(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, String tsName) throws Exception {
        if (tsName != null && !"".equalsIgnoreCase(tsName)) {
            if (tableProxy.getTemporary().equals("NO")) {
                TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                if (tableSpace == null) {
                    tableSpace = storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpace.setName(tsName);
                    this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                }
                tableProxy.setTableSpace(tableSpace);
            } else {
                TemporaryTablespaceOracle tableSpace = (TemporaryTablespaceOracle)storageDesign.getTemporaryTablespaceSet().getByName(tsName);
                if (tableSpace == null) {
                    tableSpace = storageDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
                    tableSpace.setName(tsName);
                    this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                }
                tableProxy.setTemporaryTablespace(tableSpace);
            }
        }
    }

    private void setCluster(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        ClusterOracle cluster;
        String clusterName = resultSet.getString("CLUSTER_NAME");
        if (clusterName != null && !"".equalsIgnoreCase(clusterName) && (cluster = (ClusterOracle)storageDesign.getClusterSet().getByName(clusterName)) != null) {
            tableProxy.setCluster(cluster);
            this.containsClusterRefs = true;
        }
    }

    private void setProperties(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet, boolean allProps) throws Exception {
        String logging = resultSet.getString("LOGGING");
        String parallel = resultSet.getString("DEGREE");
        String partitioned = resultSet.getString("PARTITIONED");
        String temporary = resultSet.getString("TEMPORARY");
        String duration = resultSet.getString("DURATION");
        String cache = resultSet.getString("CACHE");
        String rowMovement = resultSet.getString("ROW_MOVEMENT");
        String monitoring = null;
        String compression = null;
        String dependencies = null;
        if (storageDesign instanceof StorageDesignOraclev9i) {
            monitoring = resultSet.getString("MONITORING");
        } else {
            compression = resultSet.getString("COMPRESSION");
            dependencies = resultSet.getString("DEPENDENCIES");
        }
        String iotType = resultSet.getString("IOT_TYPE");
        if (iotType != null) {
            tableProxy.setOrganization("INDEX");
        }
        if ("YES".equalsIgnoreCase(partitioned.trim())) {
            this.isPartitioned = true;
            tableProxy.setPartitioned("YES");
        } else {
            tableProxy.setPartitioned("NO");
            if (iotType == null) {
                SegmentOracle tsegment;
                SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
                int iniTrans = resultSet.getInt("INI_TRANS");
                int maxTrans = resultSet.getInt("MAX_TRANS");
                long initialExtent = resultSet.getLong("INITIAL_EXTENT");
                long nextExtent = resultSet.getLong("NEXT_EXTENT");
                int minExtents = Integer.MAX_VALUE;
                String maxExtents = "";
                try {
                    minExtents = resultSet.getInt("MIN_EXTENTS");
                }
                catch (Exception e) {
                    LOGGER.error("error in min_extent", e);
                }
                try {
                    maxExtents = resultSet.getString("MAX_EXTENTS");
                }
                catch (Exception e) {
                    LOGGER.error("error in max_extent", e);
                }
                int pctIncrease = resultSet.getInt("PCT_INCREASE");
                int freeLists = resultSet.getInt("FREELISTS");
                int freeListGroups = resultSet.getInt("FREELIST_GROUPS");
                int pctFree = resultSet.getInt("PCT_FREE");
                int pctUsed = resultSet.getInt("PCT_USED");
                String bufferPool = resultSet.getString("BUFFER_POOL");
                if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
                    segment.setInitrans(iniTrans);
                    segment.setMaxTrans(maxTrans);
                }
                if (segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                    segment.setSCInitialExtent(initialExtent);
                }
                if (segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                    segment.setSCNextExtent(nextExtent);
                }
                if (segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                    segment.setSCMinExtents(minExtents);
                }
                if (segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                    segment.setSCMaxExtents(String.valueOf(maxExtents));
                }
                if (segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                    segment.setSCPctIncrease(pctIncrease);
                }
                if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                    segment.setSCFreeLists(freeLists);
                }
                if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                    segment.setSCFreelistGroups(freeListGroups);
                }
                if ((pctFree > 0 || resultSet.getObject("PCT_FREE") != null) && segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
                    segment.setPCTFree(pctFree);
                }
                if (pctUsed > 0 && segment.getDesign().getSettings().isIncludePctUsedInDDL()) {
                    segment.setPCTUsed(pctUsed);
                }
                if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                    segment.setSCBufferPool(bufferPool.trim().toUpperCase());
                }
                if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                    segment.remove(true);
                }
                segment = tsegment;
                tableProxy.setSegment(segment);
            }
        }
        if (logging != null) {
            tableProxy.setLogging(logging.trim().toUpperCase());
        }
        if ("ENABLED".equalsIgnoreCase(compression)) {
            String compressFor;
            tableProxy.setDataSegmentCompression("YES");
            if (storageDesign instanceof StorageDesignOraclev11g && (compressFor = resultSet.getString("COMPRESS_FOR")) != null) {
                int rowLevelLockingIndex = compressFor.indexOf(" ROW LEVEL LOCKING");
                if (rowLevelLockingIndex > -1) {
                    compressFor = compressFor.substring(0, rowLevelLockingIndex);
                }
                ((TableProxyOraclev11g)tableProxy).setCompressionType(compressFor);
            }
        }
        if ("ENABLED".equalsIgnoreCase(dependencies)) {
            tableProxy.setRowDependency("YES");
        }
        if ("1".equals(parallel.trim())) {
            tableProxy.setParallel("NO");
        } else {
            tableProxy.setParallel("YES");
            tableProxy.setDegree(parallel.trim());
        }
        if ("Y".equalsIgnoreCase(temporary.trim())) {
            tableProxy.setTemporary("YES");
            if ("SYS$TRANSACTION".equalsIgnoreCase(duration)) {
                tableProxy.setTempPreserveRows("NO");
            } else {
                tableProxy.setTempPreserveRows("YES");
            }
        } else {
            tableProxy.setTemporary("NO");
        }
        if ("YES".equalsIgnoreCase(monitoring)) {
            tableProxy.setMonitoring("YES");
        } else {
            tableProxy.setMonitoring("NO");
        }
        if ("DISABLED".equalsIgnoreCase(rowMovement)) {
            tableProxy.setParttitionedRowMovement("DISABLE");
        } else {
            tableProxy.setParttitionedRowMovement("ENABLE");
        }
        if (cache != null && "Y".equalsIgnoreCase(cache.trim())) {
            tableProxy.setCache("YES");
        } else {
            tableProxy.setCache("NO");
        }
        if (tableProxy instanceof TableProxyOraclev12c && allProps) {
            TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)tableProxy;
            String inMemory = resultSet.getString("INMEMORY");
            if ("DISABLED".equals(inMemory)) {
                tableProxy12c.setInMemory("NO");
            } else if ("ENABLED".equals(inMemory)) {
                tableProxy12c.setInMemory("YES");
                tableProxy12c.setInMemoryPriority(resultSet.getString("INMEMORY_PRIORITY"));
                tableProxy12c.setInMemoryDistribute(resultSet.getString("INMEMORY_DISTRIBUTE"));
                tableProxy12c.setInMemoryCompression(resultSet.getString("INMEMORY_COMPRESSION"));
                tableProxy12c.setInMemoryDuplicate(resultSet.getString("INMEMORY_DUPLICATE"));
            }
        }
    }

    private void setOverflowProperties(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        SegmentOracle tsegment;
        String tablespaceName = resultSet.getString("TABLESPACE_NAME");
        if (tablespaceName != null && !"".equalsIgnoreCase(tablespaceName)) {
            TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName);
            if (tablespace == null) {
                tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                tablespace.setName(tablespaceName);
                this.stampModelObject((ModelObject)tablespace, tableProxy, tablespaceName);
            }
            tableProxy.setIotOverflowTablespace(tablespace);
        }
        int iniTrans = resultSet.getInt("INI_TRANS");
        int maxTrans = resultSet.getInt("MAX_TRANS");
        long initialExtent = resultSet.getLong("INITIAL_EXTENT");
        long nextExtent = resultSet.getLong("NEXT_EXTENT");
        int minExtents = Integer.MAX_VALUE;
        String maxExtents = "";
        try {
            minExtents = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in min_extent", e);
        }
        try {
            maxExtents = resultSet.getString("MAX_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in max_extent", e);
        }
        int pctIncrease = resultSet.getInt("PCT_INCREASE");
        int freeLists = resultSet.getInt("FREELISTS");
        int freeListGroups = resultSet.getInt("FREELIST_GROUPS");
        int pctFree = resultSet.getInt("PCT_FREE");
        int pctUsed = resultSet.getInt("PCT_USED");
        String bufferPool = resultSet.getString("BUFFER_POOL");
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        if (segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
            segment.setSCInitialExtent(initialExtent);
        }
        if (segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
            segment.setSCNextExtent(nextExtent);
        }
        if (segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
            segment.setSCMinExtents(minExtents);
        }
        if (segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(String.valueOf(maxExtents));
        }
        if (segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
            segment.setSCPctIncrease(pctIncrease);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("PCT_FREE") != null) && segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (pctUsed > 0 && segment.getDesign().getSettings().isIncludePctUsedInDDL()) {
            segment.setPCTUsed(pctUsed);
        }
        if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim().toUpperCase());
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        tableProxy.setIotOverflowSegment(segment);
        String logging = resultSet.getString("LOGGING");
        if (logging != null) {
            tableProxy.setIotOverflowLogging(logging.trim());
        }
    }

    private void setDefProperties(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        SegmentOracle tsegment;
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        int iniTrans = resultSet.getInt("DEF_INI_TRANS");
        int maxTrans = resultSet.getInt("DEF_MAX_TRANS");
        String initialExtent = resultSet.getString("DEF_INITIAL_EXTENT");
        String nextExtent = resultSet.getString("DEF_NEXT_EXTENT");
        String minExtents = resultSet.getString("DEF_MIN_EXTENTS");
        String maxExtents = resultSet.getString("DEF_MAX_EXTENTS");
        String pctIncrease = resultSet.getString("DEF_PCT_INCREASE");
        int freeLists = resultSet.getInt("DEF_FREELISTS");
        int freeListGroups = resultSet.getInt("DEF_FREELIST_GROUPS");
        int pctFree = resultSet.getInt("DEF_PCT_FREE");
        int pctUsed = resultSet.getInt("DEF_PCT_USED");
        String bufferPool = resultSet.getString("DEF_BUFFER_POOL");
        String logging = resultSet.getString("DEF_LOGGING");
        String compression = null;
        if (!(storageDesign instanceof StorageDesignOraclev9i)) {
            compression = resultSet.getString("DEF_COMPRESSION");
        }
        if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        try {
            if (initialExtent != null && !initialExtent.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                segment.setSCInitialExtent(Long.parseLong(initialExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_INITIAL_EXTENT", e);
        }
        try {
            if (nextExtent != null && !nextExtent.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                segment.setSCNextExtent(Long.parseLong(nextExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_NEXT_EXTENT", e);
        }
        try {
            if (minExtents != null && !minExtents.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                segment.setSCMinExtents(Integer.parseInt(minExtents.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_MIN_EXTENTS", e);
        }
        if (maxExtents != null && !maxExtents.equals("DEFAULT") && segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(maxExtents.trim());
        }
        try {
            if (pctIncrease != null && !pctIncrease.equals("DEFAULT") && segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                segment.setSCPctIncrease(Integer.parseInt(pctIncrease.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_PCT_INCREASE", e);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("DEF_PCT_FREE") != null) && segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (pctUsed > 0 && segment.getDesign().getSettings().isIncludePctUsedInDDL()) {
            segment.setPCTUsed(pctUsed);
        }
        if (bufferPool != null && segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim().toUpperCase());
        }
        if (logging != null) {
            tableProxy.setLogging(logging.trim().toUpperCase());
        }
        if ("ENABLED".equalsIgnoreCase(compression)) {
            String compressFor;
            tableProxy.setDataSegmentCompression("YES");
            if (storageDesign instanceof StorageDesignOraclev11g && (compressFor = resultSet.getString("DEF_COMPRESS_FOR")) != null) {
                int rowLevelLockingIndex = compressFor.indexOf(" ROW LEVEL LOCKING");
                if (rowLevelLockingIndex > -1) {
                    compressFor = compressFor.substring(0, rowLevelLockingIndex);
                }
                ((TableProxyOraclev11g)tableProxy).setCompressionType(compressFor);
            }
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        tableProxy.setSegment(segment);
    }

    private String getPartTablesQuery(StorageDesign storageDesign, boolean allProps) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("PARTITIONING_TYPE").append(',');
        buffer.append("SUBPARTITIONING_TYPE").append(',');
        buffer.append("PARTITION_COUNT").append(',');
        buffer.append("DEF_SUBPARTITION_COUNT").append(',');
        buffer.append("DEF_TABLESPACE_NAME").append(',');
        buffer.append("DEF_PCT_FREE").append(',');
        buffer.append("DEF_PCT_USED").append(',');
        buffer.append("DEF_INI_TRANS").append(',');
        buffer.append("DEF_MAX_TRANS").append(',');
        buffer.append("DEF_INITIAL_EXTENT").append(',');
        buffer.append("DEF_NEXT_EXTENT").append(',');
        buffer.append("DEF_MIN_EXTENTS").append(',');
        buffer.append("DEF_MAX_EXTENTS").append(',');
        buffer.append("DEF_PCT_INCREASE").append(',');
        buffer.append("DEF_FREELISTS").append(',');
        buffer.append("DEF_FREELIST_GROUPS").append(',');
        buffer.append("DEF_LOGGING").append(',');
        if (storageDesign instanceof StorageDesignOraclev10g) {
            buffer.append("DEF_COMPRESSION").append(',');
            if (storageDesign instanceof StorageDesignOraclev11g) {
                buffer.append("DEF_COMPRESS_FOR").append(',');
                buffer.append("REF_PTN_CONSTRAINT_NAME").append(',');
                buffer.append("INTERVAL").append(',');
                if (storageDesign instanceof StorageDesignOraclev12c && allProps) {
                    buffer.append("DEF_INMEMORY").append(',');
                    buffer.append("DEF_INMEMORY_PRIORITY").append(',');
                    buffer.append("DEF_INMEMORY_DISTRIBUTE").append(',');
                    buffer.append("DEF_INMEMORY_COMPRESSION").append(',');
                    buffer.append("DEF_INMEMORY_DUPLICATE").append(',');
                }
            }
        }
        buffer.append("DEF_BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_part_tables" : "all_part_tables").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("TABLE_NAME");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPartitionInfo(Connection sqlConnection, StorageDesignOracle storageDesign, List dbos) throws Exception {
        this.part_statement = null;
        this.partLS_statement = null;
        this.subpartCol_statement = null;
        this.subpartTemplate_statement = null;
        this.subPartTemplateLS_statement = null;
        this.subPart_statement = null;
        this.subPartLS_statement = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("COLUMN_POSITION").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_part_key_columns" : "all_part_key_columns").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("OBJECT_TYPE").append('=').append('\'');
        buffer.append("TABLE").append('\'').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("COLUMN_POSITION");
        String col_sql = buffer.toString();
        PreparedStatement col_statement = null;
        boolean oraclev11g = storageDesign instanceof StorageDesignOraclev11g;
        PreparedStatement statement = null;
        boolean allProps = true;
        try {
            for (DBObject dbo : dbos) {
                if (!dbo.partitioned) continue;
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                String owner = dbo.getSchema();
                ResultSet rs = null;
                try {
                    try {
                        if (statement == null) {
                            String sql = this.getPartTablesQuery(storageDesign, allProps);
                            statement = sqlConnection.prepareStatement(sql);
                        }
                        statement.setString(1, dbo.getSchema());
                        statement.setString(2, tableProxy.getName());
                        rs = statement.executeQuery();
                    }
                    catch (SQLSyntaxErrorException e) {
                        if (allProps) {
                            allProps = false;
                            if (statement != null) {
                                statement.close();
                            }
                            String sql = this.getPartTablesQuery(storageDesign, allProps);
                            statement = sqlConnection.prepareStatement(sql);
                            statement.setString(1, dbo.getSchema());
                            statement.setString(2, tableProxy.getName());
                            rs = statement.executeQuery();
                        }
                        throw e;
                    }
                    if (rs != null) {
                        while (rs.next()) {
                            this.setTableSpace(tableProxy, storageDesign, rs.getString("DEF_TABLESPACE_NAME"));
                            if (tableProxy.getSnapshot() != null) {
                                tableProxy.getSnapshot().setTablespace(tableProxy.getTableSpace());
                            }
                            this.setDefProperties(tableProxy, storageDesign, rs);
                            String part_type = rs.getString("PARTITIONING_TYPE").trim();
                            String subPartType = rs.getString("SUBPARTITIONING_TYPE").trim();
                            int partCount = rs.getInt("PARTITION_COUNT");
                            PartitionListOracle partitionList = storageDesign.getPartitionListSet().createPartitionList();
                            if ("HASH".equalsIgnoreCase(part_type)) {
                                partitionList.setPartitionType("HASH BY LIST OF PARTITIONS");
                                partitionList.setHashPQuantity(partCount);
                            } else if ("HASH".equalsIgnoreCase(subPartType) && !oraclev11g) {
                                partitionList.setPartitionType("COMPOSITE BY HASH");
                            } else if ("LIST".equalsIgnoreCase(subPartType) && !oraclev11g) {
                                partitionList.setPartitionType("COMPOSITE BY LIST");
                            } else {
                                partitionList.setPartitionType(part_type);
                            }
                            if ("HASH".equalsIgnoreCase(subPartType)) {
                                int subpartCount = rs.getInt("DEF_SUBPARTITION_COUNT");
                                partitionList.setSubPartitionsQuantity(subpartCount);
                            }
                            if (oraclev11g) {
                                String refConstraint;
                                partitionList.setSubpartitionType(subPartType);
                                String intervalExp = rs.getString("INTERVAL");
                                if (intervalExp != null) {
                                    ((PartitionListOraclev11g)partitionList).setIntervalExpression(intervalExp);
                                }
                                if ((refConstraint = rs.getString("REF_PTN_CONSTRAINT_NAME")) != null) {
                                    partitionList.setTable(tableProxy);
                                    ((PartitionListOraclev11g)partitionList).setRefConstraint(refConstraint);
                                }
                            }
                            tableProxy.setPartitionList(partitionList);
                            if (col_statement == null) {
                                col_statement = sqlConnection.prepareStatement(col_sql);
                            }
                            this.setPartitioningColumns(tableProxy.getName(), owner, partitionList, col_statement);
                            if (!"NONE".equalsIgnoreCase(subPartType) && !"SYSTEM".equalsIgnoreCase(subPartType)) {
                                this.setSubPartitioningColumns(tableProxy, tableProxy.getName(), owner, partitionList, sqlConnection);
                            }
                            if (partCount > 0 && this.getDbmeHandler().isPartitions()) {
                                this.setPartitions(tableProxy, owner, storageDesign, partitionList, sqlConnection, part_type);
                            }
                            if (!(tableProxy instanceof TableProxyOraclev12c) || !allProps) continue;
                            TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)tableProxy;
                            String inMemory = rs.getString("DEF_INMEMORY");
                            if ("DISABLED".equals(inMemory)) {
                                tableProxy12c.setInMemory("NO");
                                continue;
                            }
                            if (!"ENABLED".equals(inMemory)) continue;
                            tableProxy12c.setInMemory("YES");
                            tableProxy12c.setInMemoryPriority(rs.getString("DEF_INMEMORY_PRIORITY"));
                            tableProxy12c.setInMemoryDistribute(rs.getString("DEF_INMEMORY_DISTRIBUTE"));
                            tableProxy12c.setInMemoryCompression(rs.getString("DEF_INMEMORY_COMPRESSION"));
                            tableProxy12c.setInMemoryDuplicate(rs.getString("DEF_INMEMORY_DUPLICATE"));
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.setPartitionInfo():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{this.subPart_statement, this.subpartCol_statement, this.subpartTemplate_statement, this.partLS_statement, this.subPartLS_statement, this.subPartTemplateLS_statement, col_statement, statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.subPart_statement, this.subpartCol_statement, this.subpartTemplate_statement, this.partLS_statement, this.subPartLS_statement, this.subPartTemplateLS_statement, col_statement, statement});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSegmentForPartitionedTable(Connection sqlConnection, StorageDesignOracle storageDesign, List dbos) throws Exception {
        PreparedStatement statement = null;
        boolean allProps = true;
        try {
            for (DBObject dbo : dbos) {
                if (!dbo.partitioned) continue;
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                ResultSet rs = null;
                try {
                    try {
                        if (statement == null) {
                            String sql = this.getPartTablesQuery(storageDesign, allProps);
                            statement = sqlConnection.prepareStatement(sql);
                        }
                        statement.setString(1, dbo.getSchema());
                        statement.setString(2, tableProxy.getName());
                        rs = statement.executeQuery();
                    }
                    catch (SQLSyntaxErrorException e) {
                        if (allProps) {
                            allProps = false;
                            if (statement != null) {
                                Closeables.close((Object)statement);
                            }
                            String sql = this.getPartTablesQuery(storageDesign, allProps);
                            statement = sqlConnection.prepareStatement(sql);
                            statement.setString(1, dbo.getSchema());
                            statement.setString(2, tableProxy.getName());
                            rs = statement.executeQuery();
                        }
                        throw e;
                    }
                    if (rs != null) {
                        while (rs.next()) {
                            this.setTableSpace(tableProxy, storageDesign, rs.getString("DEF_TABLESPACE_NAME"));
                            if (tableProxy.getSnapshot() != null) {
                                tableProxy.getSnapshot().setTablespace(tableProxy.getTableSpace());
                            }
                            this.setDefProperties(tableProxy, storageDesign, rs);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.setPartitionInfo():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPartitioningColumns(String tbName, String owner, PartitionListOracle partitionList, PreparedStatement statement) throws Exception {
        ResultSet rs = null;
        try {
            statement.setString(1, owner);
            statement.setString(2, tbName);
            rs = statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString("COLUMN_NAME");
                    partitionList.setColumnList(name);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setPartitioningColumns():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubPartitioningColumns(TableProxyOracle tableProxy, String tbName, String owner, PartitionListOracle partitionList, Connection sqlConnection) throws Exception {
        if (this.subpartCol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("COLUMN_POSITION").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_subpart_key_columns" : "all_subpart_key_columns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("OBJECT_TYPE").append('=').append('\'');
            buffer.append("TABLE").append('\'').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("COLUMN_POSITION");
            String sql = buffer.toString();
            this.subpartCol_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.subpartCol_statement.setString(1, owner);
            this.subpartCol_statement.setString(2, tbName);
            rs = this.subpartCol_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString("COLUMN_NAME");
                    partitionList.setSubPartitionsColumnList(name);
                }
                rs.close();
                this.setSubPartitionTemplate(tableProxy, tbName, owner, partitionList, sqlConnection);
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitioningColumns():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubPartitionTemplate(TableProxyOracle tableProxy, String tbName, String owner, PartitionListOracle partitionList, Connection sqlConnection) throws Exception {
        ResultSet rs = null;
        try {
            if (this.subpartTemplate_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("SUBPARTITION_NAME").append(',');
                buffer.append("TABLESPACE_NAME").append(',');
                buffer.append("HIGH_BOUND").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_subpartition_templates" : "all_subpartition_templates").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("USER_NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
                buffer.append("ORDER BY").append(' ').append("SUBPARTITION_POSITION");
                String sql = buffer.toString();
                this.subpartTemplate_statement = sqlConnection.prepareStatement(sql);
            }
            this.subpartTemplate_statement.setString(1, owner);
            this.subpartTemplate_statement.setString(2, tbName);
            rs = this.subpartTemplate_statement.executeQuery();
            boolean first = true;
            boolean hasLobColumns = false;
            if (rs != null) {
                while (rs.next()) {
                    AbstractStorageObjectOracle template;
                    if (first) {
                        ((PartitionListOraclev9i)partitionList).setUseSubpartStorageTemplate("YES");
                        hasLobColumns = this.hasLobColumns(tableProxy);
                        first = false;
                    }
                    String partName = rs.getString("SUBPARTITION_NAME");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    StorageDesignOracle stdes = (StorageDesignOracle)tableProxy.getStorageDesign();
                    TableSpaceOracle tableSpace = null;
                    if (tsName != null && (tableSpace = (TableSpaceOracle)stdes.getTableSpaceSet().getByName(tsName)) == null) {
                        tableSpace = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                        tableSpace.setName(tsName);
                        this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                    }
                    String highBound = rs.getString("HIGH_BOUND");
                    String subpartitionType = partitionList.getSubpartitionType();
                    if (subpartitionType.equals("HASH")) {
                        HashPartitionOracle partition = stdes.getHashPartitionSet().createHashPartition();
                        partition.setName(partName);
                        if (!partName.equals(partName.toUpperCase())) {
                            partition.setNameHasQuotes(true);
                        }
                        partition.setPartOfStorageTable(tableProxy);
                        if (tableSpace != null) {
                            partition.setTableSpace(tableSpace);
                        }
                        if (!hasLobColumns) continue;
                        this.setSubPartTemplateLobStorage(partition, tableProxy, owner, stdes, sqlConnection);
                        continue;
                    }
                    if (subpartitionType.equals("LIST")) {
                        template = stdes.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                        template.setName(partName);
                        if (!partName.equals(partName.toUpperCase())) {
                            template.setNameHasQuotes(true);
                        }
                        ((ListStorageTemplatePartitionOracle)template).setPartOfStorageTable(tableProxy);
                        if (highBound != null) {
                            ((ListStorageTemplatePartitionOracle)template).setValueList(highBound);
                        }
                        if (tableSpace != null) {
                            ((ListStorageTemplatePartitionOracle)template).setTablespace(tableSpace);
                        }
                        if (!hasLobColumns) continue;
                        this.setSubPartTemplateLobStorage(template, tableProxy, owner, stdes, sqlConnection);
                        continue;
                    }
                    if (!subpartitionType.equals("RANGE")) continue;
                    template = (PartitionOraclev11g)stdes.getPartitionSet().createPartition();
                    template.setName(partName);
                    if (!partName.equals(partName.toUpperCase())) {
                        template.setNameHasQuotes(true);
                    }
                    ((PartitionOraclev11g)template).setPartOfStorageTable(tableProxy);
                    if (highBound != null) {
                        ((PartitionOracle)template).setValueList(highBound);
                    }
                    if (tableSpace != null) {
                        ((PartitionOracle)template).setTableSpace(tableSpace);
                    }
                    if (!hasLobColumns) continue;
                    this.setSubPartTemplateLobStorage(template, tableProxy, owner, stdes, sqlConnection);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitionTemplate():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPartitions(TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, PartitionListOracle partitionList, Connection sqlConnection, String part_type) throws Exception {
        boolean list = "LIST".equals(part_type);
        boolean partTypeHash = "HASH".equals(part_type);
        boolean oraclev11g = storageDesign instanceof StorageDesignOraclev11g;
        if (this.part_statement == null) {
            Object sql = "SELECT a.PARTITION_NAME,   a.SUBPARTITION_COUNT,   a.HIGH_VALUE,   a.TABLESPACE_NAME,   a.PCT_FREE,   a.PCT_USED,   a.INI_TRANS,   a.MAX_TRANS,   a.INITIAL_EXTENT,   a.NEXT_EXTENT,   a.MIN_EXTENT,   a.MAX_EXTENT,   a.PCT_INCREASE,   a.FREELISTS,   a.FREELIST_GROUPS,   a.LOGGING,   a.COMPRESSION,   a.BUFFER_POOL,   b.SUBPARTITION_NAME,   b.high_value as SUBP_HIGH_VALUE,   b.SUBPARTITION_POSITION,   b.tablespace_name as SUBP_TABLESPACE_NAME ";
            if (oraclev11g) {
                sql = (String)sql + "  ,b.compression as SUBP_COMPRESSION ";
            }
            sql = this.dbaUser ? (String)sql + " FROM dba_tab_partitions a,   dba_tab_subpartitions b " : (String)sql + " FROM ALL_TAB_PARTITIONS a,   ALL_TAB_SUBPARTITIONS b ";
            sql = (String)sql + " WHERE a.TABLE_OWNER    = ?   AND a.TABLE_NAME     = ?   and a.TABLE_OWNER    = b.TABLE_OWNER (+)   and a.TABLE_NAME     = b.TABLE_NAME (+)   and a.PARTITION_NAME = b.PARTITION_NAME (+)  ORDER BY a.PARTITION_POSITION,   b.SUBPARTITION_POSITION";
            this.part_statement = sqlConnection.prepareStatement((String)sql);
        }
        String cur_name = "";
        AbstractStorageObjectOracle used_partition = null;
        ResultSet rs = null;
        try {
            this.part_statement.setString(1, owner);
            this.part_statement.setString(2, tableProxy.getName());
            rs = this.part_statement.executeQuery();
            if (rs != null) {
                boolean hasLobColumns = this.hasLobColumns(tableProxy);
                boolean potentialHashByQuantity = false;
                boolean removeHashSubparts = false;
                ModelIDObject hashPartTablespace = null;
                TableSpaceOracle hashSubpartTablespace = null;
                int position = 0;
                while (rs.next()) {
                    int subPartCount;
                    String high_value = rs.getString("HIGH_VALUE");
                    String spHighValue = rs.getString("SUBP_HIGH_VALUE");
                    String name = rs.getString("PARTITION_NAME");
                    if (!name.equalsIgnoreCase(cur_name)) {
                        if (position > 0) {
                            this.finalizePartition(tableProxy, used_partition, removeHashSubparts, hashSubpartTablespace, hasLobColumns, owner, storageDesign, sqlConnection);
                        }
                        ++position;
                        cur_name = name;
                        hashSubpartTablespace = null;
                        removeHashSubparts = partitionList.getSubpartitionType().equals("HASH");
                        String tsName = rs.getString("TABLESPACE_NAME");
                        int pct_free = rs.getInt("PCT_FREE");
                        String pctUsed = rs.getString("PCT_USED");
                        int pct_used = 40;
                        if (pctUsed != null) {
                            try {
                                pct_used = Integer.parseInt(pctUsed);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        int ini_trans = rs.getInt("INI_TRANS");
                        int max_trans = rs.getInt("MAX_TRANS");
                        long initial_extent = rs.getLong("INITIAL_EXTENT");
                        long next_extent = rs.getLong("NEXT_EXTENT");
                        int min_extent = rs.getInt("MIN_EXTENT");
                        int max_extent = rs.getInt("MAX_EXTENT");
                        int pct_increase = rs.getInt("PCT_INCREASE");
                        int freeLists = rs.getInt("FREELISTS");
                        int freeListGroups = rs.getInt("FREELIST_GROUPS");
                        String logging = rs.getString("LOGGING");
                        String compression = rs.getString("COMPRESSION");
                        String buffer_pool = rs.getString("BUFFER_POOL");
                        TableSpaceOracle tableSpace = null;
                        if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                            tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                        }
                        if (partTypeHash) {
                            HashPartitionOracle hashPartition = storageDesign.getHashPartitionSet().createHashPartition();
                            hashPartition.setName(name);
                            if (!name.equals(name.toUpperCase())) {
                                hashPartition.setNameHasQuotes(true);
                            }
                            hashPartition.setPartitionList(partitionList);
                            hashPartition.setTableSpace(tableSpace);
                            if (hasLobColumns) {
                                this.setPartitionLobStorage(hashPartition, tableProxy, owner, storageDesign, sqlConnection);
                            }
                            if (name.startsWith("SYS_P")) {
                                if (position == 1) {
                                    hashPartTablespace = tableSpace;
                                    potentialHashByQuantity = true;
                                } else if (hashPartTablespace != tableSpace) {
                                    potentialHashByQuantity = false;
                                }
                            } else {
                                potentialHashByQuantity = false;
                            }
                        } else {
                            SegmentOracle tsegment;
                            SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
                            if (segment.getDesign().getSettings().isIncludePctFreeInDDL()) {
                                segment.setPCTFree(pct_free);
                            }
                            if (segment.getDesign().getSettings().isIncludePctUsedInDDL()) {
                                segment.setPCTUsed(pct_used);
                            }
                            if (segment.getDesign().getSettings().isIncludeInitransInDDL()) {
                                segment.setInitrans(ini_trans);
                                segment.setMaxTrans(max_trans);
                            }
                            if (segment.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                                segment.setSCInitialExtent(initial_extent);
                            }
                            if (segment.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                                segment.setSCNextExtent(next_extent);
                            }
                            if (segment.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                                segment.setSCMinExtents(min_extent);
                            }
                            if (segment.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment.setSCMaxExtents(String.valueOf(max_extent));
                            }
                            if (segment.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                                segment.setSCPctIncrease(pct_increase);
                            }
                            if (segment.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                                segment.setSCFreeLists(freeLists);
                            }
                            if (segment.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                                segment.setSCFreelistGroups(freeListGroups);
                            }
                            if (segment.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                                segment.setSCBufferPool(buffer_pool);
                            }
                            if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                                segment.remove(true);
                            }
                            segment = tsegment;
                            if (list) {
                                ListPartitionOracle lpart;
                                used_partition = lpart = storageDesign.getListPartitionSet().createListPartition();
                                lpart.setName(name);
                                if (!name.equals(name.toUpperCase())) {
                                    lpart.setNameHasQuotes(true);
                                }
                                lpart.setPartitionList(partitionList);
                                lpart.setPosition(position);
                                lpart.setColumns(high_value);
                                if (tableSpace != null) {
                                    lpart.setTablespace(tableSpace);
                                }
                                if (!"NONE".equalsIgnoreCase(logging)) {
                                    lpart.setLogging(logging);
                                }
                                if ("ENABLED".equalsIgnoreCase(compression)) {
                                    lpart.setDataSegmentCompression("YES");
                                } else if ("DISABLED".equalsIgnoreCase(compression)) {
                                    lpart.setDataSegmentCompression("NO");
                                }
                                lpart.setSegment(segment);
                                if (hasLobColumns) {
                                    this.setPartitionLobStorage(lpart, tableProxy, owner, storageDesign, sqlConnection);
                                }
                            } else {
                                PartitionOracle partition = storageDesign.getPartitionSet().createPartition();
                                used_partition = partition;
                                partition.setName(name);
                                if (!name.equals(name.toUpperCase())) {
                                    partition.setNameHasQuotes(true);
                                }
                                partition.setPartitionList(partitionList);
                                partition.setPosition(position);
                                if (high_value != null) {
                                    partition.setValueList(high_value);
                                }
                                if (tableSpace != null) {
                                    partition.setTableSpace(tableSpace);
                                }
                                if (!"NONE".equalsIgnoreCase(logging)) {
                                    partition.setLogging(logging);
                                }
                                if ("ENABLED".equalsIgnoreCase(compression)) {
                                    partition.setDataSegmentCompression("YES");
                                } else if ("DISABLED".equalsIgnoreCase(compression)) {
                                    partition.setDataSegmentCompression("NO");
                                }
                                partition.setSegment(segment);
                                if (hasLobColumns) {
                                    this.setPartitionLobStorage(partition, tableProxy, owner, storageDesign, sqlConnection);
                                }
                            }
                        }
                    }
                    if ((subPartCount = rs.getInt("SUBPARTITION_COUNT")) <= 0 || used_partition == null) continue;
                    String spname = rs.getString("SUBPARTITION_NAME");
                    int spPosition = rs.getInt("SUBPARTITION_POSITION");
                    String spTablespaceName = rs.getString("SUBP_TABLESPACE_NAME");
                    String spCompression = "";
                    if (oraclev11g) {
                        spCompression = rs.getString("SUBP_COMPRESSION");
                    }
                    AbstractStorageObjectOracle subPartition = null;
                    if (list && used_partition instanceof ListPartitionOracle) {
                        if (partitionList.getSubpartitionType().equals("HASH") && used_partition instanceof ListPartitionOraclev11g) {
                            ((ListPartitionOraclev11g)used_partition).setSubPartitionsQuantity(subPartCount);
                        }
                        subPartition = this.addSubpartition(used_partition, tableProxy, storageDesign, partitionList, spname, spTablespaceName, spCompression, spHighValue);
                    } else if (used_partition instanceof PartitionOracle) {
                        if (partitionList.getSubpartitionType().equals("HASH")) {
                            ((PartitionOracle)used_partition).setSubPartitionsQuantity(subPartCount);
                        }
                        subPartition = this.addSubpartition(used_partition, tableProxy, storageDesign, partitionList, spname, spTablespaceName, spCompression, spHighValue);
                    }
                    if (!removeHashSubparts) continue;
                    if (spname.startsWith("SYS_SUBP")) {
                        if (!(subPartition instanceof HashPartitionOracle)) continue;
                        TableSpaceOracle tablespace = ((HashPartitionOracle)subPartition).getTableSpace();
                        if (spPosition == 1) {
                            hashSubpartTablespace = tablespace;
                            continue;
                        }
                        if (tablespace == hashSubpartTablespace) continue;
                        removeHashSubparts = false;
                        continue;
                    }
                    removeHashSubparts = false;
                }
                this.finalizePartition(tableProxy, used_partition, removeHashSubparts, hashSubpartTablespace, hasLobColumns, owner, storageDesign, sqlConnection);
                rs.close();
                if (potentialHashByQuantity) {
                    partitionList.setPartitionType("HASH BY QUANTITY");
                    if (hashPartTablespace != tableProxy.getTableSpace() && hashPartTablespace != null) {
                        partitionList.setHashPTableSpaces(hashPartTablespace.getObjectID());
                    }
                }
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("MOHTableOracle.setPartitions():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private void finalizePartition(TableProxyOracle tableProxy, AbstractStorageObjectOracle partition, boolean removeHashSubparts, TableSpaceOracle hashSubpartTablespace, boolean hasLobColumns, String owner, StorageDesignOracle storageDesign, Connection sqlConnection) {
        try {
            if (removeHashSubparts) {
                if (partition instanceof PartitionOracle) {
                    PartitionOracle rangePartition = (PartitionOracle)partition;
                    rangePartition.getPartitions().removeAll();
                    if (hashSubpartTablespace != null && hashSubpartTablespace != rangePartition.getTableSpace()) {
                        rangePartition.setSubPartitionsTableSpaces(hashSubpartTablespace.getName());
                    }
                    return;
                }
                if (partition instanceof ListPartitionOraclev11g) {
                    ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                    listPartition.getHashSubpartitions().removeAll();
                    if (hashSubpartTablespace != null && hashSubpartTablespace != listPartition.getTablespace()) {
                        listPartition.setSubPartitionsTableSpaces(hashSubpartTablespace.getName());
                    }
                    return;
                }
            }
            ModelObjectSet subpartitions = null;
            TableSpaceOracle partitionTablespace = null;
            String partitionCompress = "";
            if (partition instanceof PartitionOracle) {
                PartitionOracle rangePartition = (PartitionOracle)partition;
                partitionTablespace = rangePartition.getTableSpace();
                partitionCompress = rangePartition.getDataSegmentCompression();
                subpartitions = rangePartition.getPartitions();
                if (subpartitions.size() == 0 && (subpartitions = rangePartition.getListPartitions()).size() == 0 && rangePartition instanceof PartitionOraclev11g) {
                    subpartitions = ((PartitionOraclev11g)rangePartition).getRangeSubpartitions();
                }
            } else if (partition instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                partitionTablespace = listPartition.getTablespace();
                partitionCompress = listPartition.getDataSegmentCompression();
                subpartitions = listPartition.getHashSubpartitions();
                if (subpartitions.size() == 0 && (subpartitions = listPartition.getListSubpartitions()).size() == 0) {
                    subpartitions = listPartition.getRangeSubpartitions();
                }
            }
            if (subpartitions != null && subpartitions.size() > 0) {
                boolean canRemoveSubparts = false;
                int subpartCount = subpartitions.size();
                StorageObjectCollection subpartTemplates = tableProxy.getListStorageTemplates();
                if (subpartTemplates.size() == subpartCount) {
                    canRemoveSubparts = true;
                    if (partitionCompress.length() == 0) {
                        partitionCompress = tableProxy.getDataSegmentCompression();
                    }
                    for (int i = 0; i < subpartCount && canRemoveSubparts; ++i) {
                        String subpartCompress;
                        AbstractStorageObjectOracle tsp;
                        AbstractStorageObjectOracle sp;
                        AbstractStorageObjectOracle subpart = (AbstractStorageObjectOracle)subpartitions.getElement(i);
                        AbstractStorageObjectOracle templateSubpart = (AbstractStorageObjectOracle)subpartTemplates.getElement(i);
                        if (partition.getName().startsWith("SYS_P")) {
                            if (!subpart.getName().startsWith("SYS_SUBP")) {
                                canRemoveSubparts = false;
                            }
                        } else if (!subpart.getName().endsWith("_" + templateSubpart.getName())) {
                            canRemoveSubparts = false;
                        }
                        boolean propsMatch = false;
                        if (subpart instanceof PartitionOracle && templateSubpart instanceof PartitionOracle) {
                            sp = (PartitionOracle)subpart;
                            tsp = (PartitionOracle)templateSubpart;
                            if (((PartitionOracle)sp).getValueList().equals(((PartitionOracle)tsp).getValueList())) {
                                propsMatch = ((PartitionOracle)tsp).getTableSpace() == null ? ((PartitionOracle)sp).getTableSpace() == partitionTablespace : ((PartitionOracle)sp).getTableSpace() == ((PartitionOracle)tsp).getTableSpace();
                                subpartCompress = ((PartitionOracle)sp).getDataSegmentCompression();
                                if (subpartCompress.length() > 0 && !subpartCompress.equals(partitionCompress)) {
                                    propsMatch = false;
                                }
                            }
                        } else if (subpart instanceof ListStorageTemplatePartitionOracle && templateSubpart instanceof ListStorageTemplatePartitionOracle) {
                            sp = (ListStorageTemplatePartitionOracle)subpart;
                            tsp = (ListStorageTemplatePartitionOracle)templateSubpart;
                            if (((ListStorageTemplatePartitionOracle)sp).getValueList().equals(((ListStorageTemplatePartitionOracle)tsp).getValueList())) {
                                propsMatch = ((ListStorageTemplatePartitionOracle)tsp).getTablespace() == null ? ((ListStorageTemplatePartitionOracle)sp).getTablespace() == partitionTablespace : ((ListStorageTemplatePartitionOracle)sp).getTablespace() == ((ListStorageTemplatePartitionOracle)tsp).getTablespace();
                                subpartCompress = ((ListStorageTemplatePartitionOracle)sp).getDataSegmentCompression();
                                if (subpartCompress.length() > 0 && !subpartCompress.equals(partitionCompress)) {
                                    propsMatch = false;
                                }
                            }
                        } else if (subpart instanceof HashPartitionOracle && templateSubpart instanceof HashPartitionOracle) {
                            TableSpaceOracle subpartTS = ((HashPartitionOracle)subpart).getTableSpace();
                            TableSpaceOracle templateTS = ((HashPartitionOracle)templateSubpart).getTableSpace();
                            if (templateTS == null) {
                                propsMatch = subpartTS == partitionTablespace;
                            } else {
                                boolean bl = propsMatch = subpartTS == templateTS;
                            }
                        }
                        if (propsMatch) continue;
                        canRemoveSubparts = false;
                    }
                    if (canRemoveSubparts) {
                        subpartitions.removeAll();
                    }
                }
                if (hasLobColumns && !canRemoveSubparts) {
                    for (AbstractStorageObjectOracle subpartition : subpartitions) {
                        this.setSubPartitionLobStorage(subpartition, tableProxy, owner, storageDesign, sqlConnection);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.finalizePartition():", e);
        }
    }

    private boolean hasLobColumns(TableProxy tableProxy) {
        Table table = (Table)tableProxy.getObject();
        String rdbmsName = tableProxy.getRDBMSType().getName();
        for (Column column : table.getElementsCollection()) {
            String type = column.getDatatypeString(rdbmsName).toUpperCase();
            if (!type.equals("BLOB") && !type.endsWith("CLOB")) continue;
            return true;
        }
        return false;
    }

    private AbstractStorageObjectOracle addSubpartition(AbstractStorageObjectOracle partition, TableProxyOracle tableProxy, StorageDesignOracle storageDesign, PartitionListOracle partitionList, String subPartName, String tablespaceName, String compression, String highValue) throws Exception {
        boolean oraclev11g = storageDesign instanceof StorageDesignOraclev11g;
        String name = subPartName;
        String subpartitionType = partitionList.getSubpartitionType();
        TableSpaceOracle tableSpace = null;
        if (tablespaceName != null && !"".equalsIgnoreCase(tablespaceName)) {
            tableSpace = this.getTablespace(tablespaceName, storageDesign, tableProxy);
        }
        if (subpartitionType.equals("HASH")) {
            HashPartitionOracle hashPartition = storageDesign.getHashPartitionSet().createHashPartition();
            hashPartition.setName(name);
            if (!name.equals(name.toUpperCase())) {
                hashPartition.setNameHasQuotes(true);
            }
            hashPartition.setSubPartitionOf(partition);
            hashPartition.setTableSpace(tableSpace);
            return hashPartition;
        }
        if (subpartitionType.equals("LIST")) {
            ListStorageTemplatePartitionOracle listPartition = storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
            listPartition.setName(name);
            if (!name.equals(name.toUpperCase())) {
                listPartition.setNameHasQuotes(true);
            }
            listPartition.setSubPartitionOf(partition);
            listPartition.setTablespace(tableSpace);
            if (highValue != null) {
                listPartition.setValueList(highValue);
            }
            if (oraclev11g) {
                if ("ENABLED".equalsIgnoreCase(compression)) {
                    listPartition.setDataSegmentCompression("YES");
                } else if ("DISABLED".equalsIgnoreCase(compression)) {
                    listPartition.setDataSegmentCompression("NO");
                }
            }
            return listPartition;
        }
        if (subpartitionType.equals("RANGE")) {
            PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)storageDesign.getPartitionSet().createPartition();
            rangeSubpartition.setName(name);
            if (!name.equals(name.toUpperCase())) {
                rangeSubpartition.setNameHasQuotes(true);
            }
            rangeSubpartition.setSubPartitionOf(partition);
            rangeSubpartition.setTableSpace(tableSpace);
            if (highValue != null) {
                rangeSubpartition.setValueList(highValue);
            }
            if (oraclev11g) {
                if ("ENABLED".equalsIgnoreCase(compression)) {
                    rangeSubpartition.setDataSegmentCompression("YES");
                } else if ("DISABLED".equalsIgnoreCase(compression)) {
                    rangeSubpartition.setDataSegmentCompression("NO");
                }
            }
            return rangeSubpartition;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableLobStorage(StorageDesignOracle storageDesign, Connection sqlConnection, List dbos) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',');
        buffer.append("SEGMENT_NAME").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("CHUNK").append(',');
        buffer.append("PCTVERSION").append(',');
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append("SECUREFILE").append(',');
            buffer.append("COMPRESSION").append(',');
            buffer.append("DEDUPLICATION").append(',');
        }
        buffer.append("FREEPOOLS").append(',');
        buffer.append("CACHE").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("IN_ROW").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lobs" : "all_lobs").append(' ');
        buffer.append("WHERE").append(' ').append("PARTITIONED").append('=').append(' ');
        buffer.append('\'').append("NO").append('\'').append(' ');
        buffer.append("AND").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
        String sql = buffer.toString();
        if (storageDesign instanceof StorageDesignOraclev9i) {
            buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',');
            buffer.append("SEGMENT_NAME").append(',');
            buffer.append("NULL").append(' ').append("AS").append(' ').append("TABLESPACE_NAME").append(',');
            buffer.append("CHUNK").append(',');
            buffer.append("PCTVERSION").append(',');
            buffer.append("CACHE").append(',');
            buffer.append("LOGGING").append(',');
            buffer.append("IN_ROW").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lobs" : "all_lobs").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
            sql = buffer.toString();
        }
        PreparedStatement statement = null;
        try {
            for (DBObject dbo : dbos) {
                if (dbo.externalTable || !dbo.hasLOBs) continue;
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, tableProxy.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            String columnName = Token.removeQuotes(rs.getString("COLUMN_NAME"));
                            if (columnName.startsWith("SYS_NC")) continue;
                            String name = rs.getString("SEGMENT_NAME");
                            if (columnName.indexOf(46) > -1 && name.startsWith("SYS_LOB")) continue;
                            String tsName = rs.getString("TABLESPACE_NAME");
                            int chunk = rs.getInt("CHUNK");
                            int pctVersion = rs.getInt("PCTVERSION");
                            String securefile = "";
                            if (storageDesign instanceof StorageDesignOraclev11g) {
                                securefile = rs.getString("SECUREFILE");
                            }
                            String cache = rs.getString("CACHE");
                            String logging = rs.getString("LOGGING");
                            String inrow = rs.getString("IN_ROW");
                            LobStorageOracle lobStorage = storageDesign.getLobStorageSet().createLobStorage();
                            lobStorage.setName(name);
                            if (!name.startsWith("SYS_LOB")) {
                                lobStorage.setLobSegmentName(name);
                            }
                            lobStorage.setTable(tableProxy);
                            lobStorage.setColumn(columnName);
                            lobStorage.setChunk(chunk);
                            lobStorage.setPCTVersion(pctVersion);
                            if (storageDesign instanceof StorageDesignOraclev10g) {
                                lobStorage.setFreepools(rs.getInt("FREEPOOLS"));
                            }
                            if ("YES".equalsIgnoreCase(securefile)) {
                                lobStorage.setLobStorageType("SECUREFILE");
                                String compression = rs.getString("COMPRESSION");
                                if (compression.equals("HIGH") || compression.equals("MEDIUM") || compression.equals("LOW")) {
                                    lobStorage.setCompression("YES");
                                    lobStorage.setCompressionType(compression);
                                } else if (compression.equals("NO")) {
                                    lobStorage.setCompression("NO");
                                }
                                String deduplication = rs.getString("DEDUPLICATION");
                                if (deduplication.equals("LOB")) {
                                    lobStorage.setDuplication("DEDUPLICATE");
                                } else if (deduplication.equals("NO")) {
                                    lobStorage.setDuplication("KEEP_DUPLICATES");
                                }
                            }
                            if ("YES".equalsIgnoreCase(cache = cache.trim())) {
                                lobStorage.setCache("CACHE");
                            } else if ("CACHEREADS".equalsIgnoreCase(cache)) {
                                lobStorage.setCache("CACHE READS");
                            } else {
                                lobStorage.setCache("NOCACHE");
                            }
                            if ("YES".equalsIgnoreCase(inrow.trim())) {
                                lobStorage.setStorageInRow("ENABLE");
                            } else {
                                lobStorage.setStorageInRow("DISABLE");
                            }
                            if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                                TableSpaceOracle tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                                lobStorage.setTableSpace(tableSpace);
                            }
                            if ("NONE".equalsIgnoreCase(logging = logging.trim())) continue;
                            if ("YES".equalsIgnoreCase(securefile) && "NO".equalsIgnoreCase(logging)) {
                                lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
                                continue;
                            }
                            lobStorage.setLogging(logging);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.setTableLobStorage():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTablePartLobStorage(StorageDesignOracle storageDesign, Connection sqlConnection, List dbos) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("LOB_NAME").append(',');
        buffer.append("DEF_CHUNK").append(',');
        buffer.append("DEF_PCTVERSION").append(',');
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append("DEF_SECUREFILE").append(',').append(' ');
        }
        buffer.append("DEF_CACHE").append(',');
        buffer.append("DEF_IN_ROW").append(',');
        buffer.append("DEF_TABLESPACE_NAME").append(',');
        buffer.append("DEF_INITIAL_EXTENT").append(',');
        buffer.append("DEF_NEXT_EXTENT").append(',');
        buffer.append("DEF_MIN_EXTENTS").append(',');
        buffer.append("DEF_MAX_EXTENTS").append(',');
        buffer.append("DEF_PCT_INCREASE").append(',');
        buffer.append("DEF_FREELISTS").append(',');
        buffer.append("DEF_FREELIST_GROUPS").append(',');
        buffer.append("DEF_LOGGING").append(',');
        buffer.append("DEF_BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_part_lobs" : "all_part_lobs").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLE_OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("LOB_NAME");
        String sql = buffer.toString();
        PreparedStatement statement = null;
        try {
            for (DBObject dbo : dbos) {
                if (dbo.externalTable || !dbo.partitioned || !dbo.hasLOBs) continue;
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, tableProxy.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            String name = rs.getString("LOB_NAME");
                            String columnName = rs.getString("COLUMN_NAME");
                            int chunk = rs.getInt("DEF_CHUNK");
                            int pctVersion = rs.getInt("DEF_PCTVERSION");
                            String securefile = "";
                            if (storageDesign instanceof StorageDesignOraclev11g) {
                                securefile = rs.getString("DEF_SECUREFILE");
                            }
                            String cache = rs.getString("DEF_CACHE");
                            String inrow = rs.getString("DEF_IN_ROW");
                            String tsName = rs.getString("DEF_TABLESPACE_NAME");
                            String initial_extent = rs.getString("DEF_INITIAL_EXTENT");
                            String next_extent = rs.getString("DEF_NEXT_EXTENT");
                            String min_extents = rs.getString("DEF_MIN_EXTENTS");
                            String max_extents = rs.getString("DEF_MAX_EXTENTS");
                            String pctIncrease = rs.getString("DEF_PCT_INCREASE");
                            String free_lists = rs.getString("DEF_FREELISTS");
                            String freelist_groups = rs.getString("DEF_FREELIST_GROUPS");
                            String logging = rs.getString("DEF_LOGGING");
                            String bufferPool = rs.getString("DEF_BUFFER_POOL");
                            LobStorageOracle lobStorage = storageDesign.getLobStorageSet().createLobStorage();
                            lobStorage.setName(name);
                            if (!name.startsWith("SYS_LOB")) {
                                lobStorage.setLobSegmentName(name);
                            }
                            lobStorage.setTable(tableProxy);
                            lobStorage.setColumn(columnName);
                            lobStorage.setChunk(chunk);
                            lobStorage.setPCTVersion(pctVersion);
                            if (lobStorage instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(securefile)) {
                                lobStorage.setLobStorageType("SECUREFILE");
                            }
                            if ("YES".equalsIgnoreCase(cache = cache.trim())) {
                                lobStorage.setCache("CACHE");
                            } else if ("CACHEREADS".equalsIgnoreCase(cache)) {
                                lobStorage.setCache("CACHE READS");
                            } else {
                                lobStorage.setCache("NOCACHE");
                            }
                            if ("YES".equalsIgnoreCase(inrow.trim())) {
                                lobStorage.setStorageInRow("ENABLE");
                            } else {
                                lobStorage.setStorageInRow("DISABLE");
                            }
                            if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                                TableSpaceOracle tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                                lobStorage.setTableSpace(tableSpace);
                            }
                            if (initial_extent != null && lobStorage.getDesign().getSettings().isIncludeInitialExtentInDDL() && !"DEFAULT".equalsIgnoreCase(initial_extent.trim())) {
                                try {
                                    long value = Long.parseLong(initial_extent.trim());
                                    lobStorage.setSCInitialExtent(value);
                                }
                                catch (Exception value) {
                                    // empty catch block
                                }
                            }
                            if (next_extent != null && lobStorage.getDesign().getSettings().isIncludeNextExtentInDDL() && !"DEFAULT".equalsIgnoreCase(next_extent.trim())) {
                                try {
                                    long value = Long.parseLong(next_extent.trim());
                                    lobStorage.setSCNextExtent(value);
                                }
                                catch (Exception value) {
                                    // empty catch block
                                }
                            }
                            if (min_extents != null && lobStorage.getDesign().getSettings().isIncludeMinExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(min_extents.trim())) {
                                try {
                                    int value = Integer.parseInt(min_extents.trim());
                                    lobStorage.setSCMinExtents(value);
                                }
                                catch (Exception value) {
                                    // empty catch block
                                }
                            }
                            if (max_extents != null && lobStorage.getDesign().getSettings().isIncludeMaxExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(max_extents.trim())) {
                                try {
                                    int value = Integer.parseInt(max_extents.trim());
                                    lobStorage.setSCMaxExtents(String.valueOf(value));
                                }
                                catch (Exception value) {
                                    // empty catch block
                                }
                            }
                            if (pctIncrease != null && lobStorage.getDesign().getSettings().isIncludePctIncreaseInDDL() && !"DEFAULT".equalsIgnoreCase(pctIncrease.trim())) {
                                try {
                                    int value = Integer.parseInt(pctIncrease.trim());
                                    lobStorage.setSCPctIncrease(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (free_lists != null && lobStorage.getDesign().getSettings().isIncludeFreeListsInDDL() && !"DEFAULT".equalsIgnoreCase(free_lists.trim())) {
                                try {
                                    int value = Integer.parseInt(free_lists.trim());
                                    lobStorage.setSCFreeLists(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (freelist_groups != null && lobStorage.getDesign().getSettings().isIncludeFreeListGroupsInDDL() && !"DEFAULT".equalsIgnoreCase(freelist_groups.trim())) {
                                try {
                                    int value = Integer.parseInt(freelist_groups.trim());
                                    lobStorage.setSCFreelistGroups(value);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"NONE".equalsIgnoreCase(logging = logging.trim())) {
                                if ("YES".equalsIgnoreCase(securefile) && "NO".equalsIgnoreCase(logging)) {
                                    lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
                                } else {
                                    lobStorage.setLogging(logging);
                                }
                            }
                            if (!lobStorage.getDesign().getSettings().isIncludeBufferPoolInDDL()) continue;
                            lobStorage.setSCBufferPool(bufferPool);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.setTablePartLobStorage():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPartitionLobStorage(AbstractStorageObjectOracle partition, TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, Connection sqlConnection) throws Exception {
        if (this.partLS_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("LOB_NAME").append(',');
            buffer.append("LOB_PARTITION_NAME").append(',');
            buffer.append("CHUNK").append(',');
            buffer.append("PCTVERSION").append(',');
            if (storageDesign instanceof StorageDesignOraclev11g) {
                buffer.append("SECUREFILE").append(',').append(' ');
            }
            buffer.append("CACHE").append(',');
            buffer.append("IN_ROW").append(',');
            buffer.append("TABLESPACE_NAME").append(',');
            buffer.append("INITIAL_EXTENT").append(',');
            buffer.append("NEXT_EXTENT").append(',');
            buffer.append("MIN_EXTENTS").append(',');
            buffer.append("MAX_EXTENTS").append(',');
            buffer.append("PCT_INCREASE").append(',');
            buffer.append("FREELISTS").append(',');
            buffer.append("FREELIST_GROUPS").append(',');
            buffer.append("LOGGING").append(',');
            buffer.append("BUFFER_POOL").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_lob_partitions" : "all_lob_partitions").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLE_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("PARTITION_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("LOB_NAME");
            String sql = buffer.toString();
            this.partLS_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.partLS_statement.setString(1, owner);
            this.partLS_statement.setString(2, tableProxy.getName());
            this.partLS_statement.setString(3, partition.getName());
            rs = this.partLS_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    String name = rs.getString("LOB_NAME");
                    String lobPartitionName = rs.getString("LOB_PARTITION_NAME");
                    int chunk = rs.getInt("CHUNK");
                    int pctVersion = rs.getInt("PCTVERSION");
                    String securefile = "";
                    if (storageDesign instanceof StorageDesignOraclev11g) {
                        securefile = rs.getString("SECUREFILE");
                    }
                    String cache = rs.getString("CACHE");
                    String inrow = rs.getString("IN_ROW");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    String initial_extent = rs.getString("INITIAL_EXTENT");
                    String next_extent = rs.getString("NEXT_EXTENT");
                    String min_extents = rs.getString("MIN_EXTENTS");
                    String max_extents = rs.getString("MAX_EXTENTS");
                    String pctIncrease = rs.getString("PCT_INCREASE");
                    String free_lists = rs.getString("FREELISTS");
                    String freelist_groups = rs.getString("FREELIST_GROUPS");
                    String logging = rs.getString("LOGGING");
                    String bufferPool = rs.getString("BUFFER_POOL");
                    if (partition instanceof HashPartitionOracle) {
                        HashPartitionLobItemOracle lobItem = storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                        if (lobPartitionName.startsWith("SYS_LOB_P")) {
                            lobItem.setName(name);
                        } else {
                            lobItem.setName(lobPartitionName);
                        }
                        lobItem.setHashPartition((HashPartitionOracle)partition);
                        if (columnName != null && !"".equalsIgnoreCase(columnName)) {
                            ColumnProxy column = tableProxy.getColumnProxyByName(columnName);
                            lobItem.setLobColumn(column);
                        }
                        if (tsName == null || "".equalsIgnoreCase(tsName)) continue;
                        TableSpaceOracle tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                        lobItem.setTableSpace(tableSpace);
                        continue;
                    }
                    LobStorageOracle lobStorage = storageDesign.getLobStorageSet().createLobStorage();
                    lobStorage.setName(name);
                    if (!lobPartitionName.startsWith("SYS_LOB_P")) {
                        lobStorage.setLobSegmentName(lobPartitionName);
                    }
                    if (partition instanceof PartitionOracle) {
                        lobStorage.setPartition((PartitionOracle)partition);
                    } else if (partition instanceof ListPartitionOracle) {
                        lobStorage.setListPartition((ListPartitionOracle)partition);
                    }
                    lobStorage.setColumn(columnName);
                    lobStorage.setChunk(chunk);
                    lobStorage.setPCTVersion(pctVersion);
                    if (lobStorage instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(securefile)) {
                        lobStorage.setLobStorageType("SECUREFILE");
                    }
                    if ("YES".equalsIgnoreCase(cache = cache.trim())) {
                        lobStorage.setCache("CACHE");
                    } else if ("CACHEREADS".equalsIgnoreCase(cache)) {
                        lobStorage.setCache("CACHE READS");
                    } else {
                        lobStorage.setCache("NOCACHE");
                    }
                    if ("YES".equalsIgnoreCase(inrow.trim())) {
                        lobStorage.setStorageInRow("ENABLE");
                    } else {
                        lobStorage.setStorageInRow("DISABLE");
                    }
                    if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                        TableSpaceOracle tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                        lobStorage.setTableSpace(tableSpace);
                    }
                    if (initial_extent != null && lobStorage.getDesign().getSettings().isIncludeInitialExtentInDDL() && !"DEFAULT".equalsIgnoreCase(initial_extent.trim())) {
                        try {
                            long value = Long.parseLong(initial_extent.trim());
                            lobStorage.setSCInitialExtent(value);
                        }
                        catch (Exception value) {
                            // empty catch block
                        }
                    }
                    if (next_extent != null && lobStorage.getDesign().getSettings().isIncludeNextExtentInDDL() && !"DEFAULT".equalsIgnoreCase(next_extent.trim())) {
                        try {
                            long value = Long.parseLong(next_extent.trim());
                            lobStorage.setSCNextExtent(value);
                        }
                        catch (Exception value) {
                            // empty catch block
                        }
                    }
                    if (min_extents != null && lobStorage.getDesign().getSettings().isIncludeMinExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(min_extents.trim())) {
                        try {
                            int value = Integer.parseInt(min_extents.trim());
                            lobStorage.setSCMinExtents(value);
                        }
                        catch (Exception value) {
                            // empty catch block
                        }
                    }
                    if (max_extents != null && lobStorage.getDesign().getSettings().isIncludeMaxExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(max_extents.trim())) {
                        try {
                            lobStorage.setSCMaxExtents(max_extents);
                        }
                        catch (Exception value) {
                            // empty catch block
                        }
                    }
                    if (pctIncrease != null && lobStorage.getDesign().getSettings().isIncludePctIncreaseInDDL() && !"DEFAULT".equalsIgnoreCase(pctIncrease.trim())) {
                        try {
                            int value = Integer.parseInt(pctIncrease.trim());
                            lobStorage.setSCPctIncrease(value);
                        }
                        catch (NumberFormatException value) {
                            // empty catch block
                        }
                    }
                    if (free_lists != null && lobStorage.getDesign().getSettings().isIncludeFreeListsInDDL() && !"DEFAULT".equalsIgnoreCase(free_lists.trim())) {
                        try {
                            int value = Integer.parseInt(free_lists.trim());
                            lobStorage.setSCFreeLists(value);
                        }
                        catch (NumberFormatException value) {
                            // empty catch block
                        }
                    }
                    if (freelist_groups != null && lobStorage.getDesign().getSettings().isIncludeFreeListGroupsInDDL() && !"DEFAULT".equalsIgnoreCase(freelist_groups.trim())) {
                        try {
                            int value = Integer.parseInt(freelist_groups.trim());
                            lobStorage.setSCFreelistGroups(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!"NONE".equalsIgnoreCase(logging = logging.trim())) {
                        if ("YES".equalsIgnoreCase(securefile) && "NO".equalsIgnoreCase(logging)) {
                            lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
                        } else {
                            lobStorage.setLogging(logging);
                        }
                    }
                    if (!lobStorage.getDesign().getSettings().isIncludeBufferPoolInDDL()) continue;
                    lobStorage.setSCBufferPool(bufferPool);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setPartitionLobStorage():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubPartitionLobStorage(AbstractStorageObjectOracle partition, TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, Connection sqlConnection) throws Exception {
        if (this.subPartLS_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',');
            buffer.append("LOB_NAME").append(',');
            buffer.append("LOB_SUBPARTITION_NAME").append(',');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lob_subpartitions" : "all_lob_subpartitions").append(' ');
            buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("SUBPARTITION_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("LOB_NAME");
            String sql = buffer.toString();
            this.subPartLS_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.subPartLS_statement.setString(1, owner);
            this.subPartLS_statement.setString(2, tableProxy.getName());
            this.subPartLS_statement.setString(3, partition.getName());
            rs = this.subPartLS_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString("LOB_NAME");
                    String columnName = rs.getString("COLUMN_NAME");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    String lobSubpartitionName = rs.getString("LOB_SUBPARTITION_NAME");
                    HashPartitionLobItemOracle lobItem = storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                    if (lobSubpartitionName.startsWith("SYS_LOB_SUBP")) {
                        lobItem.setName(name);
                    } else {
                        lobItem.setName(lobSubpartitionName);
                    }
                    if (partition instanceof HashPartitionOracle) {
                        lobItem.setHashPartition((HashPartitionOracle)partition);
                    } else if (partition instanceof ListStorageTemplatePartitionOracle) {
                        lobItem.setListTemplatePartition((ListStorageTemplatePartitionOracle)partition);
                    } else if (partition instanceof PartitionOracle) {
                        lobItem.setRangePartition((PartitionOracle)partition);
                    }
                    if (columnName != null && !"".equalsIgnoreCase(columnName)) {
                        ColumnProxy column = tableProxy.getColumnProxyByName(columnName);
                        lobItem.setLobColumn(column);
                    }
                    if (tsName == null || "".equalsIgnoreCase(tsName)) continue;
                    TableSpaceOracle tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                    lobItem.setTableSpace(tableSpace);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitionLobStorage():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubPartTemplateLobStorage(AbstractStorageObjectOracle subpartition, TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, Connection sqlConnection) throws Exception {
        ResultSet rs = null;
        try {
            if (this.subPartTemplateLS_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("DISTINCT").append(' ');
                buffer.append("LOB_COL_NAME").append(',');
                buffer.append("LOB_SEGMENT_NAME").append(',');
                buffer.append("TABLESPACE_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lob_templates" : "all_lob_templates").append(' ');
                buffer.append("WHERE").append(' ').append("USER_NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("SUBPARTITION_NAME").append('=').append('?');
                String sql = buffer.toString();
                this.subPartTemplateLS_statement = sqlConnection.prepareStatement(sql);
            }
            this.subPartTemplateLS_statement.setString(1, owner);
            this.subPartTemplateLS_statement.setString(2, tableProxy.getName());
            this.subPartTemplateLS_statement.setString(3, subpartition.getName());
            rs = this.subPartTemplateLS_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String columnName = rs.getString("LOB_COL_NAME");
                    String name = rs.getString("LOB_SEGMENT_NAME");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    HashPartitionLobItemOracle lobItem = storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                    lobItem.setName(name);
                    if (subpartition instanceof HashPartitionOracle) {
                        lobItem.setHashPartition((HashPartitionOracle)subpartition);
                    } else if (subpartition instanceof ListStorageTemplatePartitionOracle) {
                        lobItem.setListTemplatePartition((ListStorageTemplatePartitionOracle)subpartition);
                    } else if (subpartition instanceof PartitionOracle) {
                        lobItem.setRangePartition((PartitionOracle)subpartition);
                    }
                    if (columnName != null && !"".equalsIgnoreCase(columnName)) {
                        ColumnProxy column = tableProxy.getColumnProxyByName(columnName);
                        lobItem.setLobColumn(column);
                    }
                    if (tsName == null || "".equalsIgnoreCase(tsName)) continue;
                    TableSpaceOracle tableSpace = this.getTablespace(tsName, storageDesign, tableProxy);
                    lobItem.setTableSpace(tableSpace);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartTemplateLobStorage():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private TableSpaceOracle getTablespace(String name, StorageDesignOracle storageDesign, TableProxyOracle tableProxy) {
        TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(name);
        if (tablespace == null && tableProxy.getTemporary().equals("NO")) {
            tablespace = storageDesign.getTableSpaceSet().createTableSpace();
            tablespace.setName(name);
            this.stampModelObject((ModelObject)tablespace, tableProxy, name);
        }
        return tablespace;
    }

    private Index getIndexForColumnNames(Table table, List names, Index notThis) {
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (inds[i] == notThis || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBObject> getTriggers(Connection sqlConnection, String schema) throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        ArrayList<DBObject> list;
        block9: {
            list = new ArrayList<DBObject>();
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("OWNER").append(',');
            buffer.append("TRIGGER_NAME").append(',');
            buffer.append("TRIGGER_TYPE").append(',');
            buffer.append("TRIGGERING_EVENT").append(',');
            buffer.append("TABLE_OWNER").append(',');
            buffer.append("TABLE_NAME").append(',');
            buffer.append("BASE_OBJECT_TYPE").append(',');
            buffer.append("WHEN_CLAUSE").append(',');
            buffer.append("STATUS").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("TRIGGER_NAME");
            String sql = buffer.toString();
            int limit = this.getDbmeHandler().getLimit();
            if (limit > 0) {
                sql = this.getDbmeHandler().getPaginatedQuery(sql);
            }
            statement = null;
            rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, schema);
                rs = statement.executeQuery();
                if (rs == null) break block9;
                while (rs.next()) {
                    String trigName = rs.getString("TRIGGER_NAME");
                    String type = rs.getString("TRIGGER_TYPE");
                    String event = rs.getString("TRIGGERING_EVENT");
                    String towner = rs.getString("TABLE_OWNER");
                    String tname = rs.getString("TABLE_NAME");
                    String whenClause = rs.getString("WHEN_CLAUSE");
                    String objectType = rs.getString("BASE_OBJECT_TYPE");
                    String status = rs.getString("STATUS");
                    DBObject dbo = new DBObject(true, trigName, "TRIGGER", schema);
                    if (tname != null) {
                        dbo.table_name = tname;
                    }
                    dbo.table_owner = towner;
                    if (whenClause != null) {
                        dbo.whenClause = whenClause;
                    }
                    dbo.baseObjectType = objectType;
                    dbo.triggerType = type;
                    dbo.event = event;
                    dbo.triggerStatus = status;
                    list.add(dbo);
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    Logger.error(e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTriggerDDL(Connection conn, String owner, String name) {
        ResultSet rs;
        PreparedStatement st;
        PreparedStatement statement;
        Object result;
        block13: {
            result = "";
            Object sql = "SELECT text FROM " + (this.dbaUser ? "dba_source" : "all_source") + " WHERE  owner = ? AND  name = ? AND type = 'TRIGGER' order by line";
            int limit = this.getDbmeHandler().getLimit();
            if (limit > 0) {
                sql = this.getDbmeHandler().getPaginatedQuery((String)sql);
            }
            statement = null;
            st = null;
            rs = null;
            try {
                if (statement == null) {
                    statement = conn.prepareStatement((String)sql);
                }
                statement.setString(1, owner);
                statement.setString(2, name);
                rs = statement.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        if (((String)result).isEmpty()) {
                            result = "CREATE OR REPLACE ";
                        }
                        String text = rs.getString(1);
                        result = (String)result + text;
                    }
                    rs.close();
                }
                if (((String)result).isEmpty()) break block13;
                result = (String)result + "\n/\n";
                rs = null;
                sql = "SELECT status FROM " + (this.dbaUser ? "dba_triggers" : "all_triggers") + " WHERE  owner = ? AND  trigger_name = ? ";
                st = conn.prepareStatement((String)sql);
                st.setString(1, owner);
                st.setString(2, name);
                rs = st.executeQuery();
                if (rs == null) break block13;
                if (rs.next()) {
                    String status = rs.getString(1);
                    boolean quoted = !name.toUpperCase().equals(name);
                    Object trname = name;
                    if (quoted || !this.getStorageDesign().isValidName(name)) {
                        trname = "\"" + name + "\"";
                    }
                    quoted = !owner.toUpperCase().equals(owner);
                    Object trowner = owner;
                    if (quoted || !this.getStorageDesign().isValidName(owner)) {
                        trowner = "\"" + owner + "\"";
                    }
                    String stat = " ENABLE;";
                    if (!"ENABLED".equals(status)) {
                        stat = " DISABLE;";
                    }
                    result = (String)result + "ALTER TRIGGER " + (String)trowner + "." + (String)trname + stat;
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    Logger.error(e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement, st});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement, st});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement, st});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTableTriggers(Connection sqlConnection, List dbos, boolean allowRetry) throws Exception {
        block41: {
            ArrayList<TriggerOracle> up_list = new ArrayList<TriggerOracle>();
            HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
            ArrayList<String> schList = new ArrayList<String>();
            PreparedStatement statement = null;
            HashMap nmap = new HashMap();
            MOHTableOracle.prepareNameMaps(schList, tmap, nmap, dbos, true);
            StringBuffer buffer = new StringBuffer();
            ResultSet rs = null;
            for (String schema : schList) {
                block39: {
                    List list = (List)tmap.get(schema);
                    String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
                    boolean includeCrossEdition = allowRetry && this.getStorageDesign() instanceof StorageDesignOraclev11g;
                    buffer.append("SELECT").append(' ').append("OWNER").append(',');
                    buffer.append("TRIGGER_NAME").append(',');
                    buffer.append("TABLE_NAME").append(',');
                    buffer.append("TRIGGER_TYPE").append(',');
                    buffer.append("TRIGGERING_EVENT").append(',');
                    buffer.append("REFERENCING_NAMES").append(',');
                    buffer.append("WHEN_CLAUSE").append(',');
                    if (includeCrossEdition) {
                        buffer.append("CROSSEDITION").append(',');
                    }
                    buffer.append("TRIGGER_BODY").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
                    buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
                    buffer.append("AND").append(' ').append(incl);
                    String sql = buffer.toString();
                    try {
                        statement = sqlConnection.prepareStatement(sql);
                        statement.setFetchSize(50);
                        statement.setString(1, schema);
                        int k = 1;
                        for (String tname : list) {
                            statement.setString(++k, tname);
                        }
                        if (allowRetry) {
                            try {
                                rs = statement.executeQuery();
                            }
                            catch (SQLSyntaxErrorException e) {
                                this.initTableTriggers(sqlConnection, dbos, false);
                                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                                return;
                            }
                            allowRetry = false;
                        } else {
                            rs = statement.executeQuery();
                        }
                        if (rs == null) break block39;
                        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                        while (rs.next()) {
                            String trigOwner = rs.getString("OWNER");
                            String trigName = rs.getString("TRIGGER_NAME");
                            String tname = rs.getString("TABLE_NAME");
                            String type = rs.getString("TRIGGER_TYPE");
                            String event = rs.getString("TRIGGERING_EVENT");
                            String refNames = rs.getString("REFERENCING_NAMES");
                            String whenClause = rs.getString("WHEN_CLAUSE");
                            DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                            if (dbo == null) continue;
                            Table table = (Table)dbo.getTable();
                            TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                            String crossEdition = includeCrossEdition ? rs.getString("CROSSEDITION") : "NO";
                            String trBody = rs.getString("TRIGGER_BODY");
                            TriggerOracle trigger = storage.getTriggerSet().createTrigger();
                            UserOracle user = (UserOracle)storage.getUserSet().getByName(trigOwner);
                            if (user == null) {
                                user = storage.getUserSet().createUser();
                                user.setName(trigOwner);
                                this.stampModelObject((ModelObject)user, "", trigOwner);
                            }
                            trigger.setOwner(user);
                            trigger.setName(trigName);
                            trigger.setTempTableOwner(dbo.getSchema());
                            if (!trigName.equals(trigName.toUpperCase())) {
                                trigger.setNameHasQuotes(true);
                            }
                            trigger.setTable(tableProxy);
                            this.stampModelObject((ModelObject)trigger, tableProxy, trigName);
                            if (type.indexOf("STATEMENT") > -1) {
                                trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                            } else {
                                trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                            }
                            if (type.indexOf("BEFORE") > -1) {
                                trigger.setTriggerTime("BEFORE");
                            } else if (type.indexOf("AFTER") > -1) {
                                trigger.setTriggerTime("AFTER");
                            } else {
                                trigger.setTriggerTime(type);
                            }
                            if (event.indexOf("INSERT") > -1) {
                                trigger.setActions(Trigger.ACTION_TYPES[0]);
                            }
                            if (event.indexOf("UPDATE") > -1) {
                                trigger.setActions(Trigger.ACTION_TYPES[1]);
                                up_list.add(trigger);
                            }
                            if (event.indexOf("DELETE") > -1) {
                                trigger.setActions(Trigger.ACTION_TYPES[2]);
                            }
                            String newref = "NEW";
                            String oldref = "OLD";
                            String parentref = "PARENT";
                            if (refNames.indexOf(NEW_AS) > -1 && !"NEW".equalsIgnoreCase(newref = Token.getFirstToken(Token.getStringAfter(refNames, NEW_AS)))) {
                                trigger.setRef_NEW_AS(newref);
                            }
                            if (refNames.indexOf(OLD_AS) > -1 && !"OLD".equalsIgnoreCase(oldref = Token.getFirstToken(Token.getStringAfter(refNames, OLD_AS)))) {
                                trigger.setRef_OLD_AS(oldref);
                            }
                            if (refNames.indexOf(PARENT_AS) > -1 && !"PARENT".equalsIgnoreCase(parentref = Token.getFirstToken(Token.getStringAfter(refNames, PARENT_AS)))) {
                                trigger.setRef_PARENT_AS(parentref);
                            }
                            trigger.setCrossEdition(crossEdition);
                            if (whenClause != null) {
                                trigger.setCondition(whenClause);
                            }
                            trigger.setBody(trBody);
                            if (trBody.indexOf(this.CWD_TS_TAB_META) > -1) {
                                this.initTriggerTypeSubstitution(table, trigger, trBody);
                                trigger.setCWDGenerated(true);
                            }
                            if (trBody.indexOf(this.CWD_TS_COLUMN_META) > -1) {
                                this.initTriggerColumnTypeSubstitution(table, trigger, trBody);
                                trigger.setCWDGenerated(true);
                            }
                            this.checkAutoIncTrigger(trigger, table, storage);
                        }
                        rs.close();
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.error("MOHTableOracle.initTableTriggers():", e);
                        }
                        catch (Throwable throwable) {
                            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                            throw throwable;
                        }
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        continue;
                    }
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
            if (up_list.size() <= 0) break block41;
            tmap.clear();
            schList.clear();
            HashMap<CallSite, TriggerOracle> namemap = new HashMap<CallSite, TriggerOracle>();
            for (TriggerOracle tr : up_list) {
                String schema = tr.getOwner().getName();
                String name = tr.getName();
                namemap.put((CallSite)((Object)(schema + "." + name)), tr);
                ArrayList<String> list = (ArrayList<String>)tmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
            TimeLog.log("Trigger columns begin");
            for (String schema : schList) {
                PreparedStatement col_statement;
                block40: {
                    List list = (List)tmap.get(schema);
                    String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "trigger_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "trigger_name");
                    buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("TRIGGER_NAME").append(',');
                    buffer.append("COLUMN_NAME").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_trigger_cols" : "all_trigger_cols").append(' ');
                    buffer.append("WHERE").append(" column_list = 'YES'  AND ").append("TRIGGER_OWNER").append('=').append('?').append(' ');
                    buffer.append("AND").append(' ').append(incl);
                    String colsql = buffer.toString();
                    col_statement = sqlConnection.prepareStatement(colsql);
                    col_statement.setFetchSize(200);
                    rs = null;
                    try {
                        col_statement.setString(1, schema);
                        int k = 1;
                        for (String tname : list) {
                            col_statement.setString(++k, tname);
                        }
                        rs = col_statement.executeQuery();
                        if (rs == null) break block40;
                        while (rs.next()) {
                            TableProxyOracle table;
                            ColumnProxy cp;
                            String trName = rs.getString("TRIGGER_NAME");
                            String colName = rs.getString("COLUMN_NAME");
                            TriggerOracle trigger = (TriggerOracle)namemap.get(schema + "." + trName);
                            if (trigger == null || (cp = (table = trigger.getTable()).getColumnProxyByName(colName)) == null) continue;
                            trigger.setColumns(cp.getObjectID());
                        }
                        rs.close();
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.error("MOHTableOracle.initTriggerColumns():", e);
                        }
                        catch (Throwable throwable) {
                            Closeables.close((Object[])new AutoCloseable[]{rs, col_statement});
                            throw throwable;
                        }
                        Closeables.close((Object[])new AutoCloseable[]{rs, col_statement});
                    }
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, col_statement});
                TimeLog.log("Trigger columns end");
            }
        }
    }

    private void checkAutoIncTrigger(TriggerOracle trigger, Table table, StorageDesignOracle storageDesign) {
        Column column;
        TriggerOracle.AutoIncDetails autoIncDetails = trigger.checkAutoIncTrigger();
        if (autoIncDetails != null && (column = (Column)table.getElementByName(autoIncDetails.getColumnName())) != null) {
            TableProxy syncTableProxy;
            RDBMSSite rdbmsSite;
            StorageDesign syncSD;
            String sequenceLongName;
            String autoIncSequenceName = autoIncDetails.getSequenceName();
            String sequenceName = sequenceLongName = Token.removeQuotes(autoIncSequenceName);
            String sequenceUser = null;
            int dotIndex = sequenceLongName.indexOf(46);
            if (dotIndex > -1) {
                sequenceUser = sequenceLongName.substring(0, dotIndex);
                sequenceName = sequenceLongName.substring(dotIndex + 1);
            }
            column.setAutoIncrementColumn(true);
            column.setAutoIncrementSequenceName(sequenceName);
            column.setAutoIncrementTriggerName(trigger.getName());
            ColumnProxyOracle columnProxy = (ColumnProxyOracle)storageDesign.getColumnProxySet().getProxy(column.getObjectID());
            if (columnProxy != null) {
                UserOracle triggerOwner;
                columnProxy.setAutoIncrementDDL("TRIGGER");
                if (sequenceUser == null && (triggerOwner = trigger.getOwner()) != null) {
                    sequenceUser = triggerOwner.getName();
                }
                if (sequenceUser != null && !sequenceUser.equalsIgnoreCase(table.getSchema())) {
                    UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(sequenceUser);
                    columnProxy.setAutoIncrementUser(user);
                }
            }
            boolean triggerInModel = false;
            RelationalDesign syncModel = table.getRelationalModel().getRelatedSyncModel();
            if (syncModel != null && (syncSD = syncModel.getStorageDesign(rdbmsSite = storageDesign.getRDBMSSite())) != null && (syncTableProxy = syncSD.getTableProxyBySchemaAndName(table.getSchema(), table.getName())) != null && syncTableProxy.getTriggers().getByName(trigger.getName()) != null) {
                triggerInModel = true;
            }
            if (!triggerInModel) {
                trigger.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTriggerColumns(PreparedStatement pstatement, TriggerOracle trigger) throws Exception {
        ResultSet rs = null;
        try {
            pstatement.setString(1, trigger.getTempTableOwner());
            pstatement.setString(2, trigger.getTable().getName());
            pstatement.setString(3, trigger.getOwner().getName());
            pstatement.setString(4, trigger.getName());
            rs = pstatement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    TableProxyOracle table;
                    ColumnProxy cp;
                    String colName = rs.getString("COLUMN_NAME");
                    String colList = rs.getString("COLUMN_LIST");
                    if (!"YES".equalsIgnoreCase(colList) || (cp = (table = trigger.getTable()).getColumnProxyByName(colName)) == null) continue;
                    trigger.setColumns(cp.getObjectID());
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.initTriggerColumns():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConstraintColumns(Connection sqlConnection, Map ukMap, List<FKTemp> fkTempList, List<ConstrHelper> clist, boolean dbaUser) {
        if (fkTempList.size() > 0 || clist.size() > 0) {
            List<String> list;
            String name;
            String schema;
            HashMap tmap = new HashMap();
            ArrayList<String> schList = new ArrayList<String>();
            HashMap<CallSite, Object> nmap = new HashMap<CallSite, Object>();
            HashMap<CallSite, ArrayList<String>> cmap = new HashMap<CallSite, ArrayList<String>>();
            for (FKTemp fKTemp : fkTempList) {
                schema = fKTemp.owner;
                name = fKTemp.name;
                nmap.put((CallSite)((Object)(schema + "." + name)), fKTemp);
                list = (ArrayList<String>)tmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
            for (ConstrHelper constrHelper : clist) {
                schema = constrHelper.owner;
                name = constrHelper.cname;
                nmap.put((CallSite)((Object)(schema + "." + name)), constrHelper);
                list = (List)tmap.get(schema);
                if (list == null) {
                    list = new ArrayList();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
            for (String string : schList) {
                List list2 = (List)tmap.get(string);
                String incl = list2.size() > 990 ? MOHTableOracle.getInParamExpr(list2.size(), "CONSTRAINT_NAME", 600) : MOHTableOracle.getInParamExpr(list2.size(), "CONSTRAINT_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("OWNER").append(',');
                buffer.append("CONSTRAINT_NAME").append(',');
                buffer.append("COLUMN_NAME").append(' ');
                buffer.append("FROM").append(' ').append(dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append(" and " + incl).append(' ');
                buffer.append("ORDER BY").append(' ').append("OWNER").append(',').append("CONSTRAINT_NAME").append(',').append("POSITION");
                String ncol_sql = buffer.toString();
                PreparedStatement ncol_st = null;
                ResultSet nrs = null;
                try {
                    ncol_st = sqlConnection.prepareStatement(ncol_sql);
                    ncol_st.setFetchSize(100);
                    ncol_st.setString(1, string);
                    int k = 1;
                    for (String string2 : list2) {
                        ncol_st.setString(++k, string2);
                    }
                    nrs = ncol_st.executeQuery();
                    if (nrs != null) {
                        String temp = "";
                        while (nrs.next()) {
                            String string3 = nrs.getString(1);
                            String cname = nrs.getString(2);
                            String colName = Token.removeQuotes(nrs.getString(3));
                            String lname = string3 + "." + cname;
                            ArrayList<String> cols = (ArrayList<String>)cmap.get(lname);
                            if (cols == null) {
                                cols = new ArrayList<String>();
                                cmap.put((CallSite)((Object)lname), cols);
                            }
                            cols.add(colName);
                        }
                        nrs.close();
                    }
                    for (Map.Entry entry : cmap.entrySet()) {
                        Object obj = nmap.get(entry.getKey());
                        if (obj instanceof FKTemp) {
                            ((FKTemp)obj).columns.addAll((Collection)entry.getValue());
                            continue;
                        }
                        if (!(obj instanceof ConstrHelper)) continue;
                        ConstrHelper ch = (ConstrHelper)obj;
                        if (ch.key != null) {
                            boolean valid;
                            FKContainer table = (FKContainer)ch.key.getContainerWithKeyObject();
                            if (table == null || (valid = MOHTableOracle.initPK_UK_Columns(ch.key, (List)entry.getValue(), ch.cname))) continue;
                            ukMap.put(entry.getKey(), table);
                            ch.key.remove();
                            continue;
                        }
                        ch.columns = (List)entry.getValue();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", e);
                }
                finally {
                    if (nrs != null) {
                        try {
                            nrs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (ncol_st == null) continue;
                    try {
                        ncol_st.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private void initTriggerTypeSubstitution(Table table, TriggerOracle trigger, String trBody) {
        ArrayList<Temp> list = new ArrayList<Temp>();
        String body = trBody;
        int l = this.CWD_TS_TAB_META.length();
        int ind = body.indexOf(this.CWD_TS_TAB_META);
        try {
            while (ind > -1) {
                body = body.substring(ind + l);
                String tableName = Token.getFirstToken(Token.getStringAfter(body, "table="));
                String typeName = Token.getFirstToken(Token.getStringAfter(body, "type="));
                String parenTypeName = Token.getFirstToken(Token.getStringAfter(body, "parent_type="));
                Temp temp = new Temp();
                temp.tableName = Token.removeQuotes(tableName);
                temp.typeName = Token.removeQuotes(typeName);
                temp.parenTypeName = Token.removeQuotes(parenTypeName);
                list.add(temp);
                ind = body.indexOf(this.CWD_TS_TAB_META);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("MOHTableOracle.initTriggerTypeSubstitution():", e);
        }
        ArrayList<Temp> rlist = new ArrayList<Temp>();
        for (Temp temp : list) {
            Table tab = (Table)table.getDesign().getRelationalDesign().getTableSet().getByName(temp.tableName);
            if (tab != null) continue;
            StructuredType st = this.getStructuredType(temp.typeName, table.getDesign(), trigger.getStorageDesign());
            StructuredType stPar = this.getStructuredType(temp.parenTypeName, table.getDesign(), trigger.getStorageDesign());
            if (st == null || stPar == null) continue;
            temp.st = st;
            temp.stPar = stPar;
            rlist.add(temp);
        }
        this.createSubTables(table, rlist);
    }

    private void initTriggerColumnTypeSubstitution(Table table, Trigger trigger, String trBody) {
        ArrayList<Temp> list = new ArrayList<Temp>();
        String body = trBody;
        int l = this.CWD_TS_COLUMN_META.length();
        int ind = body.indexOf(this.CWD_TS_COLUMN_META);
        try {
            while (ind > -1) {
                body = body.substring(ind + l);
                String columnName = Token.getFirstToken(Token.getStringAfter(body, "column="));
                String typeName = Token.getFirstToken(Token.getStringAfter(body, "type="));
                Temp temp = new Temp();
                temp.tableName = Token.removeQuotes(columnName);
                temp.typeName = Token.removeQuotes(typeName);
                list.add(temp);
                ind = body.indexOf(this.CWD_TS_COLUMN_META);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("MOHTableOracle.initTriggerColumnTypeSubstitution():", e);
        }
        for (Temp temp : list) {
            StructuredType st;
            Column column = (Column)table.getElementByName(temp.tableName);
            if (column == null || (st = this.getStructuredType(temp.typeName, table.getDesign(), trigger.getStorageDesign())) == null) continue;
            List types = column.getPermittedSubTypes();
            if (!types.contains(st)) {
                types.add(st);
            }
            column.setAllowSubtypeSubstitution(true);
            column.setRestrictedTypeSubstitution(true);
        }
    }

    private void createSubTables(Table table, List list) {
        RelationalDesign pd = (RelationalDesign)table.getDesignPart();
        List subtypes = this.getElementsForType(table.getBasedOnStructuredType(), list);
        list.removeAll(subtypes);
        for (Temp temp : subtypes) {
            Table newTab = pd.createTable();
            newTab.setName(temp.tableName);
            newTab.setBasedOnStructuredType(temp.st);
            if (!temp.tableName.equals(temp.tableName.toUpperCase())) {
                newTab.setNameHasQuotes(true);
            }
            this.stampModelObject((ModelObject)newTab, table.getSchema(), temp.tableName);
            TypeSubstitution ts = pd.createTypeSubstitution();
            ts.setChildContainerObject(newTab);
            ts.setParentContainerObject(table);
            if (list.size() <= 0) continue;
            this.createSubTables(newTab, list);
        }
    }

    private List getElementsForType(StructuredType parent, List list) {
        ArrayList<Temp> elems = new ArrayList<Temp>();
        for (Temp temp : list) {
            if (temp.stPar != parent) continue;
            elems.add(temp);
        }
        return elems;
    }

    private StructuredType getStructuredType(String longName, Design design, StorageDesign sd) {
        int ind = longName.indexOf(46);
        if (ind > -1) {
            String user = longName.substring(0, ind);
            String name = longName.substring(ind + 1);
            StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)sd.getStructuredTypeProxySet()).getByLongName(name, user);
            if (stp != null) {
                return stp.getStructuredType();
            }
            return null;
        }
        return (StructuredType)design.getDataTypesDesign().getStructuredTypeSet().getByName(longName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createFKeys(Connection sqlConnection, List fkTempList, Map ukMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("POSITION").append(',').append("COLUMN_NAME");
        String fk_sql = buffer.toString();
        PreparedStatement fk_statement = null;
        try {
            Map vukMap = null;
            for (FKTemp fkt : fkTempList) {
                try {
                    DesignObject ukMapObject = (DesignObject)ukMap.get(fkt.UK_Owner + fkt.UK_Name);
                    if (ukMapObject == null) {
                        if (vukMap == null) {
                            vukMap = this.getViewHandlerOracle().getUkMap();
                        }
                        if (vukMap != null) {
                            ukMapObject = (DesignObject)vukMap.get(fkt.UK_Owner + fkt.UK_Name);
                        }
                    }
                    KeyObject index = ukMapObject instanceof Table ? ((Table)ukMapObject).getPK() : (ukMapObject instanceof TableView ? ((TableView)ukMapObject).getPK() : (KeyObject)ukMapObject);
                    ArrayList<String> refColumns = new ArrayList<String>();
                    String refTable = null;
                    if (index == null) {
                        index = (Index)((RelationalDesign)fkt.table.getDesignPart()).getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                        RelationalDesign rd = ((RelationalDesign)fkt.table.getDesignPart()).getRelatedSyncModel();
                        if (index == null && rd != null) {
                            index = (Index)rd.getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                        }
                        if (index == null) {
                            if (fk_statement == null) {
                                fk_statement = sqlConnection.prepareStatement(fk_sql);
                            }
                            fk_statement.setString(1, fkt.UK_Owner);
                            fk_statement.setString(2, fkt.UK_Name);
                            try (ResultSet fk_rs = fk_statement.executeQuery();){
                                if (fk_rs != null) {
                                    while (fk_rs.next()) {
                                        refTable = fk_rs.getString("TABLE_NAME");
                                        refColumns.add(fk_rs.getString("COLUMN_NAME"));
                                    }
                                }
                            }
                            index = (Index)((RelationalDesign)fkt.table.getDesignPart()).getGlobalIndexSet().getByMatchingColumns(fkt.UK_Owner, refTable, refColumns);
                            if (index == null && rd != null) {
                                index = (Index)rd.getGlobalIndexSet().getByMatchingColumns(fkt.UK_Owner, refTable, refColumns);
                            }
                        }
                    }
                    FKIndexAssociation fk = null;
                    ModelIDObject localFKIndex = null;
                    if (index != null) {
                        fk = fkt.table.addFK(index);
                        fk.setName(fkt.name);
                        this.stampModelObject((ModelObject)fk, fkt.table.getSchema(), fkt.name);
                        localFKIndex = fk.getLocalFKIndex();
                        localFKIndex.setName(fkt.name);
                        if (!fkt.name.equals(fkt.name.toUpperCase())) {
                            localFKIndex.setNameHasQuotes(true);
                        }
                        fk.setDeleteRule(fkt.delete_rule);
                        for (int i = 0; i < fkt.columns.size(); ++i) {
                            String colName = fkt.columns.get(i);
                            Column column = (Column)fkt.table.getElementByName(colName);
                            FKElement refCol = null;
                            try {
                                refCol = (FKElement)index.getElement(i);
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            if (column == null || refCol == null) continue;
                            column.addFKAssociation(refCol, fk);
                            ((SubsetCO)localFKIndex).add(column);
                        }
                    } else if (refTable != null && refColumns.size() > 0) {
                        Object refTableName;
                        fk = ((RelationalDesign)fkt.table.getDesignPart()).createForeignKey();
                        fk.setContainerWithKeyObject(fkt.table);
                        fk.setName(fkt.name);
                        fkt.table.setLoadedCompletely(true);
                        fk.addToTable();
                        this.stampModelObject((ModelObject)fk, fkt.table.getSchema(), fkt.name);
                        localFKIndex = fk.getLocalFKIndex();
                        localFKIndex.setName(fkt.name);
                        if (!fkt.name.equals(fkt.name.toUpperCase())) {
                            localFKIndex.setNameHasQuotes(true);
                        }
                        fk.setDeleteRule(fkt.delete_rule);
                        Object refTableOwner = fkt.UK_Owner;
                        if (!((String)refTableOwner).equals(((String)refTableOwner).toUpperCase())) {
                            refTableOwner = "\"" + (String)refTableOwner + "\"";
                        }
                        if (!((String)(refTableName = refTable)).equals(((String)refTableName).toUpperCase())) {
                            refTableName = "\"" + (String)refTableName + "\"";
                        }
                        fk.setReferredTableLongName((String)refTableOwner + "." + (String)refTableName);
                        fk.setReferredKeyName(fkt.UK_Name);
                        String refCols = null;
                        for (String string : refColumns) {
                            void var20_31;
                            if (!string.equals(string.toUpperCase())) {
                                String string2 = "\"" + string + "\"";
                            }
                            if (refCols == null) {
                                refCols = var20_31;
                                continue;
                            }
                            refCols = refCols + "," + (String)var20_31;
                        }
                        fk.setReferredColumnNames(refCols);
                        for (int i = 0; i < fkt.columns.size(); ++i) {
                            String string = fkt.columns.get(i);
                            Column column = (Column)fkt.table.getElementByName(string);
                            if (column == null) continue;
                            ((SubsetCO)localFKIndex).add(column);
                        }
                    }
                    if (fk == null) continue;
                    fk.resetMandatoryUsingColumns();
                    FKProxyOracle fkProxy = (FKProxyOracle)this.getStorageDesign().getStorageObject(localFKIndex.getObjectID());
                    if (fkProxy == null) continue;
                    if (fkt.status.equals("ENABLED")) {
                        fkProxy.setEnable("YES");
                    } else {
                        fkProxy.setEnable("NO");
                    }
                    if (fkt.deferrable.equals("DEFERRABLE")) {
                        fkProxy.setDeferrable("YES");
                    } else {
                        fkProxy.setDeferrable("NO");
                    }
                    if (fkt.deferred.equals("DEFERRED")) {
                        fkProxy.setInitially("DEFERRED");
                    } else {
                        fkProxy.setInitially("IMMEDIATE");
                    }
                    if (fkt.validated.equals("VALIDATED")) {
                        fkProxy.setValidate("YES");
                        continue;
                    }
                    fkProxy.setValidate("NO");
                    if (fkt.rely != null && fkt.rely.equals("RELY")) {
                        fkProxy.setRely("YES");
                        continue;
                    }
                    fkProxy.setRely("NO");
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.createFKeys(): " + fkt.name, e);
                }
            }
        }
        finally {
            Closeables.close(fk_statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFKColomns(Connection sqlConnection, List fkTempList, boolean dbaUser) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(' ');
        buffer.append("FROM").append(' ').append(dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("POSITION").append(',').append("COLUMN_NAME");
        String fk_sql = buffer.toString();
        PreparedStatement fk_statement = null;
        try {
            for (FKTemp fkt : fkTempList) {
                ResultSet fk_rs = null;
                try {
                    if (fk_statement == null) {
                        fk_statement = sqlConnection.prepareStatement(fk_sql);
                    }
                    fk_statement.setString(1, fkt.owner);
                    fk_statement.setString(2, fkt.name);
                    fk_rs = fk_statement.executeQuery();
                    if (fk_rs != null) {
                        while (fk_rs.next()) {
                            fkt.columns.add(fk_rs.getString("COLUMN_NAME"));
                        }
                        fk_rs.close();
                    }
                    Closeables.close((Object)fk_rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.createFKeys(): " + fkt.name, e);
                }
                finally {
                    Closeables.close(fk_rs);
                }
            }
        }
        finally {
            Closeables.close(fk_statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addRedactionPolicies(Connection sqlConnection, List dbos) throws SQLException {
        if (!(this.getStorageDesign() instanceof StorageDesignOraclev11g)) return;
        PreparedStatement column_statement = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("POLICY_NAME").append(',');
        buffer.append("EXPRESSION").append(',');
        buffer.append("ENABLE").append(' ');
        buffer.append("FROM").append(' ').append("REDACTION_POLICIES rp").append(' ');
        buffer.append("WHERE").append(' ').append("OBJECT_OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("OBJECT_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("NOT").append(' ').append("EXISTS").append(' ').append('(');
        buffer.append("SELECT").append(' ').append("1").append(' ').append("FROM").append(' ').append("DBA_TSDP_POLICY_PROTECTION").append(' ');
        buffer.append("WHERE").append(' ').append("security_feature_policy").append('=').append("rp.policy_name").append(')');
        String sql = buffer.toString();
        PreparedStatement statement = null;
        try {
            for (DBObject dbo : dbos) {
                Table table = (Table)dbo.getTable();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, table.getName());
                    try {
                        rs = statement.executeQuery();
                    }
                    catch (SQLSyntaxErrorException e) {
                        Closeables.close((Object)rs);
                        break;
                    }
                    if (rs != null) {
                        if (rs.next()) {
                            String policyName = rs.getString("POLICY_NAME");
                            String expression = rs.getString("EXPRESSION");
                            String enabled = rs.getString("ENABLE");
                            table.setRedactionPolicyName(policyName.trim());
                            table.setRedactionPolicyDefaultExpression(expression);
                            if ("YES".equalsIgnoreCase(enabled.trim())) {
                                table.setRedactionPolicyEnabled(true);
                            } else {
                                table.setRedactionPolicyEnabled(false);
                            }
                            table.setRedactionPolicyGenerateInDDL(true);
                            if (column_statement == null) {
                                buffer = new StringBuffer();
                                buffer.append("SELECT").append(' ');
                                buffer.append("COLUMN_NAME").append(',');
                                buffer.append("FUNCTION_TYPE").append(',');
                                buffer.append("FUNCTION_PARAMETERS").append(',');
                                buffer.append("REGEXP_PATTERN").append(',');
                                buffer.append("REGEXP_REPLACE_STRING").append(',');
                                buffer.append("REGEXP_POSITION").append(',');
                                buffer.append("REGEXP_OCCURRENCE").append(',');
                                buffer.append("REGEXP_MATCH_PARAMETER").append(' ');
                                buffer.append("FROM").append(' ').append("REDACTION_COLUMNS").append(' ');
                                buffer.append("WHERE").append(' ').append("OBJECT_OWNER").append('=').append('?').append(' ');
                                buffer.append("AND").append(' ').append("OBJECT_NAME").append('=').append('?');
                                String csql = buffer.toString();
                                column_statement = sqlConnection.prepareStatement(csql);
                            }
                            this.addColumnRedactionPolicies(column_statement, table);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.addRedactionPolicies():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{column_statement, statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{column_statement, statement});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnRedactionPolicies(PreparedStatement column_statement, Table table) throws SQLException {
        ResultSet rs = null;
        try {
            column_statement.setString(1, table.getSchema());
            column_statement.setString(2, table.getName());
            rs = column_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    MaskTemplate mt;
                    String columnName = rs.getString("COLUMN_NAME");
                    String functionType = rs.getString("FUNCTION_TYPE");
                    String functionParameters = rs.getString("FUNCTION_PARAMETERS");
                    String pattern = rs.getString("REGEXP_PATTERN");
                    String replaceString = rs.getString("REGEXP_REPLACE_STRING");
                    int position = rs.getInt("REGEXP_POSITION");
                    int occurrence = rs.getInt("REGEXP_OCCURRENCE");
                    String matchParameter = rs.getString("REGEXP_MATCH_PARAMETER");
                    Column column = (Column)table.getElementByName(columnName.trim());
                    if (column == null) continue;
                    if ((functionType = functionType.trim()).startsWith("FULL")) {
                        column.setMaskingType("FULL");
                        continue;
                    }
                    if (functionType.startsWith("NONE")) {
                        column.setMaskingType("TEST");
                        continue;
                    }
                    if (functionType.startsWith("PARTIAL")) {
                        column.setMaskingType("PARTIAL");
                        mt = new MaskTemplate();
                        mt.setFunctionType(0);
                        this.maskTemplatesAdded = true;
                        continue;
                    }
                    if (functionType.startsWith("REGEXP")) {
                        column.setMaskingType("REGEXP");
                        mt = new MaskTemplate();
                        mt.setFunctionType(1);
                        if (pattern != null) {
                            mt.setPattern(pattern);
                        }
                        if (replaceString != null) {
                            mt.setReplaceString(replaceString);
                        }
                        mt.setPosition(position);
                        mt.setOccurrence(occurrence);
                        if (matchParameter != null) {
                            mt.setMatchParameter(matchParameter);
                        }
                        this.maskTemplatesAdded = true;
                        continue;
                    }
                    if (!functionType.startsWith("RANDOM")) continue;
                    column.setMaskingType("RANDOM");
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.addColumnRedactionPolicies():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private int getMaskTemplateDataType(String datatype) {
        if ("CHAR".equalsIgnoreCase(datatype) || "VARCHAR".equalsIgnoreCase(datatype) || "VARCHAR2".equalsIgnoreCase(datatype) || "NVARCHAR".equalsIgnoreCase(datatype) || "NVARCHAR2".equalsIgnoreCase(datatype)) {
            return 0;
        }
        if ("NUMBER".equalsIgnoreCase(datatype) || "INTEGER".equalsIgnoreCase(datatype)) {
            return 1;
        }
        if ("DATE".equalsIgnoreCase(datatype)) {
            return 2;
        }
        return 0;
    }

    public MOHViewOracle getViewHandlerOracle() {
        return this.viewHandlerOracle;
    }

    public void setViewHandlerOracle(MOHViewOracle viewHandlerOracle) {
        this.viewHandlerOracle = viewHandlerOracle;
    }

    public Map getUkMap() {
        return this.ukMap;
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        this.ukMap.clear();
        Iterator it = this.getRelationalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            table.removeFK_DuplicatingJoins();
            boolean c = false;
            int size = table.getElementsCollection().size();
            String sel = table.getUserDefinedSQL();
            if (!table.isMaterializedQueryTable() || sel == null || sel.isEmpty()) continue;
            List<SQLAnalyzer.PDescriptor> list = SQLAnalyzer.getTables(sel);
            for (SQLAnalyzer.PDescriptor pd : list) {
                if ("DUAL".equalsIgnoreCase(pd.name)) continue;
                SQLNameHelper nh = new SQLNameHelper(true, false);
                if (pd.schema != null) {
                    nh.setSchema(pd.schema.toUpperCase());
                } else {
                    nh.setSchema(table.getSchema());
                }
                nh.setTableName(pd.name.toUpperCase());
                nh.setContainer(true);
                table.getSQLNames().add(nh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DBObject> getMViews(Connection conn, List schemas) {
        TimeLog.log("Extract Table begin");
        list = new ArrayList<DBObject>();
        statement = null;
        try {
            s = this.getDesign().getSettings();
            for (DBObject dboNext : schemas) {
                if (!dboNext.isSelected()) continue;
                owner = dboNext.getName();
                tables = new ArrayList<E>();
                rs = null;
                try {
                    if (statement == null) {
                        sql = "select mview_name, build_mode from ";
                        sql = (String)sql + (this.dbaUser != false ? "dba_mviews" : "all_mviews") + " where owner = ? order by mview_name";
                        limit = this.getDbmeHandler().getLimit();
                        if (limit > 0) {
                            sql = this.getDbmeHandler().getPaginatedQuery((String)sql);
                        }
                        statement = conn.prepareStatement((String)sql);
                    }
                    statement.setString(1, owner);
                    rs = statement.executeQuery();
                    if (rs != null) {
                        try {
                            while (rs.next()) {
                                name = rs.getString(1);
                                buildMode = rs.getString(2);
                                dboTable = new DBObject(true, name, "TABLE", owner);
                                dboTable.buildMode = buildMode;
                                list.add(dboTable);
                            }
                            rs.close();
                        }
                        catch (SQLException e) {
                            MOHTableOracle.LOGGER.error("MOHTableOracle.getMViews() - rs.next():", e);
                        }
                    }
                    ** GOTO lbl44
                }
                catch (Exception e) {
                    try {
                        MOHTableOracle.LOGGER.error("MOHTableOracle.getMViews():", e);
                    }
                    catch (Throwable var14_17) {
                        Closeables.close(rs);
                        throw var14_17;
                    }
lbl44:
                    // 2 sources

                    Closeables.close((Object)rs);
                    continue;
                    Closeables.close((Object)rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
        TimeLog.log("Extract Table end");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTables(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Table begin");
        ArrayList list = new ArrayList();
        PreparedStatement statement = null;
        PreparedStatement statement_ext = null;
        try {
            Settings s = this.getDesign().getSettings();
            boolean mvs = s.isImportMViews();
            String mvCheck = " AND NOT EXISTS (   SELECT     1   FROM     " + (this.dbaUser ? "dba_mviews" : "all_mviews") + " b   WHERE     a.owner       = b.owner   AND a.TABLE_NAME=b.MVIEW_NAME   AND build_mode <> 'PREBUILT' )";
            for (DBObject dboNext : schemas) {
                ResultSet rs_ext;
                ResultSet rs;
                ArrayList<DBObject> tables;
                String owner;
                block24: {
                    if (!dboNext.isSelected()) continue;
                    owner = dboNext.getName();
                    tables = new ArrayList<DBObject>();
                    rs = null;
                    rs_ext = null;
                    try {
                        if (statement == null) {
                            String filterCondition = this.getFilterConditionOracle("TABLE_NAME");
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("TABLE_NAME").append(' ').append(',');
                            buffer.append("TABLE_TYPE").append(' ').append(',');
                            buffer.append("TABLE_TYPE_OWNER").append(' ').append(',');
                            buffer.append("PARTITIONED").append(' ').append(',');
                            buffer.append("IOT_TYPE").append(' ').append(',');
                            buffer.append("TEMPORARY").append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ').append("a").append(' ');
                            buffer.append("WHERE").append(' ').append("IOT_NAME").append(' ').append("IS").append(' ').append("NULL").append(' ');
                            buffer.append("AND").append(' ').append('(');
                            buffer.append("IOT_TYPE").append(' ').append("IS").append(' ').append("NULL").append(' ');
                            buffer.append("OR").append(' ').append("IOT_TYPE").append('=').append("'IOT'");
                            buffer.append(')').append(' ');
                            buffer.append("AND").append(' ').append("NESTED").append('=').append('\'').append("NO").append('\'').append(' ');
                            buffer.append("AND").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
                            if (!this.getDbmeHandler().isSecondaryTables()) {
                                buffer.append("AND").append(' ');
                                buffer.append("SECONDARY").append('=').append('\'').append("N").append('\'').append(' ');
                            }
                            buffer.append(mvCheck);
                            buffer.append("AND").append(' ').append("NOT").append(' ').append("EXISTS").append(' ').append('(');
                            buffer.append("SELECT").append(' ').append('1').append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_queue_tables" : "all_queue_tables").append(' ').append("c").append(' ');
                            buffer.append("WHERE").append(' ').append("c.").append("OWNER").append('=').append("a.").append("OWNER").append(' ');
                            buffer.append("AND").append(' ').append("c.").append("QUEUE_TABLE").append('=').append("a.").append("TABLE_NAME").append(')').append(' ');
                            if (filterCondition != null) {
                                buffer.append("AND").append(' ').append(filterCondition).append(' ');
                            }
                            buffer.append("ORDER BY").append(' ').append("TABLE_NAME");
                            String sql = buffer.toString();
                            int limit = this.getDbmeHandler().getLimit();
                            if (limit > 0) {
                                sql = this.getDbmeHandler().getPaginatedQuery(sql);
                            }
                            statement = sqlConnection.prepareStatement(sql);
                        }
                        statement.setString(1, owner);
                        rs = statement.executeQuery();
                        if (rs == null) break block24;
                        while (rs.next()) {
                            String objName = rs.getString("TABLE_NAME");
                            String tableTypeOwner = rs.getString("TABLE_TYPE_OWNER");
                            String tableType = rs.getString("TABLE_TYPE");
                            DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, "TABLE", owner);
                            dboTable.setTypeName(tableType);
                            dboTable.setTypeOwner(tableTypeOwner);
                            String partitioned = rs.getString("PARTITIONED");
                            String iotType = rs.getString("IOT_TYPE");
                            if (mvs) {
                                String buildMode;
                                dboTable.buildMode = buildMode = rs.getString("BUILD_MODE");
                            }
                            if (iotType != null) {
                                dboTable.isIOT = true;
                            }
                            String temporary = rs.getString("TEMPORARY");
                            if ("YES".equalsIgnoreCase(partitioned.trim())) {
                                dboTable.partitioned = true;
                            }
                            if ("Y".equalsIgnoreCase(temporary.trim())) {
                                dboTable.isTemporary = true;
                            }
                            tables.add(dboTable);
                        }
                        rs.close();
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.error("MOHTableOraclev9i.extract():", e);
                        }
                        catch (Throwable throwable) {
                            Closeables.close(rs);
                            throw throwable;
                        }
                        Closeables.close((Object)rs);
                    }
                }
                Closeables.close((Object)rs);
                if (s.isImportTables()) {
                    block25: {
                        try {
                            if (statement_ext == null) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("SELECT").append(' ');
                                buffer.append("TABLE_NAME").append(' ');
                                buffer.append("FROM").append(' ');
                                buffer.append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ').append("a").append(' ');
                                buffer.append("WHERE").append(' ');
                                buffer.append("OWNER").append('=').append('?');
                                statement_ext = sqlConnection.prepareStatement(buffer.toString());
                            }
                            statement_ext.setString(1, owner);
                            rs_ext = statement_ext.executeQuery();
                            if (rs_ext == null) break block25;
                            Object[] tabs = tables.toArray();
                            block12: while (rs_ext.next()) {
                                String objName = rs_ext.getString("TABLE_NAME");
                                for (int i = 0; i < tabs.length; ++i) {
                                    DBObject dboTable = (DBObject)tabs[i];
                                    if (!dboTable.getName().equals(objName)) continue;
                                    dboTable.setType("EXTERNAL TABLE");
                                    continue block12;
                                }
                            }
                            rs_ext.close();
                        }
                        catch (Exception e) {
                            try {
                                LOGGER.error("MOHTableOraclev9i.extract() external tables:", e);
                            }
                            catch (Throwable throwable) {
                                Closeables.close(rs_ext);
                                throw throwable;
                            }
                            Closeables.close((Object)rs_ext);
                        }
                    }
                    Closeables.close((Object)rs_ext);
                }
                list.addAll(tables);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{statement_ext, statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{statement_ext, statement});
        TimeLog.log("Extract Table end");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSupplementalLog(Connection sqlConnection, List dbos) {
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            return;
        }
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, dbos, true);
        HashMap<CallSite, SLGHelper> map = new HashMap<CallSite, SLGHelper>();
        ResultSet rs = null;
        for (String schema : schList) {
            Object grname;
            int k;
            PreparedStatement col_st;
            String colviewName;
            String incl;
            block28: {
                List list = (List)tmap.get(schema);
                incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
                String viewName = this.dbaUser ? "DBA_LOG_GROUPS" : "ALL_LOG_GROUPS";
                colviewName = this.dbaUser ? "DBA_LOG_GROUP_COLUMNS" : "ALL_LOG_GROUP_COLUMNS";
                String sql = "select table_name, log_group_name,log_group_type,always from " + viewName + " where owner = ? and " + incl;
                col_st = null;
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    map.clear();
                    String owner = schema;
                    rs = null;
                    try {
                        statement.setString(1, schema);
                        k = 1;
                        for (String tname : list) {
                            statement.setString(++k, tname);
                        }
                        rs = statement.executeQuery();
                    }
                    catch (Exception e) {
                        LOGGER.error("MOHTableOracle.initSupplementalLog():", e);
                    }
                    if (rs == null) break block28;
                    while (rs.next()) {
                        String tname = rs.getString(1);
                        grname = rs.getString(2);
                        String gtype = rs.getString(3);
                        String always = rs.getString(4);
                        DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                        Table table = (Table)dbo.getTable();
                        TableProxyOraclev10g tp = (TableProxyOraclev10g)dbo.getTableProxy();
                        TableProxy t = dbo.getTableProxy();
                        if (gtype.startsWith("USER")) {
                            SupplementalLogGroup sg = new SupplementalLogGroup(tp.getStorageDesign());
                            sg.setName((String)grname);
                            if ("ALWAYS".equalsIgnoreCase(always)) {
                                sg.setCondition("ALWAYS");
                            }
                            SLGHelper sh = new SLGHelper();
                            sh.tp = tp;
                            sh.sg = sg;
                            map.put((CallSite)((Object)(tp.getLongName() + "." + sg.getName())), sh);
                            tp.getLoggingGroups().add(sg);
                            continue;
                        }
                        if (gtype.startsWith("ALL")) {
                            tp.setSupplementalLogALL(true);
                            continue;
                        }
                        if (gtype.startsWith("PRIMARY")) {
                            tp.setSupplementalLogPK(true);
                            continue;
                        }
                        if (gtype.startsWith("UNIQUE")) {
                            tp.setSupplementalLogUK(true);
                            continue;
                        }
                        if (!gtype.startsWith("FOREIGN")) continue;
                        tp.setSupplementalLogFK(true);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("MOHTableOracle.initSupplementalLog():", e);
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            if (map.size() <= 0) continue;
            incl = MOHTableOracle.getInParamExprTwoNames(map.values().size());
            String col_sql = "select table_name, log_group_name,column_name, logging_property, position  from " + colviewName + " where owner = ? and (table_name, log_group_name) in " + incl;
            rs = null;
            try {
                col_st = sqlConnection.prepareStatement(col_sql);
                col_st.setString(1, schema);
                k = 1;
                for (SLGHelper sg : map.values()) {
                    col_st.setString(k + 1, sg.tp.getName());
                    col_st.setString(k + 2, sg.sg.getName());
                    k += 2;
                }
                rs = col_st.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.initSupplementalLog():", e);
            }
            if (rs == null) continue;
            try {
                while (rs.next()) {
                    String tname = rs.getString(1);
                    grname = rs.getString(2);
                    SLGHelper sgh = (SLGHelper)map.get(schema + "." + tname + "." + (String)grname);
                    SupplementalLogGroup sg = null;
                    TableProxyOraclev10g tp = null;
                    if (sgh != null) {
                        sg = sgh.sg;
                        tp = sgh.tp;
                    }
                    if (sg == null) continue;
                    String cname = rs.getString(3);
                    String log = rs.getString(4);
                    ColumnProxy column = tp.getColumnProxyByName(cname);
                    if (column == null) continue;
                    String id = column.getObjectID();
                    Object ids = sg.getColumns();
                    Object idsnl = sg.getColumnsNoLog();
                    if (ids == null) {
                        ids = "";
                    }
                    if (idsnl == null) {
                        idsnl = "";
                    }
                    if (log.startsWith("NO LOG")) {
                        idsnl = ((String)idsnl).isEmpty() ? id : (String)idsnl + "," + id;
                    } else {
                        ids = ((String)ids).isEmpty() ? id : (String)ids + "," + id;
                    }
                    sg.setColumns((String)ids);
                    sg.setColumnsNoLog((String)idsnl);
                }
                rs.close();
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, col_st});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, col_st});
                continue;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, col_st});
        }
    }

    public MOHBitmapIndexesv10g getBitmapJoinIndexHandler() {
        return this.bitmapJoinIndexHandler;
    }

    public void setBitmapJoinIndexHandler(MOHBitmapIndexesv10g bitmapJoinIndexHandler) {
        this.bitmapJoinIndexHandler = bitmapJoinIndexHandler;
    }

    static class SLGHelper
    implements TwoNames {
        TableProxyOraclev10g tp;
        SupplementalLogGroup sg;

        SLGHelper() {
        }

        @Override
        public String getName1() {
            return this.tp == null ? "" : this.tp.getName();
        }

        @Override
        public String getName2() {
            return this.sg == null ? "" : this.sg.getName();
        }
    }

    static interface TwoNames {
        public String getName1();

        public String getName2();
    }

    static class ConstrHelper {
        String owner;
        String tableName;
        String cname;
        KeyObject key;
        Table table;
        TableProxyOracle tableProxy;
        List<String> columns;
        String deferred;
        String status;
        String deferrable;
        String validated;
        String condition;

        ConstrHelper() {
        }
    }

    public static class FKTemp {
        public String name;
        public String UK_Owner;
        public String UK_Name;
        public String delete_rule;
        public List<String> columns = new ArrayList<String>();
        public Table table;
        public TableView view;
        public String status;
        public String deferrable;
        public String deferred;
        public String validated;
        public String rely;
        public String tname;
        public String owner;
        public boolean onView = false;
        public PK_UK_helper hlp;
    }

    class Temp {
        String tableName;
        String typeName;
        String parenTypeName;
        StructuredType st;
        StructuredType stPar;

        Temp() {
        }
    }

    class ExprHelp {
        String expr;
        int col_pos;

        ExprHelp() {
        }
    }

    class PSHolder {
        PreparedStatement indspat_st = null;

        PSHolder() {
        }
    }

    public static class PK_UK_helper {
        public String owner;
        public String name;
        public String tname;
        public String columns;
        KeyObject index;
        public boolean onView = false;
        KeyObject relatedIndex = null;

        public PK_UK_helper(KeyObject index) {
            this(index, null);
        }

        public PK_UK_helper(KeyObject index, KeyObject relatedIndex) {
            this.index = index;
            this.relatedIndex = relatedIndex;
            this.name = index.getName();
            this.tname = index.getContainerObject().getName();
            this.owner = index.getContainerObject().getSchema();
            StorageDesign sd = ((RelationalDesign)index.getDesignPart()).getStorageDesign();
            this.columns = index.getColumnsAsString(sd);
            if (relatedIndex != null) {
                this.columns = relatedIndex.getColumnsAsString(sd);
            }
        }

        public PK_UK_helper(String owner, String tname, String pkName) {
            this.owner = owner;
            this.tname = tname;
            this.name = pkName;
        }

        public String toString() {
            return this.owner + "." + this.name;
        }

        public String getID() {
            return this.owner + "." + this.name;
        }
    }
}

