/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHDBLinksOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DB_LINK";
    private static final Logger LOGGER = new Logger(MOHDBLinksOracle.class);
    protected boolean dbaUser;

    public MOHDBLinksOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHDBLinksOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract DBLinks begin");
        statement = null;
        list = new ArrayList<DBObject>();
        map = new TreeMap<K, V>();
        s = this.getDesign().getSettings();
        link = s.isImportDB_Links();
        plink = s.isImportPublicDB_Links();
        cschemas = new ArrayList<E>(schemas);
        try {
            for (DBObject dboNext : cschemas) {
                if (!dboNext.isSelected()) continue;
                if (statement == null) {
                    filterCondition = this.getFilterConditionOracle("SYNONYM_NAME");
                    buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("USERNAME").append(',');
                    buffer.append("OWNER").append(',');
                    buffer.append("HOST").append(',');
                    buffer.append("DB_LINK").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser != false ? "dba_db_links" : "all_db_links").append(' ');
                    buffer.append("WHERE").append(' ');
                    if (link) {
                        if (plink) {
                            buffer.append('(');
                        }
                        buffer.append("OWNER").append('=').append('?').append(' ');
                        if (plink) {
                            buffer.append("OR");
                        }
                    }
                    if (plink) {
                        buffer.append(' ').append("OWNER").append('=').append("'PUBLIC'");
                        if (link) {
                            buffer.append(')');
                        }
                        buffer.append(' ');
                    }
                    if (filterCondition != null) {
                        buffer.append("AND").append(' ').append(filterCondition).append(' ');
                    }
                    buffer.append("ORDER BY").append(' ').append("DB_LINK");
                    sql = buffer.toString();
                    if (this.getDbmeHandler().getLimit() > 0) {
                        sql = this.getDbmeHandler().getPaginatedQuery(sql);
                    }
                    statement = sqlConnection.prepareStatement(sql);
                }
                rs = null;
                try {
                    if (link) {
                        statement.setString(1, dboNext.getName());
                    }
                    if ((rs = statement.executeQuery()) != null) {
                        while (rs.next()) {
                            userName = rs.getString(1);
                            owner = rs.getString(2);
                            host = rs.getString(3);
                            db_link = rs.getString(4);
                            dbo = new DBObject(true, db_link, "DB_LINK", owner);
                            list.add(dbo);
                            if (userName != null) {
                                dbo.userName = userName;
                            }
                            if (host == null) continue;
                            dbo.host = host;
                        }
                        rs.close();
                    }
                    ** GOTO lbl85
                }
                catch (Exception e) {
                    try {
                        MOHDBLinksOracle.LOGGER.error("MOHDBLinkOracle.extract():", e);
                    }
                    catch (Throwable var18_19) {
                        Closeables.close(rs);
                        throw var18_19;
                    }
lbl85:
                    // 1 sources

                    Closeables.close((Object)rs);
                    continue;
                    Closeables.close((Object)rs);
                }
            }
        }
        finally {
            map.clear();
            Closeables.close(statement);
        }
        TimeLog.log("Extract DBLinks end");
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            if (storageDesign != null) {
                // empty if block
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    static class DescSyn {
        String dblink;
        String tablename;
        String tableowner;

        DescSyn() {
        }
    }
}

